import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermConsumptionBudgetResourceGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_resource_group.html#name DataAzurermConsumptionBudgetResourceGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_resource_group.html#resource_group_id DataAzurermConsumptionBudgetResourceGroup#resource_group_id}.
     *
     * @stability stable
     */
    readonly resourceGroupId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_resource_group.html#timeouts DataAzurermConsumptionBudgetResourceGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermConsumptionBudgetResourceGroupTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetResourceGroupFilterDimension extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    get values(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetResourceGroupFilterNotDimension extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    get values(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetResourceGroupFilterNotTag extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    get values(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetResourceGroupFilterNot extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get dimension(): any;
    /**
     * @stability stable
     */
    get tag(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetResourceGroupFilterTag extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    get values(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetResourceGroupFilter extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get dimension(): any;
    /**
     * @stability stable
     */
    get not(): any;
    /**
     * @stability stable
     */
    get tag(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetResourceGroupNotification extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get contactEmails(): string[];
    /**
     * @stability stable
     */
    get contactGroups(): string[];
    /**
     * @stability stable
     */
    get contactRoles(): string[];
    /**
     * @stability stable
     */
    get enabled(): any;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    get threshold(): number;
    /**
     * @stability stable
     */
    get thresholdType(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetResourceGroupTimePeriod extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get endDate(): string;
    /**
     * @stability stable
     */
    get startDate(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermConsumptionBudgetResourceGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_resource_group.html#read DataAzurermConsumptionBudgetResourceGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermConsumptionBudgetResourceGroupTimeoutsToTerraform(struct?: DataAzurermConsumptionBudgetResourceGroupTimeoutsOutputReference | DataAzurermConsumptionBudgetResourceGroupTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetResourceGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermConsumptionBudgetResourceGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermConsumptionBudgetResourceGroupTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_resource_group.html azurerm_consumption_budget_resource_group}.
 *
 * @stability stable
 */
export declare class DataAzurermConsumptionBudgetResourceGroup extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/consumption_budget_resource_group.html azurerm_consumption_budget_resource_group} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermConsumptionBudgetResourceGroupConfig);
    /**
     * @stability stable
     */
    get amount(): number;
    /**
     * @stability stable
     */
    filter(index: string): DataAzurermConsumptionBudgetResourceGroupFilter;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    notification(index: string): DataAzurermConsumptionBudgetResourceGroupNotification;
    private _resourceGroupId?;
    /**
     * @stability stable
     */
    get resourceGroupId(): string;
    /**
     * @stability stable
     */
    set resourceGroupId(value: string);
    /**
     * @stability stable
     */
    get resourceGroupIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get timeGrain(): string;
    /**
     * @stability stable
     */
    timePeriod(index: string): DataAzurermConsumptionBudgetResourceGroupTimePeriod;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermConsumptionBudgetResourceGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermConsumptionBudgetResourceGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermConsumptionBudgetResourceGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
