import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermServicebusQueueAuthorizationRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue_authorization_rule.html#name DataAzurermServicebusQueueAuthorizationRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue_authorization_rule.html#namespace_name DataAzurermServicebusQueueAuthorizationRule#namespace_name}.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue_authorization_rule.html#queue_name DataAzurermServicebusQueueAuthorizationRule#queue_name}.
     *
     * @stability stable
     */
    readonly queueName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue_authorization_rule.html#resource_group_name DataAzurermServicebusQueueAuthorizationRule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue_authorization_rule.html#timeouts DataAzurermServicebusQueueAuthorizationRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermServicebusQueueAuthorizationRuleTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermServicebusQueueAuthorizationRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue_authorization_rule.html#read DataAzurermServicebusQueueAuthorizationRule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermServicebusQueueAuthorizationRuleTimeoutsToTerraform(struct?: DataAzurermServicebusQueueAuthorizationRuleTimeoutsOutputReference | DataAzurermServicebusQueueAuthorizationRuleTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermServicebusQueueAuthorizationRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermServicebusQueueAuthorizationRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermServicebusQueueAuthorizationRuleTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue_authorization_rule.html azurerm_servicebus_queue_authorization_rule}.
 *
 * @stability stable
 */
export declare class DataAzurermServicebusQueueAuthorizationRule extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_queue_authorization_rule.html azurerm_servicebus_queue_authorization_rule} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermServicebusQueueAuthorizationRuleConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get listen(): any;
    /**
     * @stability stable
     */
    get manage(): any;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespaceName?;
    /**
     * @stability stable
     */
    get namespaceName(): string;
    /**
     * @stability stable
     */
    set namespaceName(value: string);
    /**
     * @stability stable
     */
    get namespaceNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get primaryConnectionString(): string;
    /**
     * @stability stable
     */
    get primaryConnectionStringAlias(): string;
    /**
     * @stability stable
     */
    get primaryKey(): string;
    private _queueName?;
    /**
     * @stability stable
     */
    get queueName(): string;
    /**
     * @stability stable
     */
    set queueName(value: string);
    /**
     * @stability stable
     */
    get queueNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryConnectionString(): string;
    /**
     * @stability stable
     */
    get secondaryConnectionStringAlias(): string;
    /**
     * @stability stable
     */
    get secondaryKey(): string;
    /**
     * @stability stable
     */
    get send(): any;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermServicebusQueueAuthorizationRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermServicebusQueueAuthorizationRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermServicebusQueueAuthorizationRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
