import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SynapseRoleAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_role_assignment.html#principal_id SynapseRoleAssignment#principal_id}.
     *
     * @stability stable
     */
    readonly principalId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_role_assignment.html#role_name SynapseRoleAssignment#role_name}.
     *
     * @stability stable
     */
    readonly roleName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_role_assignment.html#synapse_spark_pool_id SynapseRoleAssignment#synapse_spark_pool_id}.
     *
     * @stability stable
     */
    readonly synapseSparkPoolId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_role_assignment.html#synapse_workspace_id SynapseRoleAssignment#synapse_workspace_id}.
     *
     * @stability stable
     */
    readonly synapseWorkspaceId?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_role_assignment.html#timeouts SynapseRoleAssignment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SynapseRoleAssignmentTimeouts;
}
/**
 * @stability stable
 */
export interface SynapseRoleAssignmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_role_assignment.html#create SynapseRoleAssignment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_role_assignment.html#delete SynapseRoleAssignment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_role_assignment.html#read SynapseRoleAssignment#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function synapseRoleAssignmentTimeoutsToTerraform(struct?: SynapseRoleAssignmentTimeoutsOutputReference | SynapseRoleAssignmentTimeouts): any;
/**
 * @stability stable
 */
export declare class SynapseRoleAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseRoleAssignmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseRoleAssignmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_role_assignment.html azurerm_synapse_role_assignment}.
 *
 * @stability stable
 */
export declare class SynapseRoleAssignment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_role_assignment.html azurerm_synapse_role_assignment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SynapseRoleAssignmentConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _principalId?;
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    set principalId(value: string);
    /**
     * @stability stable
     */
    get principalIdInput(): string | undefined;
    private _roleName?;
    /**
     * @stability stable
     */
    get roleName(): string;
    /**
     * @stability stable
     */
    set roleName(value: string);
    /**
     * @stability stable
     */
    get roleNameInput(): string | undefined;
    private _synapseSparkPoolId?;
    /**
     * @stability stable
     */
    get synapseSparkPoolId(): string;
    /**
     * @stability stable
     */
    set synapseSparkPoolId(value: string);
    /**
     * @stability stable
     */
    resetSynapseSparkPoolId(): void;
    /**
     * @stability stable
     */
    get synapseSparkPoolIdInput(): string | undefined;
    private _synapseWorkspaceId?;
    /**
     * @stability stable
     */
    get synapseWorkspaceId(): string;
    /**
     * @stability stable
     */
    set synapseWorkspaceId(value: string);
    /**
     * @stability stable
     */
    resetSynapseWorkspaceId(): void;
    /**
     * @stability stable
     */
    get synapseWorkspaceIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SynapseRoleAssignmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SynapseRoleAssignmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SynapseRoleAssignmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
