"""MultiTenantContext Mutation."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python.services.multi_tenant_context.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.multi_tenant_context import (
        MultiTenantContextService,
    )

log = logging.getLogger(__name__)


class TaegisSDKMultiTenantContextMutation:
    """Taegis Multi_tenant_context Mutation operations."""

    def __init__(self, service: MultiTenantContextService):
        self.service = service

    def create_session(self, input_: CreateSessionInput) -> Session:
        """Creates a session. Any inputs besides the key are optional.."""
        endpoint = "createSession"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(Session),
        )
        if result.get(endpoint) is not None:
            return Session.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createSession")

    def set_session(self, inputs: Optional[List[SessionInput]] = None) -> List[Session]:
        """Sets a multi tenant session. Set the tenants you want to look at for a session.."""
        endpoint = "setSession"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "inputs": prepare_input(inputs),
            },
            output=build_output_string(Session),
        )
        if result.get(endpoint) is not None:
            return Session.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for mutation setSession")

    def add_to_tenant_history(self, input_: SessionInput) -> List[History]:
        """Adds to a subject's tenant history. Returns the new histories which were added.."""
        endpoint = "addToTenantHistory"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "input": prepare_input(input_),
            },
            output=build_output_string(History),
        )
        if result.get(endpoint) is not None:
            return History.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for mutation addToTenantHistory")

    def delete_session(self, key: str) -> Session:
        """Deletes a multi tenant session. Returns a session which should be deleted."""
        endpoint = "deleteSession"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "key": prepare_input(key),
            },
            output=build_output_string(Session),
        )
        if result.get(endpoint) is not None:
            return Session.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation deleteSession")

    def claim_tenant(self, tenant_id: str) -> TenantClaim:
        """Claims a tenant."""
        endpoint = "claimTenant"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "tenantID": prepare_input(tenant_id),
            },
            output=build_output_string(TenantClaim),
        )
        if result.get(endpoint) is not None:
            return TenantClaim.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation claimTenant")

    def delete_tenant_claim(self, tenant_id: str) -> TenantClaim:
        """Deletes/removes a tenant claim."""
        endpoint = "deleteTenantClaim"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "tenantID": prepare_input(tenant_id),
            },
            output=build_output_string(TenantClaim),
        )
        if result.get(endpoint) is not None:
            return TenantClaim.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation deleteTenantClaim")
