"""Preferences Mutation."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code, wildcard-import, unused-wildcard-import, cyclic-import


# Autogenerated
# DO NOT MODIFY

from __future__ import annotations

import logging
from typing import TYPE_CHECKING, Any, Dict, List, Optional, Tuple, Union

from taegis_sdk_python import GraphQLNoRowsInResultSetError
from taegis_sdk_python.utils import (
    build_output_string,
    parse_union_result,
    prepare_input,
)
from taegis_sdk_python.services.preferences.types import *

if TYPE_CHECKING:  # pragma: no cover
    from taegis_sdk_python.services.preferences import PreferencesService

log = logging.getLogger(__name__)


class TaegisSDKPreferencesMutation:
    """Taegis Preferences Mutation operations."""

    def __init__(self, service: PreferencesService):
        self.service = service

    def create_user_preference(
        self, new_user_preference: Optional[NewUserPreferenceInput] = None
    ) -> UserPreference:
        """None."""
        endpoint = "createUserPreference"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "newUserPreference": prepare_input(new_user_preference),
            },
            output=build_output_string(UserPreference),
        )
        if result.get(endpoint) is not None:
            return UserPreference.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createUserPreference")

    def update_user_preference(
        self, updated_user_preference: Optional[UpdateUserPreferenceInput] = None
    ) -> UserPreference:
        """None."""
        endpoint = "updateUserPreference"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "updatedUserPreference": prepare_input(updated_user_preference),
            },
            output=build_output_string(UserPreference),
        )
        if result.get(endpoint) is not None:
            return UserPreference.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation updateUserPreference")

    def reset_user_preferences(self) -> List[UserPreference]:
        """None."""
        endpoint = "resetUserPreferences"

        result = self.service.execute_mutation(
            endpoint=endpoint, variables={}, output=build_output_string(UserPreference)
        )
        if result.get(endpoint) is not None:
            return UserPreference.schema().load(
                [r or {} for r in result.get(endpoint)], many=True
            )
        raise GraphQLNoRowsInResultSetError("for mutation resetUserPreferences")

    def create_tenant_preference(
        self, new_tenant_preference: Optional[NewTenantPreferenceInput] = None
    ) -> TenantPreference:
        """None."""
        endpoint = "createTenantPreference"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "newTenantPreference": prepare_input(new_tenant_preference),
            },
            output=build_output_string(TenantPreference),
        )
        if result.get(endpoint) is not None:
            return TenantPreference.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation createTenantPreference")

    def update_tenant_preference(
        self, updated_tenant_preference: Optional[UpdateTenantPreferenceInput] = None
    ) -> TenantPreference:
        """None."""
        endpoint = "updateTenantPreference"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "updatedTenantPreference": prepare_input(updated_tenant_preference),
            },
            output=build_output_string(TenantPreference),
        )
        if result.get(endpoint) is not None:
            return TenantPreference.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation updateTenantPreference")

    def delete_tenant_preference(self, key: str) -> TenantPreference:
        """None."""
        endpoint = "deleteTenantPreference"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "key": prepare_input(key),
            },
            output=build_output_string(TenantPreference),
        )
        if result.get(endpoint) is not None:
            return TenantPreference.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation deleteTenantPreference")

    def save_ticketing_settings(
        self, ticketing_settings_input: TicketingSettingsInput
    ) -> TicketingSettings:
        """None."""
        endpoint = "saveTicketingSettings"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "ticketingSettingsInput": prepare_input(ticketing_settings_input),
            },
            output=build_output_string(TicketingSettings),
        )
        if result.get(endpoint) is not None:
            return TicketingSettings.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation saveTicketingSettings")

    def save_partner_preferences(
        self, partner_preference_input: PartnerPreferenceInput
    ) -> PartnerPreference:
        """None."""
        endpoint = "savePartnerPreferences"

        result = self.service.execute_mutation(
            endpoint=endpoint,
            variables={
                "partnerPreferenceInput": prepare_input(partner_preference_input),
            },
            output=build_output_string(PartnerPreference),
        )
        if result.get(endpoint) is not None:
            return PartnerPreference.from_dict(result.get(endpoint))
        raise GraphQLNoRowsInResultSetError("for mutation savePartnerPreferences")
