"""Rules Types and Enums."""
# pylint: disable=no-member, unused-argument, too-many-locals, duplicate-code

# Autogenerated
# DO NOT MODIFY

from typing import Optional, List, Dict, Union, Any, Tuple


from enum import Enum


from dataclasses import dataclass, field
from dataclasses_json import dataclass_json, config


class RuleEventType(str, Enum):
    """RuleEventType."""

    ANTIVIRUS = "antivirus"
    APICALL = "apicall"
    AUTH = "auth"
    CLOUDAUDIT = "cloudaudit"
    DHCP = "dhcp"
    DNSQUERY = "dnsquery"
    EMAIL = "email"
    ENCRYPT = "encrypt"
    FILEMOD = "filemod"
    GENERIC = "generic"
    HTTP = "http"
    MANAGEMENT_EVENT = "management_event"
    NETFLOW = "netflow"
    NIDS = "nids"
    OBSERVATION_V2 = "observation_v2"
    PERSISTENCE = "persistence"
    PROCESS = "process"
    REGISTRY = "registry"
    SCRIPT_BLOCK = "script_block"
    THIRDPARTYALERT = "thirdpartyalert"
    THREAD_INJECTION = "thread_injection"
    PROCESS_MODULE = "process_module"


class RuleEndpointPlatform(str, Enum):
    """RuleEndpointPlatform."""

    PLATFORM_WINDOWS = "PLATFORM_WINDOWS"
    PLATFORM_LINUX = "PLATFORM_LINUX"
    PLATFORM_MAC = "PLATFORM_MAC"
    PLATFORM_UNKNOWN = "PLATFORM_UNKNOWN"


class RuleCountComparison(str, Enum):
    """RuleCountComparison."""

    GREATER_THAN = "greater_than"
    LESS_THAN = "less_than"
    EQUAL_TO = "equal_to"


class RuleType(str, Enum):
    """RuleType."""

    REGEX = "REGEX"
    REDQL = "REDQL"
    QL = "QL"


class RuleAction(str, Enum):
    """RuleAction."""

    ALERT = "ALERT"
    SUPPRESS = "SUPPRESS"
    TUNE = "TUNE"
    TAG_EVENT = "TAG_EVENT"
    NONE = "NONE"


class RuleSource(str, Enum):
    """RuleSource."""

    WATCHLIST = "WATCHLIST"
    DETECTOR = "DETECTOR"
    CUSTOM = "CUSTOM"


class RuleVisibility(str, Enum):
    """RuleVisibility."""

    VISIBLE = "visible"
    HIDDEN = "hidden"


class RuleDay(str, Enum):
    """RuleDay."""

    MONDAY = "Monday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"
    THURSDAY = "Thursday"
    FRIDAY = "Friday"
    SATURDAY = "Saturday"
    SUNDAY = "Sunday"


class RuleQueryKind(str, Enum):
    """RuleQueryKind."""

    ALL = "all"
    GLOBAL = "global"
    TENANT = "tenant"


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class AttackCategoryDetail:
    """AttackCategoryDetail."""

    technique_id: Optional[str] = field(
        default=None, metadata=config(field_name="techniqueID")
    )
    technique: Optional[str] = field(
        default=None, metadata=config(field_name="technique")
    )
    tactics: Optional[List[str]] = field(
        default=None, metadata=config(field_name="tactics")
    )
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    url: Optional[str] = field(default=None, metadata=config(field_name="url"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleCount:
    """RuleCount."""

    enabled: Optional[int] = field(default=None, metadata=config(field_name="enabled"))
    disabled: Optional[int] = field(
        default=None, metadata=config(field_name="disabled")
    )
    deleted: Optional[int] = field(default=None, metadata=config(field_name="deleted"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleReference:
    """RuleReference."""

    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    url: Optional[str] = field(default=None, metadata=config(field_name="url"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleQLFilterTest:
    """RuleQLFilterTest."""

    field_name: Optional[str] = field(
        default=None, metadata=config(field_name="fieldName")
    )
    field_value: Optional[str] = field(
        default=None, metadata=config(field_name="fieldValue")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleQLFilterTestInput:
    """RuleQLFilterTestInput."""

    field_name: Optional[str] = field(
        default=None, metadata=config(field_name="fieldName")
    )
    field_value: Optional[str] = field(
        default=None, metadata=config(field_name="fieldValue")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleRedQLFilterTest:
    """RuleRedQLFilterTest."""

    field_name: Optional[str] = field(
        default=None, metadata=config(field_name="fieldName")
    )
    field_value: Optional[str] = field(
        default=None, metadata=config(field_name="fieldValue")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleRedQLFilterTestInput:
    """RuleRedQLFilterTestInput."""

    field_name: Optional[str] = field(
        default=None, metadata=config(field_name="fieldName")
    )
    field_value: Optional[str] = field(
        default=None, metadata=config(field_name="fieldValue")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleReferenceInput:
    """RuleReferenceInput."""

    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    url: Optional[str] = field(default=None, metadata=config(field_name="url"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleEventData:
    """RuleEventData."""

    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    value: Optional[str] = field(default=None, metadata=config(field_name="value"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleDailyCount:
    """RuleDailyCount."""

    count: Optional[int] = field(default=None, metadata=config(field_name="count"))
    date: Optional[str] = field(default=None, metadata=config(field_name="date"))
    timestamp: Optional[int] = field(
        default=None, metadata=config(field_name="timestamp")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ParseError:
    """ParseError."""

    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    start_line: Optional[int] = field(
        default=None, metadata=config(field_name="startLine")
    )
    stop_line: Optional[int] = field(
        default=None, metadata=config(field_name="stopLine")
    )
    start_column: Optional[int] = field(
        default=None, metadata=config(field_name="startColumn")
    )
    stop_column: Optional[int] = field(
        default=None, metadata=config(field_name="stopColumn")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SearchRulesInput:
    """SearchRulesInput."""

    query: Optional[str] = field(default=None, metadata=config(field_name="query"))


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class WatchlistRuleQueryInput:
    """WatchlistRuleQueryInput."""

    exclude_prefixes: Optional[List[str]] = field(
        default=None, metadata=config(field_name="excludePrefixes")
    )
    updated_since_days: Optional[int] = field(
        default=None, metadata=config(field_name="updatedSinceDays")
    )
    updated_since: Optional[str] = field(
        default=None, metadata=config(field_name="updatedSince")
    )
    updated_prior_to: Optional[str] = field(
        default=None, metadata=config(field_name="updatedPriorTo")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class PageInfoOffset:
    """PageInfoOffset."""

    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    per_page: Optional[int] = field(default=None, metadata=config(field_name="perPage"))
    offset: Optional[int] = field(default=None, metadata=config(field_name="offset"))
    total_entries_size: Optional[int] = field(
        default=None, metadata=config(field_name="totalEntriesSize")
    )
    current_entries_size: Optional[int] = field(
        default=None, metadata=config(field_name="currentEntriesSize")
    )
    total_pages: Optional[int] = field(
        default=None, metadata=config(field_name="totalPages")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleTermCount:
    """RuleTermCount."""

    value: Optional[int] = field(default=None, metadata=config(field_name="value"))
    comparison: Optional[RuleCountComparison] = field(
        default=None, metadata=config(field_name="comparison")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleFilter:
    """RuleFilter."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    rule_id: Optional[str] = field(default=None, metadata=config(field_name="ruleID"))
    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    pattern: Optional[str] = field(default=None, metadata=config(field_name="pattern"))
    inverted: Optional[bool] = field(
        default=None, metadata=config(field_name="inverted")
    )
    case_sensitive: Optional[bool] = field(
        default=None, metadata=config(field_name="caseSensitive")
    )
    test_should: Optional[List[str]] = field(
        default=None, metadata=config(field_name="testShould")
    )
    test_should_not: Optional[List[str]] = field(
        default=None, metadata=config(field_name="testShouldNot")
    )
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    count: Optional[RuleTermCount] = field(
        default=None, metadata=config(field_name="count")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleTermCountInput:
    """RuleTermCountInput."""

    value: Optional[int] = field(default=None, metadata=config(field_name="value"))
    comparison: Optional[RuleCountComparison] = field(
        default=None, metadata=config(field_name="comparison")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleFilterInput:
    """RuleFilterInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    key: Optional[str] = field(default=None, metadata=config(field_name="key"))
    pattern: Optional[str] = field(default=None, metadata=config(field_name="pattern"))
    inverted: Optional[bool] = field(
        default=None, metadata=config(field_name="inverted")
    )
    case_sensitive: Optional[bool] = field(
        default=None, metadata=config(field_name="caseSensitive")
    )
    clear_count: Optional[bool] = field(
        default=None, metadata=config(field_name="clearCount")
    )
    test_should: Optional[List[str]] = field(
        default=None, metadata=config(field_name="testShould")
    )
    test_should_not: Optional[List[str]] = field(
        default=None, metadata=config(field_name="testShouldNot")
    )
    count: Optional[RuleTermCountInput] = field(
        default=None, metadata=config(field_name="count")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleSampleEvent:
    """RuleSampleEvent."""

    data: Optional[List[RuleEventData]] = field(
        default=None, metadata=config(field_name="data")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleMetrics:
    """RuleMetrics."""

    total_count: Optional[int] = field(
        default=None, metadata=config(field_name="totalCount")
    )
    last_hit_date: Optional[str] = field(
        default=None, metadata=config(field_name="lastHitDate")
    )
    last30_days_count: Optional[int] = field(
        default=None, metadata=config(field_name="last30DaysCount")
    )
    daily_counts: Optional[List[RuleDailyCount]] = field(
        default=None, metadata=config(field_name="dailyCounts")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleCountResponse:
    """RuleCountResponse."""

    suppression: Optional[RuleCount] = field(
        default=None, metadata=config(field_name="suppression")
    )
    custom: Optional[RuleCount] = field(
        default=None, metadata=config(field_name="custom")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleQLFilter:
    """RuleQLFilter."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    rule_id: Optional[str] = field(default=None, metadata=config(field_name="ruleID"))
    query: Optional[str] = field(default=None, metadata=config(field_name="query"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    test_should: Optional[List[RuleQLFilterTest]] = field(
        default=None, metadata=config(field_name="testShould")
    )
    test_should_not: Optional[List[RuleQLFilterTest]] = field(
        default=None, metadata=config(field_name="testShouldNot")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleQLFilterInput:
    """RuleQLFilterInput."""

    query: Optional[str] = field(default=None, metadata=config(field_name="query"))
    test_should: Optional[List[RuleQLFilterTestInput]] = field(
        default=None, metadata=config(field_name="testShould")
    )
    test_should_not: Optional[List[RuleQLFilterTestInput]] = field(
        default=None, metadata=config(field_name="testShouldNot")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleRedQLFilter:
    """RuleRedQLFilter."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    rule_id: Optional[str] = field(default=None, metadata=config(field_name="ruleID"))
    query: Optional[str] = field(default=None, metadata=config(field_name="query"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    test_should: Optional[List[RuleRedQLFilterTest]] = field(
        default=None, metadata=config(field_name="testShould")
    )
    test_should_not: Optional[List[RuleRedQLFilterTest]] = field(
        default=None, metadata=config(field_name="testShouldNot")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleRedQLFilterInput:
    """RuleRedQLFilterInput."""

    query: Optional[str] = field(default=None, metadata=config(field_name="query"))
    test_should: Optional[List[RuleRedQLFilterTestInput]] = field(
        default=None, metadata=config(field_name="testShould")
    )
    test_should_not: Optional[List[RuleRedQLFilterTestInput]] = field(
        default=None, metadata=config(field_name="testShouldNot")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleTestMatchStep:
    """RuleTestMatchStep."""

    total: Optional[int] = field(default=None, metadata=config(field_name="total"))
    matches: Optional[int] = field(default=None, metadata=config(field_name="matches"))
    duration: Optional[str] = field(
        default=None, metadata=config(field_name="duration")
    )
    filter: Optional[RuleFilter] = field(
        default=None, metadata=config(field_name="filter")
    )
    samples: Optional[List[RuleSampleEvent]] = field(
        default=None, metadata=config(field_name="samples")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class ValidateQLFilter:
    """ValidateQLFilter."""

    original_query: Optional[str] = field(
        default=None, metadata=config(field_name="originalQuery")
    )
    expanded_query: Optional[str] = field(
        default=None, metadata=config(field_name="expandedQuery")
    )
    event_type: Optional[RuleEventType] = field(
        default=None, metadata=config(field_name="eventType")
    )
    errors: Optional[List[ParseError]] = field(
        default=None, metadata=config(field_name="errors")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class EventTaggingRulesInput:
    """EventTaggingRulesInput."""

    page: Optional[int] = field(default=None, metadata=config(field_name="page"))
    count: Optional[int] = field(default=None, metadata=config(field_name="count"))
    since: Optional[str] = field(default=None, metadata=config(field_name="since"))
    event_type: Optional[RuleEventType] = field(
        default=None, metadata=config(field_name="eventType")
    )
    kind: Optional[RuleQueryKind] = field(
        default=None, metadata=config(field_name="kind")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class RuleInput:
    """RuleInput."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    group_key_template: Optional[str] = field(
        default=None, metadata=config(field_name="groupKeyTemplate")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    severity: Optional[float] = field(
        default=None, metadata=config(field_name="severity")
    )
    confidence: Optional[float] = field(
        default=None, metadata=config(field_name="confidence")
    )
    create_alert: Optional[bool] = field(
        default=None, metadata=config(field_name="createAlert")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    destination_topic: Optional[str] = field(
        default=None, metadata=config(field_name="destinationTopic")
    )
    attack_categories: Optional[List[str]] = field(
        default=None, metadata=config(field_name="attackCategories")
    )
    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    event_type: Optional[RuleEventType] = field(
        default=None, metadata=config(field_name="eventType")
    )
    visibility: Optional[RuleVisibility] = field(
        default=None, metadata=config(field_name="visibility")
    )
    result_visibility: Optional[RuleVisibility] = field(
        default=None, metadata=config(field_name="resultVisibility")
    )
    rule_source: Optional[RuleSource] = field(
        default=None, metadata=config(field_name="ruleSource")
    )
    rule_action: Optional[RuleAction] = field(
        default=None, metadata=config(field_name="ruleAction")
    )
    endpoint_platform: Optional[List[RuleEndpointPlatform]] = field(
        default=None, metadata=config(field_name="endpointPlatform")
    )
    references: Optional[List[RuleReferenceInput]] = field(
        default=None, metadata=config(field_name="references")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class Rule:
    """Rule."""

    id: Optional[str] = field(default=None, metadata=config(field_name="id"))
    tenant_id: Optional[str] = field(
        default=None, metadata=config(field_name="tenantID")
    )
    user_id: Optional[str] = field(default=None, metadata=config(field_name="userID"))
    group_key_template: Optional[str] = field(
        default=None, metadata=config(field_name="groupKeyTemplate")
    )
    name: Optional[str] = field(default=None, metadata=config(field_name="name"))
    description: Optional[str] = field(
        default=None, metadata=config(field_name="description")
    )
    severity: Optional[float] = field(
        default=None, metadata=config(field_name="severity")
    )
    confidence: Optional[float] = field(
        default=None, metadata=config(field_name="confidence")
    )
    enabled: Optional[bool] = field(default=None, metadata=config(field_name="enabled"))
    create_alert: Optional[bool] = field(
        default=None, metadata=config(field_name="createAlert")
    )
    tags: Optional[List[str]] = field(default=None, metadata=config(field_name="tags"))
    destination_topic: Optional[str] = field(
        default=None, metadata=config(field_name="destinationTopic")
    )
    attack_categories: Optional[List[str]] = field(
        default=None, metadata=config(field_name="attackCategories")
    )
    deleted: Optional[bool] = field(default=None, metadata=config(field_name="deleted"))
    created_at: Optional[str] = field(
        default=None, metadata=config(field_name="createdAt")
    )
    updated_at: Optional[str] = field(
        default=None, metadata=config(field_name="updatedAt")
    )
    event_type: Optional[RuleEventType] = field(
        default=None, metadata=config(field_name="eventType")
    )
    seven_day_group_key_rollover_day: Optional[RuleDay] = field(
        default=None, metadata=config(field_name="sevenDayGroupKeyRolloverDay")
    )
    visibility: Optional[RuleVisibility] = field(
        default=None, metadata=config(field_name="visibility")
    )
    result_visibility: Optional[RuleVisibility] = field(
        default=None, metadata=config(field_name="resultVisibility")
    )
    attack_categories_details: Optional[List[AttackCategoryDetail]] = field(
        default=None, metadata=config(field_name="attackCategoriesDetails")
    )
    endpoint_platform: Optional[List[RuleEndpointPlatform]] = field(
        default=None, metadata=config(field_name="endpointPlatform")
    )
    references: Optional[List[RuleReference]] = field(
        default=None, metadata=config(field_name="references")
    )
    filters: Optional[List[RuleFilter]] = field(
        default=None, metadata=config(field_name="filters")
    )
    ql_filter: Optional[RuleQLFilter] = field(
        default=None, metadata=config(field_name="qlFilter")
    )
    rule_action: Optional[RuleAction] = field(
        default=None, metadata=config(field_name="ruleAction")
    )
    rule_source: Optional[RuleSource] = field(
        default=None, metadata=config(field_name="ruleSource")
    )
    red_ql_filter: Optional[RuleRedQLFilter] = field(
        default=None, metadata=config(field_name="redQLFilter")
    )


@dataclass_json
@dataclass(order=True, eq=True, frozen=True)
class SearchRulesOutput:
    """SearchRulesOutput."""

    rules: Optional[List[Rule]] = field(
        default=None, metadata=config(field_name="rules")
    )
    page_info: Optional[PageInfoOffset] = field(
        default=None, metadata=config(field_name="pageInfo")
    )
