import { cdk } from "projen";
/**
 * Configurable knobs for Awesome Lists
 */
export interface AwesomeListProjectOptions extends cdk.JsiiProjectOptions {
    /**
     * What e-mail address to list for the Code of Conduct Point of Contact
     *
     * @default - `project.authorAddress`
     */
    readonly contactEmail?: string;
}
/**
 * Awesome List project
 *
 * @pjid awesome-list
 */
export declare class AwesomeList extends cdk.JsiiProject {
    constructor(options: AwesomeListProjectOptions);
    private _awesomeLint;
    private codeOfConduct;
    private contributing;
}
