"""
    University Photo API

      ## Introduction  The Photo API allows access to Photos of members of the University. The Photos exposed by this API are expected to be a good representation of the person they relate to.  The API broadly follows the principles of REST and strives to provide an interface that can be easily consumed by downstream systems.  The API is currently read-only, and does not expose any operations to create or delete Photos.  ### Stability  This release of the Photo API is a `beta` offering: a service we are moving towards live but which requires wider testing with a broader group of users.  ### Versioning  The Photo API is versioned using url path prefixes in the format: `/v1beta1/photos`. This follows the pattern established by the [GCP API](https://cloud.google.com/apis/design/versioning). Breaking changes will not be made without a change in API major version, however non-breaking changes will be introduced without changes to the version path prefix. All changes will be documented in the project's [CHANGELOG](https://gitlab.developers.cam.ac.uk/uis/devops/iam/photo-api/-/blob/master/CHANGELOG.md)  The available versions of the API are listed at the API's root.  ### Domain  The Photo API serves Photos of members of the University, linking a Photo to an individual through `PhotoIdentifiers` (see below) which pertain to a person record within an external system.  The Photos served by the Photo API are expected to be of good enough quality to identify the person they represent. Photos which have been manually reviewed and determined to be good quality are marked as having the status `approved` and exposed through the `approved-photos` endpoints.  ### Data source  The Photos exposed by the Photo API are currently a mirror of card Photos contained within the [Card Database](https://webservices.admin.cam.ac.uk/uc/). With Photos being synced from the Card Database to the Photo API hourly.  In future, the Photo API will be extended to allow Photos to be created and 'approved' using the API.  ## Core entities  ### The `Photo` Entity  The `Photo` entity contains information and metadata about a Photo of a member of the university. The `status` field on a Photo indicates whether this Photo has been reviewed and approved as identifying the person it relates to. Only Photos which have the status `approved` are exposed through the `approved-photos` endpoints.  Each Photo entity contains a link to the image data itself and a thumbnail for this Photo, which is guaranteed to be less than 128x128 pixels. Images are served by redirecting to a temporary url provided by the service used to host images. These temporary urls will expire after an hour so should not be retained for long-lasting access to a given Photo.  Each Photo may contain a block of JSON metadata recording information about the Photo. Seeing as Photos cannot be updated once created (apart from to move their status to `approved`) this metadata should not be used to store application state or any other information which is not related to the content of the Photo.  Each Photo will have a set of `PhotoIdentifier` which allow the Photo to be linked to a person record within another system.  ### The `PhotoIdentifier` Entity  The `PhotoIdentifier` entity holds the `value` and `scheme` of a given identifier. The `value` field of a `PhotoIdentifier` is a simple ID string - e.g. `wgd23` or `000001`. The `scheme` field of a `PhotoIdentifier` indicates what system this identifier relates to or was issued by. This allows many identifiers which relate to different systems to be recorded against a single `Photo`.  The supported schemes are: * `v1.person.identifiers.cam.ac.uk`: The CRSID of the person represented by this Photo * `person.v1.student-records.university.identifiers.cam.ac.uk`: The CamSIS identifier (USN) of the person represented by this Photo * `person.v1.human-resources.university.identifiers.cam.ac.uk`: The CHRIS identifier (staff number) of the person represented by this Photo * `photo.v1.legacy-card.university.identifiers.cam.ac.uk`: The id of this Photo within the legacy card system  ## Using the API  ### Auth  To authenticate against the Photo API, an application must be registered within the API Gateway and granted access to the `University Photo` product. Details of how to register an application and grant access to products can be found in the [API Gateway Getting Started Guide](https://developer.api.apps.cam.ac.uk/start-using-an-api).    # noqa: E501

    The version of the OpenAPI document: v1beta1
    Contact: devops+photoapi@uis.cam.ac.uk
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from identitylib.photo_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from identitylib.photo_client.exceptions import ApiAttributeError



class APIVersions(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'v1alpha1': (str,),  # noqa: E501
            'v1beta1': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'v1alpha1': 'v1alpha1',  # noqa: E501
        'v1beta1': 'v1beta1',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, v1alpha1, v1beta1, *args, **kwargs):  # noqa: E501
        """APIVersions - a model defined in OpenAPI

        Args:
            v1alpha1 (str):
            v1beta1 (str):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.v1alpha1 = v1alpha1
        self.v1beta1 = v1beta1
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, v1alpha1, v1beta1, *args, **kwargs):  # noqa: E501
        """APIVersions - a model defined in OpenAPI

        Args:
            v1alpha1 (str):
            v1beta1 (str):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.v1alpha1 = v1alpha1
        self.v1beta1 = v1beta1
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
