from importlib.metadata import version

from ._registry import ExtractorRegistry
from ._types import (
    EasyOCRConfig,
    Entity,
    ExtractedImage,
    ExtractionConfig,
    ExtractionResult,
    GMFTConfig,
    HTMLToMarkdownConfig,
    ImageOCRConfig,
    ImageOCRResult,
    JSONExtractionConfig,
    LanguageDetectionConfig,
    Metadata,
    PaddleOCRConfig,
    PSMMode,
    SpacyEntityExtractionConfig,
    TableData,
    TesseractConfig,
    TokenReductionConfig,
)
from .exceptions import KreuzbergError, MissingDependencyError, OCRError, ParsingError, ValidationError
from .extraction import (
    batch_extract_bytes,
    batch_extract_bytes_sync,
    batch_extract_file,
    batch_extract_file_sync,
    extract_bytes,
    extract_bytes_sync,
    extract_file,
    extract_file_sync,
)

__version__ = version("kreuzberg")

__all__ = [
    "EasyOCRConfig",
    "Entity",
    "ExtractedImage",
    "ExtractionConfig",
    "ExtractionResult",
    "ExtractorRegistry",
    "GMFTConfig",
    "HTMLToMarkdownConfig",
    "ImageOCRConfig",
    "ImageOCRResult",
    "JSONExtractionConfig",
    "KreuzbergError",
    "LanguageDetectionConfig",
    "Metadata",
    "MissingDependencyError",
    "OCRError",
    "PSMMode",
    "PaddleOCRConfig",
    "ParsingError",
    "SpacyEntityExtractionConfig",
    "TableData",
    "TesseractConfig",
    "TokenReductionConfig",
    "ValidationError",
    "__version__",
    "batch_extract_bytes",
    "batch_extract_bytes_sync",
    "batch_extract_file",
    "batch_extract_file_sync",
    "extract_bytes",
    "extract_bytes_sync",
    "extract_file",
    "extract_file_sync",
]
