# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.15.2142
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, conlist, constr
from vrt_lss_studio.models.time_window import TimeWindow

class FeatureLifetime(BaseModel):
    """
    Feature life time window.  # noqa: E501
    """
    feature: constr(strict=True, max_length=256, min_length=1) = Field(..., description="Feature. ")
    time_windows: conlist(TimeWindow, max_items=2, min_items=0, unique_items=True) = Field(..., description="A list of time windows within which the specified feature exists in the `performer_features` and `transport_features` lists. If compatibility is affected by several features with different windows - entities will be considered compatible within the intersection of windows. ")
    __properties = ["feature", "time_windows"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FeatureLifetime:
        """Create an instance of FeatureLifetime from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in time_windows (list)
        _items = []
        if self.time_windows:
            for _item in self.time_windows:
                if _item:
                    _items.append(_item.to_dict())
            _dict['time_windows'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FeatureLifetime:
        """Create an instance of FeatureLifetime from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FeatureLifetime.parse_obj(obj)

        _obj = FeatureLifetime.parse_obj({
            "feature": obj.get("feature"),
            "time_windows": [TimeWindow.from_dict(_item) for _item in obj.get("time_windows")] if obj.get("time_windows") is not None else None
        })
        return _obj


