# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg)

    The version of the OpenAPI document: 6.15.2142
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist
from vrt_lss_studio.models.compatibility_penalty import CompatibilityPenalty

class TripPenalties(BaseModel):
    """
    Planning penalties - ability to disrupt a part of the planning business rules.   # noqa: E501
    """
    compatibilities: Optional[conlist(CompatibilityPenalty, max_items=1000000, min_items=0, unique_items=True)] = Field(None, description="Penalties for compatibility violation.")
    __properties = ["compatibilities"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TripPenalties:
        """Create an instance of TripPenalties from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in compatibilities (list)
        _items = []
        if self.compatibilities:
            for _item in self.compatibilities:
                if _item:
                    _items.append(_item.to_dict())
            _dict['compatibilities'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TripPenalties:
        """Create an instance of TripPenalties from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TripPenalties.parse_obj(obj)

        _obj = TripPenalties.parse_obj({
            "compatibilities": [CompatibilityPenalty.from_dict(_item) for _item in obj.get("compatibilities")] if obj.get("compatibilities") is not None else None
        })
        return _obj


