"""
    Agent API

    This document refers to Symphony API calls to send and receive messages and content. They need the on-premise Agent installed to perform decryption/encryption of content.  - sessionToken and keyManagerToken can be obtained by calling the authenticationAPI on the symphony back end and the key manager respectively. Refer to the methods described in authenticatorAPI.yaml. - A new authorizationToken has been introduced in the authenticationAPI response payload. It can be used to replace the sessionToken in any of the API calls and can be passed as \"Authorization\" header. - Actions are defined to be atomic, ie will succeed in their entirety or fail and have changed nothing. - If it returns a 40X status then it will have sent no message to any stream even if a request to some subset of the requested streams would have succeeded. - If this contract cannot be met for any reason then this is an error and the response code will be 50X. - MessageML is a markup language for messages. See reference here: https://rest-api.symphony.com/docs/messagemlv2 - **Real Time Events**: The following events are returned when reading from a real time messages and events stream (\"datafeed\"). These events will be returned for datafeeds created with the v5 endpoints. To know more about the endpoints, refer to Create Messages/Events Stream and Read Messages/Events Stream. Unless otherwise specified, all events were added in 1.46.   # noqa: E501

    The version of the OpenAPI document: 20.15.0-SNAPSHOT
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from symphony.bdk.gen.api_client import ApiClient, Endpoint as _Endpoint
from symphony.bdk.gen.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from symphony.bdk.gen.agent_model.error import Error
from symphony.bdk.gen.agent_model.v1_dlp_dictionary_metadata_collection_response import V1DLPDictionaryMetadataCollectionResponse
from symphony.bdk.gen.agent_model.v1_dlp_dictionary_metadata_create_request import V1DLPDictionaryMetadataCreateRequest
from symphony.bdk.gen.agent_model.v1_dlp_dictionary_metadata_response import V1DLPDictionaryMetadataResponse
from symphony.bdk.gen.agent_model.v1_dlp_dictionary_metadata_update_request import V1DLPDictionaryMetadataUpdateRequest
from symphony.bdk.gen.agent_model.v1_dlp_policies_collection_response import V1DLPPoliciesCollectionResponse
from symphony.bdk.gen.agent_model.v1_dlp_policy_request import V1DLPPolicyRequest
from symphony.bdk.gen.agent_model.v1_dlp_policy_response import V1DLPPolicyResponse
from symphony.bdk.gen.agent_model.v3_dlp_policies_collection_response import V3DLPPoliciesCollectionResponse
from symphony.bdk.gen.agent_model.v3_dlp_policy_request import V3DLPPolicyRequest
from symphony.bdk.gen.agent_model.v3_dlp_policy_response import V3DLPPolicyResponse


class DLPPoliciesAndDictionaryManagementApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.v1_dlp_dictionaries_dict_id_data_download_get_endpoint = _Endpoint(
            settings={
                'response_type': (str,),
                'auth': [],
                'endpoint_path': '/v1/dlp/dictionaries/{dictId}/data/download',
                'operation_id': 'v1_dlp_dictionaries_dict_id_data_download_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'dict_id',
                    'dict_version',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'dict_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'dict_id':
                        (str,),
                    'dict_version':
                        (str,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'dict_id': 'dictId',
                    'dict_version': 'dictVersion',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'dict_id': 'path',
                    'dict_version': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/octet-stream'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_dlp_dictionaries_dict_id_data_upload_post_endpoint = _Endpoint(
            settings={
                'response_type': (V1DLPDictionaryMetadataResponse,),
                'auth': [],
                'endpoint_path': '/v1/dlp/dictionaries/{dictId}/data/upload',
                'operation_id': 'v1_dlp_dictionaries_dict_id_data_upload_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'dict_id',
                    'data',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'dict_id',
                    'data',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'dict_id':
                        (str,),
                    'data':
                        (file_type,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'dict_id': 'dictId',
                    'data': 'data',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'dict_id': 'path',
                    'data': 'form',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [
                    'multipart/form-data'
                ]
            },
            api_client=api_client
        )
        self.v1_dlp_dictionaries_dict_id_delete_endpoint = _Endpoint(
            settings={
                'response_type': (V1DLPDictionaryMetadataResponse,),
                'auth': [],
                'endpoint_path': '/v1/dlp/dictionaries/{dictId}',
                'operation_id': 'v1_dlp_dictionaries_dict_id_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'dict_id',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'dict_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'dict_id':
                        (str,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'dict_id': 'dictId',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'dict_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_dlp_dictionaries_dict_id_get_endpoint = _Endpoint(
            settings={
                'response_type': (V1DLPDictionaryMetadataResponse,),
                'auth': [],
                'endpoint_path': '/v1/dlp/dictionaries/{dictId}',
                'operation_id': 'v1_dlp_dictionaries_dict_id_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'dict_id',
                    'dict_version',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'dict_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'dict_id':
                        (str,),
                    'dict_version':
                        (str,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'dict_id': 'dictId',
                    'dict_version': 'dictVersion',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'dict_id': 'path',
                    'dict_version': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_dlp_dictionaries_dict_id_put_endpoint = _Endpoint(
            settings={
                'response_type': (V1DLPDictionaryMetadataResponse,),
                'auth': [],
                'endpoint_path': '/v1/dlp/dictionaries/{dictId}',
                'operation_id': 'v1_dlp_dictionaries_dict_id_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'dict_id',
                    'body',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'dict_id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'dict_id':
                        (str,),
                    'body':
                        (V1DLPDictionaryMetadataUpdateRequest,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'dict_id': 'dictId',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'dict_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v1_dlp_dictionaries_get_endpoint = _Endpoint(
            settings={
                'response_type': (V1DLPDictionaryMetadataCollectionResponse,),
                'auth': [],
                'endpoint_path': '/v1/dlp/dictionaries',
                'operation_id': 'v1_dlp_dictionaries_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'page',
                    'limit',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'page':
                        (int,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'page': 'page',
                    'limit': 'limit',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'page': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_dlp_dictionaries_post_endpoint = _Endpoint(
            settings={
                'response_type': (V1DLPDictionaryMetadataResponse,),
                'auth': [],
                'endpoint_path': '/v1/dlp/dictionaries',
                'operation_id': 'v1_dlp_dictionaries_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'body',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'body':
                        (V1DLPDictionaryMetadataCreateRequest,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v1_dlp_policies_get_endpoint = _Endpoint(
            settings={
                'response_type': (V1DLPPoliciesCollectionResponse,),
                'auth': [],
                'endpoint_path': '/v1/dlp/policies',
                'operation_id': 'v1_dlp_policies_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'page',
                    'limit',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'page':
                        (int,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'page': 'page',
                    'limit': 'limit',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'page': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_dlp_policies_policy_id_delete_endpoint = _Endpoint(
            settings={
                'response_type': (V1DLPPolicyResponse,),
                'auth': [],
                'endpoint_path': '/v1/dlp/policies/{policyId}',
                'operation_id': 'v1_dlp_policies_policy_id_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'policy_id':
                        (str,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'policy_id': 'policyId',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'policy_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_dlp_policies_policy_id_disable_post_endpoint = _Endpoint(
            settings={
                'response_type': (V1DLPPolicyResponse,),
                'auth': [],
                'endpoint_path': '/v1/dlp/policies/{policyId}/disable',
                'operation_id': 'v1_dlp_policies_policy_id_disable_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'policy_id':
                        (str,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'policy_id': 'policyId',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'policy_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_dlp_policies_policy_id_enable_post_endpoint = _Endpoint(
            settings={
                'response_type': (V1DLPPolicyResponse,),
                'auth': [],
                'endpoint_path': '/v1/dlp/policies/{policyId}/enable',
                'operation_id': 'v1_dlp_policies_policy_id_enable_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'policy_id':
                        (str,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'policy_id': 'policyId',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'policy_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_dlp_policies_policy_id_get_endpoint = _Endpoint(
            settings={
                'response_type': (V1DLPPolicyResponse,),
                'auth': [],
                'endpoint_path': '/v1/dlp/policies/{policyId}',
                'operation_id': 'v1_dlp_policies_policy_id_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                    'policy_version',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'policy_id':
                        (str,),
                    'policy_version':
                        (str,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'policy_id': 'policyId',
                    'policy_version': 'policyVersion',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'policy_id': 'path',
                    'policy_version': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v1_dlp_policies_policy_id_put_endpoint = _Endpoint(
            settings={
                'response_type': (V1DLPPolicyResponse,),
                'auth': [],
                'endpoint_path': '/v1/dlp/policies/{policyId}',
                'operation_id': 'v1_dlp_policies_policy_id_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                    'body',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'policy_id':
                        (str,),
                    'body':
                        (V1DLPPolicyRequest,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'policy_id': 'policyId',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'policy_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v1_dlp_policies_post_endpoint = _Endpoint(
            settings={
                'response_type': (V1DLPPolicyResponse,),
                'auth': [],
                'endpoint_path': '/v1/dlp/policies',
                'operation_id': 'v1_dlp_policies_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'body',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'body':
                        (V1DLPPolicyRequest,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v3_dlp_policies_get_endpoint = _Endpoint(
            settings={
                'response_type': (V3DLPPoliciesCollectionResponse,),
                'auth': [],
                'endpoint_path': '/v3/dlp/policies',
                'operation_id': 'v3_dlp_policies_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'page',
                    'limit',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'page':
                        (int,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'page': 'page',
                    'limit': 'limit',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'page': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v3_dlp_policies_policy_id_delete_post_endpoint = _Endpoint(
            settings={
                'response_type': (V3DLPPolicyResponse,),
                'auth': [],
                'endpoint_path': '/v3/dlp/policies/{policyId}/delete',
                'operation_id': 'v3_dlp_policies_policy_id_delete_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'policy_id':
                        (str,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'policy_id': 'policyId',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'policy_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v3_dlp_policies_policy_id_disable_post_endpoint = _Endpoint(
            settings={
                'response_type': (V3DLPPolicyResponse,),
                'auth': [],
                'endpoint_path': '/v3/dlp/policies/{policyId}/disable',
                'operation_id': 'v3_dlp_policies_policy_id_disable_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'policy_id':
                        (str,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'policy_id': 'policyId',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'policy_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v3_dlp_policies_policy_id_enable_post_endpoint = _Endpoint(
            settings={
                'response_type': (V3DLPPolicyResponse,),
                'auth': [],
                'endpoint_path': '/v3/dlp/policies/{policyId}/enable',
                'operation_id': 'v3_dlp_policies_policy_id_enable_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'policy_id':
                        (str,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'policy_id': 'policyId',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'policy_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v3_dlp_policies_policy_id_get_endpoint = _Endpoint(
            settings={
                'response_type': (V3DLPPolicyResponse,),
                'auth': [],
                'endpoint_path': '/v3/dlp/policies/{policyId}',
                'operation_id': 'v3_dlp_policies_policy_id_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                    'policy_version',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'policy_id':
                        (str,),
                    'policy_version':
                        (str,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'policy_id': 'policyId',
                    'policy_version': 'policyVersion',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'policy_id': 'path',
                    'policy_version': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.v3_dlp_policies_policy_id_update_post_endpoint = _Endpoint(
            settings={
                'response_type': (V3DLPPolicyResponse,),
                'auth': [],
                'endpoint_path': '/v3/dlp/policies/{policyId}/update',
                'operation_id': 'v3_dlp_policies_policy_id_update_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                    'body',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'policy_id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'policy_id':
                        (str,),
                    'body':
                        (V3DLPPolicyRequest,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                    'policy_id': 'policyId',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'policy_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    '*/*'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.v3_dlp_policies_post_endpoint = _Endpoint(
            settings={
                'response_type': (V3DLPPolicyResponse,),
                'auth': [],
                'endpoint_path': '/v3/dlp/policies',
                'operation_id': 'v3_dlp_policies_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'session_token',
                    'key_manager_token',
                    'body',
                ],
                'required': [
                    'session_token',
                    'key_manager_token',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'session_token':
                        (str,),
                    'key_manager_token':
                        (str,),
                    'body':
                        (V3DLPPolicyRequest,),
                },
                'attribute_map': {
                    'session_token': 'sessionToken',
                    'key_manager_token': 'keyManagerToken',
                },
                'location_map': {
                    'session_token': 'header',
                    'key_manager_token': 'header',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def v1_dlp_dictionaries_dict_id_data_download_get(
        self,
        session_token,
        key_manager_token,
        dict_id,
        **kwargs
    ):
        """Downloads Base 64 encoded dictionary content.  # noqa: E501

        Downloads Base 64 encoded dictionary content.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_dlp_dictionaries_dict_id_data_download_get(session_token, key_manager_token, dict_id, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            dict_id (str): Unique dictionary identifier

        Keyword Args:
            dict_version (str): If set to be valid dictionary version number, will return dictionary with specified version. Otherwise, return the latest dictionary. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            str
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['dict_id'] = \
            dict_id
        return self.v1_dlp_dictionaries_dict_id_data_download_get_endpoint.call_with_http_info(**kwargs)

    def v1_dlp_dictionaries_dict_id_data_upload_post(
        self,
        session_token,
        key_manager_token,
        dict_id,
        data,
        **kwargs
    ):
        """Override dictionary content with provided content.  # noqa: E501

        Override dictionary content with provided content.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_dlp_dictionaries_dict_id_data_upload_post(session_token, key_manager_token, dict_id, data, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            dict_id (str): Unique dictionary identifier
            data (file_type):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DLPDictionaryMetadataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['dict_id'] = \
            dict_id
        kwargs['data'] = \
            data
        return self.v1_dlp_dictionaries_dict_id_data_upload_post_endpoint.call_with_http_info(**kwargs)

    def v1_dlp_dictionaries_dict_id_delete(
        self,
        session_token,
        key_manager_token,
        dict_id,
        **kwargs
    ):
        """Delete a dictionary  # noqa: E501

        Deletes a dictionary. Note: All related policies will be affected.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_dlp_dictionaries_dict_id_delete(session_token, key_manager_token, dict_id, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            dict_id (str): Unique dictionary identifier

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DLPDictionaryMetadataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['dict_id'] = \
            dict_id
        return self.v1_dlp_dictionaries_dict_id_delete_endpoint.call_with_http_info(**kwargs)

    def v1_dlp_dictionaries_dict_id_get(
        self,
        session_token,
        key_manager_token,
        dict_id,
        **kwargs
    ):
        """Get dictionary metadata  # noqa: E501

        Get basic information for a dictionary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_dlp_dictionaries_dict_id_get(session_token, key_manager_token, dict_id, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            dict_id (str): Unique dictionary identifier

        Keyword Args:
            dict_version (str): If set to be valid dictionary version number, will return dictionary metadata with specified version. Otherwise, return the latest dictionary metadata. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DLPDictionaryMetadataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['dict_id'] = \
            dict_id
        return self.v1_dlp_dictionaries_dict_id_get_endpoint.call_with_http_info(**kwargs)

    def v1_dlp_dictionaries_dict_id_put(
        self,
        session_token,
        key_manager_token,
        dict_id,
        body,
        **kwargs
    ):
        """Updates a dictionary  # noqa: E501

        Updates the dictionary's basic metadata without content. This API cannot be used for creating a new dictionary. In case of update only \"name\" can be changed. Note: All related policies will also have versions updated.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_dlp_dictionaries_dict_id_put(session_token, key_manager_token, dict_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            dict_id (str): Unique dictionary identifier
            body (V1DLPDictionaryMetadataUpdateRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DLPDictionaryMetadataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['dict_id'] = \
            dict_id
        kwargs['body'] = \
            body
        return self.v1_dlp_dictionaries_dict_id_put_endpoint.call_with_http_info(**kwargs)

    def v1_dlp_dictionaries_get(
        self,
        session_token,
        key_manager_token,
        **kwargs
    ):
        """Get all dictionary metadatas  # noqa: E501

        Get all dictionary metadatas with the latest version. Each dictionary object will only contain meta data of the content.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_dlp_dictionaries_get(session_token, key_manager_token, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.

        Keyword Args:
            page (int): Optional parameter to specify which page to return (default is 0). [optional]
            limit (int): Optional parameter to specify the number of result to return per page, default is 50. Maximum is 50. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DLPDictionaryMetadataCollectionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        return self.v1_dlp_dictionaries_get_endpoint.call_with_http_info(**kwargs)

    def v1_dlp_dictionaries_post(
        self,
        session_token,
        key_manager_token,
        body,
        **kwargs
    ):
        """Create a dictionary  # noqa: E501

        Creates a dictionary with basic metadata and no content. Only \"name\" and \"type\" field is used to create a new dictionary entry.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_dlp_dictionaries_post(session_token, key_manager_token, body, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            body (V1DLPDictionaryMetadataCreateRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DLPDictionaryMetadataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['body'] = \
            body
        return self.v1_dlp_dictionaries_post_endpoint.call_with_http_info(**kwargs)

    def v1_dlp_policies_get(
        self,
        session_token,
        key_manager_token,
        **kwargs
    ):
        """Get all policies  # noqa: E501

        Get all policies  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_dlp_policies_get(session_token, key_manager_token, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.

        Keyword Args:
            page (int): Optional parameter to specify which page to return (default is 0). [optional]
            limit (int): Optional parameter to specify the number of result to return per page, default is 50. Maximum is 50. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DLPPoliciesCollectionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        return self.v1_dlp_policies_get_endpoint.call_with_http_info(**kwargs)

    def v1_dlp_policies_policy_id_delete(
        self,
        session_token,
        key_manager_token,
        policy_id,
        **kwargs
    ):
        """Delete a policy  # noqa: E501

        Delete a policy. Note: Only disabled policy can be deleted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_dlp_policies_policy_id_delete(session_token, key_manager_token, policy_id, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            policy_id (str): Unique dictionary identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DLPPolicyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['policy_id'] = \
            policy_id
        return self.v1_dlp_policies_policy_id_delete_endpoint.call_with_http_info(**kwargs)

    def v1_dlp_policies_policy_id_disable_post(
        self,
        session_token,
        key_manager_token,
        policy_id,
        **kwargs
    ):
        """Disables a policy.  # noqa: E501

        Disables a policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_dlp_policies_policy_id_disable_post(session_token, key_manager_token, policy_id, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            policy_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DLPPolicyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['policy_id'] = \
            policy_id
        return self.v1_dlp_policies_policy_id_disable_post_endpoint.call_with_http_info(**kwargs)

    def v1_dlp_policies_policy_id_enable_post(
        self,
        session_token,
        key_manager_token,
        policy_id,
        **kwargs
    ):
        """Enables a policy.  # noqa: E501

        Enables a policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_dlp_policies_policy_id_enable_post(session_token, key_manager_token, policy_id, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            policy_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DLPPolicyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['policy_id'] = \
            policy_id
        return self.v1_dlp_policies_policy_id_enable_post_endpoint.call_with_http_info(**kwargs)

    def v1_dlp_policies_policy_id_get(
        self,
        session_token,
        key_manager_token,
        policy_id,
        **kwargs
    ):
        """Get a policy  # noqa: E501

        Get a policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_dlp_policies_policy_id_get(session_token, key_manager_token, policy_id, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            policy_id (str): Unique dictionary identifier.

        Keyword Args:
            policy_version (str): Optional parameter, if set to be valid policy version number,  will return policy with specified policyVersion. Otherwise, return the latest policy. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DLPPolicyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['policy_id'] = \
            policy_id
        return self.v1_dlp_policies_policy_id_get_endpoint.call_with_http_info(**kwargs)

    def v1_dlp_policies_policy_id_put(
        self,
        session_token,
        key_manager_token,
        policy_id,
        body,
        **kwargs
    ):
        """Updates a policy. Cannot be used for creation.  # noqa: E501

        Update the policy (name, type, contentTypes, scopes) and also the dictionaries for a policy. Warning: If you send empty list of dictionaries during the update operation, then all the dictionaries for this policy are deleted and policy is automatically disabled. Note: The policy should already exist.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_dlp_policies_policy_id_put(session_token, key_manager_token, policy_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            policy_id (str): Unique dictionary identifier.
            body (V1DLPPolicyRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DLPPolicyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['policy_id'] = \
            policy_id
        kwargs['body'] = \
            body
        return self.v1_dlp_policies_policy_id_put_endpoint.call_with_http_info(**kwargs)

    def v1_dlp_policies_post(
        self,
        session_token,
        key_manager_token,
        body,
        **kwargs
    ):
        """Creates a policy  # noqa: E501

        Creates a new policy with dictionary references.  At the time of policy creation, the caller should only provide - contentTypes, name, scopes and type. The rest of the information is populated automatically.  Note - You need to enable the policy after creation to start enforcing the policy.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v1_dlp_policies_post(session_token, key_manager_token, body, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            body (V1DLPPolicyRequest): Details about the policy that should be created.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DLPPolicyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['body'] = \
            body
        return self.v1_dlp_policies_post_endpoint.call_with_http_info(**kwargs)

    def v3_dlp_policies_get(
        self,
        session_token,
        key_manager_token,
        **kwargs
    ):
        """Get all policies  # noqa: E501

        Get all policies  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v3_dlp_policies_get(session_token, key_manager_token, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.

        Keyword Args:
            page (int): Optional parameter to specify which page to return (default is 0). [optional]
            limit (int): Optional parameter to specify the number of result to return per page, default is 50. Maximum is 50. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V3DLPPoliciesCollectionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        return self.v3_dlp_policies_get_endpoint.call_with_http_info(**kwargs)

    def v3_dlp_policies_policy_id_delete_post(
        self,
        session_token,
        key_manager_token,
        policy_id,
        **kwargs
    ):
        """Delete a policy  # noqa: E501

        Delete a policy. Note: Only disabled policy can be deleted   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v3_dlp_policies_policy_id_delete_post(session_token, key_manager_token, policy_id, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            policy_id (str): Unique dictionary identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V3DLPPolicyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['policy_id'] = \
            policy_id
        return self.v3_dlp_policies_policy_id_delete_post_endpoint.call_with_http_info(**kwargs)

    def v3_dlp_policies_policy_id_disable_post(
        self,
        session_token,
        key_manager_token,
        policy_id,
        **kwargs
    ):
        """Disables a policy.  # noqa: E501

        Disables a policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v3_dlp_policies_policy_id_disable_post(session_token, key_manager_token, policy_id, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            policy_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V3DLPPolicyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['policy_id'] = \
            policy_id
        return self.v3_dlp_policies_policy_id_disable_post_endpoint.call_with_http_info(**kwargs)

    def v3_dlp_policies_policy_id_enable_post(
        self,
        session_token,
        key_manager_token,
        policy_id,
        **kwargs
    ):
        """Enables a policy.  # noqa: E501

        Enables a policy.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v3_dlp_policies_policy_id_enable_post(session_token, key_manager_token, policy_id, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            policy_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V3DLPPolicyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['policy_id'] = \
            policy_id
        return self.v3_dlp_policies_policy_id_enable_post_endpoint.call_with_http_info(**kwargs)

    def v3_dlp_policies_policy_id_get(
        self,
        session_token,
        key_manager_token,
        policy_id,
        **kwargs
    ):
        """Get a policy  # noqa: E501

        Get a policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v3_dlp_policies_policy_id_get(session_token, key_manager_token, policy_id, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            policy_id (str): Unique dictionary identifier.

        Keyword Args:
            policy_version (str): Optional parameter, if set to be valid policy version number,  will return policy with specified policyVersion. Otherwise, return the latest policy. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V3DLPPolicyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['policy_id'] = \
            policy_id
        return self.v3_dlp_policies_policy_id_get_endpoint.call_with_http_info(**kwargs)

    def v3_dlp_policies_policy_id_update_post(
        self,
        session_token,
        key_manager_token,
        policy_id,
        body,
        **kwargs
    ):
        """Updates a policy. Cannot be used for creation.  # noqa: E501

        Update the policy (name, type, contentTypes, scopes) and also the dictionaries for a policy. Warning: If you send empty list of dictionaries during the update operation, then all the dictionaries for this policy are deleted and policy is automatically disabled. Note: The policy should already exist.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v3_dlp_policies_policy_id_update_post(session_token, key_manager_token, policy_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            policy_id (str): Unique dictionary identifier.
            body (V3DLPPolicyRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V3DLPPolicyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['policy_id'] = \
            policy_id
        kwargs['body'] = \
            body
        return self.v3_dlp_policies_policy_id_update_post_endpoint.call_with_http_info(**kwargs)

    def v3_dlp_policies_post(
        self,
        session_token,
        key_manager_token,
        body,
        **kwargs
    ):
        """Creates a policy  # noqa: E501

        Creates a new policy with dictionary references. At the time of policy creation, the caller should only provide - contentTypes, name, scopes and type. The rest of the information is populated automatically. Note - You need to enable the policy after creation to start enforcing the policy.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = agent_api.v3_dlp_policies_post(session_token, key_manager_token, body, async_req=True)
        >>> result = thread.get()

        Args:
            session_token (str): Session authentication token.
            key_manager_token (str): Key Manager authentication token.
            body (V3DLPPolicyRequest): Details about the policy that should be created.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V3DLPPolicyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['session_token'] = \
            session_token
        kwargs['key_manager_token'] = \
            key_manager_token
        kwargs['body'] = \
            body
        return self.v3_dlp_policies_post_endpoint.call_with_http_info(**kwargs)

