"""Contains all the data models used in inputs/outputs"""

from .changelog_response import ChangelogResponse
from .client_response import ClientResponse
from .current_user_response import CurrentUserResponse
from .login_choose_response import LoginChooseResponse
from .login_choose_response_clients_item import LoginChooseResponseClientsItem
from .login_choose_response_type import LoginChooseResponseType
from .login_payload import LoginPayload
from .login_token_response import LoginTokenResponse
from .login_token_response_type import LoginTokenResponseType
from .post_auth_register_body import PostAuthRegisterBody
from .post_auth_reset_password_body import PostAuthResetPasswordBody
from .post_back_office_event_definition_email_subscription_body import (
    PostBackOfficeEventDefinitionEmailSubscriptionBody,
)
from .post_comment_new_body import PostCommentNewBody
from .post_container_delete_many_body import PostContainerDeleteManyBody
from .post_container_new_many_body import PostContainerNewManyBody
from .post_custom_field_body import PostCustomFieldBody
from .post_custom_field_option_id_custom_field_body import PostCustomFieldOptionIdCustomFieldBody
from .post_device_live_data_update_body import PostDeviceLiveDataUpdateBody
from .post_device_map_corrections_body import PostDeviceMapCorrectionsBody
from .post_device_submit_check_in_body import PostDeviceSubmitCheckInBody
from .post_error_report_device_crash_report_body import PostErrorReportDeviceCrashReportBody
from .post_event_definition_category_new_body import PostEventDefinitionCategoryNewBody
from .post_event_definition_new_body import PostEventDefinitionNewBody
from .post_event_delete_many_body import PostEventDeleteManyBody
from .post_external_button_collect_request_body import PostExternalButtonCollectRequestBody
from .post_external_create_ifm_itinerary_id_realisation_body import PostExternalCreateIFMItineraryIdRealisationBody
from .post_external_live_vehicle_data_body import PostExternalLiveVehicleDataBody
from .post_operational_layers_data_source_body import PostOperationalLayersDataSourceBody
from .post_producer_delete_many_body import PostProducerDeleteManyBody
from .post_producer_id_uni_and_co_user_body import PostProducerIdUniAndCoUserBody
from .post_producing_place_by_serial_numbers_body import PostProducingPlaceBySerialNumbersBody
from .post_producing_place_delete_many_body import PostProducingPlaceDeleteManyBody
from .post_producing_place_distinct_by_containers_ids_body import PostProducingPlaceDistinctByContainersIdsBody
from .post_producing_place_unique_stream_containers_total_by_ids_body import (
    PostProducingPlaceUniqueStreamContainersTotalByIdsBody,
)
from .post_realisation_round_delete_many_body import PostRealisationRoundDeleteManyBody
from .post_realisation_round_outlet_realised_body import PostRealisationRoundOutletRealisedBody
from .post_round_tracks_body import PostRoundTracksBody
from .post_route_parts_availabilities_body import PostRoutePartsAvailabilitiesBody
from .post_route_parts_producing_place_in_polygon_body import PostRoutePartsProducingPlaceInPolygonBody
from .post_sector_new_body import PostSectorNewBody
from .post_stream_new_body import PostStreamNewBody
from .post_unibac_login_body import PostUnibacLoginBody
from .post_unibac_reset_password_body import PostUnibacResetPasswordBody
from .post_unibac_scan_body import PostUnibacScanBody
from .post_vehicle_environmental_criterion_new_body import PostVehicleEnvironmentalCriterionNewBody
from .post_vehicle_loading_type_new_body import PostVehicleLoadingTypeNewBody
from .post_vehicle_vehicle_profile_new_body import PostVehicleVehicleProfileNewBody
from .put_auth_by_id_id_body import PutAuthByIdIdBody
from .put_auth_change_password_body import PutAuthChangePasswordBody
from .put_calendar_settings_body import PutCalendarSettingsBody
from .put_client_default_speed_on_segment_km_h_body import PutClientDefaultSpeedOnSegmentKmHBody
from .put_client_mapbox_body import PutClientMapboxBody
from .put_client_show_deadheading_body import PutClientShowDeadheadingBody
from .put_comment_by_id_id_body import PutCommentByIdIdBody
from .put_constraint_body import PutConstraintBody
from .put_container_update_state_by_id_id_body import PutContainerUpdateStateByIdIdBody
from .put_employee_archive_id_body import PutEmployeeArchiveIdBody
from .put_employee_archive_many_body import PutEmployeeArchiveManyBody
from .put_employee_id_constraint_body import PutEmployeeIdConstraintBody
from .put_employee_sectors_id_body import PutEmployeeSectorsIdBody
from .put_event_definition_by_id_id_body import PutEventDefinitionByIdIdBody
from .put_event_definition_category_by_id_id_body import PutEventDefinitionCategoryByIdIdBody
from .put_intervention_id_planned_date_body import PutInterventionIdPlannedDateBody
from .put_outlet_id_body import PutOutletIdBody
from .put_producing_place_id_update_trackdechets_info_body import PutProducingPlaceIdUpdateTrackdechetsInfoBody
from .put_producing_place_linked_producers_body import PutProducingPlaceLinkedProducersBody
from .put_producing_place_sectors_id_body import PutProducingPlaceSectorsIdBody
from .put_realisation_round_proof_of_passage_id_ppra_body import PutRealisationRoundProofOfPassageIdPpraBody
from .put_round_body import PutRoundBody
from .put_round_occurrence_body import PutRoundOccurrenceBody
from .put_round_round_slots_id_round_body import PutRoundRoundSlotsIdRoundBody
from .put_stream_by_id_id_body import PutStreamByIdIdBody
from .put_street_service_transpose_realisation_id_realisation_body import (
    PutStreetServiceTransposeRealisationIdRealisationBody,
)
from .put_unibac_change_password_body import PutUnibacChangePasswordBody
from .put_user_preferences_logistic_params_column_body import PutUserPreferencesLogisticParamsColumnBody
from .put_user_preferences_operational_tabs_params_body import PutUserPreferencesOperationalTabsParamsBody
from .put_user_preferences_pdf_export_params_body import PutUserPreferencesPdfExportParamsBody
from .put_vehicle_archive_many_body import PutVehicleArchiveManyBody
from .put_vehicle_archive_vehicle_id_body import PutVehicleArchiveVehicleIdBody
from .put_vehicle_environmental_criterion_update_body import PutVehicleEnvironmentalCriterionUpdateBody
from .put_vehicle_loading_type_update_body import PutVehicleLoadingTypeUpdateBody
from .put_vehicle_sectors_sector_id_body import PutVehicleSectorsSectorIdBody
from .put_vehicle_vehicle_profile_update_body import PutVehicleVehicleProfileUpdateBody

__all__ = (
    "ChangelogResponse",
    "ClientResponse",
    "CurrentUserResponse",
    "LoginChooseResponse",
    "LoginChooseResponseClientsItem",
    "LoginChooseResponseType",
    "LoginPayload",
    "LoginTokenResponse",
    "LoginTokenResponseType",
    "PostAuthRegisterBody",
    "PostAuthResetPasswordBody",
    "PostBackOfficeEventDefinitionEmailSubscriptionBody",
    "PostCommentNewBody",
    "PostContainerDeleteManyBody",
    "PostContainerNewManyBody",
    "PostCustomFieldBody",
    "PostCustomFieldOptionIdCustomFieldBody",
    "PostDeviceLiveDataUpdateBody",
    "PostDeviceMapCorrectionsBody",
    "PostDeviceSubmitCheckInBody",
    "PostErrorReportDeviceCrashReportBody",
    "PostEventDefinitionCategoryNewBody",
    "PostEventDefinitionNewBody",
    "PostEventDeleteManyBody",
    "PostExternalButtonCollectRequestBody",
    "PostExternalCreateIFMItineraryIdRealisationBody",
    "PostExternalLiveVehicleDataBody",
    "PostOperationalLayersDataSourceBody",
    "PostProducerDeleteManyBody",
    "PostProducerIdUniAndCoUserBody",
    "PostProducingPlaceBySerialNumbersBody",
    "PostProducingPlaceDeleteManyBody",
    "PostProducingPlaceDistinctByContainersIdsBody",
    "PostProducingPlaceUniqueStreamContainersTotalByIdsBody",
    "PostRealisationRoundDeleteManyBody",
    "PostRealisationRoundOutletRealisedBody",
    "PostRoundTracksBody",
    "PostRoutePartsAvailabilitiesBody",
    "PostRoutePartsProducingPlaceInPolygonBody",
    "PostSectorNewBody",
    "PostStreamNewBody",
    "PostUnibacLoginBody",
    "PostUnibacResetPasswordBody",
    "PostUnibacScanBody",
    "PostVehicleEnvironmentalCriterionNewBody",
    "PostVehicleLoadingTypeNewBody",
    "PostVehicleVehicleProfileNewBody",
    "PutAuthByIdIdBody",
    "PutAuthChangePasswordBody",
    "PutCalendarSettingsBody",
    "PutClientDefaultSpeedOnSegmentKmHBody",
    "PutClientMapboxBody",
    "PutClientShowDeadheadingBody",
    "PutCommentByIdIdBody",
    "PutConstraintBody",
    "PutContainerUpdateStateByIdIdBody",
    "PutEmployeeArchiveIdBody",
    "PutEmployeeArchiveManyBody",
    "PutEmployeeIdConstraintBody",
    "PutEmployeeSectorsIdBody",
    "PutEventDefinitionByIdIdBody",
    "PutEventDefinitionCategoryByIdIdBody",
    "PutInterventionIdPlannedDateBody",
    "PutOutletIdBody",
    "PutProducingPlaceIdUpdateTrackdechetsInfoBody",
    "PutProducingPlaceLinkedProducersBody",
    "PutProducingPlaceSectorsIdBody",
    "PutRealisationRoundProofOfPassageIdPpraBody",
    "PutRoundBody",
    "PutRoundOccurrenceBody",
    "PutRoundRoundSlotsIdRoundBody",
    "PutStreamByIdIdBody",
    "PutStreetServiceTransposeRealisationIdRealisationBody",
    "PutUnibacChangePasswordBody",
    "PutUserPreferencesLogisticParamsColumnBody",
    "PutUserPreferencesOperationalTabsParamsBody",
    "PutUserPreferencesPdfExportParamsBody",
    "PutVehicleArchiveManyBody",
    "PutVehicleArchiveVehicleIdBody",
    "PutVehicleEnvironmentalCriterionUpdateBody",
    "PutVehicleLoadingTypeUpdateBody",
    "PutVehicleSectorsSectorIdBody",
    "PutVehicleVehicleProfileUpdateBody",
)
