from typing import Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="PostOperationalLayersDataSourceBody")


@_attrs_define
class PostOperationalLayersDataSourceBody:
    """
    Attributes:
        shared_form (Union[Unset, Any]):  Example: any.
        producing_place_related_form (Union[Unset, Any]):  Example: any.
        event_related_form (Union[Unset, Any]):  Example: any.
    """

    shared_form: Union[Unset, Any] = UNSET
    producing_place_related_form: Union[Unset, Any] = UNSET
    event_related_form: Union[Unset, Any] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        shared_form = self.shared_form

        producing_place_related_form = self.producing_place_related_form

        event_related_form = self.event_related_form

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if shared_form is not UNSET:
            field_dict["sharedForm"] = shared_form
        if producing_place_related_form is not UNSET:
            field_dict["producingPlaceRelatedForm"] = producing_place_related_form
        if event_related_form is not UNSET:
            field_dict["eventRelatedForm"] = event_related_form

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        shared_form = d.pop("sharedForm", UNSET)

        producing_place_related_form = d.pop("producingPlaceRelatedForm", UNSET)

        event_related_form = d.pop("eventRelatedForm", UNSET)

        post_operational_layers_data_source_body = cls(
            shared_form=shared_form,
            producing_place_related_form=producing_place_related_form,
            event_related_form=event_related_form,
        )

        post_operational_layers_data_source_body.additional_properties = d
        return post_operational_layers_data_source_body

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
