"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .payment_link_response import PaymentLinkResponse, PaymentLinkResponseTypedDict
from .profile_response import ProfileResponse, ProfileResponseTypedDict
from .url import URL, URLTypedDict
from enum import Enum
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class EntityWebhookEventWebhookEventTypes(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The list of events to enable for this webhook. You may specify `'*'` to add all events, except those
    that require explicit selection.
    """

    PAYMENT_LINK_PAID = "payment-link.paid"
    BALANCE_TRANSACTION_CREATED = "balance-transaction.created"
    SALES_INVOICE_CREATED = "sales-invoice.created"
    SALES_INVOICE_ISSUED = "sales-invoice.issued"
    SALES_INVOICE_CANCELED = "sales-invoice.canceled"
    SALES_INVOICE_PAID = "sales-invoice.paid"
    WILDCARD_ = "*"


EntityTypedDict = TypeAliasType(
    "EntityTypedDict", Union[ProfileResponseTypedDict, PaymentLinkResponseTypedDict]
)


Entity = TypeAliasType("Entity", Union[ProfileResponse, PaymentLinkResponse])


class EmbeddedTypedDict(TypedDict):
    r"""Full payload of the event."""

    entity: NotRequired[EntityTypedDict]


class Embedded(BaseModel):
    r"""Full payload of the event."""

    entity: Optional[Entity] = None


class EntityWebhookEventLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    entity: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityWebhookEventLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    entity: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityWebhookEventTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a webhook event object. Will always contain the string `event` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this event."""
    webhook_event_types: EntityWebhookEventWebhookEventTypes
    entity_id: str
    r"""The entity token that triggered the event"""
    created_at: str
    r"""The event's date time of creation."""
    links: EntityWebhookEventLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    embedded: NotRequired[Nullable[EmbeddedTypedDict]]
    r"""Full payload of the event."""


class EntityWebhookEvent(BaseModel):
    resource: str
    r"""Indicates the response contains a webhook event object. Will always contain the string `event` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this event."""

    webhook_event_types: Annotated[
        Annotated[
            EntityWebhookEventWebhookEventTypes,
            PlainValidator(validate_open_enum(False)),
        ],
        pydantic.Field(alias="type"),
    ]

    entity_id: Annotated[str, pydantic.Field(alias="entityId")]
    r"""The entity token that triggered the event"""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The event's date time of creation."""

    links: Annotated[EntityWebhookEventLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    embedded: Annotated[
        OptionalNullable[Embedded], pydantic.Field(alias="_embedded")
    ] = UNSET
    r"""Full payload of the event."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["_embedded"]
        nullable_fields = ["_embedded"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
