"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .entity_capability import EntityCapability, EntityCapabilityTypedDict
from .url import URL, URLTypedDict
from mollie.types import BaseModel
from mollie.utils import FieldMetadata, HeaderMetadata
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListCapabilitiesRequestTypedDict(TypedDict):
    idempotency_key: NotRequired[str]
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""


class ListCapabilitiesRequest(BaseModel):
    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="idempotency-key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""


class ListCapabilitiesEmbeddedTypedDict(TypedDict):
    capabilities: List[EntityCapabilityTypedDict]


class ListCapabilitiesEmbedded(BaseModel):
    capabilities: List[EntityCapability]


class ListCapabilitiesLinksTypedDict(TypedDict):
    documentation: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListCapabilitiesLinks(BaseModel):
    documentation: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListCapabilitiesResponseTypedDict(TypedDict):
    r"""A list of capabilities."""

    count: int
    r"""The number of items in this result set."""
    embedded: ListCapabilitiesEmbeddedTypedDict
    links: ListCapabilitiesLinksTypedDict


class ListCapabilitiesResponse(BaseModel):
    r"""A list of capabilities."""

    count: int
    r"""The number of items in this result set."""

    embedded: Annotated[ListCapabilitiesEmbedded, pydantic.Field(alias="_embedded")]

    links: Annotated[ListCapabilitiesLinks, pydantic.Field(alias="_links")]
