"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .method_status import MethodStatus
from .url import URL, URLTypedDict
from enum import Enum
from mollie import utils
from mollie.types import BaseModel, Nullable, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListEntityMethodID(str, Enum, metaclass=utils.OpenEnumMeta):
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment
    method selection screen will be skipped.
    """

    ALMA = "alma"
    APPLEPAY = "applepay"
    BACS = "bacs"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    IDEAL = "ideal"
    IN3 = "in3"
    KBC = "kbc"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MOBILEPAY = "mobilepay"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    POINTOFSALE = "pointofsale"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VIPPS = "vipps"
    VOUCHER = "voucher"
    # Deprecated, use 'klarna' instead
    KLARNAPAYLATER = "klarnapaylater"
    # Deprecated, use 'klarna' instead
    KLARNAPAYNOW = "klarnapaynow"
    # Deprecated, use 'klarna' instead
    KLARNASLICEIT = "klarnasliceit"
    # No longer available
    PAYCONIQ = "payconiq"


class ListEntityMethodMinimumAmountTypedDict(TypedDict):
    r"""The minimum payment amount required to use this payment method."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListEntityMethodMinimumAmount(BaseModel):
    r"""The minimum payment amount required to use this payment method."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListEntityMethodMaximumAmountTypedDict(TypedDict):
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null`
    is returned instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListEntityMethodMaximumAmount(BaseModel):
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null`
    is returned instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListEntityMethodImageTypedDict(TypedDict):
    r"""URLs of images representing the payment method."""

    size1x: str
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: str
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: str
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class ListEntityMethodImage(BaseModel):
    r"""URLs of images representing the payment method."""

    size1x: str
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: str
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: str
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class ListEntityMethodIssuerImageTypedDict(TypedDict):
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """

    size1x: NotRequired[str]
    r"""The URL pointing to an icon of 32 by 24 pixels."""
    size2x: NotRequired[str]
    r"""The URL pointing to an icon of 64 by 48 pixels."""
    svg: NotRequired[str]
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class ListEntityMethodIssuerImage(BaseModel):
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """

    size1x: Optional[str] = None
    r"""The URL pointing to an icon of 32 by 24 pixels."""

    size2x: Optional[str] = None
    r"""The URL pointing to an icon of 64 by 48 pixels."""

    svg: Optional[str] = None
    r"""The URL pointing to a vector version of the icon. Usage of this format is preferred, since the icon can
    scale to any desired size without compromising visual quality.
    """


class ListEntityMethodIssuerTypedDict(TypedDict):
    resource: str
    id: str
    name: str
    r"""The full name of the issuer."""
    image: ListEntityMethodIssuerImageTypedDict
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """


class ListEntityMethodIssuer(BaseModel):
    resource: str

    id: str

    name: str
    r"""The full name of the issuer."""

    image: ListEntityMethodIssuerImage
    r"""URLs of images representing the issuer.
    required:
    - size1x
    - size2x
    - svg
    """


class ListEntityMethodLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListEntityMethodLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListEntityMethodTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a payment method object. Will always contain the string `method` for this
    endpoint.
    """
    id: Nullable[ListEntityMethodID]
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment
    method selection screen will be skipped.
    """
    description: str
    r"""The full name of the payment method.

    If a `locale` parameter is provided, the name is translated to the given locale if possible.
    """
    minimum_amount: ListEntityMethodMinimumAmountTypedDict
    r"""The minimum payment amount required to use this payment method."""
    maximum_amount: Nullable[ListEntityMethodMaximumAmountTypedDict]
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null`
    is returned instead.
    """
    image: ListEntityMethodImageTypedDict
    r"""URLs of images representing the payment method."""
    status: Nullable[MethodStatus]
    r"""The payment method's activation status for this profile."""
    links: ListEntityMethodLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    issuers: NotRequired[List[ListEntityMethodIssuerTypedDict]]
    r"""**Optional include.** Array of objects for each 'issuer' that is available for this payment method. Only relevant
    for iDEAL, KBC/CBC, gift cards, and vouchers.
    """


class ListEntityMethod(BaseModel):
    resource: str
    r"""Indicates the response contains a payment method object. Will always contain the string `method` for this
    endpoint.
    """

    id: Annotated[
        Nullable[ListEntityMethodID], PlainValidator(validate_open_enum(False))
    ]
    r"""The unique identifier of the payment method. When used during [payment creation](create-payment), the payment
    method selection screen will be skipped.
    """

    description: str
    r"""The full name of the payment method.

    If a `locale` parameter is provided, the name is translated to the given locale if possible.
    """

    minimum_amount: Annotated[
        ListEntityMethodMinimumAmount, pydantic.Field(alias="minimumAmount")
    ]
    r"""The minimum payment amount required to use this payment method."""

    maximum_amount: Annotated[
        Nullable[ListEntityMethodMaximumAmount], pydantic.Field(alias="maximumAmount")
    ]
    r"""The maximum payment amount allowed when using this payment method. If there is no method-specific maximum, `null`
    is returned instead.
    """

    image: ListEntityMethodImage
    r"""URLs of images representing the payment method."""

    status: Annotated[Nullable[MethodStatus], PlainValidator(validate_open_enum(False))]
    r"""The payment method's activation status for this profile."""

    links: Annotated[ListEntityMethodLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    issuers: Optional[List[ListEntityMethodIssuer]] = None
    r"""**Optional include.** Array of objects for each 'issuer' that is available for this payment method. Only relevant
    for iDEAL, KBC/CBC, gift cards, and vouchers.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["issuers"]
        nullable_fields = ["id", "maximumAmount", "status"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
