"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .list_links import ListLinks, ListLinksTypedDict
from .list_profile_response import ListProfileResponse, ListProfileResponseTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, HeaderMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListProfilesRequestTypedDict(TypedDict):
    from_: NotRequired[Nullable[str]]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    idempotency_key: NotRequired[str]
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""


class ListProfilesRequest(BaseModel):
    from_: Annotated[
        OptionalNullable[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The maximum number of items to return. Defaults to 50 items."""

    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="idempotency-key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "idempotency-key"]
        nullable_fields = ["from", "limit"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListProfilesEmbeddedTypedDict(TypedDict):
    profiles: List[ListProfileResponseTypedDict]
    r"""An array of profile objects."""


class ListProfilesEmbedded(BaseModel):
    profiles: List[ListProfileResponse]
    r"""An array of profile objects."""


class ListProfilesResponseTypedDict(TypedDict):
    r"""A list of profile objects."""

    count: int
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: ListProfilesEmbeddedTypedDict
    links: ListLinksTypedDict
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListProfilesResponse(BaseModel):
    r"""A list of profile objects."""

    count: int
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[ListProfilesEmbedded, pydantic.Field(alias="_embedded")]

    links: Annotated[ListLinks, pydantic.Field(alias="_links")]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
