"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .sales_invoice_payment_details_source_response import (
    SalesInvoicePaymentDetailsSourceResponse,
)
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing_extensions import Annotated, NotRequired, TypedDict


class SalesInvoicePaymentDetailsResponseTypedDict(TypedDict):
    source: SalesInvoicePaymentDetailsSourceResponse
    r"""The way through which the invoice is to be set to paid."""
    source_reference: NotRequired[Nullable[str]]
    r"""A reference to the payment the sales invoice is paid by. Required for `source` values `payment-link` and
    `payment`.
    """


class SalesInvoicePaymentDetailsResponse(BaseModel):
    source: Annotated[
        SalesInvoicePaymentDetailsSourceResponse,
        PlainValidator(validate_open_enum(False)),
    ]
    r"""The way through which the invoice is to be set to paid."""

    source_reference: Annotated[
        OptionalNullable[str], pydantic.Field(alias="sourceReference")
    ] = UNSET
    r"""A reference to the payment the sales invoice is paid by. Required for `source` values `payment-link` and
    `payment`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceReference"]
        nullable_fields = ["sourceReference"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
