"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie.types import BaseModel
from mollie.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import pydantic
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class TestWebhookRequestBodyTypedDict(TypedDict):
    __test__ = False  # pyright: ignore[reportGeneralTypeIssues]

    testmode: NotRequired[bool]
    r"""You can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class TestWebhookRequestBody(BaseModel):
    __test__ = False

    testmode: Optional[bool] = None
    r"""You can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class TestWebhookRequestTypedDict(TypedDict):
    __test__ = False  # pyright: ignore[reportGeneralTypeIssues]

    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    idempotency_key: NotRequired[str]
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""
    request_body: NotRequired[TestWebhookRequestBodyTypedDict]


class TestWebhookRequest(BaseModel):
    __test__ = False

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="idempotency-key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""

    request_body: Annotated[
        Optional[TestWebhookRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None
