# Generated by Django 2.1.3 on 2018-11-27 19:02

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import simple_history.models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('quartet_masterdata', '0001_initial'),
        ('serialbox', '0005_auto_20181031_1738'),
        ('quartet_output', '0002_auto_20180909_0946'),
        ('list_based_flavorpack', '0002_auto_20181002_1052'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('quartet_capture', '0003_auto_20181127_1120'),
        ('quartet_templates', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalAuthenticationInfo',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('username', models.CharField(help_text='The username.', max_length=150, verbose_name='Username')),
                ('password', models.CharField(help_text='The password for the user.', max_length=25, verbose_name='Password')),
                ('type', models.CharField(help_text='The type of authentication to use.  For example, Basic, Digest, SSH, etc.  This is optional depending on whether or not any steps require this information.', max_length=25, verbose_name='Type')),
                ('description', models.CharField(help_text='An optional description.', max_length=200, null=True, verbose_name='Description')),
                ('private_key', models.TextField(help_text='Any private key value if applicable.', null=True, verbose_name='Private Key')),
                ('public_key', models.TextField(help_text='Any public key info if applicable.', null=True, verbose_name='Public Key')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical authentication info',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalCompany',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('GLN13', models.CharField(db_index=True, help_text='The GLN (Global Location Number) provides a standard means to identify legal entities, trading parties and locations to support the requirements of electronic commerce. The GLN-13 is defined by GS1', max_length=13, null=True, verbose_name='GLN13')),
                ('SGLN', models.CharField(db_index=True, help_text='The SGLN EPC scheme is used to assign a unique identity to a physical location or sub-location, such as a specific building or a specific unit of shelving within a warehouse.  TheSGLN is expressed as a URN value.', max_length=150, null=True, verbose_name='SGLN')),
                ('name', models.CharField(db_index=True, help_text='A unique name for the location or party.', max_length=128, verbose_name='Name')),
                ('address1', models.CharField(help_text='For example, the name of the street and the number in the street or the name of a building', max_length=1000, null=True, verbose_name='Street Address One')),
                ('address2', models.CharField(help_text='The second free form line complements the first free form line to locate the party or location.', max_length=1000, null=True, verbose_name='Street Address Two')),
                ('address3', models.CharField(help_text='The third free form line complements the first and second free form lines where necessary.', max_length=1000, null=True, verbose_name='Street Address Three')),
                ('country', models.CharField(help_text='Country ISO 3166-1 alpha-2 Code', max_length=2, null=True, verbose_name='Country Code')),
                ('city', models.CharField(help_text='City', max_length=50, null=True, verbose_name='city')),
                ('state_province', models.CharField(help_text='One of the constituent units of a nation having a federal government.', max_length=20, null=True, verbose_name='State or Province')),
                ('postal_code', models.CharField(help_text='Postal Code', max_length=20, null=True, verbose_name='Postal Code')),
                ('latitude', models.DecimalField(decimal_places=6, help_text=' Latitude of the location, in degrees. Positive numbers are northern latitude; negative numbers are southern latitude.', max_digits=9, null=True, verbose_name='Latitude')),
                ('longitude', models.DecimalField(decimal_places=6, help_text='Longitude of the location, in degrees. Positive numbers are eastern longitude; negative numbers are western longitude.', max_digits=9, null=True, verbose_name='Longitude')),
                ('gs1_company_prefix', models.CharField(help_text='A GS1 Company Prefix is a unique string of four to twelve digits used to issue GS1 identification keys.', max_length=12, verbose_name='GS1 Company Prefix')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('company_type', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_masterdata.CompanyType')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical company',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalCompanyType',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('identifier', models.CharField(db_index=True, help_text='The unique type identifier.', max_length=20, verbose_name='Identifier')),
                ('description', models.CharField(help_text='A brief description of the type.', max_length=400, verbose_name='Description')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical CompanyType',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalEndPoint',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(db_index=True, help_text='The name of the endpoint', max_length=150, verbose_name='Name')),
                ('urn', models.CharField(help_text='A uniform resource locator that includes protocol information.', max_length=1000, verbose_name='URL')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical end point',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalEPCISOutputCriteria',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(db_index=True, help_text='The name of the criteria record', max_length=150, verbose_name='Name')),
                ('sender_identifier', models.CharField(help_text='Typically an SGLN but an identifier that is in the SBDH and uniquely identifies a sending entity.', max_length=250, null=True, verbose_name='SBDH Sender Identifier')),
                ('receiver_identifier', models.CharField(help_text='Typically an SGLN but an identifier that is in the SBDH and uniquely identifies a receiving entity.', max_length=250, null=True, verbose_name='SBDH Receiver Identifier')),
                ('event_type', models.CharField(choices=[('Object', 'Object'), ('Transaction', 'Transaction'), ('Transformation', 'Transformation'), ('Aggregation', 'Aggregation')], help_text='The type of EPCIS event.', max_length=20, null=True, verbose_name='Event Type')),
                ('action', models.CharField(choices=[('ADD', 'Add'), ('OBSERVE', 'Observe'), ('DELETE', 'Delete')], help_text="The EPCIS event's ACTION type.", max_length=20, null=True, verbose_name='Action')),
                ('biz_step', models.CharField(help_text='The business step URN.  Can be a CBV value or any customuri.  If CBV it must be exactly as specified in v1.2', max_length=150, null=True, verbose_name='Business Step (BizStep)')),
                ('disposition', models.CharField(help_text='A Disposition URN- can be CBV or custom.', max_length=150, null=True, verbose_name='Disposition')),
                ('read_point', models.CharField(help_text='The read point URN.  Typically representing a sub-site.', max_length=150, null=True, verbose_name='Read Point')),
                ('biz_location', models.CharField(help_text='The business location URN.  Typically representing a site', max_length=150, null=True, verbose_name='Business Location')),
                ('source_type', models.CharField(help_text='The type of the source- a CBV 1.2 URI or custom URI.', max_length=150, null=True, verbose_name='Source Type')),
                ('source_id', models.CharField(help_text='A URI that identifies the source specified in the Source Type field.', max_length=200, null=True, verbose_name='Source ID')),
                ('destination_type', models.CharField(help_text='The type of the Destination- a CBV 1.2 URI or custom URI.', max_length=150, null=True, verbose_name='Destination Type')),
                ('destination_id', models.CharField(help_text='A URI that identifies the Destination specified in the Destination Type field.', max_length=200, null=True, verbose_name='Destination ID')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('authentication_info', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_output.AuthenticationInfo')),
                ('end_point', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_output.EndPoint')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical EPCIS Output Criteria',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalListBasedRegion',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_date', models.DateTimeField(blank=True, db_index=True, editable=False, help_text='The date and time that this record was created', verbose_name='Created Date')),
                ('modified_date', models.DateTimeField(blank=True, db_index=True, editable=False, help_text='The date and time that this record was modified last.', verbose_name='Last Modified')),
                ('readable_name', models.CharField(db_index=True, help_text='A human-readable name for use in GUIs and reports and such.', max_length=100, verbose_name='Readable Name')),
                ('machine_name', models.CharField(db_index=True, help_text='A url/api-friendly unique key for use in API calls and such.', max_length=100, validators=[django.core.validators.RegexValidator('^[A-Za-z0-9]*$', 'Only numbers and letters are allowed. Invalid API Key.')], verbose_name='API Key')),
                ('active', models.BooleanField(default=True, help_text='Whether or not this pool is active/in-use. If marked false the pool will no longer be able to be used in API calls, etc.', verbose_name='Active')),
                ('order', models.IntegerField(blank=True, help_text='The order in which this region will be consumed as numbers are issued from the pool overall', null=True, verbose_name='Order')),
                ('last_number_line', models.IntegerField(default=1, help_text='The line number of the last number issued maintains the state of the list-based region.', verbose_name='Last Number Line')),
                ('processing_class_path', models.CharField(help_text='The full python path to the class that will be processing region allocations', max_length=150, verbose_name='Processing Class Path')),
                ('file_id', models.UUIDField(default=uuid.uuid1, editable=False)),
                ('directory_path', models.CharField(blank=True, default='/var/quartet/numbers', help_text='The full path to the directory where numbers will be stored. Leave blank for default. Default is /var/quartet/numbers', max_length=150, null=True)),
                ('number_replenishment_size', models.IntegerField(help_text='The size that the outbound message will request from the third-party system, if numbers available are low. E.g.: 500', verbose_name='Number Replenishment Size')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('authentication_info', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_output.AuthenticationInfo')),
                ('end_point', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_output.EndPoint')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('pool', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='serialbox.Pool')),
                ('rule', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_capture.Rule')),
                ('template', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_templates.Template')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical list based region',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalLocation',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('GLN13', models.CharField(db_index=True, help_text='The GLN (Global Location Number) provides a standard means to identify legal entities, trading parties and locations to support the requirements of electronic commerce. The GLN-13 is defined by GS1', max_length=13, null=True, verbose_name='GLN13')),
                ('SGLN', models.CharField(db_index=True, help_text='The SGLN EPC scheme is used to assign a unique identity to a physical location or sub-location, such as a specific building or a specific unit of shelving within a warehouse.  TheSGLN is expressed as a URN value.', max_length=150, null=True, verbose_name='SGLN')),
                ('name', models.CharField(db_index=True, help_text='A unique name for the location or party.', max_length=128, verbose_name='Name')),
                ('address1', models.CharField(help_text='For example, the name of the street and the number in the street or the name of a building', max_length=1000, null=True, verbose_name='Street Address One')),
                ('address2', models.CharField(help_text='The second free form line complements the first free form line to locate the party or location.', max_length=1000, null=True, verbose_name='Street Address Two')),
                ('address3', models.CharField(help_text='The third free form line complements the first and second free form lines where necessary.', max_length=1000, null=True, verbose_name='Street Address Three')),
                ('country', models.CharField(help_text='Country ISO 3166-1 alpha-2 Code', max_length=2, null=True, verbose_name='Country Code')),
                ('city', models.CharField(help_text='City', max_length=50, null=True, verbose_name='city')),
                ('state_province', models.CharField(help_text='One of the constituent units of a nation having a federal government.', max_length=20, null=True, verbose_name='State or Province')),
                ('postal_code', models.CharField(help_text='Postal Code', max_length=20, null=True, verbose_name='Postal Code')),
                ('latitude', models.DecimalField(decimal_places=6, help_text=' Latitude of the location, in degrees. Positive numbers are northern latitude; negative numbers are southern latitude.', max_digits=9, null=True, verbose_name='Latitude')),
                ('longitude', models.DecimalField(decimal_places=6, help_text='Longitude of the location, in degrees. Positive numbers are eastern longitude; negative numbers are western longitude.', max_digits=9, null=True, verbose_name='Longitude')),
                ('icon', models.TextField(help_text='An icon to represent the location in a GUI or report.', max_length=100, null=True, verbose_name='Icon')),
                ('sst', models.SmallIntegerField(help_text='Sub-Site Type: describes the primary business function of the sub-site location. This master data attribute is only applicable to a sub-site location.  This value is expressed as a single numerical code.', null=True, verbose_name='Sub-Site Type')),
                ('ssa', models.CharField(help_text='Sub-Site Attribute: further qualifies the business function of the sub-site location. This master data attribute is only applicable to a sub-site location. Sub-site attributes are expressed as a comma- separated list of zero or more numerical codes', max_length=1000, null=True, verbose_name='Sub-Site Attribute')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('company', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_masterdata.Company')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('location_type', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_masterdata.LocationType')),
                ('site', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_masterdata.Location')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical Location',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalLocationField',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(db_index=True, help_text='The name of the field.', max_length=100, verbose_name='Name')),
                ('value', models.TextField(help_text='The value of the field.', verbose_name='Value')),
                ('description', models.CharField(help_text='A short description.', max_length=500, null=True, verbose_name='Description')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('location', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_masterdata.Location')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical Location Field',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalLocationIdentifier',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('identifier', models.CharField(help_text='A unique identifier for a location such as a GLN or SGLN.', max_length=250, verbose_name='identifier')),
                ('identifier_type', models.CharField(help_text='The type of location identifier. For example: GLN-13, SGLN, etc.', max_length=50, verbose_name='identifier_type')),
                ('description', models.CharField(help_text='A brief description of what the identifier represents.', max_length=150, null=True, verbose_name='Description')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('location', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_masterdata.Location')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical LocationIdentifier',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalLocationType',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('identifier', models.CharField(db_index=True, help_text='The unique type identifier.', max_length=20, verbose_name='Identifier')),
                ('description', models.CharField(help_text='A brief description of the type.', max_length=400, verbose_name='Description')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical Location Type',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalMeasurement',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('measurement', models.FloatField(help_text='The numerical value of the measurement', verbose_name='Measurement')),
                ('measurement_unit_code', models.CharField(help_text='The unit of measure for the measurement. The code list for this attribute is UN/ECE Recommendation 20', max_length=40, null=True, verbose_name='measurement_unit_code')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical measurement',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalPool',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_date', models.DateTimeField(blank=True, db_index=True, editable=False, help_text='The date and time that this record was created', verbose_name='Created Date')),
                ('modified_date', models.DateTimeField(blank=True, db_index=True, editable=False, help_text='The date and time that this record was modified last.', verbose_name='Last Modified')),
                ('readable_name', models.CharField(db_index=True, help_text='A human-readable name for use in GUIs and reports and such.', max_length=100, verbose_name='Readable Name')),
                ('machine_name', models.CharField(db_index=True, help_text='A url/api-friendly unique key for use in API calls and such.', max_length=100, validators=[django.core.validators.RegexValidator('^[A-Za-z0-9]*$', 'Only numbers and letters are allowed. Invalid API Key.')], verbose_name='API Key')),
                ('active', models.BooleanField(default=True, help_text='Whether or not this pool is active/in-use. If marked false the pool will no longer be able to be used in API calls, etc.', verbose_name='Active')),
                ('request_threshold', models.BigIntegerField(default=50000, help_text='The maximimum number of items that can be requested from this pool at once.  Default of 50000.', verbose_name='Threshold')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical Pool',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalProcessingParameters',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('key', models.CharField(help_text='The key part of the key-value pair. Example: q', max_length=200)),
                ('value', models.CharField(blank=True, help_text='The value part of the key-value pair.', max_length=400, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('list_based_region', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='list_based_flavorpack.ListBasedRegion')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical processing parameters',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalRandomizedRegion',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_date', models.DateTimeField(blank=True, db_index=True, editable=False, help_text='The date and time that this record was created', verbose_name='Created Date')),
                ('modified_date', models.DateTimeField(blank=True, db_index=True, editable=False, help_text='The date and time that this record was modified last.', verbose_name='Last Modified')),
                ('readable_name', models.CharField(db_index=True, help_text='A human-readable name for use in GUIs and reports and such.', max_length=100, verbose_name='Readable Name')),
                ('machine_name', models.CharField(db_index=True, help_text='A url/api-friendly unique key for use in API calls and such.', max_length=100, validators=[django.core.validators.RegexValidator('^[A-Za-z0-9]*$', 'Only numbers and letters are allowed. Invalid API Key.')], verbose_name='API Key')),
                ('active', models.BooleanField(default=True, help_text='Whether or not this pool is active/in-use. If marked false the pool will no longer be able to be used in API calls, etc.', verbose_name='Active')),
                ('order', models.IntegerField(blank=True, help_text='The order in which this region will be consumed as numbers are issued from the pool overall', null=True, verbose_name='Order')),
                ('min', models.BigIntegerField(default=1, help_text='The minimum value in the randomized region.', validators=[django.core.validators.MinValueValidator(0)], verbose_name='Minimum')),
                ('max', models.BigIntegerField(default=9223372036854775807, help_text='The maximum value in the randomized region.', validators=[django.core.validators.MinValueValidator(0)], verbose_name='Maximum')),
                ('start', models.BigIntegerField(blank=True, help_text='The start number will fall somewhere in between the minimum and maximum numbers.  This number will be randomly selected by the system to assure the most randomized range possible', null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Start Number')),
                ('current', models.BigIntegerField(blank=True, help_text='The current number represents the next number in the generator.  The current number is used by the system as a state variable that, along with the start, can be used to re-position the random number generator where it left off.', null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Current')),
                ('remaining', models.BigIntegerField(blank=True, help_text='The number of remaining serial numbers in this randomized region.', null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Remaining')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('pool', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='serialbox.Pool')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical Randomized Region',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalResponse',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_date', models.DateTimeField(blank=True, db_index=True, editable=False, help_text='The date and time that this record was created', verbose_name='Created Date')),
                ('modified_date', models.DateTimeField(blank=True, db_index=True, editable=False, help_text='The date and time that this record was modified last.', verbose_name='Last Modified')),
                ('fulfilled', models.BooleanField(help_text='Whether or not the full request was fulfilled by the system', verbose_name='Fulfilled')),
                ('type', models.CharField(choices=[('sequential', 'Sequential'), ('random', 'Random'), ('list', 'List')], help_text='The type of response- either sequential, random, or list based.', max_length=10, verbose_name='Type')),
                ('encoding', models.CharField(choices=[('base-36', 'Base 36 (1-9, A-Z)'), ('hex', 'Base 16 (0-F)'), ('decimal', 'Base 10 (0-9)')], default='decimal', help_text='The number encoding, choices are base-36, hex or decimal.', max_length=10, verbose_name='Encoding')),
                ('pool', models.CharField(help_text='The machine_name value of the Pool that served the request.', max_length=100, verbose_name='Pool')),
                ('region', models.CharField(blank=True, help_text='The machine_name of the Region that served the request.  This may be any type of region.', max_length=100, null=True, verbose_name='Region')),
                ('size_granted', models.IntegerField(help_text='The number of serial numbers that were actually granted from the given pool.', verbose_name='Size Granted')),
                ('remote_host', models.CharField(help_text='The remote host which made the request.', max_length=400, verbose_name='Remote Host')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical Response',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalResponseRule',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_date', models.DateTimeField(blank=True, db_index=True, editable=False, help_text='The date and time that this record was created', verbose_name='Created Date')),
                ('modified_date', models.DateTimeField(blank=True, db_index=True, editable=False, help_text='The date and time that this record was modified last.', verbose_name='Last Modified')),
                ('content_type', models.CharField(choices=[('xml', 'xml'), ('json', 'json'), ('yaml', 'yaml'), ('csv', 'csv')], help_text='The content type this response rule will handle.', max_length=100, null=True, verbose_name='Content Type')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('pool', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='serialbox.Pool')),
                ('rule', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_capture.Rule')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical response rule',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalResponseTemplate',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_date', models.DateTimeField(blank=True, db_index=True, editable=False, help_text='The date and time that this record was created', verbose_name='Created Date')),
                ('modified_date', models.DateTimeField(blank=True, db_index=True, editable=False, help_text='The date and time that this record was modified last.', verbose_name='Last Modified')),
                ('readable_name', models.CharField(help_text='The name of the template.', max_length=100, verbose_name='Name')),
                ('description', models.TextField(help_text='A brief description of what this template does.', verbose_name='Description')),
                ('template_text', models.TextField(help_text='The template text using Jinja2 format markup.  For more info on Jinja templates see http://jinja.pocoo.org/', verbose_name='Template Text')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical Response Template',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalResponseTemplate_pool',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('pool', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='serialbox.Pool')),
                ('responsetemplate', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='serialbox.ResponseTemplate')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical responsetemplate-pool relationship',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalRule',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(db_index=True, help_text='A rule is composed of multiple steps that execute in order.', max_length=100, verbose_name='Rule')),
                ('description', models.CharField(help_text='A short description.', max_length=500, null=True, verbose_name='Description')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical Rule',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalRuleParameter',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(db_index=True, help_text='The name of the field.', max_length=100, verbose_name='Name')),
                ('value', models.TextField(help_text='The value of the field.', verbose_name='Value')),
                ('description', models.CharField(help_text='A short description.', max_length=500, null=True, verbose_name='Description')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('rule', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_capture.Rule')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical Rule Parameter',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalSequentialRegion',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('created_date', models.DateTimeField(blank=True, db_index=True, editable=False, help_text='The date and time that this record was created', verbose_name='Created Date')),
                ('modified_date', models.DateTimeField(blank=True, db_index=True, editable=False, help_text='The date and time that this record was modified last.', verbose_name='Last Modified')),
                ('readable_name', models.CharField(db_index=True, help_text='A human-readable name for use in GUIs and reports and such.', max_length=100, verbose_name='Readable Name')),
                ('machine_name', models.CharField(db_index=True, help_text='A url/api-friendly unique key for use in API calls and such.', max_length=100, validators=[django.core.validators.RegexValidator('^[A-Za-z0-9]*$', 'Only numbers and letters are allowed. Invalid API Key.')], verbose_name='API Key')),
                ('active', models.BooleanField(default=True, help_text='Whether or not this pool is active/in-use. If marked false the pool will no longer be able to be used in API calls, etc.', verbose_name='Active')),
                ('order', models.IntegerField(blank=True, help_text='The order in which this region will be consumed as numbers are issued from the pool overall', null=True, verbose_name='Order')),
                ('start', models.BigIntegerField(help_text='The starting number for this region.', verbose_name='Starting Number')),
                ('end', models.BigIntegerField(help_text='The ending number for this region.', verbose_name='Ending Number')),
                ('state', models.BigIntegerField(help_text='The State represents the current number in use if an API request were to come in now.', verbose_name='State')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('pool', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='serialbox.Pool')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical Sequential Region',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalStep',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(help_text='A step is a piece of logic that runs within a rule.', max_length=100, verbose_name='Step')),
                ('description', models.CharField(help_text='A short description.', max_length=500, null=True, verbose_name='Description')),
                ('step_class', models.CharField(help_text='The full python path to where the Step class is defined for example, mypackage.mymodule.MyStep', max_length=500, verbose_name='Class Path')),
                ('order', models.IntegerField(help_text='Defines the order in which the step is executed.  Steps are executed in numerical order.', verbose_name='Execution Order')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('rule', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_capture.Rule')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical Step',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalStepParameter',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(db_index=True, help_text='The name of the field.', max_length=100, verbose_name='Name')),
                ('value', models.TextField(help_text='The value of the field.', verbose_name='Value')),
                ('description', models.CharField(help_text='A short description.', max_length=500, null=True, verbose_name='Description')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('step', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_capture.Step')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical Step Parameter',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalTaskParameter',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(db_index=True, help_text='The name of the field.', max_length=100, verbose_name='Name')),
                ('value', models.TextField(help_text='The value of the field.', verbose_name='Value')),
                ('description', models.CharField(help_text='A short description.', max_length=500, null=True, verbose_name='Description')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('task', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_capture.Task')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical Task Parameter',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalTemplate',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(db_index=True, help_text='A name to identify this template', max_length=100)),
                ('content', models.TextField(help_text='The full Django/Jinja template to be used.')),
                ('description', models.CharField(blank=True, max_length=200, null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical template',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalTradeItem',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('country_of_origin', models.CharField(help_text='Country from which the goods are supplied. The code list for this attribute is the ISO 3166-1 Alpha-2 list of 2-letter country codes', max_length=2, null=True, verbose_name='Country Of Origin')),
                ('drained_weight', models.FloatField(help_text='The weight of the trade item when drained of its liquid. For example 225 grm', null=True, verbose_name='Drained Weight')),
                ('drained_weight_uom', models.CharField(help_text='The unit of measure for the drained weight as defined inUN/ECE Recommendation 20.', max_length=5, null=True, verbose_name='Drained Weight UOM')),
                ('gross_weight', models.FloatField(help_text='Used to identify the gross weight of the trade item. The gross weight includes all packaging materials of the trade item.', null=True, verbose_name='Gross Weight')),
                ('gross_weight_uom', models.CharField(help_text='The unit of measure for the gross weight as defined inUN/ECE Recommendation 20.', max_length=5, null=True, verbose_name='Gross Weight UOM')),
                ('net_weight', models.FloatField(help_text='Used to identify the net weight of the trade item. Net weight excludes any packaging materials and applies to all levels but consumer unit level.', null=True, verbose_name='Net Weight')),
                ('net_weight_uom', models.CharField(help_text='The unit of measure for the net weight as defined inUN/ECE Recommendation 20.', max_length=5, null=True, verbose_name='NET Weight UOM')),
                ('image', models.TextField(help_text='An image to represent the product in a GUI or report.', max_length=100, null=True, verbose_name='Icon')),
                ('GTIN14', models.CharField(db_index=True, help_text='The GS1 GTIN-14 associated with the Trade Item.', max_length=14, verbose_name='GTIN-14')),
                ('NDC', models.CharField(help_text='The national drug code for the product. US Only.', max_length=12, null=True, verbose_name='NDC')),
                ('NDC_pattern', models.CharField(choices=[('4-4-2', '4-4-2'), ('5-3-2', '5-3-2'), ('5-4-1', '5-4-1')], help_text='The pattern of the NDC.  US Only.  Optional.', max_length=5, null=True, verbose_name='NDC_pattern')),
                ('additional_id', models.CharField(help_text='A trade item identifier that is in addition to the GTIN.', max_length=80, null=True, verbose_name='Additional ID')),
                ('additional_id_typecode', models.CharField(help_text='The code list for this attribute is defined in GS1 GDSN.', max_length=250, null=True, verbose_name='Additional ID TypeCode')),
                ('description_short', models.CharField(help_text='A free form short length description of the trade item that can be used to identify the trade item at point of sale.', max_length=35, null=True, verbose_name='description_short')),
                ('dosage_form_type', models.CharField(help_text='A dosage form is the physical form of a medication that identifies the form of the pharmaceutical item. For example: PILL', max_length=35, null=True, verbose_name='Dosage Form Type')),
                ('functional_name', models.CharField(help_text='Describes use of the product or service by the consumer. Should help clarify the product classification associated with the GTIN.', max_length=100, null=True, verbose_name='functional_name')),
                ('manufacturer_name', models.CharField(help_text='Party name information for the manufacturer of the trade item. Example: Acme Corporation', max_length=300, null=True, verbose_name='manufacturer_name')),
                ('net_content_description', models.CharField(help_text='Free text describing the amount of the trade item contained by a package, usually as claimed on the label. Example: 253 grams', max_length=500, null=True, verbose_name='Net Content Description')),
                ('label_description', models.CharField(help_text="A literal reproduction of the text featured on a product's label in the same word-by-word order in which it appears on the front of the product's packaging.", max_length=500, null=True, verbose_name='Label Description')),
                ('regulated_product_name', models.CharField(help_text='The prescribed, regulated or generic product name or denomination that describes the true nature of the product according to country specific regulation.', max_length=500, null=True, verbose_name='regulated_product_name')),
                ('strength_description', models.CharField(help_text='Free text describing the strength of the active ingredient(s) of the product. Example: 200mg/100mg', max_length=500, null=True, verbose_name='strength_description')),
                ('trade_item_description', models.CharField(help_text='An understandable and useable description of a trade item using brand and other descriptors.', max_length=200, null=True, verbose_name='Trade Item Description')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('company', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_masterdata.Company')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical Trade Item',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalTradeItemField',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('name', models.CharField(db_index=True, help_text='The name of the field.', max_length=100, verbose_name='Name')),
                ('value', models.TextField(help_text='The value of the field.', verbose_name='Value')),
                ('description', models.CharField(help_text='A short description.', max_length=500, null=True, verbose_name='Description')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_date', models.DateTimeField()),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('trade_item', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='quartet_masterdata.TradeItem')),
            ],
            options={
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
                'verbose_name': 'historical Trade Item Field',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
