# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'LicensingSubscriptionSubscriptionsBindItem',
    'LicensingSubscriptionSubscriptionsBindItemInsufficientEntitlement',
    'LicensingSubscriptionSubscriptionsBindItemNetwork',
    'LicensingSubscriptionSubscriptionsBindParameters',
    'LicensingSubscriptionSubscriptionsClaimItem',
    'LicensingSubscriptionSubscriptionsClaimItemCounts',
    'LicensingSubscriptionSubscriptionsClaimItemCountsSeats',
    'LicensingSubscriptionSubscriptionsClaimItemEntitlement',
    'LicensingSubscriptionSubscriptionsClaimItemEntitlementSeats',
    'LicensingSubscriptionSubscriptionsClaimKeyValidateItem',
    'LicensingSubscriptionSubscriptionsClaimKeyValidateItemCounts',
    'LicensingSubscriptionSubscriptionsClaimKeyValidateItemCountsSeats',
    'LicensingSubscriptionSubscriptionsClaimKeyValidateItemEntitlement',
    'LicensingSubscriptionSubscriptionsClaimKeyValidateItemEntitlementSeats',
    'LicensingSubscriptionSubscriptionsClaimKeyValidateParameters',
    'LicensingSubscriptionSubscriptionsClaimParameters',
    'GetIdentitiesMeItemResult',
    'GetIdentitiesMeItemAuthenticationResult',
    'GetIdentitiesMeItemAuthenticationApiResult',
    'GetIdentitiesMeItemAuthenticationApiKeyResult',
    'GetIdentitiesMeItemAuthenticationSamlResult',
    'GetIdentitiesMeItemAuthenticationTwoFactorResult',
    'GetLicensingSubscriptionEntitlementsItemResult',
    'GetLicensingSubscriptionSubscriptionsComplianceStatusesItemResult',
    'GetLicensingSubscriptionSubscriptionsComplianceStatusesItemSubscriptionResult',
    'GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsResult',
    'GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsByProductClassResult',
    'GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsByProductClassMissingResult',
    'GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsByProductClassMissingEntitlementResult',
    'GetLicensingSubscriptionSubscriptionsItemResult',
    'GetLicensingSubscriptionSubscriptionsItemCountsResult',
    'GetLicensingSubscriptionSubscriptionsItemCountsSeatsResult',
    'GetLicensingSubscriptionSubscriptionsItemEntitlementResult',
    'GetLicensingSubscriptionSubscriptionsItemEntitlementSeatsResult',
]

@pulumi.output_type
class LicensingSubscriptionSubscriptionsBindItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "insufficientEntitlements":
            suggest = "insufficient_entitlements"
        elif key == "subscriptionId":
            suggest = "subscription_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LicensingSubscriptionSubscriptionsBindItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LicensingSubscriptionSubscriptionsBindItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LicensingSubscriptionSubscriptionsBindItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 errors: Optional[Sequence[builtins.str]] = None,
                 insufficient_entitlements: Optional[Sequence['outputs.LicensingSubscriptionSubscriptionsBindItemInsufficientEntitlement']] = None,
                 networks: Optional[Sequence['outputs.LicensingSubscriptionSubscriptionsBindItemNetwork']] = None,
                 subscription_id: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] errors: Array of errors if failed
        :param Sequence['LicensingSubscriptionSubscriptionsBindItemInsufficientEntitlementArgs'] insufficient_entitlements: A list of entitlements required to successfully bind the networks to the subscription
        :param Sequence['LicensingSubscriptionSubscriptionsBindItemNetworkArgs'] networks: Unbound networks
        :param builtins.str subscription_id: Subscription ID
        """
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if insufficient_entitlements is not None:
            pulumi.set(__self__, "insufficient_entitlements", insufficient_entitlements)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter
    def errors(self) -> Optional[Sequence[builtins.str]]:
        """
        Array of errors if failed
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="insufficientEntitlements")
    def insufficient_entitlements(self) -> Optional[Sequence['outputs.LicensingSubscriptionSubscriptionsBindItemInsufficientEntitlement']]:
        """
        A list of entitlements required to successfully bind the networks to the subscription
        """
        return pulumi.get(self, "insufficient_entitlements")

    @property
    @pulumi.getter
    def networks(self) -> Optional[Sequence['outputs.LicensingSubscriptionSubscriptionsBindItemNetwork']]:
        """
        Unbound networks
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[builtins.str]:
        """
        Subscription ID
        """
        return pulumi.get(self, "subscription_id")


@pulumi.output_type
class LicensingSubscriptionSubscriptionsBindItemInsufficientEntitlement(dict):
    def __init__(__self__, *,
                 quantity: Optional[builtins.int] = None,
                 sku: Optional[builtins.str] = None):
        """
        :param builtins.int quantity: Number required
        :param builtins.str sku: SKU of the required product
        """
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter
    def quantity(self) -> Optional[builtins.int]:
        """
        Number required
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter
    def sku(self) -> Optional[builtins.str]:
        """
        SKU of the required product
        """
        return pulumi.get(self, "sku")


@pulumi.output_type
class LicensingSubscriptionSubscriptionsBindItemNetwork(dict):
    def __init__(__self__, *,
                 id: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str id: Network ID
        :param builtins.str name: Network name
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Network ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Network name
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LicensingSubscriptionSubscriptionsBindParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkIds":
            suggest = "network_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LicensingSubscriptionSubscriptionsBindParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LicensingSubscriptionSubscriptionsBindParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LicensingSubscriptionSubscriptionsBindParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] network_ids: List of network ids to bind to the subscription
        """
        if network_ids is not None:
            pulumi.set(__self__, "network_ids", network_ids)

    @property
    @pulumi.getter(name="networkIds")
    def network_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        List of network ids to bind to the subscription
        """
        return pulumi.get(self, "network_ids")


@pulumi.output_type
class LicensingSubscriptionSubscriptionsClaimItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDate":
            suggest = "end_date"
        elif key == "productTypes":
            suggest = "product_types"
        elif key == "startDate":
            suggest = "start_date"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "webOrderId":
            suggest = "web_order_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LicensingSubscriptionSubscriptionsClaimItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LicensingSubscriptionSubscriptionsClaimItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LicensingSubscriptionSubscriptionsClaimItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 counts: Optional['outputs.LicensingSubscriptionSubscriptionsClaimItemCounts'] = None,
                 description: Optional[builtins.str] = None,
                 end_date: Optional[builtins.str] = None,
                 entitlements: Optional[Sequence['outputs.LicensingSubscriptionSubscriptionsClaimItemEntitlement']] = None,
                 name: Optional[builtins.str] = None,
                 product_types: Optional[Sequence[builtins.str]] = None,
                 start_date: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 subscription_id: Optional[builtins.str] = None,
                 web_order_id: Optional[builtins.str] = None):
        """
        :param 'LicensingSubscriptionSubscriptionsClaimItemCountsArgs' counts: Numeric breakdown of network and entitlement counts
        :param builtins.str description: Subscription description
        :param builtins.str end_date: Subscription expiration date
        :param Sequence['LicensingSubscriptionSubscriptionsClaimItemEntitlementArgs'] entitlements: Entitlement info
        :param builtins.str name: Subscription name
        :param Sequence[builtins.str] product_types: Products the subscription has entitlements for
        :param builtins.str start_date: Subscription start date
        :param builtins.str status: Subscription status
        :param builtins.str subscription_id: Subscription's ID
        :param builtins.str web_order_id: Web order id
        """
        if counts is not None:
            pulumi.set(__self__, "counts", counts)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_date is not None:
            pulumi.set(__self__, "end_date", end_date)
        if entitlements is not None:
            pulumi.set(__self__, "entitlements", entitlements)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product_types is not None:
            pulumi.set(__self__, "product_types", product_types)
        if start_date is not None:
            pulumi.set(__self__, "start_date", start_date)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if web_order_id is not None:
            pulumi.set(__self__, "web_order_id", web_order_id)

    @property
    @pulumi.getter
    def counts(self) -> Optional['outputs.LicensingSubscriptionSubscriptionsClaimItemCounts']:
        """
        Numeric breakdown of network and entitlement counts
        """
        return pulumi.get(self, "counts")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Subscription description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[builtins.str]:
        """
        Subscription expiration date
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter
    def entitlements(self) -> Optional[Sequence['outputs.LicensingSubscriptionSubscriptionsClaimItemEntitlement']]:
        """
        Entitlement info
        """
        return pulumi.get(self, "entitlements")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Subscription name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productTypes")
    def product_types(self) -> Optional[Sequence[builtins.str]]:
        """
        Products the subscription has entitlements for
        """
        return pulumi.get(self, "product_types")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> Optional[builtins.str]:
        """
        Subscription start date
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Subscription status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[builtins.str]:
        """
        Subscription's ID
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="webOrderId")
    def web_order_id(self) -> Optional[builtins.str]:
        """
        Web order id
        """
        return pulumi.get(self, "web_order_id")


@pulumi.output_type
class LicensingSubscriptionSubscriptionsClaimItemCounts(dict):
    def __init__(__self__, *,
                 networks: Optional[builtins.int] = None,
                 seats: Optional['outputs.LicensingSubscriptionSubscriptionsClaimItemCountsSeats'] = None):
        """
        :param builtins.int networks: Number of networks bound to this subscription
        :param 'LicensingSubscriptionSubscriptionsClaimItemCountsSeatsArgs' seats: Seat distribution
        """
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if seats is not None:
            pulumi.set(__self__, "seats", seats)

    @property
    @pulumi.getter
    def networks(self) -> Optional[builtins.int]:
        """
        Number of networks bound to this subscription
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter
    def seats(self) -> Optional['outputs.LicensingSubscriptionSubscriptionsClaimItemCountsSeats']:
        """
        Seat distribution
        """
        return pulumi.get(self, "seats")


@pulumi.output_type
class LicensingSubscriptionSubscriptionsClaimItemCountsSeats(dict):
    def __init__(__self__, *,
                 assigned: Optional[builtins.int] = None,
                 available: Optional[builtins.int] = None,
                 limit: Optional[builtins.int] = None):
        """
        :param builtins.int assigned: Number of seats in use
        :param builtins.int available: Number of seats available for use
        :param builtins.int limit: Total number of seats provided by this subscription
        """
        if assigned is not None:
            pulumi.set(__self__, "assigned", assigned)
        if available is not None:
            pulumi.set(__self__, "available", available)
        if limit is not None:
            pulumi.set(__self__, "limit", limit)

    @property
    @pulumi.getter
    def assigned(self) -> Optional[builtins.int]:
        """
        Number of seats in use
        """
        return pulumi.get(self, "assigned")

    @property
    @pulumi.getter
    def available(self) -> Optional[builtins.int]:
        """
        Number of seats available for use
        """
        return pulumi.get(self, "available")

    @property
    @pulumi.getter
    def limit(self) -> Optional[builtins.int]:
        """
        Total number of seats provided by this subscription
        """
        return pulumi.get(self, "limit")


@pulumi.output_type
class LicensingSubscriptionSubscriptionsClaimItemEntitlement(dict):
    def __init__(__self__, *,
                 seats: Optional['outputs.LicensingSubscriptionSubscriptionsClaimItemEntitlementSeats'] = None,
                 sku: Optional[builtins.str] = None):
        """
        :param 'LicensingSubscriptionSubscriptionsClaimItemEntitlementSeatsArgs' seats: Seat distribution
        :param builtins.str sku: SKU of the required product
        """
        if seats is not None:
            pulumi.set(__self__, "seats", seats)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter
    def seats(self) -> Optional['outputs.LicensingSubscriptionSubscriptionsClaimItemEntitlementSeats']:
        """
        Seat distribution
        """
        return pulumi.get(self, "seats")

    @property
    @pulumi.getter
    def sku(self) -> Optional[builtins.str]:
        """
        SKU of the required product
        """
        return pulumi.get(self, "sku")


@pulumi.output_type
class LicensingSubscriptionSubscriptionsClaimItemEntitlementSeats(dict):
    def __init__(__self__, *,
                 assigned: Optional[builtins.int] = None,
                 available: Optional[builtins.int] = None,
                 limit: Optional[builtins.int] = None):
        """
        :param builtins.int assigned: Number of seats in use
        :param builtins.int available: Number of seats available for use
        :param builtins.int limit: Total number of seats provided by this subscription for this sku
        """
        if assigned is not None:
            pulumi.set(__self__, "assigned", assigned)
        if available is not None:
            pulumi.set(__self__, "available", available)
        if limit is not None:
            pulumi.set(__self__, "limit", limit)

    @property
    @pulumi.getter
    def assigned(self) -> Optional[builtins.int]:
        """
        Number of seats in use
        """
        return pulumi.get(self, "assigned")

    @property
    @pulumi.getter
    def available(self) -> Optional[builtins.int]:
        """
        Number of seats available for use
        """
        return pulumi.get(self, "available")

    @property
    @pulumi.getter
    def limit(self) -> Optional[builtins.int]:
        """
        Total number of seats provided by this subscription for this sku
        """
        return pulumi.get(self, "limit")


@pulumi.output_type
class LicensingSubscriptionSubscriptionsClaimKeyValidateItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endDate":
            suggest = "end_date"
        elif key == "productTypes":
            suggest = "product_types"
        elif key == "startDate":
            suggest = "start_date"
        elif key == "subscriptionId":
            suggest = "subscription_id"
        elif key == "webOrderId":
            suggest = "web_order_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LicensingSubscriptionSubscriptionsClaimKeyValidateItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LicensingSubscriptionSubscriptionsClaimKeyValidateItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LicensingSubscriptionSubscriptionsClaimKeyValidateItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 counts: Optional['outputs.LicensingSubscriptionSubscriptionsClaimKeyValidateItemCounts'] = None,
                 description: Optional[builtins.str] = None,
                 end_date: Optional[builtins.str] = None,
                 entitlements: Optional[Sequence['outputs.LicensingSubscriptionSubscriptionsClaimKeyValidateItemEntitlement']] = None,
                 name: Optional[builtins.str] = None,
                 product_types: Optional[Sequence[builtins.str]] = None,
                 start_date: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 subscription_id: Optional[builtins.str] = None,
                 web_order_id: Optional[builtins.str] = None):
        """
        :param 'LicensingSubscriptionSubscriptionsClaimKeyValidateItemCountsArgs' counts: Numeric breakdown of network and entitlement counts
        :param builtins.str description: Subscription description
        :param builtins.str end_date: Subscription expiration date
        :param Sequence['LicensingSubscriptionSubscriptionsClaimKeyValidateItemEntitlementArgs'] entitlements: Entitlement info
        :param builtins.str name: Subscription name
        :param Sequence[builtins.str] product_types: Products the subscription has entitlements for
        :param builtins.str start_date: Subscription start date
        :param builtins.str status: Subscription status
        :param builtins.str subscription_id: Subscription's ID
        :param builtins.str web_order_id: Web order id
        """
        if counts is not None:
            pulumi.set(__self__, "counts", counts)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if end_date is not None:
            pulumi.set(__self__, "end_date", end_date)
        if entitlements is not None:
            pulumi.set(__self__, "entitlements", entitlements)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product_types is not None:
            pulumi.set(__self__, "product_types", product_types)
        if start_date is not None:
            pulumi.set(__self__, "start_date", start_date)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if web_order_id is not None:
            pulumi.set(__self__, "web_order_id", web_order_id)

    @property
    @pulumi.getter
    def counts(self) -> Optional['outputs.LicensingSubscriptionSubscriptionsClaimKeyValidateItemCounts']:
        """
        Numeric breakdown of network and entitlement counts
        """
        return pulumi.get(self, "counts")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Subscription description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[builtins.str]:
        """
        Subscription expiration date
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter
    def entitlements(self) -> Optional[Sequence['outputs.LicensingSubscriptionSubscriptionsClaimKeyValidateItemEntitlement']]:
        """
        Entitlement info
        """
        return pulumi.get(self, "entitlements")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Subscription name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productTypes")
    def product_types(self) -> Optional[Sequence[builtins.str]]:
        """
        Products the subscription has entitlements for
        """
        return pulumi.get(self, "product_types")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> Optional[builtins.str]:
        """
        Subscription start date
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Subscription status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[builtins.str]:
        """
        Subscription's ID
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="webOrderId")
    def web_order_id(self) -> Optional[builtins.str]:
        """
        Web order id
        """
        return pulumi.get(self, "web_order_id")


@pulumi.output_type
class LicensingSubscriptionSubscriptionsClaimKeyValidateItemCounts(dict):
    def __init__(__self__, *,
                 networks: Optional[builtins.int] = None,
                 seats: Optional['outputs.LicensingSubscriptionSubscriptionsClaimKeyValidateItemCountsSeats'] = None):
        """
        :param builtins.int networks: Number of networks bound to this subscription
        :param 'LicensingSubscriptionSubscriptionsClaimKeyValidateItemCountsSeatsArgs' seats: Seat distribution
        """
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if seats is not None:
            pulumi.set(__self__, "seats", seats)

    @property
    @pulumi.getter
    def networks(self) -> Optional[builtins.int]:
        """
        Number of networks bound to this subscription
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter
    def seats(self) -> Optional['outputs.LicensingSubscriptionSubscriptionsClaimKeyValidateItemCountsSeats']:
        """
        Seat distribution
        """
        return pulumi.get(self, "seats")


@pulumi.output_type
class LicensingSubscriptionSubscriptionsClaimKeyValidateItemCountsSeats(dict):
    def __init__(__self__, *,
                 assigned: Optional[builtins.int] = None,
                 available: Optional[builtins.int] = None,
                 limit: Optional[builtins.int] = None):
        """
        :param builtins.int assigned: Number of seats in use
        :param builtins.int available: Number of seats available for use
        :param builtins.int limit: Total number of seats provided by this subscription
        """
        if assigned is not None:
            pulumi.set(__self__, "assigned", assigned)
        if available is not None:
            pulumi.set(__self__, "available", available)
        if limit is not None:
            pulumi.set(__self__, "limit", limit)

    @property
    @pulumi.getter
    def assigned(self) -> Optional[builtins.int]:
        """
        Number of seats in use
        """
        return pulumi.get(self, "assigned")

    @property
    @pulumi.getter
    def available(self) -> Optional[builtins.int]:
        """
        Number of seats available for use
        """
        return pulumi.get(self, "available")

    @property
    @pulumi.getter
    def limit(self) -> Optional[builtins.int]:
        """
        Total number of seats provided by this subscription
        """
        return pulumi.get(self, "limit")


@pulumi.output_type
class LicensingSubscriptionSubscriptionsClaimKeyValidateItemEntitlement(dict):
    def __init__(__self__, *,
                 seats: Optional['outputs.LicensingSubscriptionSubscriptionsClaimKeyValidateItemEntitlementSeats'] = None,
                 sku: Optional[builtins.str] = None):
        """
        :param 'LicensingSubscriptionSubscriptionsClaimKeyValidateItemEntitlementSeatsArgs' seats: Seat distribution
        :param builtins.str sku: SKU of the required product
        """
        if seats is not None:
            pulumi.set(__self__, "seats", seats)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter
    def seats(self) -> Optional['outputs.LicensingSubscriptionSubscriptionsClaimKeyValidateItemEntitlementSeats']:
        """
        Seat distribution
        """
        return pulumi.get(self, "seats")

    @property
    @pulumi.getter
    def sku(self) -> Optional[builtins.str]:
        """
        SKU of the required product
        """
        return pulumi.get(self, "sku")


@pulumi.output_type
class LicensingSubscriptionSubscriptionsClaimKeyValidateItemEntitlementSeats(dict):
    def __init__(__self__, *,
                 assigned: Optional[builtins.int] = None,
                 available: Optional[builtins.int] = None,
                 limit: Optional[builtins.int] = None):
        """
        :param builtins.int assigned: Number of seats in use
        :param builtins.int available: Number of seats available for use
        :param builtins.int limit: Total number of seats provided by this subscription for this sku
        """
        if assigned is not None:
            pulumi.set(__self__, "assigned", assigned)
        if available is not None:
            pulumi.set(__self__, "available", available)
        if limit is not None:
            pulumi.set(__self__, "limit", limit)

    @property
    @pulumi.getter
    def assigned(self) -> Optional[builtins.int]:
        """
        Number of seats in use
        """
        return pulumi.get(self, "assigned")

    @property
    @pulumi.getter
    def available(self) -> Optional[builtins.int]:
        """
        Number of seats available for use
        """
        return pulumi.get(self, "available")

    @property
    @pulumi.getter
    def limit(self) -> Optional[builtins.int]:
        """
        Total number of seats provided by this subscription for this sku
        """
        return pulumi.get(self, "limit")


@pulumi.output_type
class LicensingSubscriptionSubscriptionsClaimKeyValidateParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "claimKey":
            suggest = "claim_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LicensingSubscriptionSubscriptionsClaimKeyValidateParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LicensingSubscriptionSubscriptionsClaimKeyValidateParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LicensingSubscriptionSubscriptionsClaimKeyValidateParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 claim_key: Optional[builtins.str] = None):
        """
        :param builtins.str claim_key: The subscription's claim key
        """
        if claim_key is not None:
            pulumi.set(__self__, "claim_key", claim_key)

    @property
    @pulumi.getter(name="claimKey")
    def claim_key(self) -> Optional[builtins.str]:
        """
        The subscription's claim key
        """
        return pulumi.get(self, "claim_key")


@pulumi.output_type
class LicensingSubscriptionSubscriptionsClaimParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "claimKey":
            suggest = "claim_key"
        elif key == "organizationId":
            suggest = "organization_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LicensingSubscriptionSubscriptionsClaimParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LicensingSubscriptionSubscriptionsClaimParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LicensingSubscriptionSubscriptionsClaimParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 claim_key: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 organization_id: Optional[builtins.str] = None):
        """
        :param builtins.str claim_key: The subscription's claim key
        :param builtins.str description: Extra details or notes about the subscription
        :param builtins.str name: Friendly name to identify the subscription
        :param builtins.str organization_id: The id of the organization claiming the subscription
        """
        if claim_key is not None:
            pulumi.set(__self__, "claim_key", claim_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)

    @property
    @pulumi.getter(name="claimKey")
    def claim_key(self) -> Optional[builtins.str]:
        """
        The subscription's claim key
        """
        return pulumi.get(self, "claim_key")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Extra details or notes about the subscription
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Friendly name to identify the subscription
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[builtins.str]:
        """
        The id of the organization claiming the subscription
        """
        return pulumi.get(self, "organization_id")


@pulumi.output_type
class GetIdentitiesMeItemResult(dict):
    def __init__(__self__, *,
                 authentication: 'outputs.GetIdentitiesMeItemAuthenticationResult',
                 email: builtins.str,
                 last_used_dashboard_at: builtins.str,
                 name: builtins.str):
        """
        :param 'GetIdentitiesMeItemAuthenticationArgs' authentication: Authentication info
        :param builtins.str email: User email
        :param builtins.str last_used_dashboard_at: Last seen active on Dashboard UI
        :param builtins.str name: Username
        """
        pulumi.set(__self__, "authentication", authentication)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "last_used_dashboard_at", last_used_dashboard_at)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def authentication(self) -> 'outputs.GetIdentitiesMeItemAuthenticationResult':
        """
        Authentication info
        """
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        User email
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="lastUsedDashboardAt")
    def last_used_dashboard_at(self) -> builtins.str:
        """
        Last seen active on Dashboard UI
        """
        return pulumi.get(self, "last_used_dashboard_at")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Username
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetIdentitiesMeItemAuthenticationResult(dict):
    def __init__(__self__, *,
                 api: 'outputs.GetIdentitiesMeItemAuthenticationApiResult',
                 mode: builtins.str,
                 saml: 'outputs.GetIdentitiesMeItemAuthenticationSamlResult',
                 two_factor: 'outputs.GetIdentitiesMeItemAuthenticationTwoFactorResult'):
        """
        :param 'GetIdentitiesMeItemAuthenticationApiArgs' api: API authentication
        :param builtins.str mode: Authentication mode
        :param 'GetIdentitiesMeItemAuthenticationSamlArgs' saml: SAML authentication
        :param 'GetIdentitiesMeItemAuthenticationTwoFactorArgs' two_factor: TwoFactor authentication
        """
        pulumi.set(__self__, "api", api)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "saml", saml)
        pulumi.set(__self__, "two_factor", two_factor)

    @property
    @pulumi.getter
    def api(self) -> 'outputs.GetIdentitiesMeItemAuthenticationApiResult':
        """
        API authentication
        """
        return pulumi.get(self, "api")

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        Authentication mode
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def saml(self) -> 'outputs.GetIdentitiesMeItemAuthenticationSamlResult':
        """
        SAML authentication
        """
        return pulumi.get(self, "saml")

    @property
    @pulumi.getter(name="twoFactor")
    def two_factor(self) -> 'outputs.GetIdentitiesMeItemAuthenticationTwoFactorResult':
        """
        TwoFactor authentication
        """
        return pulumi.get(self, "two_factor")


@pulumi.output_type
class GetIdentitiesMeItemAuthenticationApiResult(dict):
    def __init__(__self__, *,
                 key: 'outputs.GetIdentitiesMeItemAuthenticationApiKeyResult'):
        """
        :param 'GetIdentitiesMeItemAuthenticationApiKeyArgs' key: API key
        """
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def key(self) -> 'outputs.GetIdentitiesMeItemAuthenticationApiKeyResult':
        """
        API key
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class GetIdentitiesMeItemAuthenticationApiKeyResult(dict):
    def __init__(__self__, *,
                 created: builtins.bool):
        """
        :param builtins.bool created: If API key is created for this user
        """
        pulumi.set(__self__, "created", created)

    @property
    @pulumi.getter
    def created(self) -> builtins.bool:
        """
        If API key is created for this user
        """
        return pulumi.get(self, "created")


@pulumi.output_type
class GetIdentitiesMeItemAuthenticationSamlResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: If SAML authentication is enabled for this user
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        If SAML authentication is enabled for this user
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetIdentitiesMeItemAuthenticationTwoFactorResult(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: If twoFactor authentication is enabled for this user
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        If twoFactor authentication is enabled for this user
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetLicensingSubscriptionEntitlementsItemResult(dict):
    def __init__(__self__, *,
                 feature_tier: builtins.str,
                 is_add_on: builtins.bool,
                 name: builtins.str,
                 product_class: builtins.str,
                 product_type: builtins.str,
                 sku: builtins.str):
        """
        :param builtins.str feature_tier: The feature tier associated with the entitlement (null for add-ons)
        :param builtins.bool is_add_on: Whether or not the entitlement is an add-on
        :param builtins.str name: The user-facing name of the entitlement
        :param builtins.str product_class: The product class associated with the entitlement
        :param builtins.str product_type: The product type of the entitlement
        :param builtins.str sku: The SKU identifier of the entitlement
        """
        pulumi.set(__self__, "feature_tier", feature_tier)
        pulumi.set(__self__, "is_add_on", is_add_on)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product_class", product_class)
        pulumi.set(__self__, "product_type", product_type)
        pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter(name="featureTier")
    def feature_tier(self) -> builtins.str:
        """
        The feature tier associated with the entitlement (null for add-ons)
        """
        return pulumi.get(self, "feature_tier")

    @property
    @pulumi.getter(name="isAddOn")
    def is_add_on(self) -> builtins.bool:
        """
        Whether or not the entitlement is an add-on
        """
        return pulumi.get(self, "is_add_on")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The user-facing name of the entitlement
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productClass")
    def product_class(self) -> builtins.str:
        """
        The product class associated with the entitlement
        """
        return pulumi.get(self, "product_class")

    @property
    @pulumi.getter(name="productType")
    def product_type(self) -> builtins.str:
        """
        The product type of the entitlement
        """
        return pulumi.get(self, "product_type")

    @property
    @pulumi.getter
    def sku(self) -> builtins.str:
        """
        The SKU identifier of the entitlement
        """
        return pulumi.get(self, "sku")


@pulumi.output_type
class GetLicensingSubscriptionSubscriptionsComplianceStatusesItemResult(dict):
    def __init__(__self__, *,
                 subscription: 'outputs.GetLicensingSubscriptionSubscriptionsComplianceStatusesItemSubscriptionResult',
                 violations: 'outputs.GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsResult'):
        """
        :param 'GetLicensingSubscriptionSubscriptionsComplianceStatusesItemSubscriptionArgs' subscription: Subscription details
        :param 'GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsArgs' violations: Violations
        """
        pulumi.set(__self__, "subscription", subscription)
        pulumi.set(__self__, "violations", violations)

    @property
    @pulumi.getter
    def subscription(self) -> 'outputs.GetLicensingSubscriptionSubscriptionsComplianceStatusesItemSubscriptionResult':
        """
        Subscription details
        """
        return pulumi.get(self, "subscription")

    @property
    @pulumi.getter
    def violations(self) -> 'outputs.GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsResult':
        """
        Violations
        """
        return pulumi.get(self, "violations")


@pulumi.output_type
class GetLicensingSubscriptionSubscriptionsComplianceStatusesItemSubscriptionResult(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 name: builtins.str,
                 status: builtins.str):
        """
        :param builtins.str id: Subscription's ID
        :param builtins.str name: Friendly name to identify the subscription
        :param builtins.str status: One of the following: "inactive" | "active" | "out*of*compliance" | "expired" | "canceled"
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Subscription's ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Friendly name to identify the subscription
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        One of the following: "inactive" | "active" | "out*of*compliance" | "expired" | "canceled"
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsResult(dict):
    def __init__(__self__, *,
                 by_product_classes: Sequence['outputs.GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsByProductClassResult']):
        """
        :param Sequence['GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsByProductClassArgs'] by_product_classes: List of violations by product class that are not compliance
        """
        pulumi.set(__self__, "by_product_classes", by_product_classes)

    @property
    @pulumi.getter(name="byProductClasses")
    def by_product_classes(self) -> Sequence['outputs.GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsByProductClassResult']:
        """
        List of violations by product class that are not compliance
        """
        return pulumi.get(self, "by_product_classes")


@pulumi.output_type
class GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsByProductClassResult(dict):
    def __init__(__self__, *,
                 grace_period_ends_at: builtins.str,
                 missing: 'outputs.GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsByProductClassMissingResult',
                 product_class: builtins.str):
        """
        :param builtins.str grace_period_ends_at: End date of the grace period in ISO 8601 format
        :param 'GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsByProductClassMissingArgs' missing: Missing entitlements details
        :param builtins.str product_class: Name of the product class
        """
        pulumi.set(__self__, "grace_period_ends_at", grace_period_ends_at)
        pulumi.set(__self__, "missing", missing)
        pulumi.set(__self__, "product_class", product_class)

    @property
    @pulumi.getter(name="gracePeriodEndsAt")
    def grace_period_ends_at(self) -> builtins.str:
        """
        End date of the grace period in ISO 8601 format
        """
        return pulumi.get(self, "grace_period_ends_at")

    @property
    @pulumi.getter
    def missing(self) -> 'outputs.GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsByProductClassMissingResult':
        """
        Missing entitlements details
        """
        return pulumi.get(self, "missing")

    @property
    @pulumi.getter(name="productClass")
    def product_class(self) -> builtins.str:
        """
        Name of the product class
        """
        return pulumi.get(self, "product_class")


@pulumi.output_type
class GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsByProductClassMissingResult(dict):
    def __init__(__self__, *,
                 entitlements: Sequence['outputs.GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsByProductClassMissingEntitlementResult']):
        """
        :param Sequence['GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsByProductClassMissingEntitlementArgs'] entitlements: List of missing entitlements
        """
        pulumi.set(__self__, "entitlements", entitlements)

    @property
    @pulumi.getter
    def entitlements(self) -> Sequence['outputs.GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsByProductClassMissingEntitlementResult']:
        """
        List of missing entitlements
        """
        return pulumi.get(self, "entitlements")


@pulumi.output_type
class GetLicensingSubscriptionSubscriptionsComplianceStatusesItemViolationsByProductClassMissingEntitlementResult(dict):
    def __init__(__self__, *,
                 quantity: builtins.int,
                 sku: builtins.str):
        """
        :param builtins.int quantity: Number required
        :param builtins.str sku: SKU of the required product
        """
        pulumi.set(__self__, "quantity", quantity)
        pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter
    def quantity(self) -> builtins.int:
        """
        Number required
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter
    def sku(self) -> builtins.str:
        """
        SKU of the required product
        """
        return pulumi.get(self, "sku")


@pulumi.output_type
class GetLicensingSubscriptionSubscriptionsItemResult(dict):
    def __init__(__self__, *,
                 counts: 'outputs.GetLicensingSubscriptionSubscriptionsItemCountsResult',
                 description: builtins.str,
                 end_date: builtins.str,
                 entitlements: Sequence['outputs.GetLicensingSubscriptionSubscriptionsItemEntitlementResult'],
                 name: builtins.str,
                 product_types: Sequence[builtins.str],
                 start_date: builtins.str,
                 status: builtins.str,
                 subscription_id: builtins.str,
                 web_order_id: builtins.str):
        """
        :param 'GetLicensingSubscriptionSubscriptionsItemCountsArgs' counts: Numeric breakdown of network and entitlement counts
        :param builtins.str description: Subscription description
        :param builtins.str end_date: Subscription expiration date
        :param Sequence['GetLicensingSubscriptionSubscriptionsItemEntitlementArgs'] entitlements: Entitlement info
        :param builtins.str name: Subscription name
        :param Sequence[builtins.str] product_types: Products the subscription has entitlements for
        :param builtins.str start_date: Subscription start date
        :param builtins.str status: Subscription status
        :param builtins.str subscription_id: Subscription's ID
        :param builtins.str web_order_id: Web order id
        """
        pulumi.set(__self__, "counts", counts)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "entitlements", entitlements)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product_types", product_types)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subscription_id", subscription_id)
        pulumi.set(__self__, "web_order_id", web_order_id)

    @property
    @pulumi.getter
    def counts(self) -> 'outputs.GetLicensingSubscriptionSubscriptionsItemCountsResult':
        """
        Numeric breakdown of network and entitlement counts
        """
        return pulumi.get(self, "counts")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Subscription description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> builtins.str:
        """
        Subscription expiration date
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter
    def entitlements(self) -> Sequence['outputs.GetLicensingSubscriptionSubscriptionsItemEntitlementResult']:
        """
        Entitlement info
        """
        return pulumi.get(self, "entitlements")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Subscription name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productTypes")
    def product_types(self) -> Sequence[builtins.str]:
        """
        Products the subscription has entitlements for
        """
        return pulumi.get(self, "product_types")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> builtins.str:
        """
        Subscription start date
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Subscription status
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> builtins.str:
        """
        Subscription's ID
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="webOrderId")
    def web_order_id(self) -> builtins.str:
        """
        Web order id
        """
        return pulumi.get(self, "web_order_id")


@pulumi.output_type
class GetLicensingSubscriptionSubscriptionsItemCountsResult(dict):
    def __init__(__self__, *,
                 networks: builtins.int,
                 seats: 'outputs.GetLicensingSubscriptionSubscriptionsItemCountsSeatsResult'):
        """
        :param builtins.int networks: Number of networks bound to this subscription
        :param 'GetLicensingSubscriptionSubscriptionsItemCountsSeatsArgs' seats: Seat distribution
        """
        pulumi.set(__self__, "networks", networks)
        pulumi.set(__self__, "seats", seats)

    @property
    @pulumi.getter
    def networks(self) -> builtins.int:
        """
        Number of networks bound to this subscription
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter
    def seats(self) -> 'outputs.GetLicensingSubscriptionSubscriptionsItemCountsSeatsResult':
        """
        Seat distribution
        """
        return pulumi.get(self, "seats")


@pulumi.output_type
class GetLicensingSubscriptionSubscriptionsItemCountsSeatsResult(dict):
    def __init__(__self__, *,
                 assigned: builtins.int,
                 available: builtins.int,
                 limit: builtins.int):
        """
        :param builtins.int assigned: Number of seats in use
        :param builtins.int available: Number of seats available for use
        :param builtins.int limit: Total number of seats provided by this subscription
        """
        pulumi.set(__self__, "assigned", assigned)
        pulumi.set(__self__, "available", available)
        pulumi.set(__self__, "limit", limit)

    @property
    @pulumi.getter
    def assigned(self) -> builtins.int:
        """
        Number of seats in use
        """
        return pulumi.get(self, "assigned")

    @property
    @pulumi.getter
    def available(self) -> builtins.int:
        """
        Number of seats available for use
        """
        return pulumi.get(self, "available")

    @property
    @pulumi.getter
    def limit(self) -> builtins.int:
        """
        Total number of seats provided by this subscription
        """
        return pulumi.get(self, "limit")


@pulumi.output_type
class GetLicensingSubscriptionSubscriptionsItemEntitlementResult(dict):
    def __init__(__self__, *,
                 seats: 'outputs.GetLicensingSubscriptionSubscriptionsItemEntitlementSeatsResult',
                 sku: builtins.str):
        """
        :param 'GetLicensingSubscriptionSubscriptionsItemEntitlementSeatsArgs' seats: Seat distribution
        :param builtins.str sku: SKU of the required product
        """
        pulumi.set(__self__, "seats", seats)
        pulumi.set(__self__, "sku", sku)

    @property
    @pulumi.getter
    def seats(self) -> 'outputs.GetLicensingSubscriptionSubscriptionsItemEntitlementSeatsResult':
        """
        Seat distribution
        """
        return pulumi.get(self, "seats")

    @property
    @pulumi.getter
    def sku(self) -> builtins.str:
        """
        SKU of the required product
        """
        return pulumi.get(self, "sku")


@pulumi.output_type
class GetLicensingSubscriptionSubscriptionsItemEntitlementSeatsResult(dict):
    def __init__(__self__, *,
                 assigned: builtins.int,
                 available: builtins.int,
                 limit: builtins.int):
        """
        :param builtins.int assigned: Number of seats in use
        :param builtins.int available: Number of seats available for use
        :param builtins.int limit: Total number of seats provided by this subscription for this sku
        """
        pulumi.set(__self__, "assigned", assigned)
        pulumi.set(__self__, "available", available)
        pulumi.set(__self__, "limit", limit)

    @property
    @pulumi.getter
    def assigned(self) -> builtins.int:
        """
        Number of seats in use
        """
        return pulumi.get(self, "assigned")

    @property
    @pulumi.getter
    def available(self) -> builtins.int:
        """
        Number of seats available for use
        """
        return pulumi.get(self, "available")

    @property
    @pulumi.getter
    def limit(self) -> builtins.int:
        """
        Total number of seats provided by this subscription for this sku
        """
        return pulumi.get(self, "limit")


