# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetNetworksResult',
    'AwaitableGetNetworksResult',
    'get_networks',
    'get_networks_output',
]

@pulumi.output_type
class GetNetworksResult:
    """
    A collection of values returned by getNetworks.
    """
    def __init__(__self__, config_template_id=None, ending_before=None, id=None, is_bound_to_config_template=None, item=None, items=None, network_id=None, organization_id=None, per_page=None, starting_after=None, tags=None, tags_filter_type=None):
        if config_template_id and not isinstance(config_template_id, str):
            raise TypeError("Expected argument 'config_template_id' to be a str")
        pulumi.set(__self__, "config_template_id", config_template_id)
        if ending_before and not isinstance(ending_before, str):
            raise TypeError("Expected argument 'ending_before' to be a str")
        pulumi.set(__self__, "ending_before", ending_before)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_bound_to_config_template and not isinstance(is_bound_to_config_template, bool):
            raise TypeError("Expected argument 'is_bound_to_config_template' to be a bool")
        pulumi.set(__self__, "is_bound_to_config_template", is_bound_to_config_template)
        if item and not isinstance(item, dict):
            raise TypeError("Expected argument 'item' to be a dict")
        pulumi.set(__self__, "item", item)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if per_page and not isinstance(per_page, int):
            raise TypeError("Expected argument 'per_page' to be a int")
        pulumi.set(__self__, "per_page", per_page)
        if starting_after and not isinstance(starting_after, str):
            raise TypeError("Expected argument 'starting_after' to be a str")
        pulumi.set(__self__, "starting_after", starting_after)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tags_filter_type and not isinstance(tags_filter_type, str):
            raise TypeError("Expected argument 'tags_filter_type' to be a str")
        pulumi.set(__self__, "tags_filter_type", tags_filter_type)

    @property
    @pulumi.getter(name="configTemplateId")
    def config_template_id(self) -> Optional[builtins.str]:
        """
        configTemplateId query parameter. An optional parameter that is the ID of a config template. Will return all networks bound to that template.
        """
        return pulumi.get(self, "config_template_id")

    @property
    @pulumi.getter(name="endingBefore")
    def ending_before(self) -> Optional[builtins.str]:
        """
        endingBefore query parameter. A token used by the server to indicate the end of the page. Often this is a timestamp or an ID but it is not limited to those. This parameter should not be defined by client applications. The link for the first, last, prev, or next page in the HTTP Link header should define it.
        """
        return pulumi.get(self, "ending_before")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isBoundToConfigTemplate")
    def is_bound_to_config_template(self) -> Optional[builtins.bool]:
        """
        isBoundToConfigTemplate query parameter. An optional parameter to filter config template bound networks. If configTemplateId is set, this cannot be false.
        """
        return pulumi.get(self, "is_bound_to_config_template")

    @property
    @pulumi.getter
    def item(self) -> 'outputs.GetNetworksItemResult':
        return pulumi.get(self, "item")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetNetworksItemResult']:
        """
        Array of ResponseOrganizationsGetOrganizationNetworks
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[builtins.str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="perPage")
    def per_page(self) -> Optional[builtins.int]:
        """
        perPage query parameter. The number of entries per page returned. Acceptable range is 3 100000. Default is 1000.
        """
        return pulumi.get(self, "per_page")

    @property
    @pulumi.getter(name="startingAfter")
    def starting_after(self) -> Optional[builtins.str]:
        """
        startingAfter query parameter. A token used by the server to indicate the start of the page. Often this is a timestamp or an ID but it is not limited to those. This parameter should not be defined by client applications. The link for the first, last, prev, or next page in the HTTP Link header should define it.
        """
        return pulumi.get(self, "starting_after")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[builtins.str]]:
        """
        tags query parameter. An optional parameter to filter networks by tags. The filtering is case-sensitive. If tags are included, 'tagsFilterType' should also be included (see below).
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsFilterType")
    def tags_filter_type(self) -> Optional[builtins.str]:
        """
        tagsFilterType query parameter. An optional parameter of value 'withAnyTags' or 'withAllTags' to indicate whether to return networks which contain ANY or ALL of the included tags. If no type is included, 'withAnyTags' will be selected.
        """
        return pulumi.get(self, "tags_filter_type")


class AwaitableGetNetworksResult(GetNetworksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworksResult(
            config_template_id=self.config_template_id,
            ending_before=self.ending_before,
            id=self.id,
            is_bound_to_config_template=self.is_bound_to_config_template,
            item=self.item,
            items=self.items,
            network_id=self.network_id,
            organization_id=self.organization_id,
            per_page=self.per_page,
            starting_after=self.starting_after,
            tags=self.tags,
            tags_filter_type=self.tags_filter_type)


def get_networks(config_template_id: Optional[builtins.str] = None,
                 ending_before: Optional[builtins.str] = None,
                 is_bound_to_config_template: Optional[builtins.bool] = None,
                 network_id: Optional[builtins.str] = None,
                 organization_id: Optional[builtins.str] = None,
                 per_page: Optional[builtins.int] = None,
                 starting_after: Optional[builtins.str] = None,
                 tags: Optional[Sequence[builtins.str]] = None,
                 tags_filter_type: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworksResult:
    """
    ## Example Usage


    :param builtins.str config_template_id: configTemplateId query parameter. An optional parameter that is the ID of a config template. Will return all networks bound to that template.
    :param builtins.str ending_before: endingBefore query parameter. A token used by the server to indicate the end of the page. Often this is a timestamp or an ID but it is not limited to those. This parameter should not be defined by client applications. The link for the first, last, prev, or next page in the HTTP Link header should define it.
    :param builtins.bool is_bound_to_config_template: isBoundToConfigTemplate query parameter. An optional parameter to filter config template bound networks. If configTemplateId is set, this cannot be false.
    :param builtins.str network_id: networkId path parameter. Network ID
    :param builtins.str organization_id: organizationId path parameter. Organization ID
    :param builtins.int per_page: perPage query parameter. The number of entries per page returned. Acceptable range is 3 100000. Default is 1000.
    :param builtins.str starting_after: startingAfter query parameter. A token used by the server to indicate the start of the page. Often this is a timestamp or an ID but it is not limited to those. This parameter should not be defined by client applications. The link for the first, last, prev, or next page in the HTTP Link header should define it.
    :param Sequence[builtins.str] tags: tags query parameter. An optional parameter to filter networks by tags. The filtering is case-sensitive. If tags are included, 'tagsFilterType' should also be included (see below).
    :param builtins.str tags_filter_type: tagsFilterType query parameter. An optional parameter of value 'withAnyTags' or 'withAllTags' to indicate whether to return networks which contain ANY or ALL of the included tags. If no type is included, 'withAnyTags' will be selected.
    """
    __args__ = dict()
    __args__['configTemplateId'] = config_template_id
    __args__['endingBefore'] = ending_before
    __args__['isBoundToConfigTemplate'] = is_bound_to_config_template
    __args__['networkId'] = network_id
    __args__['organizationId'] = organization_id
    __args__['perPage'] = per_page
    __args__['startingAfter'] = starting_after
    __args__['tags'] = tags
    __args__['tagsFilterType'] = tags_filter_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('meraki:index/getNetworks:getNetworks', __args__, opts=opts, typ=GetNetworksResult).value

    return AwaitableGetNetworksResult(
        config_template_id=pulumi.get(__ret__, 'config_template_id'),
        ending_before=pulumi.get(__ret__, 'ending_before'),
        id=pulumi.get(__ret__, 'id'),
        is_bound_to_config_template=pulumi.get(__ret__, 'is_bound_to_config_template'),
        item=pulumi.get(__ret__, 'item'),
        items=pulumi.get(__ret__, 'items'),
        network_id=pulumi.get(__ret__, 'network_id'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        per_page=pulumi.get(__ret__, 'per_page'),
        starting_after=pulumi.get(__ret__, 'starting_after'),
        tags=pulumi.get(__ret__, 'tags'),
        tags_filter_type=pulumi.get(__ret__, 'tags_filter_type'))
def get_networks_output(config_template_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        ending_before: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        is_bound_to_config_template: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                        network_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        organization_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        per_page: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                        starting_after: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        tags: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                        tags_filter_type: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworksResult]:
    """
    ## Example Usage


    :param builtins.str config_template_id: configTemplateId query parameter. An optional parameter that is the ID of a config template. Will return all networks bound to that template.
    :param builtins.str ending_before: endingBefore query parameter. A token used by the server to indicate the end of the page. Often this is a timestamp or an ID but it is not limited to those. This parameter should not be defined by client applications. The link for the first, last, prev, or next page in the HTTP Link header should define it.
    :param builtins.bool is_bound_to_config_template: isBoundToConfigTemplate query parameter. An optional parameter to filter config template bound networks. If configTemplateId is set, this cannot be false.
    :param builtins.str network_id: networkId path parameter. Network ID
    :param builtins.str organization_id: organizationId path parameter. Organization ID
    :param builtins.int per_page: perPage query parameter. The number of entries per page returned. Acceptable range is 3 100000. Default is 1000.
    :param builtins.str starting_after: startingAfter query parameter. A token used by the server to indicate the start of the page. Often this is a timestamp or an ID but it is not limited to those. This parameter should not be defined by client applications. The link for the first, last, prev, or next page in the HTTP Link header should define it.
    :param Sequence[builtins.str] tags: tags query parameter. An optional parameter to filter networks by tags. The filtering is case-sensitive. If tags are included, 'tagsFilterType' should also be included (see below).
    :param builtins.str tags_filter_type: tagsFilterType query parameter. An optional parameter of value 'withAnyTags' or 'withAllTags' to indicate whether to return networks which contain ANY or ALL of the included tags. If no type is included, 'withAnyTags' will be selected.
    """
    __args__ = dict()
    __args__['configTemplateId'] = config_template_id
    __args__['endingBefore'] = ending_before
    __args__['isBoundToConfigTemplate'] = is_bound_to_config_template
    __args__['networkId'] = network_id
    __args__['organizationId'] = organization_id
    __args__['perPage'] = per_page
    __args__['startingAfter'] = starting_after
    __args__['tags'] = tags
    __args__['tagsFilterType'] = tags_filter_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('meraki:index/getNetworks:getNetworks', __args__, opts=opts, typ=GetNetworksResult)
    return __ret__.apply(lambda __response__: GetNetworksResult(
        config_template_id=pulumi.get(__response__, 'config_template_id'),
        ending_before=pulumi.get(__response__, 'ending_before'),
        id=pulumi.get(__response__, 'id'),
        is_bound_to_config_template=pulumi.get(__response__, 'is_bound_to_config_template'),
        item=pulumi.get(__response__, 'item'),
        items=pulumi.get(__response__, 'items'),
        network_id=pulumi.get(__response__, 'network_id'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        per_page=pulumi.get(__response__, 'per_page'),
        starting_after=pulumi.get(__response__, 'starting_after'),
        tags=pulumi.get(__response__, 'tags'),
        tags_filter_type=pulumi.get(__response__, 'tags_filter_type')))
