# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertsSettingsArgs', 'AlertsSettings']

@pulumi.input_type
class AlertsSettingsArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 alerts: Optional[pulumi.Input[Sequence[pulumi.Input['AlertsSettingsAlertArgs']]]] = None,
                 default_destinations: Optional[pulumi.Input['AlertsSettingsDefaultDestinationsArgs']] = None,
                 muting: Optional[pulumi.Input['AlertsSettingsMutingArgs']] = None):
        """
        The set of arguments for constructing a AlertsSettings resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input['AlertsSettingsAlertArgs']]] alerts: Alert-specific configuration for each type. Only alerts that pertain to the network can be updated.
        :param pulumi.Input['AlertsSettingsDefaultDestinationsArgs'] default_destinations: The network-wide destinations for all alerts on the network.
        :param pulumi.Input['AlertsSettingsMutingArgs'] muting: muting
        """
        pulumi.set(__self__, "network_id", network_id)
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if default_destinations is not None:
            pulumi.set(__self__, "default_destinations", default_destinations)
        if muting is not None:
            pulumi.set(__self__, "muting", muting)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def alerts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertsSettingsAlertArgs']]]]:
        """
        Alert-specific configuration for each type. Only alerts that pertain to the network can be updated.
        """
        return pulumi.get(self, "alerts")

    @alerts.setter
    def alerts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertsSettingsAlertArgs']]]]):
        pulumi.set(self, "alerts", value)

    @property
    @pulumi.getter(name="defaultDestinations")
    def default_destinations(self) -> Optional[pulumi.Input['AlertsSettingsDefaultDestinationsArgs']]:
        """
        The network-wide destinations for all alerts on the network.
        """
        return pulumi.get(self, "default_destinations")

    @default_destinations.setter
    def default_destinations(self, value: Optional[pulumi.Input['AlertsSettingsDefaultDestinationsArgs']]):
        pulumi.set(self, "default_destinations", value)

    @property
    @pulumi.getter
    def muting(self) -> Optional[pulumi.Input['AlertsSettingsMutingArgs']]:
        """
        muting
        """
        return pulumi.get(self, "muting")

    @muting.setter
    def muting(self, value: Optional[pulumi.Input['AlertsSettingsMutingArgs']]):
        pulumi.set(self, "muting", value)


@pulumi.input_type
class _AlertsSettingsState:
    def __init__(__self__, *,
                 alerts: Optional[pulumi.Input[Sequence[pulumi.Input['AlertsSettingsAlertArgs']]]] = None,
                 alerts_responses: Optional[pulumi.Input[Sequence[pulumi.Input['AlertsSettingsAlertsResponseArgs']]]] = None,
                 default_destinations: Optional[pulumi.Input['AlertsSettingsDefaultDestinationsArgs']] = None,
                 muting: Optional[pulumi.Input['AlertsSettingsMutingArgs']] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AlertsSettings resources.
        :param pulumi.Input[Sequence[pulumi.Input['AlertsSettingsAlertArgs']]] alerts: Alert-specific configuration for each type. Only alerts that pertain to the network can be updated.
        :param pulumi.Input[Sequence[pulumi.Input['AlertsSettingsAlertsResponseArgs']]] alerts_responses: Alert-specific configuration for each type. Only alerts that pertain to the network can be updated.
        :param pulumi.Input['AlertsSettingsDefaultDestinationsArgs'] default_destinations: The network-wide destinations for all alerts on the network.
        :param pulumi.Input['AlertsSettingsMutingArgs'] muting: muting
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        """
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if alerts_responses is not None:
            pulumi.set(__self__, "alerts_responses", alerts_responses)
        if default_destinations is not None:
            pulumi.set(__self__, "default_destinations", default_destinations)
        if muting is not None:
            pulumi.set(__self__, "muting", muting)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)

    @property
    @pulumi.getter
    def alerts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertsSettingsAlertArgs']]]]:
        """
        Alert-specific configuration for each type. Only alerts that pertain to the network can be updated.
        """
        return pulumi.get(self, "alerts")

    @alerts.setter
    def alerts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertsSettingsAlertArgs']]]]):
        pulumi.set(self, "alerts", value)

    @property
    @pulumi.getter(name="alertsResponses")
    def alerts_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertsSettingsAlertsResponseArgs']]]]:
        """
        Alert-specific configuration for each type. Only alerts that pertain to the network can be updated.
        """
        return pulumi.get(self, "alerts_responses")

    @alerts_responses.setter
    def alerts_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertsSettingsAlertsResponseArgs']]]]):
        pulumi.set(self, "alerts_responses", value)

    @property
    @pulumi.getter(name="defaultDestinations")
    def default_destinations(self) -> Optional[pulumi.Input['AlertsSettingsDefaultDestinationsArgs']]:
        """
        The network-wide destinations for all alerts on the network.
        """
        return pulumi.get(self, "default_destinations")

    @default_destinations.setter
    def default_destinations(self, value: Optional[pulumi.Input['AlertsSettingsDefaultDestinationsArgs']]):
        pulumi.set(self, "default_destinations", value)

    @property
    @pulumi.getter
    def muting(self) -> Optional[pulumi.Input['AlertsSettingsMutingArgs']]:
        """
        muting
        """
        return pulumi.get(self, "muting")

    @muting.setter
    def muting(self, value: Optional[pulumi.Input['AlertsSettingsMutingArgs']]):
        pulumi.set(self, "muting", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)


@pulumi.type_token("meraki:networks/alertsSettings:AlertsSettings")
class AlertsSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alerts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertsSettingsAlertArgs', 'AlertsSettingsAlertArgsDict']]]]] = None,
                 default_destinations: Optional[pulumi.Input[Union['AlertsSettingsDefaultDestinationsArgs', 'AlertsSettingsDefaultDestinationsArgsDict']]] = None,
                 muting: Optional[pulumi.Input[Union['AlertsSettingsMutingArgs', 'AlertsSettingsMutingArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/alertsSettings:AlertsSettings example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertsSettingsAlertArgs', 'AlertsSettingsAlertArgsDict']]]] alerts: Alert-specific configuration for each type. Only alerts that pertain to the network can be updated.
        :param pulumi.Input[Union['AlertsSettingsDefaultDestinationsArgs', 'AlertsSettingsDefaultDestinationsArgsDict']] default_destinations: The network-wide destinations for all alerts on the network.
        :param pulumi.Input[Union['AlertsSettingsMutingArgs', 'AlertsSettingsMutingArgsDict']] muting: muting
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertsSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/alertsSettings:AlertsSettings example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param AlertsSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertsSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alerts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertsSettingsAlertArgs', 'AlertsSettingsAlertArgsDict']]]]] = None,
                 default_destinations: Optional[pulumi.Input[Union['AlertsSettingsDefaultDestinationsArgs', 'AlertsSettingsDefaultDestinationsArgsDict']]] = None,
                 muting: Optional[pulumi.Input[Union['AlertsSettingsMutingArgs', 'AlertsSettingsMutingArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertsSettingsArgs.__new__(AlertsSettingsArgs)

            __props__.__dict__["alerts"] = alerts
            __props__.__dict__["default_destinations"] = default_destinations
            __props__.__dict__["muting"] = muting
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["alerts_responses"] = None
        super(AlertsSettings, __self__).__init__(
            'meraki:networks/alertsSettings:AlertsSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alerts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertsSettingsAlertArgs', 'AlertsSettingsAlertArgsDict']]]]] = None,
            alerts_responses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertsSettingsAlertsResponseArgs', 'AlertsSettingsAlertsResponseArgsDict']]]]] = None,
            default_destinations: Optional[pulumi.Input[Union['AlertsSettingsDefaultDestinationsArgs', 'AlertsSettingsDefaultDestinationsArgsDict']]] = None,
            muting: Optional[pulumi.Input[Union['AlertsSettingsMutingArgs', 'AlertsSettingsMutingArgsDict']]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None) -> 'AlertsSettings':
        """
        Get an existing AlertsSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertsSettingsAlertArgs', 'AlertsSettingsAlertArgsDict']]]] alerts: Alert-specific configuration for each type. Only alerts that pertain to the network can be updated.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertsSettingsAlertsResponseArgs', 'AlertsSettingsAlertsResponseArgsDict']]]] alerts_responses: Alert-specific configuration for each type. Only alerts that pertain to the network can be updated.
        :param pulumi.Input[Union['AlertsSettingsDefaultDestinationsArgs', 'AlertsSettingsDefaultDestinationsArgsDict']] default_destinations: The network-wide destinations for all alerts on the network.
        :param pulumi.Input[Union['AlertsSettingsMutingArgs', 'AlertsSettingsMutingArgsDict']] muting: muting
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertsSettingsState.__new__(_AlertsSettingsState)

        __props__.__dict__["alerts"] = alerts
        __props__.__dict__["alerts_responses"] = alerts_responses
        __props__.__dict__["default_destinations"] = default_destinations
        __props__.__dict__["muting"] = muting
        __props__.__dict__["network_id"] = network_id
        return AlertsSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alerts(self) -> pulumi.Output[Optional[Sequence['outputs.AlertsSettingsAlert']]]:
        """
        Alert-specific configuration for each type. Only alerts that pertain to the network can be updated.
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter(name="alertsResponses")
    def alerts_responses(self) -> pulumi.Output[Sequence['outputs.AlertsSettingsAlertsResponse']]:
        """
        Alert-specific configuration for each type. Only alerts that pertain to the network can be updated.
        """
        return pulumi.get(self, "alerts_responses")

    @property
    @pulumi.getter(name="defaultDestinations")
    def default_destinations(self) -> pulumi.Output['outputs.AlertsSettingsDefaultDestinations']:
        """
        The network-wide destinations for all alerts on the network.
        """
        return pulumi.get(self, "default_destinations")

    @property
    @pulumi.getter
    def muting(self) -> pulumi.Output['outputs.AlertsSettingsMuting']:
        """
        muting
        """
        return pulumi.get(self, "muting")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

