# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FirmwareUpgradesStagedEventsArgs', 'FirmwareUpgradesStagedEvents']

@pulumi.input_type
class FirmwareUpgradesStagedEventsArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 products: Optional[pulumi.Input['FirmwareUpgradesStagedEventsProductsArgs']] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedEventsStageArgs']]]] = None):
        """
        The set of arguments for constructing a FirmwareUpgradesStagedEvents resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['FirmwareUpgradesStagedEventsProductsArgs'] products: The network devices to be updated
        :param pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedEventsStageArgs']]] stages: The ordered stages in the network
        """
        pulumi.set(__self__, "network_id", network_id)
        if products is not None:
            pulumi.set(__self__, "products", products)
        if stages is not None:
            pulumi.set(__self__, "stages", stages)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def products(self) -> Optional[pulumi.Input['FirmwareUpgradesStagedEventsProductsArgs']]:
        """
        The network devices to be updated
        """
        return pulumi.get(self, "products")

    @products.setter
    def products(self, value: Optional[pulumi.Input['FirmwareUpgradesStagedEventsProductsArgs']]):
        pulumi.set(self, "products", value)

    @property
    @pulumi.getter
    def stages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedEventsStageArgs']]]]:
        """
        The ordered stages in the network
        """
        return pulumi.get(self, "stages")

    @stages.setter
    def stages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedEventsStageArgs']]]]):
        pulumi.set(self, "stages", value)


@pulumi.input_type
class _FirmwareUpgradesStagedEventsState:
    def __init__(__self__, *,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 products: Optional[pulumi.Input['FirmwareUpgradesStagedEventsProductsArgs']] = None,
                 reasons: Optional[pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedEventsReasonArgs']]]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedEventsStageArgs']]]] = None):
        """
        Input properties used for looking up and filtering FirmwareUpgradesStagedEvents resources.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['FirmwareUpgradesStagedEventsProductsArgs'] products: The network devices to be updated
        :param pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedEventsReasonArgs']]] reasons: Reasons for the rollback
        :param pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedEventsStageArgs']]] stages: The ordered stages in the network
        """
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if products is not None:
            pulumi.set(__self__, "products", products)
        if reasons is not None:
            pulumi.set(__self__, "reasons", reasons)
        if stages is not None:
            pulumi.set(__self__, "stages", stages)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def products(self) -> Optional[pulumi.Input['FirmwareUpgradesStagedEventsProductsArgs']]:
        """
        The network devices to be updated
        """
        return pulumi.get(self, "products")

    @products.setter
    def products(self, value: Optional[pulumi.Input['FirmwareUpgradesStagedEventsProductsArgs']]):
        pulumi.set(self, "products", value)

    @property
    @pulumi.getter
    def reasons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedEventsReasonArgs']]]]:
        """
        Reasons for the rollback
        """
        return pulumi.get(self, "reasons")

    @reasons.setter
    def reasons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedEventsReasonArgs']]]]):
        pulumi.set(self, "reasons", value)

    @property
    @pulumi.getter
    def stages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedEventsStageArgs']]]]:
        """
        The ordered stages in the network
        """
        return pulumi.get(self, "stages")

    @stages.setter
    def stages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirmwareUpgradesStagedEventsStageArgs']]]]):
        pulumi.set(self, "stages", value)


@pulumi.type_token("meraki:networks/firmwareUpgradesStagedEvents:FirmwareUpgradesStagedEvents")
class FirmwareUpgradesStagedEvents(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 products: Optional[pulumi.Input[Union['FirmwareUpgradesStagedEventsProductsArgs', 'FirmwareUpgradesStagedEventsProductsArgsDict']]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirmwareUpgradesStagedEventsStageArgs', 'FirmwareUpgradesStagedEventsStageArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/firmwareUpgradesStagedEvents:FirmwareUpgradesStagedEvents example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['FirmwareUpgradesStagedEventsProductsArgs', 'FirmwareUpgradesStagedEventsProductsArgsDict']] products: The network devices to be updated
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirmwareUpgradesStagedEventsStageArgs', 'FirmwareUpgradesStagedEventsStageArgsDict']]]] stages: The ordered stages in the network
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirmwareUpgradesStagedEventsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/firmwareUpgradesStagedEvents:FirmwareUpgradesStagedEvents example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param FirmwareUpgradesStagedEventsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirmwareUpgradesStagedEventsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 products: Optional[pulumi.Input[Union['FirmwareUpgradesStagedEventsProductsArgs', 'FirmwareUpgradesStagedEventsProductsArgsDict']]] = None,
                 stages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirmwareUpgradesStagedEventsStageArgs', 'FirmwareUpgradesStagedEventsStageArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirmwareUpgradesStagedEventsArgs.__new__(FirmwareUpgradesStagedEventsArgs)

            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["products"] = products
            __props__.__dict__["stages"] = stages
            __props__.__dict__["reasons"] = None
        super(FirmwareUpgradesStagedEvents, __self__).__init__(
            'meraki:networks/firmwareUpgradesStagedEvents:FirmwareUpgradesStagedEvents',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            products: Optional[pulumi.Input[Union['FirmwareUpgradesStagedEventsProductsArgs', 'FirmwareUpgradesStagedEventsProductsArgsDict']]] = None,
            reasons: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirmwareUpgradesStagedEventsReasonArgs', 'FirmwareUpgradesStagedEventsReasonArgsDict']]]]] = None,
            stages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirmwareUpgradesStagedEventsStageArgs', 'FirmwareUpgradesStagedEventsStageArgsDict']]]]] = None) -> 'FirmwareUpgradesStagedEvents':
        """
        Get an existing FirmwareUpgradesStagedEvents resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['FirmwareUpgradesStagedEventsProductsArgs', 'FirmwareUpgradesStagedEventsProductsArgsDict']] products: The network devices to be updated
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirmwareUpgradesStagedEventsReasonArgs', 'FirmwareUpgradesStagedEventsReasonArgsDict']]]] reasons: Reasons for the rollback
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirmwareUpgradesStagedEventsStageArgs', 'FirmwareUpgradesStagedEventsStageArgsDict']]]] stages: The ordered stages in the network
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirmwareUpgradesStagedEventsState.__new__(_FirmwareUpgradesStagedEventsState)

        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["products"] = products
        __props__.__dict__["reasons"] = reasons
        __props__.__dict__["stages"] = stages
        return FirmwareUpgradesStagedEvents(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def products(self) -> pulumi.Output['outputs.FirmwareUpgradesStagedEventsProducts']:
        """
        The network devices to be updated
        """
        return pulumi.get(self, "products")

    @property
    @pulumi.getter
    def reasons(self) -> pulumi.Output[Sequence['outputs.FirmwareUpgradesStagedEventsReason']]:
        """
        Reasons for the rollback
        """
        return pulumi.get(self, "reasons")

    @property
    @pulumi.getter
    def stages(self) -> pulumi.Output[Sequence['outputs.FirmwareUpgradesStagedEventsStage']]:
        """
        The ordered stages in the network
        """
        return pulumi.get(self, "stages")

