# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FloorPlansArgs', 'FloorPlans']

@pulumi.input_type
class FloorPlansArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 bottom_left_corner: Optional[pulumi.Input['FloorPlansBottomLeftCornerArgs']] = None,
                 bottom_right_corner: Optional[pulumi.Input['FloorPlansBottomRightCornerArgs']] = None,
                 center: Optional[pulumi.Input['FloorPlansCenterArgs']] = None,
                 floor_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 image_contents: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 top_left_corner: Optional[pulumi.Input['FloorPlansTopLeftCornerArgs']] = None,
                 top_right_corner: Optional[pulumi.Input['FloorPlansTopRightCornerArgs']] = None):
        """
        The set of arguments for constructing a FloorPlans resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['FloorPlansBottomLeftCornerArgs'] bottom_left_corner: The longitude and latitude of the bottom left corner of your floor plan.
        :param pulumi.Input['FloorPlansBottomRightCornerArgs'] bottom_right_corner: The longitude and latitude of the bottom right corner of your floor plan.
        :param pulumi.Input['FloorPlansCenterArgs'] center: The longitude and latitude of the center of your floor plan. The 'center' or two adjacent corners (e.g. 'topLeftCorner' and 'bottomLeftCorner') must be specified. If 'center' is specified, the floor plan is placed over that point with no rotation. If two adjacent corners are specified, the floor plan is rotated to line up with the two specified points. The aspect ratio of the floor plan's image is preserved regardless of which corners/center are specified. (This means if that more than two corners are specified, only two corners may be used to preserve the floor plan's aspect ratio.). No two points can have the same latitude, longitude pair.
        :param pulumi.Input[builtins.str] floor_plan_id: Floor plan ID
        :param pulumi.Input[builtins.str] image_contents: The file contents (a base 64 encoded string) of your image. Supported formats are PNG, GIF, and JPG. Note that all images are saved as PNG files, regardless of the format they are uploaded in.
        :param pulumi.Input[builtins.str] name: The name of your floor plan.
        :param pulumi.Input['FloorPlansTopLeftCornerArgs'] top_left_corner: The longitude and latitude of the top left corner of your floor plan.
        :param pulumi.Input['FloorPlansTopRightCornerArgs'] top_right_corner: The longitude and latitude of the top right corner of your floor plan.
        """
        pulumi.set(__self__, "network_id", network_id)
        if bottom_left_corner is not None:
            pulumi.set(__self__, "bottom_left_corner", bottom_left_corner)
        if bottom_right_corner is not None:
            pulumi.set(__self__, "bottom_right_corner", bottom_right_corner)
        if center is not None:
            pulumi.set(__self__, "center", center)
        if floor_plan_id is not None:
            pulumi.set(__self__, "floor_plan_id", floor_plan_id)
        if image_contents is not None:
            pulumi.set(__self__, "image_contents", image_contents)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if top_left_corner is not None:
            pulumi.set(__self__, "top_left_corner", top_left_corner)
        if top_right_corner is not None:
            pulumi.set(__self__, "top_right_corner", top_right_corner)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="bottomLeftCorner")
    def bottom_left_corner(self) -> Optional[pulumi.Input['FloorPlansBottomLeftCornerArgs']]:
        """
        The longitude and latitude of the bottom left corner of your floor plan.
        """
        return pulumi.get(self, "bottom_left_corner")

    @bottom_left_corner.setter
    def bottom_left_corner(self, value: Optional[pulumi.Input['FloorPlansBottomLeftCornerArgs']]):
        pulumi.set(self, "bottom_left_corner", value)

    @property
    @pulumi.getter(name="bottomRightCorner")
    def bottom_right_corner(self) -> Optional[pulumi.Input['FloorPlansBottomRightCornerArgs']]:
        """
        The longitude and latitude of the bottom right corner of your floor plan.
        """
        return pulumi.get(self, "bottom_right_corner")

    @bottom_right_corner.setter
    def bottom_right_corner(self, value: Optional[pulumi.Input['FloorPlansBottomRightCornerArgs']]):
        pulumi.set(self, "bottom_right_corner", value)

    @property
    @pulumi.getter
    def center(self) -> Optional[pulumi.Input['FloorPlansCenterArgs']]:
        """
        The longitude and latitude of the center of your floor plan. The 'center' or two adjacent corners (e.g. 'topLeftCorner' and 'bottomLeftCorner') must be specified. If 'center' is specified, the floor plan is placed over that point with no rotation. If two adjacent corners are specified, the floor plan is rotated to line up with the two specified points. The aspect ratio of the floor plan's image is preserved regardless of which corners/center are specified. (This means if that more than two corners are specified, only two corners may be used to preserve the floor plan's aspect ratio.). No two points can have the same latitude, longitude pair.
        """
        return pulumi.get(self, "center")

    @center.setter
    def center(self, value: Optional[pulumi.Input['FloorPlansCenterArgs']]):
        pulumi.set(self, "center", value)

    @property
    @pulumi.getter(name="floorPlanId")
    def floor_plan_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Floor plan ID
        """
        return pulumi.get(self, "floor_plan_id")

    @floor_plan_id.setter
    def floor_plan_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "floor_plan_id", value)

    @property
    @pulumi.getter(name="imageContents")
    def image_contents(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The file contents (a base 64 encoded string) of your image. Supported formats are PNG, GIF, and JPG. Note that all images are saved as PNG files, regardless of the format they are uploaded in.
        """
        return pulumi.get(self, "image_contents")

    @image_contents.setter
    def image_contents(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_contents", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of your floor plan.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="topLeftCorner")
    def top_left_corner(self) -> Optional[pulumi.Input['FloorPlansTopLeftCornerArgs']]:
        """
        The longitude and latitude of the top left corner of your floor plan.
        """
        return pulumi.get(self, "top_left_corner")

    @top_left_corner.setter
    def top_left_corner(self, value: Optional[pulumi.Input['FloorPlansTopLeftCornerArgs']]):
        pulumi.set(self, "top_left_corner", value)

    @property
    @pulumi.getter(name="topRightCorner")
    def top_right_corner(self) -> Optional[pulumi.Input['FloorPlansTopRightCornerArgs']]:
        """
        The longitude and latitude of the top right corner of your floor plan.
        """
        return pulumi.get(self, "top_right_corner")

    @top_right_corner.setter
    def top_right_corner(self, value: Optional[pulumi.Input['FloorPlansTopRightCornerArgs']]):
        pulumi.set(self, "top_right_corner", value)


@pulumi.input_type
class _FloorPlansState:
    def __init__(__self__, *,
                 bottom_left_corner: Optional[pulumi.Input['FloorPlansBottomLeftCornerArgs']] = None,
                 bottom_right_corner: Optional[pulumi.Input['FloorPlansBottomRightCornerArgs']] = None,
                 center: Optional[pulumi.Input['FloorPlansCenterArgs']] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input['FloorPlansDeviceArgs']]]] = None,
                 floor_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 height: Optional[pulumi.Input[builtins.float]] = None,
                 image_contents: Optional[pulumi.Input[builtins.str]] = None,
                 image_extension: Optional[pulumi.Input[builtins.str]] = None,
                 image_md5: Optional[pulumi.Input[builtins.str]] = None,
                 image_url: Optional[pulumi.Input[builtins.str]] = None,
                 image_url_expires_at: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 top_left_corner: Optional[pulumi.Input['FloorPlansTopLeftCornerArgs']] = None,
                 top_right_corner: Optional[pulumi.Input['FloorPlansTopRightCornerArgs']] = None,
                 width: Optional[pulumi.Input[builtins.float]] = None):
        """
        Input properties used for looking up and filtering FloorPlans resources.
        :param pulumi.Input['FloorPlansBottomLeftCornerArgs'] bottom_left_corner: The longitude and latitude of the bottom left corner of your floor plan.
        :param pulumi.Input['FloorPlansBottomRightCornerArgs'] bottom_right_corner: The longitude and latitude of the bottom right corner of your floor plan.
        :param pulumi.Input['FloorPlansCenterArgs'] center: The longitude and latitude of the center of your floor plan. The 'center' or two adjacent corners (e.g. 'topLeftCorner' and 'bottomLeftCorner') must be specified. If 'center' is specified, the floor plan is placed over that point with no rotation. If two adjacent corners are specified, the floor plan is rotated to line up with the two specified points. The aspect ratio of the floor plan's image is preserved regardless of which corners/center are specified. (This means if that more than two corners are specified, only two corners may be used to preserve the floor plan's aspect ratio.). No two points can have the same latitude, longitude pair.
        :param pulumi.Input[Sequence[pulumi.Input['FloorPlansDeviceArgs']]] devices: List of devices for the floorplan
        :param pulumi.Input[builtins.str] floor_plan_id: Floor plan ID
        :param pulumi.Input[builtins.float] height: The height of your floor plan.
        :param pulumi.Input[builtins.str] image_contents: The file contents (a base 64 encoded string) of your image. Supported formats are PNG, GIF, and JPG. Note that all images are saved as PNG files, regardless of the format they are uploaded in.
        :param pulumi.Input[builtins.str] image_extension: The format type of the image.
        :param pulumi.Input[builtins.str] image_md5: The file contents (a base 64 encoded string) of your new image. Supported formats are PNG, GIF, and JPG. Note that all images are saved as PNG files, regardless of the format they are uploaded in. If you upload a new image, and you do NOT specify any new geolocation fields ('center, 'topLeftCorner', etc), the floor plan will be recentered with no rotation in order to maintain the aspect ratio of your new image.
        :param pulumi.Input[builtins.str] image_url: The url link for the floor plan image.
        :param pulumi.Input[builtins.str] image_url_expires_at: The time the image url link will expire.
        :param pulumi.Input[builtins.str] name: The name of your floor plan.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['FloorPlansTopLeftCornerArgs'] top_left_corner: The longitude and latitude of the top left corner of your floor plan.
        :param pulumi.Input['FloorPlansTopRightCornerArgs'] top_right_corner: The longitude and latitude of the top right corner of your floor plan.
        :param pulumi.Input[builtins.float] width: The width of your floor plan.
        """
        if bottom_left_corner is not None:
            pulumi.set(__self__, "bottom_left_corner", bottom_left_corner)
        if bottom_right_corner is not None:
            pulumi.set(__self__, "bottom_right_corner", bottom_right_corner)
        if center is not None:
            pulumi.set(__self__, "center", center)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if floor_plan_id is not None:
            pulumi.set(__self__, "floor_plan_id", floor_plan_id)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if image_contents is not None:
            pulumi.set(__self__, "image_contents", image_contents)
        if image_extension is not None:
            pulumi.set(__self__, "image_extension", image_extension)
        if image_md5 is not None:
            pulumi.set(__self__, "image_md5", image_md5)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if image_url_expires_at is not None:
            pulumi.set(__self__, "image_url_expires_at", image_url_expires_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if top_left_corner is not None:
            pulumi.set(__self__, "top_left_corner", top_left_corner)
        if top_right_corner is not None:
            pulumi.set(__self__, "top_right_corner", top_right_corner)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter(name="bottomLeftCorner")
    def bottom_left_corner(self) -> Optional[pulumi.Input['FloorPlansBottomLeftCornerArgs']]:
        """
        The longitude and latitude of the bottom left corner of your floor plan.
        """
        return pulumi.get(self, "bottom_left_corner")

    @bottom_left_corner.setter
    def bottom_left_corner(self, value: Optional[pulumi.Input['FloorPlansBottomLeftCornerArgs']]):
        pulumi.set(self, "bottom_left_corner", value)

    @property
    @pulumi.getter(name="bottomRightCorner")
    def bottom_right_corner(self) -> Optional[pulumi.Input['FloorPlansBottomRightCornerArgs']]:
        """
        The longitude and latitude of the bottom right corner of your floor plan.
        """
        return pulumi.get(self, "bottom_right_corner")

    @bottom_right_corner.setter
    def bottom_right_corner(self, value: Optional[pulumi.Input['FloorPlansBottomRightCornerArgs']]):
        pulumi.set(self, "bottom_right_corner", value)

    @property
    @pulumi.getter
    def center(self) -> Optional[pulumi.Input['FloorPlansCenterArgs']]:
        """
        The longitude and latitude of the center of your floor plan. The 'center' or two adjacent corners (e.g. 'topLeftCorner' and 'bottomLeftCorner') must be specified. If 'center' is specified, the floor plan is placed over that point with no rotation. If two adjacent corners are specified, the floor plan is rotated to line up with the two specified points. The aspect ratio of the floor plan's image is preserved regardless of which corners/center are specified. (This means if that more than two corners are specified, only two corners may be used to preserve the floor plan's aspect ratio.). No two points can have the same latitude, longitude pair.
        """
        return pulumi.get(self, "center")

    @center.setter
    def center(self, value: Optional[pulumi.Input['FloorPlansCenterArgs']]):
        pulumi.set(self, "center", value)

    @property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FloorPlansDeviceArgs']]]]:
        """
        List of devices for the floorplan
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FloorPlansDeviceArgs']]]]):
        pulumi.set(self, "devices", value)

    @property
    @pulumi.getter(name="floorPlanId")
    def floor_plan_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Floor plan ID
        """
        return pulumi.get(self, "floor_plan_id")

    @floor_plan_id.setter
    def floor_plan_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "floor_plan_id", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The height of your floor plan.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter(name="imageContents")
    def image_contents(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The file contents (a base 64 encoded string) of your image. Supported formats are PNG, GIF, and JPG. Note that all images are saved as PNG files, regardless of the format they are uploaded in.
        """
        return pulumi.get(self, "image_contents")

    @image_contents.setter
    def image_contents(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_contents", value)

    @property
    @pulumi.getter(name="imageExtension")
    def image_extension(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The format type of the image.
        """
        return pulumi.get(self, "image_extension")

    @image_extension.setter
    def image_extension(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_extension", value)

    @property
    @pulumi.getter(name="imageMd5")
    def image_md5(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The file contents (a base 64 encoded string) of your new image. Supported formats are PNG, GIF, and JPG. Note that all images are saved as PNG files, regardless of the format they are uploaded in. If you upload a new image, and you do NOT specify any new geolocation fields ('center, 'topLeftCorner', etc), the floor plan will be recentered with no rotation in order to maintain the aspect ratio of your new image.
        """
        return pulumi.get(self, "image_md5")

    @image_md5.setter
    def image_md5(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_md5", value)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The url link for the floor plan image.
        """
        return pulumi.get(self, "image_url")

    @image_url.setter
    def image_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_url", value)

    @property
    @pulumi.getter(name="imageUrlExpiresAt")
    def image_url_expires_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the image url link will expire.
        """
        return pulumi.get(self, "image_url_expires_at")

    @image_url_expires_at.setter
    def image_url_expires_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_url_expires_at", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of your floor plan.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="topLeftCorner")
    def top_left_corner(self) -> Optional[pulumi.Input['FloorPlansTopLeftCornerArgs']]:
        """
        The longitude and latitude of the top left corner of your floor plan.
        """
        return pulumi.get(self, "top_left_corner")

    @top_left_corner.setter
    def top_left_corner(self, value: Optional[pulumi.Input['FloorPlansTopLeftCornerArgs']]):
        pulumi.set(self, "top_left_corner", value)

    @property
    @pulumi.getter(name="topRightCorner")
    def top_right_corner(self) -> Optional[pulumi.Input['FloorPlansTopRightCornerArgs']]:
        """
        The longitude and latitude of the top right corner of your floor plan.
        """
        return pulumi.get(self, "top_right_corner")

    @top_right_corner.setter
    def top_right_corner(self, value: Optional[pulumi.Input['FloorPlansTopRightCornerArgs']]):
        pulumi.set(self, "top_right_corner", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The width of your floor plan.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "width", value)


@pulumi.type_token("meraki:networks/floorPlans:FloorPlans")
class FloorPlans(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bottom_left_corner: Optional[pulumi.Input[Union['FloorPlansBottomLeftCornerArgs', 'FloorPlansBottomLeftCornerArgsDict']]] = None,
                 bottom_right_corner: Optional[pulumi.Input[Union['FloorPlansBottomRightCornerArgs', 'FloorPlansBottomRightCornerArgsDict']]] = None,
                 center: Optional[pulumi.Input[Union['FloorPlansCenterArgs', 'FloorPlansCenterArgsDict']]] = None,
                 floor_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 image_contents: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 top_left_corner: Optional[pulumi.Input[Union['FloorPlansTopLeftCornerArgs', 'FloorPlansTopLeftCornerArgsDict']]] = None,
                 top_right_corner: Optional[pulumi.Input[Union['FloorPlansTopRightCornerArgs', 'FloorPlansTopRightCornerArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.FloorPlans("example",
            bottom_left_corner={
                "lat": 37.770040510499996,
                "lng": -122.38714009525,
            },
            bottom_right_corner={
                "lat": 37.770040510499996,
                "lng": -122.38714009525,
            },
            center={
                "lat": 37.770040510499996,
                "lng": -122.38714009525,
            },
            image_contents="2a9edd3f4ffd80130c647d13eacb59f3",
            name="HQ Floor Plan",
            network_id="string",
            top_left_corner={
                "lat": 37.770040510499996,
                "lng": -122.38714009525,
            },
            top_right_corner={
                "lat": 37.770040510499996,
                "lng": -122.38714009525,
            })
        pulumi.export("merakiNetworksFloorPlansExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/floorPlans:FloorPlans example "floor_plan_id,network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FloorPlansBottomLeftCornerArgs', 'FloorPlansBottomLeftCornerArgsDict']] bottom_left_corner: The longitude and latitude of the bottom left corner of your floor plan.
        :param pulumi.Input[Union['FloorPlansBottomRightCornerArgs', 'FloorPlansBottomRightCornerArgsDict']] bottom_right_corner: The longitude and latitude of the bottom right corner of your floor plan.
        :param pulumi.Input[Union['FloorPlansCenterArgs', 'FloorPlansCenterArgsDict']] center: The longitude and latitude of the center of your floor plan. The 'center' or two adjacent corners (e.g. 'topLeftCorner' and 'bottomLeftCorner') must be specified. If 'center' is specified, the floor plan is placed over that point with no rotation. If two adjacent corners are specified, the floor plan is rotated to line up with the two specified points. The aspect ratio of the floor plan's image is preserved regardless of which corners/center are specified. (This means if that more than two corners are specified, only two corners may be used to preserve the floor plan's aspect ratio.). No two points can have the same latitude, longitude pair.
        :param pulumi.Input[builtins.str] floor_plan_id: Floor plan ID
        :param pulumi.Input[builtins.str] image_contents: The file contents (a base 64 encoded string) of your image. Supported formats are PNG, GIF, and JPG. Note that all images are saved as PNG files, regardless of the format they are uploaded in.
        :param pulumi.Input[builtins.str] name: The name of your floor plan.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['FloorPlansTopLeftCornerArgs', 'FloorPlansTopLeftCornerArgsDict']] top_left_corner: The longitude and latitude of the top left corner of your floor plan.
        :param pulumi.Input[Union['FloorPlansTopRightCornerArgs', 'FloorPlansTopRightCornerArgsDict']] top_right_corner: The longitude and latitude of the top right corner of your floor plan.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FloorPlansArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.FloorPlans("example",
            bottom_left_corner={
                "lat": 37.770040510499996,
                "lng": -122.38714009525,
            },
            bottom_right_corner={
                "lat": 37.770040510499996,
                "lng": -122.38714009525,
            },
            center={
                "lat": 37.770040510499996,
                "lng": -122.38714009525,
            },
            image_contents="2a9edd3f4ffd80130c647d13eacb59f3",
            name="HQ Floor Plan",
            network_id="string",
            top_left_corner={
                "lat": 37.770040510499996,
                "lng": -122.38714009525,
            },
            top_right_corner={
                "lat": 37.770040510499996,
                "lng": -122.38714009525,
            })
        pulumi.export("merakiNetworksFloorPlansExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/floorPlans:FloorPlans example "floor_plan_id,network_id"
        ```

        :param str resource_name: The name of the resource.
        :param FloorPlansArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FloorPlansArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bottom_left_corner: Optional[pulumi.Input[Union['FloorPlansBottomLeftCornerArgs', 'FloorPlansBottomLeftCornerArgsDict']]] = None,
                 bottom_right_corner: Optional[pulumi.Input[Union['FloorPlansBottomRightCornerArgs', 'FloorPlansBottomRightCornerArgsDict']]] = None,
                 center: Optional[pulumi.Input[Union['FloorPlansCenterArgs', 'FloorPlansCenterArgsDict']]] = None,
                 floor_plan_id: Optional[pulumi.Input[builtins.str]] = None,
                 image_contents: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 top_left_corner: Optional[pulumi.Input[Union['FloorPlansTopLeftCornerArgs', 'FloorPlansTopLeftCornerArgsDict']]] = None,
                 top_right_corner: Optional[pulumi.Input[Union['FloorPlansTopRightCornerArgs', 'FloorPlansTopRightCornerArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FloorPlansArgs.__new__(FloorPlansArgs)

            __props__.__dict__["bottom_left_corner"] = bottom_left_corner
            __props__.__dict__["bottom_right_corner"] = bottom_right_corner
            __props__.__dict__["center"] = center
            __props__.__dict__["floor_plan_id"] = floor_plan_id
            __props__.__dict__["image_contents"] = image_contents
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["top_left_corner"] = top_left_corner
            __props__.__dict__["top_right_corner"] = top_right_corner
            __props__.__dict__["devices"] = None
            __props__.__dict__["height"] = None
            __props__.__dict__["image_extension"] = None
            __props__.__dict__["image_md5"] = None
            __props__.__dict__["image_url"] = None
            __props__.__dict__["image_url_expires_at"] = None
            __props__.__dict__["width"] = None
        super(FloorPlans, __self__).__init__(
            'meraki:networks/floorPlans:FloorPlans',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bottom_left_corner: Optional[pulumi.Input[Union['FloorPlansBottomLeftCornerArgs', 'FloorPlansBottomLeftCornerArgsDict']]] = None,
            bottom_right_corner: Optional[pulumi.Input[Union['FloorPlansBottomRightCornerArgs', 'FloorPlansBottomRightCornerArgsDict']]] = None,
            center: Optional[pulumi.Input[Union['FloorPlansCenterArgs', 'FloorPlansCenterArgsDict']]] = None,
            devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FloorPlansDeviceArgs', 'FloorPlansDeviceArgsDict']]]]] = None,
            floor_plan_id: Optional[pulumi.Input[builtins.str]] = None,
            height: Optional[pulumi.Input[builtins.float]] = None,
            image_contents: Optional[pulumi.Input[builtins.str]] = None,
            image_extension: Optional[pulumi.Input[builtins.str]] = None,
            image_md5: Optional[pulumi.Input[builtins.str]] = None,
            image_url: Optional[pulumi.Input[builtins.str]] = None,
            image_url_expires_at: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            top_left_corner: Optional[pulumi.Input[Union['FloorPlansTopLeftCornerArgs', 'FloorPlansTopLeftCornerArgsDict']]] = None,
            top_right_corner: Optional[pulumi.Input[Union['FloorPlansTopRightCornerArgs', 'FloorPlansTopRightCornerArgsDict']]] = None,
            width: Optional[pulumi.Input[builtins.float]] = None) -> 'FloorPlans':
        """
        Get an existing FloorPlans resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FloorPlansBottomLeftCornerArgs', 'FloorPlansBottomLeftCornerArgsDict']] bottom_left_corner: The longitude and latitude of the bottom left corner of your floor plan.
        :param pulumi.Input[Union['FloorPlansBottomRightCornerArgs', 'FloorPlansBottomRightCornerArgsDict']] bottom_right_corner: The longitude and latitude of the bottom right corner of your floor plan.
        :param pulumi.Input[Union['FloorPlansCenterArgs', 'FloorPlansCenterArgsDict']] center: The longitude and latitude of the center of your floor plan. The 'center' or two adjacent corners (e.g. 'topLeftCorner' and 'bottomLeftCorner') must be specified. If 'center' is specified, the floor plan is placed over that point with no rotation. If two adjacent corners are specified, the floor plan is rotated to line up with the two specified points. The aspect ratio of the floor plan's image is preserved regardless of which corners/center are specified. (This means if that more than two corners are specified, only two corners may be used to preserve the floor plan's aspect ratio.). No two points can have the same latitude, longitude pair.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FloorPlansDeviceArgs', 'FloorPlansDeviceArgsDict']]]] devices: List of devices for the floorplan
        :param pulumi.Input[builtins.str] floor_plan_id: Floor plan ID
        :param pulumi.Input[builtins.float] height: The height of your floor plan.
        :param pulumi.Input[builtins.str] image_contents: The file contents (a base 64 encoded string) of your image. Supported formats are PNG, GIF, and JPG. Note that all images are saved as PNG files, regardless of the format they are uploaded in.
        :param pulumi.Input[builtins.str] image_extension: The format type of the image.
        :param pulumi.Input[builtins.str] image_md5: The file contents (a base 64 encoded string) of your new image. Supported formats are PNG, GIF, and JPG. Note that all images are saved as PNG files, regardless of the format they are uploaded in. If you upload a new image, and you do NOT specify any new geolocation fields ('center, 'topLeftCorner', etc), the floor plan will be recentered with no rotation in order to maintain the aspect ratio of your new image.
        :param pulumi.Input[builtins.str] image_url: The url link for the floor plan image.
        :param pulumi.Input[builtins.str] image_url_expires_at: The time the image url link will expire.
        :param pulumi.Input[builtins.str] name: The name of your floor plan.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['FloorPlansTopLeftCornerArgs', 'FloorPlansTopLeftCornerArgsDict']] top_left_corner: The longitude and latitude of the top left corner of your floor plan.
        :param pulumi.Input[Union['FloorPlansTopRightCornerArgs', 'FloorPlansTopRightCornerArgsDict']] top_right_corner: The longitude and latitude of the top right corner of your floor plan.
        :param pulumi.Input[builtins.float] width: The width of your floor plan.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FloorPlansState.__new__(_FloorPlansState)

        __props__.__dict__["bottom_left_corner"] = bottom_left_corner
        __props__.__dict__["bottom_right_corner"] = bottom_right_corner
        __props__.__dict__["center"] = center
        __props__.__dict__["devices"] = devices
        __props__.__dict__["floor_plan_id"] = floor_plan_id
        __props__.__dict__["height"] = height
        __props__.__dict__["image_contents"] = image_contents
        __props__.__dict__["image_extension"] = image_extension
        __props__.__dict__["image_md5"] = image_md5
        __props__.__dict__["image_url"] = image_url
        __props__.__dict__["image_url_expires_at"] = image_url_expires_at
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["top_left_corner"] = top_left_corner
        __props__.__dict__["top_right_corner"] = top_right_corner
        __props__.__dict__["width"] = width
        return FloorPlans(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bottomLeftCorner")
    def bottom_left_corner(self) -> pulumi.Output['outputs.FloorPlansBottomLeftCorner']:
        """
        The longitude and latitude of the bottom left corner of your floor plan.
        """
        return pulumi.get(self, "bottom_left_corner")

    @property
    @pulumi.getter(name="bottomRightCorner")
    def bottom_right_corner(self) -> pulumi.Output['outputs.FloorPlansBottomRightCorner']:
        """
        The longitude and latitude of the bottom right corner of your floor plan.
        """
        return pulumi.get(self, "bottom_right_corner")

    @property
    @pulumi.getter
    def center(self) -> pulumi.Output['outputs.FloorPlansCenter']:
        """
        The longitude and latitude of the center of your floor plan. The 'center' or two adjacent corners (e.g. 'topLeftCorner' and 'bottomLeftCorner') must be specified. If 'center' is specified, the floor plan is placed over that point with no rotation. If two adjacent corners are specified, the floor plan is rotated to line up with the two specified points. The aspect ratio of the floor plan's image is preserved regardless of which corners/center are specified. (This means if that more than two corners are specified, only two corners may be used to preserve the floor plan's aspect ratio.). No two points can have the same latitude, longitude pair.
        """
        return pulumi.get(self, "center")

    @property
    @pulumi.getter
    def devices(self) -> pulumi.Output[Sequence['outputs.FloorPlansDevice']]:
        """
        List of devices for the floorplan
        """
        return pulumi.get(self, "devices")

    @property
    @pulumi.getter(name="floorPlanId")
    def floor_plan_id(self) -> pulumi.Output[builtins.str]:
        """
        Floor plan ID
        """
        return pulumi.get(self, "floor_plan_id")

    @property
    @pulumi.getter
    def height(self) -> pulumi.Output[builtins.float]:
        """
        The height of your floor plan.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter(name="imageContents")
    def image_contents(self) -> pulumi.Output[builtins.str]:
        """
        The file contents (a base 64 encoded string) of your image. Supported formats are PNG, GIF, and JPG. Note that all images are saved as PNG files, regardless of the format they are uploaded in.
        """
        return pulumi.get(self, "image_contents")

    @property
    @pulumi.getter(name="imageExtension")
    def image_extension(self) -> pulumi.Output[builtins.str]:
        """
        The format type of the image.
        """
        return pulumi.get(self, "image_extension")

    @property
    @pulumi.getter(name="imageMd5")
    def image_md5(self) -> pulumi.Output[builtins.str]:
        """
        The file contents (a base 64 encoded string) of your new image. Supported formats are PNG, GIF, and JPG. Note that all images are saved as PNG files, regardless of the format they are uploaded in. If you upload a new image, and you do NOT specify any new geolocation fields ('center, 'topLeftCorner', etc), the floor plan will be recentered with no rotation in order to maintain the aspect ratio of your new image.
        """
        return pulumi.get(self, "image_md5")

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> pulumi.Output[builtins.str]:
        """
        The url link for the floor plan image.
        """
        return pulumi.get(self, "image_url")

    @property
    @pulumi.getter(name="imageUrlExpiresAt")
    def image_url_expires_at(self) -> pulumi.Output[builtins.str]:
        """
        The time the image url link will expire.
        """
        return pulumi.get(self, "image_url_expires_at")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of your floor plan.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="topLeftCorner")
    def top_left_corner(self) -> pulumi.Output['outputs.FloorPlansTopLeftCorner']:
        """
        The longitude and latitude of the top left corner of your floor plan.
        """
        return pulumi.get(self, "top_left_corner")

    @property
    @pulumi.getter(name="topRightCorner")
    def top_right_corner(self) -> pulumi.Output['outputs.FloorPlansTopRightCorner']:
        """
        The longitude and latitude of the top right corner of your floor plan.
        """
        return pulumi.get(self, "top_right_corner")

    @property
    @pulumi.getter
    def width(self) -> pulumi.Output[builtins.float]:
        """
        The width of your floor plan.
        """
        return pulumi.get(self, "width")

