# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPiiSmDevicesForKeyResult',
    'AwaitableGetPiiSmDevicesForKeyResult',
    'get_pii_sm_devices_for_key',
    'get_pii_sm_devices_for_key_output',
]

@pulumi.output_type
class GetPiiSmDevicesForKeyResult:
    """
    A collection of values returned by getPiiSmDevicesForKey.
    """
    def __init__(__self__, bluetooth_mac=None, email=None, id=None, imei=None, item=None, mac=None, network_id=None, serial=None, username=None):
        if bluetooth_mac and not isinstance(bluetooth_mac, str):
            raise TypeError("Expected argument 'bluetooth_mac' to be a str")
        pulumi.set(__self__, "bluetooth_mac", bluetooth_mac)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if imei and not isinstance(imei, str):
            raise TypeError("Expected argument 'imei' to be a str")
        pulumi.set(__self__, "imei", imei)
        if item and not isinstance(item, dict):
            raise TypeError("Expected argument 'item' to be a dict")
        pulumi.set(__self__, "item", item)
        if mac and not isinstance(mac, str):
            raise TypeError("Expected argument 'mac' to be a str")
        pulumi.set(__self__, "mac", mac)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if serial and not isinstance(serial, str):
            raise TypeError("Expected argument 'serial' to be a str")
        pulumi.set(__self__, "serial", serial)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="bluetoothMac")
    def bluetooth_mac(self) -> Optional[builtins.str]:
        """
        bluetoothMac query parameter. The MAC of a Bluetooth client
        """
        return pulumi.get(self, "bluetooth_mac")

    @property
    @pulumi.getter
    def email(self) -> Optional[builtins.str]:
        """
        email query parameter. The email of a network user account or a Systems Manager device
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def imei(self) -> Optional[builtins.str]:
        """
        imei query parameter. The IMEI of a Systems Manager device
        """
        return pulumi.get(self, "imei")

    @property
    @pulumi.getter
    def item(self) -> 'outputs.GetPiiSmDevicesForKeyItemResult':
        return pulumi.get(self, "item")

    @property
    @pulumi.getter
    def mac(self) -> Optional[builtins.str]:
        """
        mac query parameter. The MAC of a network client device or a Systems Manager device
        """
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> builtins.str:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def serial(self) -> Optional[builtins.str]:
        """
        serial query parameter. The serial of a Systems Manager device
        """
        return pulumi.get(self, "serial")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        username query parameter. The username of a Systems Manager user
        """
        return pulumi.get(self, "username")


class AwaitableGetPiiSmDevicesForKeyResult(GetPiiSmDevicesForKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPiiSmDevicesForKeyResult(
            bluetooth_mac=self.bluetooth_mac,
            email=self.email,
            id=self.id,
            imei=self.imei,
            item=self.item,
            mac=self.mac,
            network_id=self.network_id,
            serial=self.serial,
            username=self.username)


def get_pii_sm_devices_for_key(bluetooth_mac: Optional[builtins.str] = None,
                               email: Optional[builtins.str] = None,
                               imei: Optional[builtins.str] = None,
                               mac: Optional[builtins.str] = None,
                               network_id: Optional[builtins.str] = None,
                               serial: Optional[builtins.str] = None,
                               username: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPiiSmDevicesForKeyResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.networks.get_pii_sm_devices_for_key(bluetooth_mac="string",
        email="string",
        imei="string",
        mac="string",
        network_id="string",
        serial="string",
        username="string")
    pulumi.export("merakiNetworksPiiSmDevicesForKeyExample", example.item)
    ```


    :param builtins.str bluetooth_mac: bluetoothMac query parameter. The MAC of a Bluetooth client
    :param builtins.str email: email query parameter. The email of a network user account or a Systems Manager device
    :param builtins.str imei: imei query parameter. The IMEI of a Systems Manager device
    :param builtins.str mac: mac query parameter. The MAC of a network client device or a Systems Manager device
    :param builtins.str network_id: networkId path parameter. Network ID
    :param builtins.str serial: serial query parameter. The serial of a Systems Manager device
    :param builtins.str username: username query parameter. The username of a Systems Manager user
    """
    __args__ = dict()
    __args__['bluetoothMac'] = bluetooth_mac
    __args__['email'] = email
    __args__['imei'] = imei
    __args__['mac'] = mac
    __args__['networkId'] = network_id
    __args__['serial'] = serial
    __args__['username'] = username
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('meraki:networks/getPiiSmDevicesForKey:getPiiSmDevicesForKey', __args__, opts=opts, typ=GetPiiSmDevicesForKeyResult).value

    return AwaitableGetPiiSmDevicesForKeyResult(
        bluetooth_mac=pulumi.get(__ret__, 'bluetooth_mac'),
        email=pulumi.get(__ret__, 'email'),
        id=pulumi.get(__ret__, 'id'),
        imei=pulumi.get(__ret__, 'imei'),
        item=pulumi.get(__ret__, 'item'),
        mac=pulumi.get(__ret__, 'mac'),
        network_id=pulumi.get(__ret__, 'network_id'),
        serial=pulumi.get(__ret__, 'serial'),
        username=pulumi.get(__ret__, 'username'))
def get_pii_sm_devices_for_key_output(bluetooth_mac: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      email: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      imei: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      mac: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      network_id: Optional[pulumi.Input[builtins.str]] = None,
                                      serial: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      username: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPiiSmDevicesForKeyResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.networks.get_pii_sm_devices_for_key(bluetooth_mac="string",
        email="string",
        imei="string",
        mac="string",
        network_id="string",
        serial="string",
        username="string")
    pulumi.export("merakiNetworksPiiSmDevicesForKeyExample", example.item)
    ```


    :param builtins.str bluetooth_mac: bluetoothMac query parameter. The MAC of a Bluetooth client
    :param builtins.str email: email query parameter. The email of a network user account or a Systems Manager device
    :param builtins.str imei: imei query parameter. The IMEI of a Systems Manager device
    :param builtins.str mac: mac query parameter. The MAC of a network client device or a Systems Manager device
    :param builtins.str network_id: networkId path parameter. Network ID
    :param builtins.str serial: serial query parameter. The serial of a Systems Manager device
    :param builtins.str username: username query parameter. The username of a Systems Manager user
    """
    __args__ = dict()
    __args__['bluetoothMac'] = bluetooth_mac
    __args__['email'] = email
    __args__['imei'] = imei
    __args__['mac'] = mac
    __args__['networkId'] = network_id
    __args__['serial'] = serial
    __args__['username'] = username
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('meraki:networks/getPiiSmDevicesForKey:getPiiSmDevicesForKey', __args__, opts=opts, typ=GetPiiSmDevicesForKeyResult)
    return __ret__.apply(lambda __response__: GetPiiSmDevicesForKeyResult(
        bluetooth_mac=pulumi.get(__response__, 'bluetooth_mac'),
        email=pulumi.get(__response__, 'email'),
        id=pulumi.get(__response__, 'id'),
        imei=pulumi.get(__response__, 'imei'),
        item=pulumi.get(__response__, 'item'),
        mac=pulumi.get(__response__, 'mac'),
        network_id=pulumi.get(__response__, 'network_id'),
        serial=pulumi.get(__response__, 'serial'),
        username=pulumi.get(__response__, 'username')))
