# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSensorAlertsOverviewByMetricResult',
    'AwaitableGetSensorAlertsOverviewByMetricResult',
    'get_sensor_alerts_overview_by_metric',
    'get_sensor_alerts_overview_by_metric_output',
]

@pulumi.output_type
class GetSensorAlertsOverviewByMetricResult:
    """
    A collection of values returned by getSensorAlertsOverviewByMetric.
    """
    def __init__(__self__, id=None, interval=None, items=None, network_id=None, t0=None, t1=None, timespan=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if interval and not isinstance(interval, int):
            raise TypeError("Expected argument 'interval' to be a int")
        pulumi.set(__self__, "interval", interval)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if t0 and not isinstance(t0, str):
            raise TypeError("Expected argument 't0' to be a str")
        pulumi.set(__self__, "t0", t0)
        if t1 and not isinstance(t1, str):
            raise TypeError("Expected argument 't1' to be a str")
        pulumi.set(__self__, "t1", t1)
        if timespan and not isinstance(timespan, float):
            raise TypeError("Expected argument 'timespan' to be a float")
        pulumi.set(__self__, "timespan", timespan)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def interval(self) -> Optional[builtins.int]:
        """
        interval query parameter. The time interval in seconds for returned data. The valid intervals are: 86400, 604800. The default is 604800.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetSensorAlertsOverviewByMetricItemResult']:
        """
        Array of ResponseSensorGetNetworkSensorAlertsOverviewByMetric
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> builtins.str:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def t0(self) -> Optional[builtins.str]:
        """
        t0 query parameter. The beginning of the timespan for the data. The maximum lookback period is 365 days from today.
        """
        return pulumi.get(self, "t0")

    @property
    @pulumi.getter
    def t1(self) -> Optional[builtins.str]:
        """
        t1 query parameter. The end of the timespan for the data. t1 can be a maximum of 31 days after t0.
        """
        return pulumi.get(self, "t1")

    @property
    @pulumi.getter
    def timespan(self) -> Optional[builtins.float]:
        """
        timespan query parameter. The timespan for which the information will be fetched. If specifying timespan, do not specify parameters t0 and t1. The value must be in seconds and be less than or equal to 31 days. The default is 7 days.
        """
        return pulumi.get(self, "timespan")


class AwaitableGetSensorAlertsOverviewByMetricResult(GetSensorAlertsOverviewByMetricResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSensorAlertsOverviewByMetricResult(
            id=self.id,
            interval=self.interval,
            items=self.items,
            network_id=self.network_id,
            t0=self.t0,
            t1=self.t1,
            timespan=self.timespan)


def get_sensor_alerts_overview_by_metric(interval: Optional[builtins.int] = None,
                                         network_id: Optional[builtins.str] = None,
                                         t0: Optional[builtins.str] = None,
                                         t1: Optional[builtins.str] = None,
                                         timespan: Optional[builtins.float] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSensorAlertsOverviewByMetricResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.networks.get_sensor_alerts_overview_by_metric(interval=1,
        network_id="string",
        t0="string",
        t1="string",
        timespan=1)
    pulumi.export("merakiNetworksSensorAlertsOverviewByMetricExample", example.items)
    ```


    :param builtins.int interval: interval query parameter. The time interval in seconds for returned data. The valid intervals are: 86400, 604800. The default is 604800.
    :param builtins.str network_id: networkId path parameter. Network ID
    :param builtins.str t0: t0 query parameter. The beginning of the timespan for the data. The maximum lookback period is 365 days from today.
    :param builtins.str t1: t1 query parameter. The end of the timespan for the data. t1 can be a maximum of 31 days after t0.
    :param builtins.float timespan: timespan query parameter. The timespan for which the information will be fetched. If specifying timespan, do not specify parameters t0 and t1. The value must be in seconds and be less than or equal to 31 days. The default is 7 days.
    """
    __args__ = dict()
    __args__['interval'] = interval
    __args__['networkId'] = network_id
    __args__['t0'] = t0
    __args__['t1'] = t1
    __args__['timespan'] = timespan
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('meraki:networks/getSensorAlertsOverviewByMetric:getSensorAlertsOverviewByMetric', __args__, opts=opts, typ=GetSensorAlertsOverviewByMetricResult).value

    return AwaitableGetSensorAlertsOverviewByMetricResult(
        id=pulumi.get(__ret__, 'id'),
        interval=pulumi.get(__ret__, 'interval'),
        items=pulumi.get(__ret__, 'items'),
        network_id=pulumi.get(__ret__, 'network_id'),
        t0=pulumi.get(__ret__, 't0'),
        t1=pulumi.get(__ret__, 't1'),
        timespan=pulumi.get(__ret__, 'timespan'))
def get_sensor_alerts_overview_by_metric_output(interval: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                                network_id: Optional[pulumi.Input[builtins.str]] = None,
                                                t0: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                t1: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                timespan: Optional[pulumi.Input[Optional[builtins.float]]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSensorAlertsOverviewByMetricResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.networks.get_sensor_alerts_overview_by_metric(interval=1,
        network_id="string",
        t0="string",
        t1="string",
        timespan=1)
    pulumi.export("merakiNetworksSensorAlertsOverviewByMetricExample", example.items)
    ```


    :param builtins.int interval: interval query parameter. The time interval in seconds for returned data. The valid intervals are: 86400, 604800. The default is 604800.
    :param builtins.str network_id: networkId path parameter. Network ID
    :param builtins.str t0: t0 query parameter. The beginning of the timespan for the data. The maximum lookback period is 365 days from today.
    :param builtins.str t1: t1 query parameter. The end of the timespan for the data. t1 can be a maximum of 31 days after t0.
    :param builtins.float timespan: timespan query parameter. The timespan for which the information will be fetched. If specifying timespan, do not specify parameters t0 and t1. The value must be in seconds and be less than or equal to 31 days. The default is 7 days.
    """
    __args__ = dict()
    __args__['interval'] = interval
    __args__['networkId'] = network_id
    __args__['t0'] = t0
    __args__['t1'] = t1
    __args__['timespan'] = timespan
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('meraki:networks/getSensorAlertsOverviewByMetric:getSensorAlertsOverviewByMetric', __args__, opts=opts, typ=GetSensorAlertsOverviewByMetricResult)
    return __ret__.apply(lambda __response__: GetSensorAlertsOverviewByMetricResult(
        id=pulumi.get(__response__, 'id'),
        interval=pulumi.get(__response__, 'interval'),
        items=pulumi.get(__response__, 'items'),
        network_id=pulumi.get(__response__, 'network_id'),
        t0=pulumi.get(__response__, 't0'),
        t1=pulumi.get(__response__, 't1'),
        timespan=pulumi.get(__response__, 'timespan')))
