# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SwitchDhcpServerPolicyArgs', 'SwitchDhcpServerPolicy']

@pulumi.input_type
class SwitchDhcpServerPolicyArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 alerts: Optional[pulumi.Input['SwitchDhcpServerPolicyAlertsArgs']] = None,
                 allowed_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 arp_inspection: Optional[pulumi.Input['SwitchDhcpServerPolicyArpInspectionArgs']] = None,
                 blocked_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_policy: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SwitchDhcpServerPolicy resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['SwitchDhcpServerPolicyAlertsArgs'] alerts: Email alert settings for DHCP servers
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_servers: List the MAC addresses of DHCP servers to permit on the network when defaultPolicy is set
                 to block.An empty array will clear the entries.
        :param pulumi.Input['SwitchDhcpServerPolicyArpInspectionArgs'] arp_inspection: Dynamic ARP Inspection settings
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] blocked_servers: List the MAC addresses of DHCP servers to block on the network when defaultPolicy is set
                 to allow.An empty array will clear the entries.
        :param pulumi.Input[builtins.str] default_policy: 'allow' or 'block' new DHCP servers. Default value is 'allow'.
        """
        pulumi.set(__self__, "network_id", network_id)
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if allowed_servers is not None:
            pulumi.set(__self__, "allowed_servers", allowed_servers)
        if arp_inspection is not None:
            pulumi.set(__self__, "arp_inspection", arp_inspection)
        if blocked_servers is not None:
            pulumi.set(__self__, "blocked_servers", blocked_servers)
        if default_policy is not None:
            pulumi.set(__self__, "default_policy", default_policy)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def alerts(self) -> Optional[pulumi.Input['SwitchDhcpServerPolicyAlertsArgs']]:
        """
        Email alert settings for DHCP servers
        """
        return pulumi.get(self, "alerts")

    @alerts.setter
    def alerts(self, value: Optional[pulumi.Input['SwitchDhcpServerPolicyAlertsArgs']]):
        pulumi.set(self, "alerts", value)

    @property
    @pulumi.getter(name="allowedServers")
    def allowed_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List the MAC addresses of DHCP servers to permit on the network when defaultPolicy is set
          to block.An empty array will clear the entries.
        """
        return pulumi.get(self, "allowed_servers")

    @allowed_servers.setter
    def allowed_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_servers", value)

    @property
    @pulumi.getter(name="arpInspection")
    def arp_inspection(self) -> Optional[pulumi.Input['SwitchDhcpServerPolicyArpInspectionArgs']]:
        """
        Dynamic ARP Inspection settings
        """
        return pulumi.get(self, "arp_inspection")

    @arp_inspection.setter
    def arp_inspection(self, value: Optional[pulumi.Input['SwitchDhcpServerPolicyArpInspectionArgs']]):
        pulumi.set(self, "arp_inspection", value)

    @property
    @pulumi.getter(name="blockedServers")
    def blocked_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List the MAC addresses of DHCP servers to block on the network when defaultPolicy is set
          to allow.An empty array will clear the entries.
        """
        return pulumi.get(self, "blocked_servers")

    @blocked_servers.setter
    def blocked_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "blocked_servers", value)

    @property
    @pulumi.getter(name="defaultPolicy")
    def default_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        'allow' or 'block' new DHCP servers. Default value is 'allow'.
        """
        return pulumi.get(self, "default_policy")

    @default_policy.setter
    def default_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_policy", value)


@pulumi.input_type
class _SwitchDhcpServerPolicyState:
    def __init__(__self__, *,
                 alerts: Optional[pulumi.Input['SwitchDhcpServerPolicyAlertsArgs']] = None,
                 allowed_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 arp_inspection: Optional[pulumi.Input['SwitchDhcpServerPolicyArpInspectionArgs']] = None,
                 blocked_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_policy: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SwitchDhcpServerPolicy resources.
        :param pulumi.Input['SwitchDhcpServerPolicyAlertsArgs'] alerts: Email alert settings for DHCP servers
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_servers: List the MAC addresses of DHCP servers to permit on the network when defaultPolicy is set
                 to block.An empty array will clear the entries.
        :param pulumi.Input['SwitchDhcpServerPolicyArpInspectionArgs'] arp_inspection: Dynamic ARP Inspection settings
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] blocked_servers: List the MAC addresses of DHCP servers to block on the network when defaultPolicy is set
                 to allow.An empty array will clear the entries.
        :param pulumi.Input[builtins.str] default_policy: 'allow' or 'block' new DHCP servers. Default value is 'allow'.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        """
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if allowed_servers is not None:
            pulumi.set(__self__, "allowed_servers", allowed_servers)
        if arp_inspection is not None:
            pulumi.set(__self__, "arp_inspection", arp_inspection)
        if blocked_servers is not None:
            pulumi.set(__self__, "blocked_servers", blocked_servers)
        if default_policy is not None:
            pulumi.set(__self__, "default_policy", default_policy)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)

    @property
    @pulumi.getter
    def alerts(self) -> Optional[pulumi.Input['SwitchDhcpServerPolicyAlertsArgs']]:
        """
        Email alert settings for DHCP servers
        """
        return pulumi.get(self, "alerts")

    @alerts.setter
    def alerts(self, value: Optional[pulumi.Input['SwitchDhcpServerPolicyAlertsArgs']]):
        pulumi.set(self, "alerts", value)

    @property
    @pulumi.getter(name="allowedServers")
    def allowed_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List the MAC addresses of DHCP servers to permit on the network when defaultPolicy is set
          to block.An empty array will clear the entries.
        """
        return pulumi.get(self, "allowed_servers")

    @allowed_servers.setter
    def allowed_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_servers", value)

    @property
    @pulumi.getter(name="arpInspection")
    def arp_inspection(self) -> Optional[pulumi.Input['SwitchDhcpServerPolicyArpInspectionArgs']]:
        """
        Dynamic ARP Inspection settings
        """
        return pulumi.get(self, "arp_inspection")

    @arp_inspection.setter
    def arp_inspection(self, value: Optional[pulumi.Input['SwitchDhcpServerPolicyArpInspectionArgs']]):
        pulumi.set(self, "arp_inspection", value)

    @property
    @pulumi.getter(name="blockedServers")
    def blocked_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List the MAC addresses of DHCP servers to block on the network when defaultPolicy is set
          to allow.An empty array will clear the entries.
        """
        return pulumi.get(self, "blocked_servers")

    @blocked_servers.setter
    def blocked_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "blocked_servers", value)

    @property
    @pulumi.getter(name="defaultPolicy")
    def default_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        'allow' or 'block' new DHCP servers. Default value is 'allow'.
        """
        return pulumi.get(self, "default_policy")

    @default_policy.setter
    def default_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_policy", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)


@pulumi.type_token("meraki:networks/switchDhcpServerPolicy:SwitchDhcpServerPolicy")
class SwitchDhcpServerPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alerts: Optional[pulumi.Input[Union['SwitchDhcpServerPolicyAlertsArgs', 'SwitchDhcpServerPolicyAlertsArgsDict']]] = None,
                 allowed_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 arp_inspection: Optional[pulumi.Input[Union['SwitchDhcpServerPolicyArpInspectionArgs', 'SwitchDhcpServerPolicyArpInspectionArgsDict']]] = None,
                 blocked_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_policy: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.SwitchDhcpServerPolicy("example",
            alerts={
                "email": {
                    "enabled": True,
                },
            },
            allowed_servers=[
                "00:50:56:00:00:01",
                "00:50:56:00:00:02",
            ],
            arp_inspection={
                "enabled": True,
            },
            blocked_servers=[
                "00:50:56:00:00:03",
                "00:50:56:00:00:04",
            ],
            default_policy="block",
            network_id="string")
        pulumi.export("merakiNetworksSwitchDhcpServerPolicyExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchDhcpServerPolicy:SwitchDhcpServerPolicy example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SwitchDhcpServerPolicyAlertsArgs', 'SwitchDhcpServerPolicyAlertsArgsDict']] alerts: Email alert settings for DHCP servers
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_servers: List the MAC addresses of DHCP servers to permit on the network when defaultPolicy is set
                 to block.An empty array will clear the entries.
        :param pulumi.Input[Union['SwitchDhcpServerPolicyArpInspectionArgs', 'SwitchDhcpServerPolicyArpInspectionArgsDict']] arp_inspection: Dynamic ARP Inspection settings
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] blocked_servers: List the MAC addresses of DHCP servers to block on the network when defaultPolicy is set
                 to allow.An empty array will clear the entries.
        :param pulumi.Input[builtins.str] default_policy: 'allow' or 'block' new DHCP servers. Default value is 'allow'.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SwitchDhcpServerPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.SwitchDhcpServerPolicy("example",
            alerts={
                "email": {
                    "enabled": True,
                },
            },
            allowed_servers=[
                "00:50:56:00:00:01",
                "00:50:56:00:00:02",
            ],
            arp_inspection={
                "enabled": True,
            },
            blocked_servers=[
                "00:50:56:00:00:03",
                "00:50:56:00:00:04",
            ],
            default_policy="block",
            network_id="string")
        pulumi.export("merakiNetworksSwitchDhcpServerPolicyExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchDhcpServerPolicy:SwitchDhcpServerPolicy example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param SwitchDhcpServerPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwitchDhcpServerPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alerts: Optional[pulumi.Input[Union['SwitchDhcpServerPolicyAlertsArgs', 'SwitchDhcpServerPolicyAlertsArgsDict']]] = None,
                 allowed_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 arp_inspection: Optional[pulumi.Input[Union['SwitchDhcpServerPolicyArpInspectionArgs', 'SwitchDhcpServerPolicyArpInspectionArgsDict']]] = None,
                 blocked_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 default_policy: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwitchDhcpServerPolicyArgs.__new__(SwitchDhcpServerPolicyArgs)

            __props__.__dict__["alerts"] = alerts
            __props__.__dict__["allowed_servers"] = allowed_servers
            __props__.__dict__["arp_inspection"] = arp_inspection
            __props__.__dict__["blocked_servers"] = blocked_servers
            __props__.__dict__["default_policy"] = default_policy
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
        super(SwitchDhcpServerPolicy, __self__).__init__(
            'meraki:networks/switchDhcpServerPolicy:SwitchDhcpServerPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alerts: Optional[pulumi.Input[Union['SwitchDhcpServerPolicyAlertsArgs', 'SwitchDhcpServerPolicyAlertsArgsDict']]] = None,
            allowed_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            arp_inspection: Optional[pulumi.Input[Union['SwitchDhcpServerPolicyArpInspectionArgs', 'SwitchDhcpServerPolicyArpInspectionArgsDict']]] = None,
            blocked_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            default_policy: Optional[pulumi.Input[builtins.str]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None) -> 'SwitchDhcpServerPolicy':
        """
        Get an existing SwitchDhcpServerPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SwitchDhcpServerPolicyAlertsArgs', 'SwitchDhcpServerPolicyAlertsArgsDict']] alerts: Email alert settings for DHCP servers
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_servers: List the MAC addresses of DHCP servers to permit on the network when defaultPolicy is set
                 to block.An empty array will clear the entries.
        :param pulumi.Input[Union['SwitchDhcpServerPolicyArpInspectionArgs', 'SwitchDhcpServerPolicyArpInspectionArgsDict']] arp_inspection: Dynamic ARP Inspection settings
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] blocked_servers: List the MAC addresses of DHCP servers to block on the network when defaultPolicy is set
                 to allow.An empty array will clear the entries.
        :param pulumi.Input[builtins.str] default_policy: 'allow' or 'block' new DHCP servers. Default value is 'allow'.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwitchDhcpServerPolicyState.__new__(_SwitchDhcpServerPolicyState)

        __props__.__dict__["alerts"] = alerts
        __props__.__dict__["allowed_servers"] = allowed_servers
        __props__.__dict__["arp_inspection"] = arp_inspection
        __props__.__dict__["blocked_servers"] = blocked_servers
        __props__.__dict__["default_policy"] = default_policy
        __props__.__dict__["network_id"] = network_id
        return SwitchDhcpServerPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alerts(self) -> pulumi.Output['outputs.SwitchDhcpServerPolicyAlerts']:
        """
        Email alert settings for DHCP servers
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter(name="allowedServers")
    def allowed_servers(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List the MAC addresses of DHCP servers to permit on the network when defaultPolicy is set
          to block.An empty array will clear the entries.
        """
        return pulumi.get(self, "allowed_servers")

    @property
    @pulumi.getter(name="arpInspection")
    def arp_inspection(self) -> pulumi.Output['outputs.SwitchDhcpServerPolicyArpInspection']:
        """
        Dynamic ARP Inspection settings
        """
        return pulumi.get(self, "arp_inspection")

    @property
    @pulumi.getter(name="blockedServers")
    def blocked_servers(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List the MAC addresses of DHCP servers to block on the network when defaultPolicy is set
          to allow.An empty array will clear the entries.
        """
        return pulumi.get(self, "blocked_servers")

    @property
    @pulumi.getter(name="defaultPolicy")
    def default_policy(self) -> pulumi.Output[builtins.str]:
        """
        'allow' or 'block' new DHCP servers. Default value is 'allow'.
        """
        return pulumi.get(self, "default_policy")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

