# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SwitchStacksRoutingStaticRoutesArgs', 'SwitchStacksRoutingStaticRoutes']

@pulumi.input_type
class SwitchStacksRoutingStaticRoutesArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 switch_stack_id: pulumi.Input[builtins.str],
                 advertise_via_ospf_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_ip: Optional[pulumi.Input[builtins.str]] = None,
                 prefer_over_ospf_routes_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 static_route_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SwitchStacksRoutingStaticRoutes resource.
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] switch_stack_id: switchStackId path parameter. Switch stack ID
        :param pulumi.Input[builtins.bool] advertise_via_ospf_enabled: Option to advertise static routes via OSPF
        :param pulumi.Input[builtins.str] name: The name or description of the layer 3 static route
        :param pulumi.Input[builtins.str] next_hop_ip: The IP address of the router to which traffic for this destination network should be sent
        :param pulumi.Input[builtins.bool] prefer_over_ospf_routes_enabled: Option to prefer static routes over OSPF routes
        :param pulumi.Input[builtins.str] static_route_id: The identifier of a layer 3 static route
        :param pulumi.Input[builtins.str] subnet: The IP address of the subnetwork specified in CIDR notation (ex. 1.2.3.0/24)
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "switch_stack_id", switch_stack_id)
        if advertise_via_ospf_enabled is not None:
            pulumi.set(__self__, "advertise_via_ospf_enabled", advertise_via_ospf_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop_ip is not None:
            pulumi.set(__self__, "next_hop_ip", next_hop_ip)
        if prefer_over_ospf_routes_enabled is not None:
            pulumi.set(__self__, "prefer_over_ospf_routes_enabled", prefer_over_ospf_routes_enabled)
        if static_route_id is not None:
            pulumi.set(__self__, "static_route_id", static_route_id)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="switchStackId")
    def switch_stack_id(self) -> pulumi.Input[builtins.str]:
        """
        switchStackId path parameter. Switch stack ID
        """
        return pulumi.get(self, "switch_stack_id")

    @switch_stack_id.setter
    def switch_stack_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "switch_stack_id", value)

    @property
    @pulumi.getter(name="advertiseViaOspfEnabled")
    def advertise_via_ospf_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Option to advertise static routes via OSPF
        """
        return pulumi.get(self, "advertise_via_ospf_enabled")

    @advertise_via_ospf_enabled.setter
    def advertise_via_ospf_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "advertise_via_ospf_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name or description of the layer 3 static route
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nextHopIp")
    def next_hop_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address of the router to which traffic for this destination network should be sent
        """
        return pulumi.get(self, "next_hop_ip")

    @next_hop_ip.setter
    def next_hop_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_ip", value)

    @property
    @pulumi.getter(name="preferOverOspfRoutesEnabled")
    def prefer_over_ospf_routes_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Option to prefer static routes over OSPF routes
        """
        return pulumi.get(self, "prefer_over_ospf_routes_enabled")

    @prefer_over_ospf_routes_enabled.setter
    def prefer_over_ospf_routes_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "prefer_over_ospf_routes_enabled", value)

    @property
    @pulumi.getter(name="staticRouteId")
    def static_route_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of a layer 3 static route
        """
        return pulumi.get(self, "static_route_id")

    @static_route_id.setter
    def static_route_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "static_route_id", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address of the subnetwork specified in CIDR notation (ex. 1.2.3.0/24)
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet", value)


@pulumi.input_type
class _SwitchStacksRoutingStaticRoutesState:
    def __init__(__self__, *,
                 advertise_via_ospf_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_ip: Optional[pulumi.Input[builtins.str]] = None,
                 prefer_over_ospf_routes_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 static_route_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet: Optional[pulumi.Input[builtins.str]] = None,
                 switch_stack_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SwitchStacksRoutingStaticRoutes resources.
        :param pulumi.Input[builtins.bool] advertise_via_ospf_enabled: Option to advertise static routes via OSPF
        :param pulumi.Input[builtins.str] name: The name or description of the layer 3 static route
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] next_hop_ip: The IP address of the router to which traffic for this destination network should be sent
        :param pulumi.Input[builtins.bool] prefer_over_ospf_routes_enabled: Option to prefer static routes over OSPF routes
        :param pulumi.Input[builtins.str] static_route_id: The identifier of a layer 3 static route
        :param pulumi.Input[builtins.str] subnet: The IP address of the subnetwork specified in CIDR notation (ex. 1.2.3.0/24)
        :param pulumi.Input[builtins.str] switch_stack_id: switchStackId path parameter. Switch stack ID
        """
        if advertise_via_ospf_enabled is not None:
            pulumi.set(__self__, "advertise_via_ospf_enabled", advertise_via_ospf_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if next_hop_ip is not None:
            pulumi.set(__self__, "next_hop_ip", next_hop_ip)
        if prefer_over_ospf_routes_enabled is not None:
            pulumi.set(__self__, "prefer_over_ospf_routes_enabled", prefer_over_ospf_routes_enabled)
        if static_route_id is not None:
            pulumi.set(__self__, "static_route_id", static_route_id)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if switch_stack_id is not None:
            pulumi.set(__self__, "switch_stack_id", switch_stack_id)

    @property
    @pulumi.getter(name="advertiseViaOspfEnabled")
    def advertise_via_ospf_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Option to advertise static routes via OSPF
        """
        return pulumi.get(self, "advertise_via_ospf_enabled")

    @advertise_via_ospf_enabled.setter
    def advertise_via_ospf_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "advertise_via_ospf_enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name or description of the layer 3 static route
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="nextHopIp")
    def next_hop_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address of the router to which traffic for this destination network should be sent
        """
        return pulumi.get(self, "next_hop_ip")

    @next_hop_ip.setter
    def next_hop_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_ip", value)

    @property
    @pulumi.getter(name="preferOverOspfRoutesEnabled")
    def prefer_over_ospf_routes_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Option to prefer static routes over OSPF routes
        """
        return pulumi.get(self, "prefer_over_ospf_routes_enabled")

    @prefer_over_ospf_routes_enabled.setter
    def prefer_over_ospf_routes_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "prefer_over_ospf_routes_enabled", value)

    @property
    @pulumi.getter(name="staticRouteId")
    def static_route_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of a layer 3 static route
        """
        return pulumi.get(self, "static_route_id")

    @static_route_id.setter
    def static_route_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "static_route_id", value)

    @property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address of the subnetwork specified in CIDR notation (ex. 1.2.3.0/24)
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="switchStackId")
    def switch_stack_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        switchStackId path parameter. Switch stack ID
        """
        return pulumi.get(self, "switch_stack_id")

    @switch_stack_id.setter
    def switch_stack_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "switch_stack_id", value)


@pulumi.type_token("meraki:networks/switchStacksRoutingStaticRoutes:SwitchStacksRoutingStaticRoutes")
class SwitchStacksRoutingStaticRoutes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advertise_via_ospf_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_ip: Optional[pulumi.Input[builtins.str]] = None,
                 prefer_over_ospf_routes_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 static_route_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet: Optional[pulumi.Input[builtins.str]] = None,
                 switch_stack_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.SwitchStacksRoutingStaticRoutes("example",
            advertise_via_ospf_enabled=False,
            name="My route",
            network_id="string",
            next_hop_ip="1.2.3.4",
            prefer_over_ospf_routes_enabled=False,
            subnet="192.168.1.0/24",
            switch_stack_id="string")
        pulumi.export("merakiNetworksSwitchStacksRoutingStaticRoutesExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchStacksRoutingStaticRoutes:SwitchStacksRoutingStaticRoutes example "network_id,static_route_id,switch_stack_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] advertise_via_ospf_enabled: Option to advertise static routes via OSPF
        :param pulumi.Input[builtins.str] name: The name or description of the layer 3 static route
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] next_hop_ip: The IP address of the router to which traffic for this destination network should be sent
        :param pulumi.Input[builtins.bool] prefer_over_ospf_routes_enabled: Option to prefer static routes over OSPF routes
        :param pulumi.Input[builtins.str] static_route_id: The identifier of a layer 3 static route
        :param pulumi.Input[builtins.str] subnet: The IP address of the subnetwork specified in CIDR notation (ex. 1.2.3.0/24)
        :param pulumi.Input[builtins.str] switch_stack_id: switchStackId path parameter. Switch stack ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SwitchStacksRoutingStaticRoutesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.SwitchStacksRoutingStaticRoutes("example",
            advertise_via_ospf_enabled=False,
            name="My route",
            network_id="string",
            next_hop_ip="1.2.3.4",
            prefer_over_ospf_routes_enabled=False,
            subnet="192.168.1.0/24",
            switch_stack_id="string")
        pulumi.export("merakiNetworksSwitchStacksRoutingStaticRoutesExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchStacksRoutingStaticRoutes:SwitchStacksRoutingStaticRoutes example "network_id,static_route_id,switch_stack_id"
        ```

        :param str resource_name: The name of the resource.
        :param SwitchStacksRoutingStaticRoutesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwitchStacksRoutingStaticRoutesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advertise_via_ospf_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_ip: Optional[pulumi.Input[builtins.str]] = None,
                 prefer_over_ospf_routes_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 static_route_id: Optional[pulumi.Input[builtins.str]] = None,
                 subnet: Optional[pulumi.Input[builtins.str]] = None,
                 switch_stack_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwitchStacksRoutingStaticRoutesArgs.__new__(SwitchStacksRoutingStaticRoutesArgs)

            __props__.__dict__["advertise_via_ospf_enabled"] = advertise_via_ospf_enabled
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["next_hop_ip"] = next_hop_ip
            __props__.__dict__["prefer_over_ospf_routes_enabled"] = prefer_over_ospf_routes_enabled
            __props__.__dict__["static_route_id"] = static_route_id
            __props__.__dict__["subnet"] = subnet
            if switch_stack_id is None and not opts.urn:
                raise TypeError("Missing required property 'switch_stack_id'")
            __props__.__dict__["switch_stack_id"] = switch_stack_id
        super(SwitchStacksRoutingStaticRoutes, __self__).__init__(
            'meraki:networks/switchStacksRoutingStaticRoutes:SwitchStacksRoutingStaticRoutes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advertise_via_ospf_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            next_hop_ip: Optional[pulumi.Input[builtins.str]] = None,
            prefer_over_ospf_routes_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            static_route_id: Optional[pulumi.Input[builtins.str]] = None,
            subnet: Optional[pulumi.Input[builtins.str]] = None,
            switch_stack_id: Optional[pulumi.Input[builtins.str]] = None) -> 'SwitchStacksRoutingStaticRoutes':
        """
        Get an existing SwitchStacksRoutingStaticRoutes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] advertise_via_ospf_enabled: Option to advertise static routes via OSPF
        :param pulumi.Input[builtins.str] name: The name or description of the layer 3 static route
        :param pulumi.Input[builtins.str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[builtins.str] next_hop_ip: The IP address of the router to which traffic for this destination network should be sent
        :param pulumi.Input[builtins.bool] prefer_over_ospf_routes_enabled: Option to prefer static routes over OSPF routes
        :param pulumi.Input[builtins.str] static_route_id: The identifier of a layer 3 static route
        :param pulumi.Input[builtins.str] subnet: The IP address of the subnetwork specified in CIDR notation (ex. 1.2.3.0/24)
        :param pulumi.Input[builtins.str] switch_stack_id: switchStackId path parameter. Switch stack ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwitchStacksRoutingStaticRoutesState.__new__(_SwitchStacksRoutingStaticRoutesState)

        __props__.__dict__["advertise_via_ospf_enabled"] = advertise_via_ospf_enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["next_hop_ip"] = next_hop_ip
        __props__.__dict__["prefer_over_ospf_routes_enabled"] = prefer_over_ospf_routes_enabled
        __props__.__dict__["static_route_id"] = static_route_id
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["switch_stack_id"] = switch_stack_id
        return SwitchStacksRoutingStaticRoutes(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="advertiseViaOspfEnabled")
    def advertise_via_ospf_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Option to advertise static routes via OSPF
        """
        return pulumi.get(self, "advertise_via_ospf_enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name or description of the layer 3 static route
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="nextHopIp")
    def next_hop_ip(self) -> pulumi.Output[builtins.str]:
        """
        The IP address of the router to which traffic for this destination network should be sent
        """
        return pulumi.get(self, "next_hop_ip")

    @property
    @pulumi.getter(name="preferOverOspfRoutesEnabled")
    def prefer_over_ospf_routes_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Option to prefer static routes over OSPF routes
        """
        return pulumi.get(self, "prefer_over_ospf_routes_enabled")

    @property
    @pulumi.getter(name="staticRouteId")
    def static_route_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of a layer 3 static route
        """
        return pulumi.get(self, "static_route_id")

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[builtins.str]:
        """
        The IP address of the subnetwork specified in CIDR notation (ex. 1.2.3.0/24)
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter(name="switchStackId")
    def switch_stack_id(self) -> pulumi.Output[builtins.str]:
        """
        switchStackId path parameter. Switch stack ID
        """
        return pulumi.get(self, "switch_stack_id")

