"""
box- and single-column breakup-focused examples from
[de Jong et al. 2023](https://doi.org/10.5194/gmd-16-4193-2023)

fig_9.ipynb:
.. include:: ./fig_9.ipynb.badges.md

figs_3_4_5.ipynb:
.. include:: ./figs_3_4_5.ipynb.badges.md

figs_6_7_8.ipynb:
.. include:: ./figs_6_7_8.ipynb.badges.md

figs_10_11_12_13.ipynb:
.. include:: ./figs_10_11_12_13.ipynb.badges.md
"""

# pylint: disable=invalid-name
from .plot_rates import plot_ax, plot_zeros_ax
from .settings1D import Settings1D
from .settings_0D import Settings0D
from .simulation1D import Simulation1D
from .simulation_0D import run_box_breakup, run_box_NObreakup
from .simulation_ss import (
    get_straub_fig10_data,
    get_straub_fig10_init,
    run_to_steady_state,
)
