#pragma once
#include "ATen/Type.h"
#include "ATen/Context.h"
#include "ATen/TensorMethods.h"
#include "ATen/CheckGenerator.h"

#ifdef _MSC_VER
#ifdef Type
#undef Type
#endif
#endif

namespace at {

struct CPUCharType final : public Type {
  explicit CPUCharType(Context* context);
  virtual ScalarType scalarType() const override;
  virtual Backend backend() const override;
  virtual bool isCuda() const override;
  virtual bool isSparse() const override;
  virtual bool isDistributed() const override;
  virtual std::unique_ptr<Storage> storage() const override;
  virtual std::unique_ptr<Storage> storage(size_t size) const override;
  virtual std::unique_ptr<Storage> storageFromBlob(void * data, int64_t size, const std::function<void(void*)> & deleter) const override;
  virtual std::unique_ptr<Generator> generator() const override;
  virtual const char * toString() const override;
  virtual std::size_t elementSizeInBytes() const override;
  virtual TypeID ID() const override;
  static const char * typeString();
  Tensor unsafeTensorFromTH(void * th_pointer, bool retain) const override;

  // example
  // virtual Tensor * add(Tensor & a, Tensor & b) override;

  virtual void s_copy(const Tensor & src, Tensor & dst) const override;
  virtual int64_t m_storage_offset(const Tensor & self) const override;
  virtual Tensor & m_resize_(Tensor & self, IntList size) const override;
  virtual Tensor & zeros_out(Tensor & result, IntList size) const override;
  virtual Tensor zeros(IntList size) const override;
  virtual Tensor & zeros_like_out(Tensor & result, const Tensor & input) const override;
  virtual Tensor zeros_like(const Tensor & input) const override;
  virtual Tensor & ones_out(Tensor & result, IntList size) const override;
  virtual Tensor ones(IntList size) const override;
  virtual Tensor & ones_like_out(Tensor & result, const Tensor & input) const override;
  virtual Tensor ones_like(const Tensor & input) const override;
  virtual int64_t numel(const Tensor & self) const override;
  virtual Tensor & m_set_(Tensor & self, Storage & storage) const override;
  virtual Tensor & m_set_(Tensor & self, Storage & sourceStorage, int64_t storage_offset, IntList size, IntList stride) const override;
  virtual Tensor & m_set_(Tensor & self, const Tensor & source) const override;
  virtual Tensor & m_set_(Tensor & self) const override;
  virtual Tensor & m_fill_(Tensor & self, Scalar value) const override;
  virtual bool m_is_contiguous(const Tensor & self) const override;
  virtual bool m_is_set_to(const Tensor & self, const Tensor & tensor) const override;
  virtual Tensor & s_m_masked_fill_(Tensor & self, const Tensor & mask, Scalar value) const override;
  virtual Tensor & s_m_masked_scatter_(Tensor & self, const Tensor & mask, const Tensor & source) const override;
  virtual Tensor & s_masked_select_out(Tensor & result, const Tensor & self, const Tensor & mask) const override;
  virtual Tensor s_masked_select(const Tensor & self, const Tensor & mask) const override;
  virtual Tensor transpose(const Tensor & self, int64_t dim0, int64_t dim1) const override;
  virtual Tensor & m_transpose_(Tensor & self, int64_t dim0, int64_t dim1) const override;
  virtual Tensor t(const Tensor & self) const override;
  virtual Tensor & m_t_(Tensor & self) const override;
  virtual Tensor & squeeze_out(Tensor & result, const Tensor & self, int64_t dim) const override;
  virtual Tensor squeeze(const Tensor & self, int64_t dim) const override;
  virtual Tensor & squeeze_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor squeeze(const Tensor & self) const override;
  virtual Tensor & m_squeeze_(Tensor & self, int64_t dim) const override;
  virtual Tensor & m_squeeze_(Tensor & self) const override;
  virtual Tensor & unsqueeze_out(Tensor & result, const Tensor & self, int64_t dim) const override;
  virtual Tensor unsqueeze(const Tensor & self, int64_t dim) const override;
  virtual Tensor & m_unsqueeze_(Tensor & self, int64_t dim) const override;
  virtual Tensor & nonzero_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor nonzero(const Tensor & self) const override;
  virtual Tensor m_contiguous(const Tensor & self) const override;
  virtual Tensor m_clone(const Tensor & self) const override;
  virtual Tensor m_view(const Tensor & self, IntList size) const override;
  virtual Tensor m_expand(const Tensor & self, IntList size) const override;
  virtual Tensor & m_resize_as_(Tensor & self, const Tensor & the_template) const override;
  virtual Tensor & index_select_out(Tensor & result, const Tensor & self, int64_t dim, const Tensor & index) const override;
  virtual Tensor index_select(const Tensor & self, int64_t dim, const Tensor & index) const override;
  virtual Tensor & m_index_copy_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const override;
  virtual Tensor & take_out(Tensor & result, const Tensor & self, const Tensor & index) const override;
  virtual Tensor take(const Tensor & self, const Tensor & index) const override;
  virtual Tensor & m_put_(Tensor & self, const Tensor & index, const Tensor & source, bool accumulate) const override;
  virtual Tensor & m_index_add_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & source) const override;
  virtual Tensor & m_index_fill_(Tensor & self, int64_t dim, const Tensor & index, Scalar value) const override;
  virtual Tensor m_narrow(const Tensor & self, int64_t dimension, int64_t start, int64_t length) const override;
  virtual Tensor m_unfold(const Tensor & self, int64_t dimension, int64_t size, int64_t step) const override;
  virtual Tensor & range_out(Tensor & result, Scalar start, Scalar end, Scalar step) const override;
  virtual Tensor range(Scalar start, Scalar end, Scalar step) const override;
  virtual Tensor & arange_out(Tensor & result, Scalar start, Scalar end, Scalar step) const override;
  virtual Tensor arange(Scalar start, Scalar end, Scalar step) const override;
  virtual Tensor & arange_out(Tensor & result, Scalar end) const override;
  virtual Tensor arange(Scalar end) const override;
  virtual Tensor & m_scatter_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) const override;
  virtual Tensor & m_scatter_(Tensor & self, int64_t dim, const Tensor & index, Scalar value) const override;
  virtual Tensor & m_scatter_add_(Tensor & self, int64_t dim, const Tensor & index, const Tensor & src) const override;
  virtual Tensor & gather_out(Tensor & result, const Tensor & self, int64_t dim, const Tensor & index) const override;
  virtual Tensor gather(const Tensor & self, int64_t dim, const Tensor & index) const override;
  virtual void* m_data_ptr(const Tensor & self) const override;
  virtual bool equal(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & __and___out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor __and__(const Tensor & self, Scalar other) const override;
  virtual Tensor & s___and___out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s___and__(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & __iand__(Tensor & self, Scalar other) const override;
  virtual Tensor & s___iand__(Tensor & self, const Tensor & other) const override;
  virtual Tensor & __or___out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor __or__(const Tensor & self, Scalar other) const override;
  virtual Tensor & s___or___out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s___or__(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & __ior__(Tensor & self, Scalar other) const override;
  virtual Tensor & s___ior__(Tensor & self, const Tensor & other) const override;
  virtual Tensor & __xor___out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor __xor__(const Tensor & self, Scalar other) const override;
  virtual Tensor & s___xor___out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s___xor__(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & __ixor__(Tensor & self, Scalar other) const override;
  virtual Tensor & s___ixor__(Tensor & self, const Tensor & other) const override;
  virtual Tensor & __lshift___out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor __lshift__(const Tensor & self, Scalar other) const override;
  virtual Tensor & s___lshift___out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s___lshift__(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & __ilshift__(Tensor & self, Scalar other) const override;
  virtual Tensor & s___ilshift__(Tensor & self, const Tensor & other) const override;
  virtual Tensor & __rshift___out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor __rshift__(const Tensor & self, Scalar other) const override;
  virtual Tensor & s___rshift___out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s___rshift__(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & __irshift__(Tensor & self, Scalar other) const override;
  virtual Tensor & s___irshift__(Tensor & self, const Tensor & other) const override;
  virtual Tensor & lt_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor lt(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_lt_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_lt(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_lt_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_lt_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & gt_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor gt(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_gt_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_gt(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_gt_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_gt_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & le_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor le(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_le_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_le(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_le_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_le_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & ge_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor ge(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_ge_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_ge(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_ge_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_ge_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & eq_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor eq(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_eq_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_eq(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_eq_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_eq_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & ne_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor ne(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_ne_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_ne(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_ne_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_ne_(Tensor & self, const Tensor & other) const override;
  virtual std::tuple<Tensor &,Tensor &> min_out(Tensor & min, Tensor & min_indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor,Tensor> min(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Tensor & s_min_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_min(const Tensor & self, const Tensor & other) const override;
  virtual Scalar min(const Tensor & self) const override;
  virtual std::tuple<Tensor &,Tensor &> max_out(Tensor & max, Tensor & max_indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor,Tensor> max(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Tensor & s_max_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_max(const Tensor & self, const Tensor & other) const override;
  virtual Scalar max(const Tensor & self) const override;
  virtual std::tuple<Tensor &,Tensor &> kthvalue_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor,Tensor> kthvalue(const Tensor & self, int64_t k, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor &,Tensor &> mode_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor,Tensor> mode(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor &,Tensor &> median_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual std::tuple<Tensor,Tensor> median(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Scalar median(const Tensor & self) const override;
  virtual std::tuple<Tensor &,Tensor &> sort_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t dim, bool descending) const override;
  virtual std::tuple<Tensor,Tensor> sort(const Tensor & self, int64_t dim, bool descending) const override;
  virtual std::tuple<Tensor &,Tensor &> topk_out(Tensor & values, Tensor & indices, const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted) const override;
  virtual std::tuple<Tensor,Tensor> topk(const Tensor & self, int64_t k, int64_t dim, bool largest, bool sorted) const override;
  virtual Tensor & m_zero_(Tensor & self) const override;
  virtual Tensor & sum_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Tensor sum(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Scalar sum(const Tensor & self) const override;
  virtual Tensor & prod_out(Tensor & result, const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Tensor prod(const Tensor & self, int64_t dim, bool keepdim) const override;
  virtual Scalar prod(const Tensor & self) const override;
  virtual Tensor & cumsum_out(Tensor & result, const Tensor & self, int64_t dim) const override;
  virtual Tensor cumsum(const Tensor & self, int64_t dim) const override;
  virtual Tensor & cumprod_out(Tensor & result, const Tensor & self, int64_t dim) const override;
  virtual Tensor cumprod(const Tensor & self, int64_t dim) const override;
  virtual Tensor & sign_out(Tensor & result, const Tensor & self) const override;
  virtual Tensor sign(const Tensor & self) const override;
  virtual Tensor & m_sign_(Tensor & self) const override;
  virtual Scalar trace(const Tensor & self) const override;
  virtual Tensor & add_out(Tensor & result, const Tensor & self, Scalar other, Scalar alpha) const override;
  virtual Tensor add(const Tensor & self, Scalar other, Scalar alpha) const override;
  virtual Tensor & s_add_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor s_add(const Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor & add_out(Tensor & result, const Tensor & self, SparseTensor other, Scalar alpha) const override;
  virtual Tensor add(const Tensor & self, SparseTensor other, Scalar alpha) const override;
  virtual Tensor & m_add_(Tensor & self, Scalar other, Scalar alpha) const override;
  virtual Tensor & s_m_add_(Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor & m_add_(Tensor & self, SparseTensor other, Scalar alpha) const override;
  virtual Tensor & sub_out(Tensor & result, const Tensor & self, Scalar other, Scalar alpha) const override;
  virtual Tensor sub(const Tensor & self, Scalar other, Scalar alpha) const override;
  virtual Tensor & s_sub_out(Tensor & result, const Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor s_sub(const Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor & m_sub_(Tensor & self, Scalar other, Scalar alpha) const override;
  virtual Tensor & s_m_sub_(Tensor & self, const Tensor & other, Scalar alpha) const override;
  virtual Tensor & mul_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor mul(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_mul_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_mul(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_mul_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_mul_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & div_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor div(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_div_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_div(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_div_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_div_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & fmod_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor fmod(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_fmod_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_fmod(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_fmod_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_fmod_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & remainder_out(Tensor & result, const Tensor & self, Scalar other) const override;
  virtual Tensor remainder(const Tensor & self, Scalar other) const override;
  virtual Tensor & s_remainder_out(Tensor & result, const Tensor & self, const Tensor & other) const override;
  virtual Tensor s_remainder(const Tensor & self, const Tensor & other) const override;
  virtual Tensor & m_remainder_(Tensor & self, Scalar other) const override;
  virtual Tensor & s_m_remainder_(Tensor & self, const Tensor & other) const override;
  virtual Tensor & clamp_out(Tensor & destination, const Tensor & self, Scalar min, Scalar max) const override;
  virtual Tensor clamp(const Tensor & self, Scalar min, Scalar max) const override;
  virtual Tensor & clamp_out(Tensor & result, const Tensor & self, Scalar min) const override;
  virtual Tensor clamp(const Tensor & self, Scalar min) const override;
  virtual Tensor & m_clamp_(Tensor & self, Scalar min, Scalar max) const override;
  virtual Tensor & m_clamp_(Tensor & self, Scalar min) const override;
  virtual Scalar dot(const Tensor & self, const Tensor & tensor) const override;
  virtual Tensor & tril_out(Tensor & destination, const Tensor & self, int64_t diagonal) const override;
  virtual Tensor tril(const Tensor & self, int64_t diagonal) const override;
  virtual Tensor & m_tril_(Tensor & self, int64_t diagonal) const override;
  virtual Tensor & triu_out(Tensor & destination, const Tensor & self, int64_t diagonal) const override;
  virtual Tensor triu(const Tensor & self, int64_t diagonal) const override;
  virtual Tensor & m_triu_(Tensor & self, int64_t diagonal) const override;
  virtual Tensor & cross_out(Tensor & destination, const Tensor & self, const Tensor & other, int64_t dim) const override;
  virtual Tensor cross(const Tensor & self, const Tensor & other, int64_t dim) const override;
  virtual Tensor & eye_out(Tensor & result, int64_t n, int64_t m) const override;
  virtual Tensor eye(int64_t n, int64_t m) const override;
  virtual Tensor & diag_out(Tensor & result, const Tensor & self, int64_t diagonal) const override;
  virtual Tensor diag(const Tensor & self, int64_t diagonal) const override;
  virtual Tensor & s_addmm_out(Tensor & result, const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  virtual Tensor s_addmm(const Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & m_addmm_(Tensor & self, const Tensor & mat1, const Tensor & mat2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & s_addmv_out(Tensor & result, const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const override;
  virtual Tensor s_addmv(const Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const override;
  virtual Tensor & m_addmv_(Tensor & self, const Tensor & mat, const Tensor & vec, Scalar beta, Scalar alpha) const override;
  virtual Tensor & s_addr_out(Tensor & result, const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const override;
  virtual Tensor s_addr(const Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & m_addr_(Tensor & self, const Tensor & vec1, const Tensor & vec2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & ger_out(Tensor & result, const Tensor & self, const Tensor & vec2) const override;
  virtual Tensor ger(const Tensor & self, const Tensor & vec2) const override;
  virtual Tensor & mv_out(Tensor & result, const Tensor & self, const Tensor & vec) const override;
  virtual Tensor mv(const Tensor & self, const Tensor & vec) const override;
  virtual Tensor & mm_out(Tensor & result, const Tensor & self, const Tensor & mat2) const override;
  virtual Tensor mm(const Tensor & self, const Tensor & mat2) const override;
  virtual Tensor & bmm_out(Tensor & result, const Tensor & self, const Tensor & mat2) const override;
  virtual Tensor bmm(const Tensor & self, const Tensor & mat2) const override;
  virtual Tensor & s_addbmm_out(Tensor & result, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  virtual Tensor s_addbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & m_addbmm_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & s_baddbmm_out(Tensor & result, const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  virtual Tensor s_baddbmm(const Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & m_baddbmm_(Tensor & self, const Tensor & batch1, const Tensor & batch2, Scalar beta, Scalar alpha) const override;
  virtual Tensor & s_addcmul_out(Tensor & result, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  virtual Tensor s_addcmul(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  virtual Tensor & s_m_addcmul_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  virtual Tensor & s_addcdiv_out(Tensor & result, const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  virtual Tensor s_addcdiv(const Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  virtual Tensor & s_m_addcdiv_(Tensor & self, const Tensor & tensor1, const Tensor & tensor2, Scalar value) const override;
  virtual Tensor & randperm_out(Tensor & result, int64_t n, Generator * generator) const override;
  virtual Tensor randperm(int64_t n, Generator * generator) const override;
  virtual Tensor & m_random_(Tensor & self, int64_t from, int64_t to, Generator * generator) const override;
  virtual Tensor & m_random_(Tensor & self, int64_t to, Generator * generator) const override;
  virtual Tensor & m_random_(Tensor & self, Generator * generator) const override;
  virtual Tensor & m_geometric_(Tensor & self, double p, Generator * generator) const override;
  virtual int64_t m_size(const Tensor & self, int64_t dim) const override;
  virtual int64_t m_stride(const Tensor & self, int64_t dim) const override;
  virtual Tensor tensor(Storage & storage, int64_t storageOffset, IntList size, IntList stride) const override;
  virtual Tensor tensor(IntList size) const override;
  virtual Tensor tensor(IntList size, IntList stride) const override;
  virtual Tensor tensor() const override;
  virtual Tensor alias(const Tensor & tensor) const override;
  virtual Tensor & select_out(Tensor & result, const Tensor & self, int64_t dim, int64_t sliceIndex) const override;
  virtual Tensor select(const Tensor & self, int64_t dim, int64_t sliceIndex) const override;
  virtual Tensor & _unnarrow_out(Tensor & result, const Tensor & self, int64_t dimension, int64_t offset, int64_t dimSize) const override;
  virtual Tensor _unnarrow(const Tensor & self, int64_t dimension, int64_t offset, int64_t dimSize) const override;
  virtual Tensor & m_assign_(Tensor & self, const Tensor & src) const override;
  virtual Tensor & as_strided_out(Tensor & result, const Tensor & self, IntList size, IntList stride) const override;
  virtual Tensor as_strided(const Tensor & self, IntList size, IntList stride) const override;
  virtual Tensor & as_strided_(Tensor & self, IntList size, IntList stride, int64_t storage_offset) const override;
  virtual Tensor & cat_out(Tensor & self, TensorList tensors, int64_t dim) const override;
  virtual Tensor cat(TensorList tensors, int64_t dim) const override;
  virtual Tensor & m_reshape_(Tensor & self, IntList size, IntList stride) const override;
};

} // namespace at
