#pragma once

#include <TH/TH.h>
#include <THNN/THNN.h>
#undef THNN_
#include <THS/THS.h>

#include "ATen/Tensor.h"
#include "ATen/TensorImpl.h"
#include "ATen/Context.h"
#include "ATen/TensorMethods.h"

namespace at {

struct SparseCPUByteTensor final : public TensorImpl {
public:
  explicit SparseCPUByteTensor(Context* context);
  SparseCPUByteTensor(Context* context, THSByteTensor * tensor);
  virtual ~SparseCPUByteTensor();
  virtual const char * toString() const override;
  virtual IntList sizes() const override;
  virtual IntList strides() const override;
  virtual int64_t dim() const override;
  virtual Scalar localScalar() override;
  virtual void assign_(Scalar s) override;
  virtual void * unsafeGetTH(bool retain) override;
  static const char * typeString();

//TODO(zach): sort of friend permissions later so this
// can be protected
public:
  THSByteTensor * tensor;
  Context* context;
  friend struct SparseCPUByteType;
};

} // namespace at
