

# This file was autogenerated by some hot garbage in the `uniffi` crate.
# Trust me, you don't want to mess with it!

# Common helper code.
#
# Ideally this would live in a separate .py file where it can be unittested etc
# in isolation, and perhaps even published as a re-useable package.
#
# However, it's important that the details of how this helper code works (e.g. the
# way that different builtin types are passed across the FFI) exactly match what's
# expected by the rust code on the other side of the interface. In practice right
# now that means coming from the exact some version of `uniffi` that was used to
# compile the rust component. The easiest way to ensure this is to bundle the Python
# helpers directly inline like we're doing here.

from __future__ import annotations
import os
import sys
import ctypes
import enum
import struct
import contextlib
import datetime
import threading
import itertools
import traceback
import typing
import platform

# Used for default argument values
_DEFAULT = object() # type: typing.Any


class _UniffiRustBuffer(ctypes.Structure):
    _fields_ = [
        ("capacity", ctypes.c_uint64),
        ("len", ctypes.c_uint64),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    @staticmethod
    def default():
        return _UniffiRustBuffer(0, 0, None)

    @staticmethod
    def alloc(size):
        return _uniffi_rust_call(_UniffiLib.ffi_zmanim_core_rustbuffer_alloc, size)

    @staticmethod
    def reserve(rbuf, additional):
        return _uniffi_rust_call(_UniffiLib.ffi_zmanim_core_rustbuffer_reserve, rbuf, additional)

    def free(self):
        return _uniffi_rust_call(_UniffiLib.ffi_zmanim_core_rustbuffer_free, self)

    def __str__(self):
        return "_UniffiRustBuffer(capacity={}, len={}, data={})".format(
            self.capacity,
            self.len,
            self.data[0:self.len]
        )

    @contextlib.contextmanager
    def alloc_with_builder(*args):
        """Context-manger to allocate a buffer using a _UniffiRustBufferBuilder.

        The allocated buffer will be automatically freed if an error occurs, ensuring that
        we don't accidentally leak it.
        """
        builder = _UniffiRustBufferBuilder()
        try:
            yield builder
        except:
            builder.discard()
            raise

    @contextlib.contextmanager
    def consume_with_stream(self):
        """Context-manager to consume a buffer using a _UniffiRustBufferStream.

        The _UniffiRustBuffer will be freed once the context-manager exits, ensuring that we don't
        leak it even if an error occurs.
        """
        try:
            s = _UniffiRustBufferStream.from_rust_buffer(self)
            yield s
            if s.remaining() != 0:
                raise RuntimeError("junk data left in buffer at end of consume_with_stream")
        finally:
            self.free()

    @contextlib.contextmanager
    def read_with_stream(self):
        """Context-manager to read a buffer using a _UniffiRustBufferStream.

        This is like consume_with_stream, but doesn't free the buffer afterwards.
        It should only be used with borrowed `_UniffiRustBuffer` data.
        """
        s = _UniffiRustBufferStream.from_rust_buffer(self)
        yield s
        if s.remaining() != 0:
            raise RuntimeError("junk data left in buffer at end of read_with_stream")

class _UniffiForeignBytes(ctypes.Structure):
    _fields_ = [
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    def __str__(self):
        return "_UniffiForeignBytes(len={}, data={})".format(self.len, self.data[0:self.len])


class _UniffiRustBufferStream:
    """
    Helper for structured reading of bytes from a _UniffiRustBuffer
    """

    def __init__(self, data, len):
        self.data = data
        self.len = len
        self.offset = 0

    @classmethod
    def from_rust_buffer(cls, buf):
        return cls(buf.data, buf.len)

    def remaining(self):
        return self.len - self.offset

    def _unpack_from(self, size, format):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        value = struct.unpack(format, self.data[self.offset:self.offset+size])[0]
        self.offset += size
        return value

    def read(self, size):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        data = self.data[self.offset:self.offset+size]
        self.offset += size
        return data

    def read_i8(self):
        return self._unpack_from(1, ">b")

    def read_u8(self):
        return self._unpack_from(1, ">B")

    def read_i16(self):
        return self._unpack_from(2, ">h")

    def read_u16(self):
        return self._unpack_from(2, ">H")

    def read_i32(self):
        return self._unpack_from(4, ">i")

    def read_u32(self):
        return self._unpack_from(4, ">I")

    def read_i64(self):
        return self._unpack_from(8, ">q")

    def read_u64(self):
        return self._unpack_from(8, ">Q")

    def read_float(self):
        v = self._unpack_from(4, ">f")
        return v

    def read_double(self):
        return self._unpack_from(8, ">d")

class _UniffiRustBufferBuilder:
    """
    Helper for structured writing of bytes into a _UniffiRustBuffer.
    """

    def __init__(self):
        self.rbuf = _UniffiRustBuffer.alloc(16)
        self.rbuf.len = 0

    def finalize(self):
        rbuf = self.rbuf
        self.rbuf = None
        return rbuf

    def discard(self):
        if self.rbuf is not None:
            rbuf = self.finalize()
            rbuf.free()

    @contextlib.contextmanager
    def _reserve(self, num_bytes):
        if self.rbuf.len + num_bytes > self.rbuf.capacity:
            self.rbuf = _UniffiRustBuffer.reserve(self.rbuf, num_bytes)
        yield None
        self.rbuf.len += num_bytes

    def _pack_into(self, size, format, value):
        with self._reserve(size):
            # XXX TODO: I feel like I should be able to use `struct.pack_into` here but can't figure it out.
            for i, byte in enumerate(struct.pack(format, value)):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write(self, value):
        with self._reserve(len(value)):
            for i, byte in enumerate(value):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write_i8(self, v):
        self._pack_into(1, ">b", v)

    def write_u8(self, v):
        self._pack_into(1, ">B", v)

    def write_i16(self, v):
        self._pack_into(2, ">h", v)

    def write_u16(self, v):
        self._pack_into(2, ">H", v)

    def write_i32(self, v):
        self._pack_into(4, ">i", v)

    def write_u32(self, v):
        self._pack_into(4, ">I", v)

    def write_i64(self, v):
        self._pack_into(8, ">q", v)

    def write_u64(self, v):
        self._pack_into(8, ">Q", v)

    def write_float(self, v):
        self._pack_into(4, ">f", v)

    def write_double(self, v):
        self._pack_into(8, ">d", v)

    def write_c_size_t(self, v):
        self._pack_into(ctypes.sizeof(ctypes.c_size_t) , "@N", v)
# A handful of classes and functions to support the generated data structures.
# This would be a good candidate for isolating in its own ffi-support lib.

class InternalError(Exception):
    pass

class _UniffiRustCallStatus(ctypes.Structure):
    """
    Error runtime.
    """
    _fields_ = [
        ("code", ctypes.c_int8),
        ("error_buf", _UniffiRustBuffer),
    ]

    # These match the values from the uniffi::rustcalls module
    CALL_SUCCESS = 0
    CALL_ERROR = 1
    CALL_UNEXPECTED_ERROR = 2

    @staticmethod
    def default():
        return _UniffiRustCallStatus(code=_UniffiRustCallStatus.CALL_SUCCESS, error_buf=_UniffiRustBuffer.default())

    def __str__(self):
        if self.code == _UniffiRustCallStatus.CALL_SUCCESS:
            return "_UniffiRustCallStatus(CALL_SUCCESS)"
        elif self.code == _UniffiRustCallStatus.CALL_ERROR:
            return "_UniffiRustCallStatus(CALL_ERROR)"
        elif self.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
            return "_UniffiRustCallStatus(CALL_UNEXPECTED_ERROR)"
        else:
            return "_UniffiRustCallStatus(<invalid code>)"

def _uniffi_rust_call(fn, *args):
    # Call a rust function
    return _uniffi_rust_call_with_error(None, fn, *args)

def _uniffi_rust_call_with_error(error_ffi_converter, fn, *args):
    # Call a rust function and handle any errors
    #
    # This function is used for rust calls that return Result<> and therefore can set the CALL_ERROR status code.
    # error_ffi_converter must be set to the _UniffiConverter for the error class that corresponds to the result.
    call_status = _UniffiRustCallStatus.default()

    args_with_error = args + (ctypes.byref(call_status),)
    result = fn(*args_with_error)
    _uniffi_check_call_status(error_ffi_converter, call_status)
    return result

def _uniffi_check_call_status(error_ffi_converter, call_status):
    if call_status.code == _UniffiRustCallStatus.CALL_SUCCESS:
        pass
    elif call_status.code == _UniffiRustCallStatus.CALL_ERROR:
        if error_ffi_converter is None:
            call_status.error_buf.free()
            raise InternalError("_uniffi_rust_call_with_error: CALL_ERROR, but error_ffi_converter is None")
        else:
            raise error_ffi_converter.lift(call_status.error_buf)
    elif call_status.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
        # When the rust code sees a panic, it tries to construct a _UniffiRustBuffer
        # with the message.  But if that code panics, then it just sends back
        # an empty buffer.
        if call_status.error_buf.len > 0:
            msg = _UniffiConverterString.lift(call_status.error_buf)
        else:
            msg = "Unknown rust panic"
        raise InternalError(msg)
    else:
        raise InternalError("Invalid _UniffiRustCallStatus code: {}".format(
            call_status.code))

def _uniffi_trait_interface_call(call_status, make_call, write_return_value):
    try:
        return write_return_value(make_call())
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))

def _uniffi_trait_interface_call_with_error(call_status, make_call, write_return_value, error_type, lower_error):
    try:
        try:
            return write_return_value(make_call())
        except error_type as e:
            call_status.code = _UniffiRustCallStatus.CALL_ERROR
            call_status.error_buf = lower_error(e)
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))
class _UniffiHandleMap:
    """
    A map where inserting, getting and removing data is synchronized with a lock.
    """

    def __init__(self):
        # type Handle = int
        self._map = {}  # type: Dict[Handle, Any]
        self._lock = threading.Lock()
        self._counter = itertools.count()

    def insert(self, obj):
        with self._lock:
            handle = next(self._counter)
            self._map[handle] = obj
            return handle

    def get(self, handle):
        try:
            with self._lock:
                return self._map[handle]
        except KeyError:
            raise InternalError("_UniffiHandleMap.get: Invalid handle")

    def remove(self, handle):
        try:
            with self._lock:
                return self._map.pop(handle)
        except KeyError:
            raise InternalError("_UniffiHandleMap.remove: Invalid handle")

    def __len__(self):
        return len(self._map)
# Types conforming to `_UniffiConverterPrimitive` pass themselves directly over the FFI.
class _UniffiConverterPrimitive:
    @classmethod
    def lift(cls, value):
        return value

    @classmethod
    def lower(cls, value):
        return value

class _UniffiConverterPrimitiveInt(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__index__()
        except Exception:
            raise TypeError("'{}' object cannot be interpreted as an integer".format(type(value).__name__))
        if not isinstance(value, int):
            raise TypeError("__index__ returned non-int (type {})".format(type(value).__name__))
        if not cls.VALUE_MIN <= value < cls.VALUE_MAX:
            raise ValueError("{} requires {} <= value < {}".format(cls.CLASS_NAME, cls.VALUE_MIN, cls.VALUE_MAX))

class _UniffiConverterPrimitiveFloat(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__float__()
        except Exception:
            raise TypeError("must be real number, not {}".format(type(value).__name__))
        if not isinstance(value, float):
            raise TypeError("__float__ returned non-float (type {})".format(type(value).__name__))

# Helper class for wrapper types that will always go through a _UniffiRustBuffer.
# Classes should inherit from this and implement the `read` and `write` static methods.
class _UniffiConverterRustBuffer:
    @classmethod
    def lift(cls, rbuf):
        with rbuf.consume_with_stream() as stream:
            return cls.read(stream)

    @classmethod
    def lower(cls, value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            cls.write(value, builder)
            return builder.finalize()

# Contains loading, initialization code, and the FFI Function declarations.
# Define some ctypes FFI types that we use in the library

"""
Function pointer for a Rust task, which a callback function that takes a opaque pointer
"""
_UNIFFI_RUST_TASK = ctypes.CFUNCTYPE(None, ctypes.c_void_p, ctypes.c_int8)

def _uniffi_future_callback_t(return_type):
    """
    Factory function to create callback function types for async functions
    """
    return ctypes.CFUNCTYPE(None, ctypes.c_uint64, return_type, _UniffiRustCallStatus)

def _uniffi_load_indirect():
    """
    This is how we find and load the dynamic library provided by the component.
    For now we just look it up by name.
    """
    if sys.platform == "darwin":
        libname = "lib{}.dylib"
    elif sys.platform.startswith("win"):
        # As of python3.8, ctypes does not seem to search $PATH when loading DLLs.
        # We could use `os.add_dll_directory` to configure the search path, but
        # it doesn't feel right to mess with application-wide settings. Let's
        # assume that the `.dll` is next to the `.py` file and load by full path.
        libname = os.path.join(
            os.path.dirname(__file__),
            "{}.dll",
        )
    else:
        # Anything else must be an ELF platform - Linux, *BSD, Solaris/illumos
        libname = "lib{}.so"

    libname = libname.format("zmanim_core")
    path = os.path.join(os.path.dirname(__file__), libname)
    lib = ctypes.cdll.LoadLibrary(path)
    return lib

def _uniffi_check_contract_api_version(lib):
    # Get the bindings contract version from our ComponentInterface
    bindings_contract_version = 26
    # Get the scaffolding contract version by calling the into the dylib
    scaffolding_contract_version = lib.ffi_zmanim_core_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version:
        raise InternalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")

def _uniffi_check_api_checksums(lib):
    if lib.uniffi_zmanim_core_checksum_func_new_astronomical_calendar() != 41832:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_func_new_complex_zmanim_calendar() != 15780:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_func_new_geolocation() != 28616:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_func_new_jewish_date() != 23873:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_func_new_noaa_calculator() != 1127:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_func_new_zmanim_calendar() != 19700:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_begin_astronomical_twilight() != 62489:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_begin_civil_twilight() != 56856:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_begin_nautical_twilight() != 60352:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_end_astronomical_twilight() != 7254:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_end_civil_twilight() != 53502:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_end_nautical_twilight() != 7547:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_geo_location() != 8696:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_noaa_calculator() != 20877:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sea_level_sunrise() != 64373:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sea_level_sunset() != 39697:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_solar_midnight() != 11473:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sun_transit() != 33500:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sun_transit_with_start_and_end_times() != 18808:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sunrise() != 26285:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sunrise_offset_by_degrees() != 63651:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sunset() != 36772:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sunset_offset_by_degrees() != 31916:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_temporal_hour() != 50743:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_temporal_hour_with_start_and_end_times() != 49651:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_timestamp() != 5457:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_utc_sea_level_sunrise() != 22630:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_utc_sea_level_sunset() != 23783:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_utc_sunrise() != 22626:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_utc_sunset() != 29434:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_120() != 48582:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_120_zmanis() != 25920:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_16_point_1_degrees() != 20901:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_18_degrees() != 23652:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_19_degrees() != 55481:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_19_point_8_degrees() != 4080:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_26_degrees() != 64809:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_60() != 47303:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_72_zmanis() != 50364:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_90() != 19837:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_90_zmanis() != 12400:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_96() != 21524:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_96_zmanis() != 36004:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_baal_hatanya() != 12575:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_astronomical_calendar() != 13876:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_ateret_torah_sunset_offset() != 7175:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_rt_13_point_24_degrees() != 2134:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_rt_13_point_5_minutes_before_7_point_083_degrees() != 35449:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_rt_2_stars() != 21245:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_rt_58_point_5_minutes() != 60329:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_yereim_13_point_5_minutes() != 49609:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_yereim_16_point_875_minutes() != 57416:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_yereim_18_minutes() != 21764:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_yereim_2_point_1_degrees() != 31971:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_yereim_2_point_8_degrees() != 52603:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_yereim_3_point_05_degrees() != 23744:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosrt_13_point_24_degrees() != 52444:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosrt_13_point_5_minutes_before_7_point_083_degrees() != 47710:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosrt_2_stars() != 37031:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosrt_58_point_5_minutes() != 30994:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosyereim_13_point_5_minutes() != 32816:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosyereim_16_point_875_minutes() != 2477:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosyereim_18_minutes() != 45356:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosyereim_2_point_1_degrees() != 54242:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosyereim_2_point_8_degrees() != 34750:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosyereim_3_point_05_degrees() != 42404:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_candle_lighting_offset() != 26485:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_fixed_local_chatzos() != 18084:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_fixed_local_chatzos_based_zmanim() != 3083:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_16_point_1_degrees() != 46680:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_30_minutes() != 29504:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_72_minutes() != 35627:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_ahavat_shalom() != 30157:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_ateret_torah() != 17467:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_baal_hatanya() != 49576:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_baal_hatanya_greater_than_30() != 13677:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_gra_fixed_local_chatzos_30_minutes() != 56007:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_greater_than_30() != 14350:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_ketana_16_point_1_degrees() != 51580:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_ketana_72_minutes() != 49765:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_ketana_ahavat_shalom() != 51101:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_ketana_ateret_torah() != 52689:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_ketana_baal_hatanya() != 12508:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_ketana_gra_fixed_local_chatzos_to_sunset() != 9807:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_misheyakir_10_point_2_degrees() != 58955:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_misheyakir_11_degrees() != 48093:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_misheyakir_11_point_5_degrees() != 47599:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_misheyakir_7_point_65_degrees() != 40310:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_misheyakir_9_point_5_degrees() != 605:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_ahavat_shalom() != 62525:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_alos_16_point_1_to_tzais_geonim_7_point_083_degrees() != 64193:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_alos_to_sunset() != 59347:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_120_minutes() != 48573:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_120_minutes_zmanis() != 51079:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_16_point_1_degrees() != 41190:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_18_degrees() != 16664:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_19_point_8_degrees() != 53540:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_26_degrees() != 25526:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_60_minutes() != 558:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_72_minutes() != 25979:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_72_minutes_zmanis() != 57762:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_90_minutes() != 18702:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_90_minutes_zmanis() != 2976:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_96_minutes() != 52628:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_96_minutes_zmanis() != 32732:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_ateret_torah() != 41470:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_baal_hatanya() != 6323:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_gra_fixed_local_chatzos_to_sunset() != 13895:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_samuch_le_mincha_ketana_16_point_1_degrees() != 35373:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_samuch_le_mincha_ketana_72_minutes() != 4572:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_samuch_le_mincha_ketana_gra() != 38016:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_120_minutes() != 10814:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_120_minutes_zmanis() != 62946:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_16_point_1_degrees() != 43475:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_18_degrees() != 52852:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_19_point_8_degrees() != 30492:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_26_degrees() != 3749:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_60_minutes() != 42906:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_72_minutes() != 2556:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_72_minutes_zmanis() != 40431:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_90_minutes() != 43283:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_90_minutes_zmanis() != 34655:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_96_minutes() != 64111:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_96_minutes_zmanis() != 49232:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_alos_16_point_1_to_tzais_3_point_7() != 42532:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_alos_16_point_1_to_tzais_3_point_8() != 4104:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_ateret_torah() != 18786:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_baal_hatanya() != 7832:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_baal_hatanya() != 9370:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_gra() != 8758:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_mga_16_point_1_degrees() != 27003:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_mga_72_minutes() != 52878:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_mga_72_minutes_zmanis() != 8958:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_biur_chametz_baal_hatanya() != 54751:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_biur_chametz_gra() != 26192:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_biur_chametz_mga_16_point_1_degrees() != 55899:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_biur_chametz_mga_72_minutes() != 14723:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_biur_chametz_mga_72_minutes_zmanis() != 46863:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_kidush_levana_15_days() != 40848:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_kidush_levana_15_days_default() != 40468:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_kidush_levana_between_moldos() != 20960:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_kidush_levana_between_moldos_default() != 8680:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_3_hours_before_chatzos() != 7200:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_alos_16_point_1_to_sunset() != 37150:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_alos_16_point_1_to_tzais_geonim_7_point_083_degrees() != 8206:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_ateret_torah() != 8518:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_baal_hatanya() != 18486:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_fixed_local() != 16063:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_gra_sunrise_to_fixed_local_chatzos() != 58695:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_kol_eliyahu() != 17817:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_120_minutes() != 51894:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_16_point_1_degrees() != 62121:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_16_point_1_degrees_to_fixed_local_chatzos() != 24402:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_18_degrees() != 25825:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_18_degrees_to_fixed_local_chatzos() != 4464:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_19_point_8_degrees() != 41385:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_72_minutes() != 40558:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_72_minutes_to_fixed_local_chatzos() != 16594:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_72_minutes_zmanis() != 19288:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_90_minutes() != 28107:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_90_minutes_to_fixed_local_chatzos() != 50933:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_90_minutes_zmanis() != 2652:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_96_minutes() != 20485:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_96_minutes_zmanis() != 62040:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_2_hours_before_chatzos() != 54480:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_ateret_torah() != 34025:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_baal_hatanya() != 59083:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_fixed_local() != 44319:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_gra_sunrise_to_fixed_local_chatzos() != 54477:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_120_minutes() != 3137:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_16_point_1_degrees() != 55912:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_18_degrees() != 39612:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_19_point_8_degrees() != 309:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_72_minutes() != 54692:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_72_minutes_zmanis() != 51829:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_90_minutes() != 22866:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_90_minutes_zmanis() != 41522:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_96_minutes() != 62775:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_96_minutes_zmanis() != 25086:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfilah_ateret_torah() != 62677:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_3_days() != 27286:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_3_days_with_times() != 31605:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_7_days() != 45982:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_7_days_default() != 38286:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_120() != 52832:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_120_zmanis() != 61796:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_16_point_1_degrees() != 49788:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_18_degrees() != 45922:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_19_point_8_degrees() != 5829:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_26_degrees() != 11870:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_50() != 17943:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_60() != 31840:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_72_zmanis() != 34591:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_90() != 41989:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_90_zmanis() != 5800:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_96() != 11807:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_96_zmanis() != 2711:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_ateret_torah() != 59206:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_baal_hatanya() != 16596:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_3_point_65_degrees() != 43653:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_3_point_676_degrees() != 23197:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_3_point_7_degrees() != 23058:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_3_point_8_degrees() != 18091:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_4_point_37_degrees() != 64877:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_4_point_61_degrees() != 25702:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_4_point_8_degrees() != 11242:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_5_point_88_degrees() != 44153:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_5_point_95_degrees() != 31751:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_6_point_45_degrees() != 59135:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_7_point_083_degrees() != 48808:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_7_point_67_degrees() != 18226:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_8_point_5_degrees() != 65499:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_9_point_3_degrees() != 60242:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_9_point_75_degrees() != 61681:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_use_astronomical_chatzos() != 35399:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_use_astronomical_chatzos_for_other_zmanim() != 14721:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_zman_molad() != 44122:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_geolocation_geodesic_distance() != 62033:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_geolocation_geodesic_final_bearing() != 27490:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_geolocation_geodesic_initial_bearing() != 36808:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_geolocation_get_elevation() != 53256:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_geolocation_get_latitude() != 11900:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_geolocation_get_longitude() != 53669:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_geolocation_rhumb_line_bearing() != 21906:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_geolocation_rhumb_line_distance() != 18055:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_geolocation_vincenty_inverse_formula() != 57718:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_bavli_daf_yomi() != 54974:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_day_of_chanukah() != 52566:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_day_of_omer() != 26068:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_in_israel() != 20250:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_jewish_date() != 39592:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_parshah() != 3074:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_use_modern_holidays() != 23527:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_yom_tov_index() != 50909:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_has_candle_lighting() != 40482:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_aseres_yemei_teshuva() != 64432:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_assur_bemelacha() != 11688:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_chanukah() != 12392:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_chol_hamoed() != 32230:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_chol_hamoed_pesach() != 26780:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_chol_hamoed_succos() != 7096:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_erev_yom_tov() != 49090:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_erev_yom_tov_sheni() != 14387:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_hoshana_rabba() != 1316:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_isru_chag() != 35283:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_pesach() != 3826:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_purim() != 16100:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_rosh_chodesh() != 8221:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_rosh_hashana() != 15876:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_shavuos() != 51728:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_shemini_atzeres() != 17118:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_simchas_torah() != 48466:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_succos() != 36900:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_taanis() != 12867:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_taanis_bechoros() != 44134:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_tisha_beav() != 65009:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_tomorrow_shabbos_or_yom_tov() != 52722:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_yom_kippur() != 7664:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_yom_tov() != 41380:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_yom_tov_assur_bemelacha() != 15967:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishdate_get_chalakim_since_molad_tohu() != 56202:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishdate_get_cheshvan_kislev_kviah() != 51674:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishdate_get_day_of_week() != 55271:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishdate_get_days_in_jewish_month() != 19694:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishdate_get_days_in_jewish_year() != 19713:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishdate_get_days_since_start_of_jewish_year() != 50707:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishdate_get_gregorian_day_of_month() != 22662:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishdate_get_gregorian_month() != 18768:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishdate_get_gregorian_year() != 24044:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishdate_get_jewish_day_of_month() != 32340:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishdate_get_jewish_month() != 59238:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishdate_get_jewish_year() != 39347:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishdate_get_molad_data() != 29846:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishdate_get_molad_date() != 32020:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishdate_is_cheshvan_long() != 42144:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishdate_is_jewish_leap_year() != 49033:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_jewishdate_is_kislev_short() != 44688:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_noaacalculator_get_solar_azimuth() != 65501:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_noaacalculator_get_solar_elevation() != 36899:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_noaacalculator_get_utc_midnight() != 14576:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_noaacalculator_get_utc_noon() != 43731:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_noaacalculator_get_utc_sunrise() != 10089:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_noaacalculator_get_utc_sunset() != 58722:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar__get_mincha_gedola() != 6028:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar__get_mincha_ketana() != 60269:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar__get_plag_hamincha() != 63219:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar__get_samuch_le_mincha_ketana() != 3882:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar__get_sof_zman_shma() != 10834:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar__get_sof_zman_tfila() != 9134:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_alos72() != 36744:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_alos_hashachar() != 57562:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_astronomical_calendar() != 28643:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_candle_lighting() != 57067:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_candle_lighting_offset() != 18649:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_chatzos() != 28341:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_chatzos_as_half_day() != 2021:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_half_day_based_shaah_zmanis() != 64353:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_half_day_based_zman() != 38483:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_mincha_gedola_default() != 43718:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_mincha_gedola_simple() != 25011:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_mincha_ketana_default() != 1744:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_mincha_ketana_simple() != 55145:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_percent_of_shaah_zmanis_from_degrees() != 65181:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_plag_hamincha_default() != 6441:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_plag_hamincha_simple() != 25025:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_samuch_le_mincha_ketana_simple() != 57139:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_shaah_zmanis_based_zman() != 28559:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_shaah_zmanis_gra() != 63034:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_shaah_zmanis_mga() != 20604:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_sof_zman_shma_gra() != 48994:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_sof_zman_shma_mga() != 47235:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_sof_zman_shma_simple() != 18087:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_sof_zman_tfila_gra() != 3389:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_sof_zman_tfila_mga() != 23676:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_sof_zman_tfila_simple() != 63288:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_tzais() != 24640:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_tzais72() != 51548:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_use_astronomical_chatzos() != 27733:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_use_astronomical_chatzos_for_other_zmanim() != 58719:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")

# A ctypes library to expose the extern-C FFI definitions.
# This is an implementation detail which will be called internally by the public API.

_UniffiLib = _uniffi_load_indirect()
_UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK = ctypes.CFUNCTYPE(None,ctypes.c_uint64,ctypes.c_int8,
)
_UNIFFI_FOREIGN_FUTURE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
_UNIFFI_CALLBACK_INTERFACE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
class _UniffiForeignFuture(ctypes.Structure):
    _fields_ = [
        ("handle", ctypes.c_uint64),
        ("free", _UNIFFI_FOREIGN_FUTURE_FREE),
    ]
class _UniffiForeignFutureStructU8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU8,
)
class _UniffiForeignFutureStructI8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI8,
)
class _UniffiForeignFutureStructU16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU16,
)
class _UniffiForeignFutureStructI16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI16,
)
class _UniffiForeignFutureStructU32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU32,
)
class _UniffiForeignFutureStructI32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI32,
)
class _UniffiForeignFutureStructU64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU64,
)
class _UniffiForeignFutureStructI64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI64,
)
class _UniffiForeignFutureStructF32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_float),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF32,
)
class _UniffiForeignFutureStructF64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_double),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF64,
)
class _UniffiForeignFutureStructPointer(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_void_p),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_POINTER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructPointer,
)
class _UniffiForeignFutureStructRustBuffer(ctypes.Structure):
    _fields_ = [
        ("return_value", _UniffiRustBuffer),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_RUST_BUFFER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructRustBuffer,
)
class _UniffiForeignFutureStructVoid(ctypes.Structure):
    _fields_ = [
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_VOID = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructVoid,
)
_UniffiLib.uniffi_zmanim_core_fn_clone_astronomicalcalculator.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_clone_astronomicalcalculator.restype = ctypes.c_void_p
_UniffiLib.uniffi_zmanim_core_fn_free_astronomicalcalculator.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_free_astronomicalcalculator.restype = None
_UniffiLib.uniffi_zmanim_core_fn_clone_astronomicalcalendar.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_clone_astronomicalcalendar.restype = ctypes.c_void_p
_UniffiLib.uniffi_zmanim_core_fn_free_astronomicalcalendar.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_free_astronomicalcalendar.restype = None
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_begin_astronomical_twilight.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_begin_astronomical_twilight.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_begin_civil_twilight.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_begin_civil_twilight.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_begin_nautical_twilight.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_begin_nautical_twilight.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_end_astronomical_twilight.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_end_astronomical_twilight.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_end_civil_twilight.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_end_civil_twilight.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_end_nautical_twilight.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_end_nautical_twilight.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_geo_location.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_geo_location.restype = ctypes.c_void_p
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_noaa_calculator.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_noaa_calculator.restype = ctypes.c_void_p
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sea_level_sunrise.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sea_level_sunrise.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sea_level_sunset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sea_level_sunset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_solar_midnight.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_solar_midnight.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sun_transit.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sun_transit.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sun_transit_with_start_and_end_times.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.c_int64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sun_transit_with_start_and_end_times.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sunrise.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sunrise.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sunrise_offset_by_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.c_double,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sunrise_offset_by_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sunset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sunset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sunset_offset_by_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.c_double,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sunset_offset_by_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_temporal_hour.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_temporal_hour.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_temporal_hour_with_start_and_end_times.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.c_int64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_temporal_hour_with_start_and_end_times.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_timestamp.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_timestamp.restype = ctypes.c_int64
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_utc_sea_level_sunrise.argtypes = (
    ctypes.c_void_p,
    ctypes.c_double,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_utc_sea_level_sunrise.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_utc_sea_level_sunset.argtypes = (
    ctypes.c_void_p,
    ctypes.c_double,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_utc_sea_level_sunset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_utc_sunrise.argtypes = (
    ctypes.c_void_p,
    ctypes.c_double,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_utc_sunrise.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_utc_sunset.argtypes = (
    ctypes.c_void_p,
    ctypes.c_double,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_utc_sunset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_clone_bavlidaf.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_clone_bavlidaf.restype = ctypes.c_void_p
_UniffiLib.uniffi_zmanim_core_fn_free_bavlidaf.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_free_bavlidaf.restype = None
_UniffiLib.uniffi_zmanim_core_fn_clone_complexzmanimcalendar.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_clone_complexzmanimcalendar.restype = ctypes.c_void_p
_UniffiLib.uniffi_zmanim_core_fn_free_complexzmanimcalendar.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_free_complexzmanimcalendar.restype = None
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_120.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_120.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_120_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_120_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_16_point_1_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_16_point_1_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_18_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_18_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_19_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_19_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_19_point_8_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_19_point_8_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_26_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_26_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_60.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_60.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_72_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_72_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_90.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_90.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_90_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_90_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_96.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_96.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_96_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_96_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_baal_hatanya.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_baal_hatanya.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_astronomical_calendar.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_astronomical_calendar.restype = ctypes.c_void_p
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_ateret_torah_sunset_offset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_ateret_torah_sunset_offset.restype = ctypes.c_int64
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_rt_13_point_24_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_rt_13_point_24_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_rt_13_point_5_minutes_before_7_point_083_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_rt_13_point_5_minutes_before_7_point_083_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_rt_2_stars.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_rt_2_stars.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_rt_58_point_5_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_rt_58_point_5_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_yereim_13_point_5_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_yereim_13_point_5_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_yereim_16_point_875_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_yereim_16_point_875_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_yereim_18_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_yereim_18_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_yereim_2_point_1_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_yereim_2_point_1_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_yereim_2_point_8_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_yereim_2_point_8_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_yereim_3_point_05_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_yereim_3_point_05_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosrt_13_point_24_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosrt_13_point_24_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosrt_13_point_5_minutes_before_7_point_083_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosrt_13_point_5_minutes_before_7_point_083_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosrt_2_stars.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosrt_2_stars.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosrt_58_point_5_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosrt_58_point_5_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosyereim_13_point_5_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosyereim_13_point_5_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosyereim_16_point_875_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosyereim_16_point_875_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosyereim_18_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosyereim_18_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosyereim_2_point_1_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosyereim_2_point_1_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosyereim_2_point_8_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosyereim_2_point_8_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosyereim_3_point_05_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosyereim_3_point_05_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_candle_lighting_offset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_candle_lighting_offset.restype = ctypes.c_int64
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_fixed_local_chatzos.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_fixed_local_chatzos.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_fixed_local_chatzos_based_zmanim.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.c_int64,
    ctypes.c_double,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_fixed_local_chatzos_based_zmanim.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_16_point_1_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_16_point_1_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_30_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_30_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_72_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_72_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_ahavat_shalom.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_ahavat_shalom.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_ateret_torah.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_ateret_torah.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_baal_hatanya.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_baal_hatanya.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_baal_hatanya_greater_than_30.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_baal_hatanya_greater_than_30.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_gra_fixed_local_chatzos_30_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_gra_fixed_local_chatzos_30_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_greater_than_30.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_greater_than_30.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_ketana_16_point_1_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_ketana_16_point_1_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_ketana_72_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_ketana_72_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_ketana_ahavat_shalom.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_ketana_ahavat_shalom.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_ketana_ateret_torah.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_ketana_ateret_torah.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_ketana_baal_hatanya.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_ketana_baal_hatanya.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_ketana_gra_fixed_local_chatzos_to_sunset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_ketana_gra_fixed_local_chatzos_to_sunset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_misheyakir_10_point_2_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_misheyakir_10_point_2_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_misheyakir_11_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_misheyakir_11_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_misheyakir_11_point_5_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_misheyakir_11_point_5_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_misheyakir_7_point_65_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_misheyakir_7_point_65_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_misheyakir_9_point_5_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_misheyakir_9_point_5_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_ahavat_shalom.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_ahavat_shalom.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_alos_16_point_1_to_tzais_geonim_7_point_083_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_alos_16_point_1_to_tzais_geonim_7_point_083_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_alos_to_sunset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_alos_to_sunset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_120_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_120_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_120_minutes_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_120_minutes_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_16_point_1_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_16_point_1_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_18_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_18_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_19_point_8_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_19_point_8_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_26_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_26_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_60_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_60_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_72_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_72_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_72_minutes_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_72_minutes_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_90_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_90_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_90_minutes_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_90_minutes_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_96_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_96_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_96_minutes_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_96_minutes_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_ateret_torah.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_ateret_torah.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_baal_hatanya.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_baal_hatanya.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_gra_fixed_local_chatzos_to_sunset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_gra_fixed_local_chatzos_to_sunset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_samuch_le_mincha_ketana_16_point_1_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_samuch_le_mincha_ketana_16_point_1_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_samuch_le_mincha_ketana_72_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_samuch_le_mincha_ketana_72_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_samuch_le_mincha_ketana_gra.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_samuch_le_mincha_ketana_gra.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_120_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_120_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_120_minutes_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_120_minutes_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_16_point_1_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_16_point_1_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_18_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_18_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_19_point_8_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_19_point_8_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_26_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_26_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_60_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_60_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_72_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_72_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_72_minutes_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_72_minutes_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_90_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_90_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_90_minutes_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_90_minutes_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_96_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_96_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_96_minutes_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_96_minutes_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_alos_16_point_1_to_tzais_3_point_7.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_alos_16_point_1_to_tzais_3_point_7.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_alos_16_point_1_to_tzais_3_point_8.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_alos_16_point_1_to_tzais_3_point_8.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_ateret_torah.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_ateret_torah.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_baal_hatanya.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_baal_hatanya.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_baal_hatanya.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_baal_hatanya.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_gra.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_gra.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_mga_16_point_1_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_mga_16_point_1_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_mga_72_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_mga_72_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_mga_72_minutes_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_mga_72_minutes_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_biur_chametz_baal_hatanya.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_biur_chametz_baal_hatanya.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_biur_chametz_gra.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_biur_chametz_gra.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_biur_chametz_mga_16_point_1_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_biur_chametz_mga_16_point_1_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_biur_chametz_mga_72_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_biur_chametz_mga_72_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_biur_chametz_mga_72_minutes_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_biur_chametz_mga_72_minutes_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_kidush_levana_15_days.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_kidush_levana_15_days.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_kidush_levana_15_days_default.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_kidush_levana_15_days_default.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_kidush_levana_between_moldos.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_kidush_levana_between_moldos.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_kidush_levana_between_moldos_default.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_kidush_levana_between_moldos_default.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_3_hours_before_chatzos.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_3_hours_before_chatzos.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_alos_16_point_1_to_sunset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_alos_16_point_1_to_sunset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_alos_16_point_1_to_tzais_geonim_7_point_083_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_alos_16_point_1_to_tzais_geonim_7_point_083_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_ateret_torah.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_ateret_torah.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_baal_hatanya.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_baal_hatanya.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_fixed_local.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_fixed_local.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_gra_sunrise_to_fixed_local_chatzos.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_gra_sunrise_to_fixed_local_chatzos.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_kol_eliyahu.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_kol_eliyahu.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_120_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_120_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_16_point_1_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_16_point_1_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_16_point_1_degrees_to_fixed_local_chatzos.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_16_point_1_degrees_to_fixed_local_chatzos.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_18_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_18_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_18_degrees_to_fixed_local_chatzos.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_18_degrees_to_fixed_local_chatzos.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_19_point_8_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_19_point_8_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_72_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_72_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_72_minutes_to_fixed_local_chatzos.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_72_minutes_to_fixed_local_chatzos.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_72_minutes_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_72_minutes_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_90_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_90_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_90_minutes_to_fixed_local_chatzos.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_90_minutes_to_fixed_local_chatzos.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_90_minutes_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_90_minutes_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_96_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_96_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_96_minutes_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_96_minutes_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_2_hours_before_chatzos.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_2_hours_before_chatzos.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_ateret_torah.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_ateret_torah.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_baal_hatanya.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_baal_hatanya.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_fixed_local.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_fixed_local.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_gra_sunrise_to_fixed_local_chatzos.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_gra_sunrise_to_fixed_local_chatzos.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_120_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_120_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_16_point_1_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_16_point_1_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_18_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_18_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_19_point_8_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_19_point_8_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_72_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_72_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_72_minutes_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_72_minutes_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_90_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_90_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_90_minutes_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_90_minutes_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_96_minutes.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_96_minutes.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_96_minutes_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_96_minutes_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfilah_ateret_torah.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfilah_ateret_torah.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_3_days.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_3_days.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_3_days_with_times.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_3_days_with_times.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_7_days.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_7_days.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_7_days_default.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_7_days_default.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_120.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_120.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_120_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_120_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_16_point_1_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_16_point_1_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_18_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_18_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_19_point_8_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_19_point_8_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_26_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_26_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_50.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_50.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_60.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_60.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_72_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_72_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_90.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_90.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_90_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_90_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_96.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_96.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_96_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_96_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_ateret_torah.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_ateret_torah.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_baal_hatanya.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_baal_hatanya.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_3_point_65_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_3_point_65_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_3_point_676_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_3_point_676_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_3_point_7_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_3_point_7_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_3_point_8_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_3_point_8_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_4_point_37_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_4_point_37_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_4_point_61_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_4_point_61_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_4_point_8_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_4_point_8_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_5_point_88_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_5_point_88_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_5_point_95_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_5_point_95_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_6_point_45_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_6_point_45_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_7_point_083_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_7_point_083_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_7_point_67_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_7_point_67_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_8_point_5_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_8_point_5_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_9_point_3_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_9_point_3_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_9_point_75_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_9_point_75_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_use_astronomical_chatzos.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_use_astronomical_chatzos.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_use_astronomical_chatzos_for_other_zmanim.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_use_astronomical_chatzos_for_other_zmanim.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_zman_molad.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_zman_molad.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_clone_geolocation.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_clone_geolocation.restype = ctypes.c_void_p
_UniffiLib.uniffi_zmanim_core_fn_free_geolocation.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_free_geolocation.restype = None
_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_geodesic_distance.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_geodesic_distance.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_geodesic_final_bearing.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_geodesic_final_bearing.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_geodesic_initial_bearing.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_geodesic_initial_bearing.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_get_elevation.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_get_elevation.restype = ctypes.c_double
_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_get_latitude.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_get_latitude.restype = ctypes.c_double
_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_get_longitude.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_get_longitude.restype = ctypes.c_double
_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_rhumb_line_bearing.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_rhumb_line_bearing.restype = ctypes.c_double
_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_rhumb_line_distance.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_rhumb_line_distance.restype = ctypes.c_double
_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_vincenty_inverse_formula.argtypes = (
    ctypes.c_void_p,
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_vincenty_inverse_formula.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_clone_jewishcalendar.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_clone_jewishcalendar.restype = ctypes.c_void_p
_UniffiLib.uniffi_zmanim_core_fn_free_jewishcalendar.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_free_jewishcalendar.restype = None
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_bavli_daf_yomi.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_bavli_daf_yomi.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_day_of_chanukah.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_day_of_chanukah.restype = ctypes.c_int32
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_day_of_omer.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_day_of_omer.restype = ctypes.c_int32
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_in_israel.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_in_israel.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_jewish_date.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_jewish_date.restype = ctypes.c_void_p
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_parshah.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_parshah.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_use_modern_holidays.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_use_modern_holidays.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_yom_tov_index.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_yom_tov_index.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_has_candle_lighting.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_has_candle_lighting.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_aseres_yemei_teshuva.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_aseres_yemei_teshuva.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_assur_bemelacha.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_assur_bemelacha.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_chanukah.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_chanukah.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_chol_hamoed.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_chol_hamoed.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_chol_hamoed_pesach.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_chol_hamoed_pesach.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_chol_hamoed_succos.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_chol_hamoed_succos.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_erev_yom_tov.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_erev_yom_tov.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_erev_yom_tov_sheni.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_erev_yom_tov_sheni.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_hoshana_rabba.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_hoshana_rabba.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_isru_chag.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_isru_chag.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_pesach.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_pesach.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_purim.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_purim.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_rosh_chodesh.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_rosh_chodesh.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_rosh_hashana.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_rosh_hashana.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_shavuos.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_shavuos.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_shemini_atzeres.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_shemini_atzeres.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_simchas_torah.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_simchas_torah.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_succos.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_succos.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_taanis.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_taanis.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_taanis_bechoros.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_taanis_bechoros.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_tisha_beav.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_tisha_beav.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_tomorrow_shabbos_or_yom_tov.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_tomorrow_shabbos_or_yom_tov.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_yom_kippur.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_yom_kippur.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_yom_tov.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_yom_tov.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_yom_tov_assur_bemelacha.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_yom_tov_assur_bemelacha.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_clone_jewishdate.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_clone_jewishdate.restype = ctypes.c_void_p
_UniffiLib.uniffi_zmanim_core_fn_free_jewishdate.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_free_jewishdate.restype = None
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_chalakim_since_molad_tohu.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_chalakim_since_molad_tohu.restype = ctypes.c_int64
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_cheshvan_kislev_kviah.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_cheshvan_kislev_kviah.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_day_of_week.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_day_of_week.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_days_in_jewish_month.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_days_in_jewish_month.restype = ctypes.c_int32
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_days_in_jewish_year.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_days_in_jewish_year.restype = ctypes.c_int32
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_days_since_start_of_jewish_year.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_days_since_start_of_jewish_year.restype = ctypes.c_int32
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_gregorian_day_of_month.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_gregorian_day_of_month.restype = ctypes.c_int32
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_gregorian_month.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_gregorian_month.restype = ctypes.c_int32
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_gregorian_year.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_gregorian_year.restype = ctypes.c_int32
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_jewish_day_of_month.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_jewish_day_of_month.restype = ctypes.c_int32
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_jewish_month.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_jewish_month.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_jewish_year.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_jewish_year.restype = ctypes.c_int32
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_molad_data.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_molad_data.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_molad_date.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_molad_date.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_is_cheshvan_long.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_is_cheshvan_long.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_is_jewish_leap_year.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_is_jewish_leap_year.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_is_kislev_short.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_is_kislev_short.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_clone_moladdata.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_clone_moladdata.restype = ctypes.c_void_p
_UniffiLib.uniffi_zmanim_core_fn_free_moladdata.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_free_moladdata.restype = None
_UniffiLib.uniffi_zmanim_core_fn_clone_noaacalculator.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_clone_noaacalculator.restype = ctypes.c_void_p
_UniffiLib.uniffi_zmanim_core_fn_free_noaacalculator.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_free_noaacalculator.restype = None
_UniffiLib.uniffi_zmanim_core_fn_method_noaacalculator_get_solar_azimuth.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_noaacalculator_get_solar_azimuth.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_noaacalculator_get_solar_elevation.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_noaacalculator_get_solar_elevation.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_noaacalculator_get_utc_midnight.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_noaacalculator_get_utc_midnight.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_noaacalculator_get_utc_noon.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_noaacalculator_get_utc_noon.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_noaacalculator_get_utc_sunrise.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.c_void_p,
    ctypes.c_double,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_noaacalculator_get_utc_sunrise.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_noaacalculator_get_utc_sunset.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.c_void_p,
    ctypes.c_double,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_noaacalculator_get_utc_sunset.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_clone_zmanimcalendar.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_clone_zmanimcalendar.restype = ctypes.c_void_p
_UniffiLib.uniffi_zmanim_core_fn_free_zmanimcalendar.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_free_zmanimcalendar.restype = None
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar__get_mincha_gedola.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_int64,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar__get_mincha_gedola.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar__get_mincha_ketana.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_int64,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar__get_mincha_ketana.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar__get_plag_hamincha.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_int64,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar__get_plag_hamincha.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar__get_samuch_le_mincha_ketana.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.c_int64,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar__get_samuch_le_mincha_ketana.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar__get_sof_zman_shma.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    _UniffiRustBuffer,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar__get_sof_zman_shma.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar__get_sof_zman_tfila.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    _UniffiRustBuffer,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar__get_sof_zman_tfila.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_alos72.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_alos72.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_alos_hashachar.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_alos_hashachar.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_astronomical_calendar.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_astronomical_calendar.restype = ctypes.c_void_p
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_candle_lighting.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_candle_lighting.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_candle_lighting_offset.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_candle_lighting_offset.restype = ctypes.c_int64
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_chatzos.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_chatzos.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_chatzos_as_half_day.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_chatzos_as_half_day.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_half_day_based_shaah_zmanis.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.c_int64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_half_day_based_shaah_zmanis.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_half_day_based_zman.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.c_int64,
    ctypes.c_double,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_half_day_based_zman.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_mincha_gedola_default.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_mincha_gedola_default.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_mincha_gedola_simple.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.c_int64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_mincha_gedola_simple.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_mincha_ketana_default.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_mincha_ketana_default.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_mincha_ketana_simple.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.c_int64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_mincha_ketana_simple.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_percent_of_shaah_zmanis_from_degrees.argtypes = (
    ctypes.c_void_p,
    ctypes.c_double,
    ctypes.c_int8,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_percent_of_shaah_zmanis_from_degrees.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_plag_hamincha_default.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_plag_hamincha_default.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_plag_hamincha_simple.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.c_int64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_plag_hamincha_simple.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_samuch_le_mincha_ketana_simple.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.c_int64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_samuch_le_mincha_ketana_simple.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_shaah_zmanis_based_zman.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.c_int64,
    ctypes.c_double,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_shaah_zmanis_based_zman.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_shaah_zmanis_gra.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_shaah_zmanis_gra.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_shaah_zmanis_mga.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_shaah_zmanis_mga.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_sof_zman_shma_gra.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_sof_zman_shma_gra.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_sof_zman_shma_mga.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_sof_zman_shma_mga.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_sof_zman_shma_simple.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.c_int64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_sof_zman_shma_simple.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_sof_zman_tfila_gra.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_sof_zman_tfila_gra.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_sof_zman_tfila_mga.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_sof_zman_tfila_mga.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_sof_zman_tfila_simple.argtypes = (
    ctypes.c_void_p,
    ctypes.c_int64,
    ctypes.c_int64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_sof_zman_tfila_simple.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_tzais.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_tzais.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_tzais72.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_tzais72.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_use_astronomical_chatzos.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_use_astronomical_chatzos.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_use_astronomical_chatzos_for_other_zmanim.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_use_astronomical_chatzos_for_other_zmanim.restype = ctypes.c_int8
_UniffiLib.uniffi_zmanim_core_fn_func_new_astronomical_calendar.argtypes = (
    ctypes.c_int64,
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_func_new_astronomical_calendar.restype = ctypes.c_void_p
_UniffiLib.uniffi_zmanim_core_fn_func_new_complex_zmanim_calendar.argtypes = (
    ctypes.c_int64,
    ctypes.c_void_p,
    ctypes.c_int8,
    ctypes.c_int8,
    ctypes.c_int64,
    ctypes.c_int64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_func_new_complex_zmanim_calendar.restype = ctypes.c_void_p
_UniffiLib.uniffi_zmanim_core_fn_func_new_geolocation.argtypes = (
    ctypes.c_double,
    ctypes.c_double,
    ctypes.c_double,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_func_new_geolocation.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_func_new_jewish_date.argtypes = (
    ctypes.c_int64,
    ctypes.c_int64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_func_new_jewish_date.restype = _UniffiRustBuffer
_UniffiLib.uniffi_zmanim_core_fn_func_new_noaa_calculator.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_func_new_noaa_calculator.restype = ctypes.c_void_p
_UniffiLib.uniffi_zmanim_core_fn_func_new_zmanim_calendar.argtypes = (
    ctypes.c_int64,
    ctypes.c_void_p,
    ctypes.c_int8,
    ctypes.c_int8,
    ctypes.c_int64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_zmanim_core_fn_func_new_zmanim_calendar.restype = ctypes.c_void_p
_UniffiLib.ffi_zmanim_core_rustbuffer_alloc.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_zmanim_core_rustbuffer_alloc.restype = _UniffiRustBuffer
_UniffiLib.ffi_zmanim_core_rustbuffer_from_bytes.argtypes = (
    _UniffiForeignBytes,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_zmanim_core_rustbuffer_from_bytes.restype = _UniffiRustBuffer
_UniffiLib.ffi_zmanim_core_rustbuffer_free.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_zmanim_core_rustbuffer_free.restype = None
_UniffiLib.ffi_zmanim_core_rustbuffer_reserve.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_zmanim_core_rustbuffer_reserve.restype = _UniffiRustBuffer
_UniffiLib.ffi_zmanim_core_rust_future_poll_u8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_poll_u8.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_cancel_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_cancel_u8.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_free_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_free_u8.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_complete_u8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_zmanim_core_rust_future_complete_u8.restype = ctypes.c_uint8
_UniffiLib.ffi_zmanim_core_rust_future_poll_i8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_poll_i8.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_cancel_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_cancel_i8.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_free_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_free_i8.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_complete_i8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_zmanim_core_rust_future_complete_i8.restype = ctypes.c_int8
_UniffiLib.ffi_zmanim_core_rust_future_poll_u16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_poll_u16.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_cancel_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_cancel_u16.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_free_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_free_u16.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_complete_u16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_zmanim_core_rust_future_complete_u16.restype = ctypes.c_uint16
_UniffiLib.ffi_zmanim_core_rust_future_poll_i16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_poll_i16.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_cancel_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_cancel_i16.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_free_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_free_i16.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_complete_i16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_zmanim_core_rust_future_complete_i16.restype = ctypes.c_int16
_UniffiLib.ffi_zmanim_core_rust_future_poll_u32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_poll_u32.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_cancel_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_cancel_u32.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_free_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_free_u32.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_complete_u32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_zmanim_core_rust_future_complete_u32.restype = ctypes.c_uint32
_UniffiLib.ffi_zmanim_core_rust_future_poll_i32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_poll_i32.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_cancel_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_cancel_i32.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_free_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_free_i32.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_complete_i32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_zmanim_core_rust_future_complete_i32.restype = ctypes.c_int32
_UniffiLib.ffi_zmanim_core_rust_future_poll_u64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_poll_u64.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_cancel_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_cancel_u64.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_free_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_free_u64.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_complete_u64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_zmanim_core_rust_future_complete_u64.restype = ctypes.c_uint64
_UniffiLib.ffi_zmanim_core_rust_future_poll_i64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_poll_i64.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_cancel_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_cancel_i64.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_free_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_free_i64.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_complete_i64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_zmanim_core_rust_future_complete_i64.restype = ctypes.c_int64
_UniffiLib.ffi_zmanim_core_rust_future_poll_f32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_poll_f32.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_cancel_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_cancel_f32.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_free_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_free_f32.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_complete_f32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_zmanim_core_rust_future_complete_f32.restype = ctypes.c_float
_UniffiLib.ffi_zmanim_core_rust_future_poll_f64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_poll_f64.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_cancel_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_cancel_f64.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_free_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_free_f64.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_complete_f64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_zmanim_core_rust_future_complete_f64.restype = ctypes.c_double
_UniffiLib.ffi_zmanim_core_rust_future_poll_pointer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_poll_pointer.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_cancel_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_cancel_pointer.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_free_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_free_pointer.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_complete_pointer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_zmanim_core_rust_future_complete_pointer.restype = ctypes.c_void_p
_UniffiLib.ffi_zmanim_core_rust_future_poll_rust_buffer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_poll_rust_buffer.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_cancel_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_cancel_rust_buffer.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_free_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_free_rust_buffer.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_complete_rust_buffer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_zmanim_core_rust_future_complete_rust_buffer.restype = _UniffiRustBuffer
_UniffiLib.ffi_zmanim_core_rust_future_poll_void.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_poll_void.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_cancel_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_cancel_void.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_free_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_zmanim_core_rust_future_free_void.restype = None
_UniffiLib.ffi_zmanim_core_rust_future_complete_void.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_zmanim_core_rust_future_complete_void.restype = None
_UniffiLib.uniffi_zmanim_core_checksum_func_new_astronomical_calendar.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_func_new_astronomical_calendar.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_func_new_complex_zmanim_calendar.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_func_new_complex_zmanim_calendar.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_func_new_geolocation.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_func_new_geolocation.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_func_new_jewish_date.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_func_new_jewish_date.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_func_new_noaa_calculator.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_func_new_noaa_calculator.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_func_new_zmanim_calendar.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_func_new_zmanim_calendar.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_begin_astronomical_twilight.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_begin_astronomical_twilight.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_begin_civil_twilight.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_begin_civil_twilight.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_begin_nautical_twilight.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_begin_nautical_twilight.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_end_astronomical_twilight.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_end_astronomical_twilight.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_end_civil_twilight.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_end_civil_twilight.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_end_nautical_twilight.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_end_nautical_twilight.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_geo_location.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_geo_location.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_noaa_calculator.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_noaa_calculator.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sea_level_sunrise.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sea_level_sunrise.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sea_level_sunset.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sea_level_sunset.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_solar_midnight.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_solar_midnight.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sun_transit.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sun_transit.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sun_transit_with_start_and_end_times.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sun_transit_with_start_and_end_times.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sunrise.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sunrise.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sunrise_offset_by_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sunrise_offset_by_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sunset.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sunset.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sunset_offset_by_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_sunset_offset_by_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_temporal_hour.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_temporal_hour.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_temporal_hour_with_start_and_end_times.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_temporal_hour_with_start_and_end_times.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_timestamp.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_timestamp.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_utc_sea_level_sunrise.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_utc_sea_level_sunrise.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_utc_sea_level_sunset.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_utc_sea_level_sunset.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_utc_sunrise.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_utc_sunrise.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_utc_sunset.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_astronomicalcalendar_get_utc_sunset.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_120.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_120.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_120_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_120_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_16_point_1_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_16_point_1_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_18_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_18_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_19_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_19_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_19_point_8_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_19_point_8_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_26_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_26_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_60.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_60.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_72_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_72_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_90.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_90.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_90_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_90_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_96.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_96.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_96_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_96_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_baal_hatanya.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_alos_baal_hatanya.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_astronomical_calendar.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_astronomical_calendar.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_ateret_torah_sunset_offset.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_ateret_torah_sunset_offset.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_rt_13_point_24_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_rt_13_point_24_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_rt_13_point_5_minutes_before_7_point_083_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_rt_13_point_5_minutes_before_7_point_083_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_rt_2_stars.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_rt_2_stars.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_rt_58_point_5_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_rt_58_point_5_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_yereim_13_point_5_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_yereim_13_point_5_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_yereim_16_point_875_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_yereim_16_point_875_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_yereim_18_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_yereim_18_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_yereim_2_point_1_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_yereim_2_point_1_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_yereim_2_point_8_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_yereim_2_point_8_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_yereim_3_point_05_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hashmashos_yereim_3_point_05_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosrt_13_point_24_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosrt_13_point_24_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosrt_13_point_5_minutes_before_7_point_083_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosrt_13_point_5_minutes_before_7_point_083_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosrt_2_stars.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosrt_2_stars.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosrt_58_point_5_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosrt_58_point_5_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosyereim_13_point_5_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosyereim_13_point_5_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosyereim_16_point_875_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosyereim_16_point_875_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosyereim_18_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosyereim_18_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosyereim_2_point_1_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosyereim_2_point_1_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosyereim_2_point_8_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosyereim_2_point_8_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosyereim_3_point_05_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_bain_hasmashosyereim_3_point_05_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_candle_lighting_offset.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_candle_lighting_offset.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_fixed_local_chatzos.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_fixed_local_chatzos.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_fixed_local_chatzos_based_zmanim.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_fixed_local_chatzos_based_zmanim.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_16_point_1_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_16_point_1_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_30_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_30_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_72_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_72_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_ahavat_shalom.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_ahavat_shalom.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_ateret_torah.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_ateret_torah.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_baal_hatanya.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_baal_hatanya.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_baal_hatanya_greater_than_30.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_baal_hatanya_greater_than_30.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_gra_fixed_local_chatzos_30_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_gra_fixed_local_chatzos_30_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_greater_than_30.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_gedola_greater_than_30.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_ketana_16_point_1_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_ketana_16_point_1_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_ketana_72_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_ketana_72_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_ketana_ahavat_shalom.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_ketana_ahavat_shalom.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_ketana_ateret_torah.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_ketana_ateret_torah.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_ketana_baal_hatanya.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_ketana_baal_hatanya.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_ketana_gra_fixed_local_chatzos_to_sunset.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_mincha_ketana_gra_fixed_local_chatzos_to_sunset.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_misheyakir_10_point_2_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_misheyakir_10_point_2_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_misheyakir_11_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_misheyakir_11_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_misheyakir_11_point_5_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_misheyakir_11_point_5_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_misheyakir_7_point_65_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_misheyakir_7_point_65_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_misheyakir_9_point_5_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_misheyakir_9_point_5_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_ahavat_shalom.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_ahavat_shalom.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_alos_16_point_1_to_tzais_geonim_7_point_083_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_alos_16_point_1_to_tzais_geonim_7_point_083_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_alos_to_sunset.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_alos_to_sunset.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_120_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_120_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_120_minutes_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_120_minutes_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_16_point_1_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_16_point_1_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_18_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_18_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_19_point_8_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_19_point_8_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_26_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_26_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_60_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_60_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_72_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_72_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_72_minutes_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_72_minutes_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_90_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_90_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_90_minutes_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_90_minutes_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_96_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_96_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_96_minutes_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_96_minutes_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_ateret_torah.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_ateret_torah.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_baal_hatanya.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_baal_hatanya.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_gra_fixed_local_chatzos_to_sunset.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_plag_hamincha_gra_fixed_local_chatzos_to_sunset.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_samuch_le_mincha_ketana_16_point_1_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_samuch_le_mincha_ketana_16_point_1_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_samuch_le_mincha_ketana_72_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_samuch_le_mincha_ketana_72_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_samuch_le_mincha_ketana_gra.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_samuch_le_mincha_ketana_gra.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_120_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_120_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_120_minutes_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_120_minutes_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_16_point_1_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_16_point_1_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_18_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_18_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_19_point_8_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_19_point_8_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_26_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_26_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_60_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_60_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_72_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_72_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_72_minutes_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_72_minutes_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_90_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_90_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_90_minutes_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_90_minutes_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_96_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_96_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_96_minutes_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_96_minutes_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_alos_16_point_1_to_tzais_3_point_7.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_alos_16_point_1_to_tzais_3_point_7.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_alos_16_point_1_to_tzais_3_point_8.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_alos_16_point_1_to_tzais_3_point_8.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_ateret_torah.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_ateret_torah.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_baal_hatanya.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_shaah_zmanis_baal_hatanya.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_baal_hatanya.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_baal_hatanya.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_gra.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_gra.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_mga_16_point_1_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_mga_16_point_1_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_mga_72_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_mga_72_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_mga_72_minutes_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_mga_72_minutes_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_biur_chametz_baal_hatanya.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_biur_chametz_baal_hatanya.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_biur_chametz_gra.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_biur_chametz_gra.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_biur_chametz_mga_16_point_1_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_biur_chametz_mga_16_point_1_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_biur_chametz_mga_72_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_biur_chametz_mga_72_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_biur_chametz_mga_72_minutes_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_biur_chametz_mga_72_minutes_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_kidush_levana_15_days.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_kidush_levana_15_days.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_kidush_levana_15_days_default.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_kidush_levana_15_days_default.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_kidush_levana_between_moldos.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_kidush_levana_between_moldos.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_kidush_levana_between_moldos_default.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_kidush_levana_between_moldos_default.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_3_hours_before_chatzos.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_3_hours_before_chatzos.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_alos_16_point_1_to_sunset.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_alos_16_point_1_to_sunset.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_alos_16_point_1_to_tzais_geonim_7_point_083_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_alos_16_point_1_to_tzais_geonim_7_point_083_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_ateret_torah.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_ateret_torah.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_baal_hatanya.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_baal_hatanya.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_fixed_local.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_fixed_local.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_gra_sunrise_to_fixed_local_chatzos.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_gra_sunrise_to_fixed_local_chatzos.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_kol_eliyahu.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_kol_eliyahu.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_120_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_120_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_16_point_1_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_16_point_1_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_16_point_1_degrees_to_fixed_local_chatzos.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_16_point_1_degrees_to_fixed_local_chatzos.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_18_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_18_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_18_degrees_to_fixed_local_chatzos.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_18_degrees_to_fixed_local_chatzos.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_19_point_8_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_19_point_8_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_72_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_72_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_72_minutes_to_fixed_local_chatzos.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_72_minutes_to_fixed_local_chatzos.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_72_minutes_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_72_minutes_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_90_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_90_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_90_minutes_to_fixed_local_chatzos.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_90_minutes_to_fixed_local_chatzos.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_90_minutes_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_90_minutes_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_96_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_96_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_96_minutes_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_shma_mga_96_minutes_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_2_hours_before_chatzos.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_2_hours_before_chatzos.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_ateret_torah.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_ateret_torah.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_baal_hatanya.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_baal_hatanya.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_fixed_local.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_fixed_local.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_gra_sunrise_to_fixed_local_chatzos.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_gra_sunrise_to_fixed_local_chatzos.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_120_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_120_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_16_point_1_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_16_point_1_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_18_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_18_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_19_point_8_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_19_point_8_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_72_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_72_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_72_minutes_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_72_minutes_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_90_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_90_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_90_minutes_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_90_minutes_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_96_minutes.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_96_minutes.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_96_minutes_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfila_mga_96_minutes_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfilah_ateret_torah.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_sof_zman_tfilah_ateret_torah.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_3_days.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_3_days.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_3_days_with_times.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_3_days_with_times.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_7_days.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_7_days.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_7_days_default.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_7_days_default.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_120.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_120.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_120_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_120_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_16_point_1_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_16_point_1_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_18_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_18_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_19_point_8_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_19_point_8_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_26_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_26_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_50.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_50.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_60.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_60.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_72_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_72_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_90.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_90.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_90_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_90_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_96.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_96.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_96_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_96_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_ateret_torah.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_ateret_torah.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_baal_hatanya.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_baal_hatanya.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_3_point_65_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_3_point_65_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_3_point_676_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_3_point_676_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_3_point_7_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_3_point_7_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_3_point_8_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_3_point_8_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_4_point_37_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_4_point_37_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_4_point_61_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_4_point_61_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_4_point_8_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_4_point_8_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_5_point_88_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_5_point_88_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_5_point_95_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_5_point_95_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_6_point_45_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_6_point_45_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_7_point_083_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_7_point_083_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_7_point_67_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_7_point_67_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_8_point_5_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_8_point_5_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_9_point_3_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_9_point_3_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_9_point_75_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_tzais_geonim_9_point_75_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_use_astronomical_chatzos.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_use_astronomical_chatzos.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_use_astronomical_chatzos_for_other_zmanim.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_use_astronomical_chatzos_for_other_zmanim.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_zman_molad.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_complexzmanimcalendar_get_zman_molad.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_geolocation_geodesic_distance.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_geolocation_geodesic_distance.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_geolocation_geodesic_final_bearing.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_geolocation_geodesic_final_bearing.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_geolocation_geodesic_initial_bearing.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_geolocation_geodesic_initial_bearing.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_geolocation_get_elevation.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_geolocation_get_elevation.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_geolocation_get_latitude.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_geolocation_get_latitude.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_geolocation_get_longitude.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_geolocation_get_longitude.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_geolocation_rhumb_line_bearing.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_geolocation_rhumb_line_bearing.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_geolocation_rhumb_line_distance.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_geolocation_rhumb_line_distance.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_geolocation_vincenty_inverse_formula.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_geolocation_vincenty_inverse_formula.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_bavli_daf_yomi.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_bavli_daf_yomi.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_day_of_chanukah.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_day_of_chanukah.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_day_of_omer.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_day_of_omer.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_in_israel.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_in_israel.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_jewish_date.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_jewish_date.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_parshah.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_parshah.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_use_modern_holidays.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_use_modern_holidays.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_yom_tov_index.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_get_yom_tov_index.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_has_candle_lighting.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_has_candle_lighting.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_aseres_yemei_teshuva.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_aseres_yemei_teshuva.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_assur_bemelacha.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_assur_bemelacha.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_chanukah.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_chanukah.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_chol_hamoed.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_chol_hamoed.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_chol_hamoed_pesach.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_chol_hamoed_pesach.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_chol_hamoed_succos.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_chol_hamoed_succos.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_erev_yom_tov.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_erev_yom_tov.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_erev_yom_tov_sheni.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_erev_yom_tov_sheni.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_hoshana_rabba.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_hoshana_rabba.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_isru_chag.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_isru_chag.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_pesach.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_pesach.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_purim.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_purim.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_rosh_chodesh.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_rosh_chodesh.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_rosh_hashana.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_rosh_hashana.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_shavuos.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_shavuos.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_shemini_atzeres.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_shemini_atzeres.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_simchas_torah.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_simchas_torah.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_succos.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_succos.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_taanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_taanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_taanis_bechoros.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_taanis_bechoros.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_tisha_beav.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_tisha_beav.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_tomorrow_shabbos_or_yom_tov.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_tomorrow_shabbos_or_yom_tov.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_yom_kippur.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_yom_kippur.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_yom_tov.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_yom_tov.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_yom_tov_assur_bemelacha.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishcalendar_is_yom_tov_assur_bemelacha.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_chalakim_since_molad_tohu.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_chalakim_since_molad_tohu.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_cheshvan_kislev_kviah.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_cheshvan_kislev_kviah.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_day_of_week.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_day_of_week.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_days_in_jewish_month.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_days_in_jewish_month.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_days_in_jewish_year.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_days_in_jewish_year.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_days_since_start_of_jewish_year.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_days_since_start_of_jewish_year.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_gregorian_day_of_month.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_gregorian_day_of_month.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_gregorian_month.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_gregorian_month.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_gregorian_year.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_gregorian_year.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_jewish_day_of_month.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_jewish_day_of_month.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_jewish_month.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_jewish_month.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_jewish_year.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_jewish_year.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_molad_data.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_molad_data.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_molad_date.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_get_molad_date.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_is_cheshvan_long.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_is_cheshvan_long.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_is_jewish_leap_year.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_is_jewish_leap_year.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_is_kislev_short.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_jewishdate_is_kislev_short.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_noaacalculator_get_solar_azimuth.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_noaacalculator_get_solar_azimuth.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_noaacalculator_get_solar_elevation.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_noaacalculator_get_solar_elevation.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_noaacalculator_get_utc_midnight.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_noaacalculator_get_utc_midnight.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_noaacalculator_get_utc_noon.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_noaacalculator_get_utc_noon.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_noaacalculator_get_utc_sunrise.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_noaacalculator_get_utc_sunrise.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_noaacalculator_get_utc_sunset.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_noaacalculator_get_utc_sunset.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar__get_mincha_gedola.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar__get_mincha_gedola.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar__get_mincha_ketana.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar__get_mincha_ketana.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar__get_plag_hamincha.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar__get_plag_hamincha.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar__get_samuch_le_mincha_ketana.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar__get_samuch_le_mincha_ketana.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar__get_sof_zman_shma.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar__get_sof_zman_shma.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar__get_sof_zman_tfila.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar__get_sof_zman_tfila.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_alos72.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_alos72.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_alos_hashachar.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_alos_hashachar.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_astronomical_calendar.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_astronomical_calendar.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_candle_lighting.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_candle_lighting.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_candle_lighting_offset.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_candle_lighting_offset.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_chatzos.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_chatzos.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_chatzos_as_half_day.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_chatzos_as_half_day.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_half_day_based_shaah_zmanis.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_half_day_based_shaah_zmanis.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_half_day_based_zman.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_half_day_based_zman.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_mincha_gedola_default.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_mincha_gedola_default.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_mincha_gedola_simple.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_mincha_gedola_simple.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_mincha_ketana_default.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_mincha_ketana_default.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_mincha_ketana_simple.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_mincha_ketana_simple.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_percent_of_shaah_zmanis_from_degrees.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_percent_of_shaah_zmanis_from_degrees.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_plag_hamincha_default.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_plag_hamincha_default.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_plag_hamincha_simple.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_plag_hamincha_simple.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_samuch_le_mincha_ketana_simple.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_samuch_le_mincha_ketana_simple.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_shaah_zmanis_based_zman.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_shaah_zmanis_based_zman.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_shaah_zmanis_gra.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_shaah_zmanis_gra.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_shaah_zmanis_mga.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_shaah_zmanis_mga.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_sof_zman_shma_gra.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_sof_zman_shma_gra.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_sof_zman_shma_mga.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_sof_zman_shma_mga.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_sof_zman_shma_simple.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_sof_zman_shma_simple.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_sof_zman_tfila_gra.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_sof_zman_tfila_gra.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_sof_zman_tfila_mga.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_sof_zman_tfila_mga.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_sof_zman_tfila_simple.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_sof_zman_tfila_simple.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_tzais.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_tzais.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_tzais72.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_tzais72.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_use_astronomical_chatzos.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_use_astronomical_chatzos.restype = ctypes.c_uint16
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_use_astronomical_chatzos_for_other_zmanim.argtypes = (
)
_UniffiLib.uniffi_zmanim_core_checksum_method_zmanimcalendar_get_use_astronomical_chatzos_for_other_zmanim.restype = ctypes.c_uint16
_UniffiLib.ffi_zmanim_core_uniffi_contract_version.argtypes = (
)
_UniffiLib.ffi_zmanim_core_uniffi_contract_version.restype = ctypes.c_uint32

_uniffi_check_contract_api_version(_UniffiLib)
# _uniffi_check_api_checksums(_UniffiLib)

# Public interface members begin here.


class _UniffiConverterInt32(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "i32"
    VALUE_MIN = -2**31
    VALUE_MAX = 2**31

    @staticmethod
    def read(buf):
        return buf.read_i32()

    @staticmethod
    def write(value, buf):
        buf.write_i32(value)

class _UniffiConverterInt64(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "i64"
    VALUE_MIN = -2**63
    VALUE_MAX = 2**63

    @staticmethod
    def read(buf):
        return buf.read_i64()

    @staticmethod
    def write(value, buf):
        buf.write_i64(value)

class _UniffiConverterDouble(_UniffiConverterPrimitiveFloat):
    @staticmethod
    def read(buf):
        return buf.read_double()

    @staticmethod
    def write(value, buf):
        buf.write_double(value)

class _UniffiConverterBool:
    @classmethod
    def check_lower(cls, value):
        return not not value

    @classmethod
    def lower(cls, value):
        return 1 if value else 0

    @staticmethod
    def lift(value):
        return value != 0

    @classmethod
    def read(cls, buf):
        return cls.lift(buf.read_u8())

    @classmethod
    def write(cls, value, buf):
        buf.write_u8(value)

class _UniffiConverterString:
    @staticmethod
    def check_lower(value):
        if not isinstance(value, str):
            raise TypeError("argument must be str, not {}".format(type(value).__name__))
        return value

    @staticmethod
    def read(buf):
        size = buf.read_i32()
        if size < 0:
            raise InternalError("Unexpected negative string length")
        utf8_bytes = buf.read(size)
        return utf8_bytes.decode("utf-8")

    @staticmethod
    def write(value, buf):
        utf8_bytes = value.encode("utf-8")
        buf.write_i32(len(utf8_bytes))
        buf.write(utf8_bytes)

    @staticmethod
    def lift(buf):
        with buf.consume_with_stream() as stream:
            return stream.read(stream.remaining()).decode("utf-8")

    @staticmethod
    def lower(value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            builder.write(value.encode("utf-8"))
            return builder.finalize()



class AstronomicalCalculatorProtocol(typing.Protocol):
    pass


class AstronomicalCalculator:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_free_astronomicalcalculator, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_clone_astronomicalcalculator, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst



class _UniffiConverterTypeAstronomicalCalculator:

    @staticmethod
    def lift(value: int):
        return AstronomicalCalculator._make_instance_(value)

    @staticmethod
    def check_lower(value: AstronomicalCalculator):
        if not isinstance(value, AstronomicalCalculator):
            raise TypeError("Expected AstronomicalCalculator instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: AstronomicalCalculatorProtocol):
        if not isinstance(value, AstronomicalCalculator):
            raise TypeError("Expected AstronomicalCalculator instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: AstronomicalCalculatorProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class AstronomicalCalendarProtocol(typing.Protocol):
    def get_begin_astronomical_twilight(self, ):
        raise NotImplementedError
    def get_begin_civil_twilight(self, ):
        raise NotImplementedError
    def get_begin_nautical_twilight(self, ):
        raise NotImplementedError
    def get_end_astronomical_twilight(self, ):
        raise NotImplementedError
    def get_end_civil_twilight(self, ):
        raise NotImplementedError
    def get_end_nautical_twilight(self, ):
        raise NotImplementedError
    def get_geo_location(self, ):
        raise NotImplementedError
    def get_noaa_calculator(self, ):
        raise NotImplementedError
    def get_sea_level_sunrise(self, ):
        raise NotImplementedError
    def get_sea_level_sunset(self, ):
        raise NotImplementedError
    def get_solar_midnight(self, ):
        raise NotImplementedError
    def get_sun_transit(self, ):
        raise NotImplementedError
    def get_sun_transit_with_start_and_end_times(self, start_time: "int",end_time: "int"):
        raise NotImplementedError
    def get_sunrise(self, ):
        raise NotImplementedError
    def get_sunrise_offset_by_degrees(self, degrees: "float"):
        raise NotImplementedError
    def get_sunset(self, ):
        raise NotImplementedError
    def get_sunset_offset_by_degrees(self, degrees: "float"):
        raise NotImplementedError
    def get_temporal_hour(self, ):
        raise NotImplementedError
    def get_temporal_hour_with_start_and_end_times(self, start_time: "int",end_time: "int"):
        raise NotImplementedError
    def get_timestamp(self, ):
        raise NotImplementedError
    def get_utc_sea_level_sunrise(self, zenith: "float"):
        raise NotImplementedError
    def get_utc_sea_level_sunset(self, zenith: "float"):
        raise NotImplementedError
    def get_utc_sunrise(self, zenith: "float"):
        raise NotImplementedError
    def get_utc_sunset(self, zenith: "float"):
        raise NotImplementedError


class AstronomicalCalendar:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_free_astronomicalcalendar, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_clone_astronomicalcalendar, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def get_begin_astronomical_twilight(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_begin_astronomical_twilight,self._uniffi_clone_pointer(),)
        )





    def get_begin_civil_twilight(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_begin_civil_twilight,self._uniffi_clone_pointer(),)
        )





    def get_begin_nautical_twilight(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_begin_nautical_twilight,self._uniffi_clone_pointer(),)
        )





    def get_end_astronomical_twilight(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_end_astronomical_twilight,self._uniffi_clone_pointer(),)
        )





    def get_end_civil_twilight(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_end_civil_twilight,self._uniffi_clone_pointer(),)
        )





    def get_end_nautical_twilight(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_end_nautical_twilight,self._uniffi_clone_pointer(),)
        )





    def get_geo_location(self, ) -> "GeoLocation":
        return _UniffiConverterTypeGeoLocation.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_geo_location,self._uniffi_clone_pointer(),)
        )





    def get_noaa_calculator(self, ) -> "NoaaCalculator":
        return _UniffiConverterTypeNoaaCalculator.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_noaa_calculator,self._uniffi_clone_pointer(),)
        )





    def get_sea_level_sunrise(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sea_level_sunrise,self._uniffi_clone_pointer(),)
        )





    def get_sea_level_sunset(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sea_level_sunset,self._uniffi_clone_pointer(),)
        )





    def get_solar_midnight(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_solar_midnight,self._uniffi_clone_pointer(),)
        )





    def get_sun_transit(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sun_transit,self._uniffi_clone_pointer(),)
        )





    def get_sun_transit_with_start_and_end_times(self, start_time: "int",end_time: "int") -> "typing.Optional[int]":
        _UniffiConverterInt64.check_lower(start_time)
        
        _UniffiConverterInt64.check_lower(end_time)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sun_transit_with_start_and_end_times,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(start_time),
        _UniffiConverterInt64.lower(end_time))
        )





    def get_sunrise(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sunrise,self._uniffi_clone_pointer(),)
        )





    def get_sunrise_offset_by_degrees(self, degrees: "float") -> "typing.Optional[int]":
        _UniffiConverterDouble.check_lower(degrees)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sunrise_offset_by_degrees,self._uniffi_clone_pointer(),
        _UniffiConverterDouble.lower(degrees))
        )





    def get_sunset(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sunset,self._uniffi_clone_pointer(),)
        )





    def get_sunset_offset_by_degrees(self, degrees: "float") -> "typing.Optional[int]":
        _UniffiConverterDouble.check_lower(degrees)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_sunset_offset_by_degrees,self._uniffi_clone_pointer(),
        _UniffiConverterDouble.lower(degrees))
        )





    def get_temporal_hour(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_temporal_hour,self._uniffi_clone_pointer(),)
        )





    def get_temporal_hour_with_start_and_end_times(self, start_time: "int",end_time: "int") -> "typing.Optional[int]":
        _UniffiConverterInt64.check_lower(start_time)
        
        _UniffiConverterInt64.check_lower(end_time)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_temporal_hour_with_start_and_end_times,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(start_time),
        _UniffiConverterInt64.lower(end_time))
        )





    def get_timestamp(self, ) -> "int":
        return _UniffiConverterInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_timestamp,self._uniffi_clone_pointer(),)
        )





    def get_utc_sea_level_sunrise(self, zenith: "float") -> "typing.Optional[float]":
        _UniffiConverterDouble.check_lower(zenith)
        
        return _UniffiConverterOptionalDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_utc_sea_level_sunrise,self._uniffi_clone_pointer(),
        _UniffiConverterDouble.lower(zenith))
        )





    def get_utc_sea_level_sunset(self, zenith: "float") -> "typing.Optional[float]":
        _UniffiConverterDouble.check_lower(zenith)
        
        return _UniffiConverterOptionalDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_utc_sea_level_sunset,self._uniffi_clone_pointer(),
        _UniffiConverterDouble.lower(zenith))
        )





    def get_utc_sunrise(self, zenith: "float") -> "typing.Optional[float]":
        _UniffiConverterDouble.check_lower(zenith)
        
        return _UniffiConverterOptionalDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_utc_sunrise,self._uniffi_clone_pointer(),
        _UniffiConverterDouble.lower(zenith))
        )





    def get_utc_sunset(self, zenith: "float") -> "typing.Optional[float]":
        _UniffiConverterDouble.check_lower(zenith)
        
        return _UniffiConverterOptionalDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_astronomicalcalendar_get_utc_sunset,self._uniffi_clone_pointer(),
        _UniffiConverterDouble.lower(zenith))
        )






class _UniffiConverterTypeAstronomicalCalendar:

    @staticmethod
    def lift(value: int):
        return AstronomicalCalendar._make_instance_(value)

    @staticmethod
    def check_lower(value: AstronomicalCalendar):
        if not isinstance(value, AstronomicalCalendar):
            raise TypeError("Expected AstronomicalCalendar instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: AstronomicalCalendarProtocol):
        if not isinstance(value, AstronomicalCalendar):
            raise TypeError("Expected AstronomicalCalendar instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: AstronomicalCalendarProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class BavliDafProtocol(typing.Protocol):
    pass


class BavliDaf:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_free_bavlidaf, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_clone_bavlidaf, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst



class _UniffiConverterTypeBavliDaf:

    @staticmethod
    def lift(value: int):
        return BavliDaf._make_instance_(value)

    @staticmethod
    def check_lower(value: BavliDaf):
        if not isinstance(value, BavliDaf):
            raise TypeError("Expected BavliDaf instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: BavliDafProtocol):
        if not isinstance(value, BavliDaf):
            raise TypeError("Expected BavliDaf instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: BavliDafProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class ComplexZmanimCalendarProtocol(typing.Protocol):
    def get_alos_120(self, ):
        raise NotImplementedError
    def get_alos_120_zmanis(self, ):
        raise NotImplementedError
    def get_alos_16_point_1_degrees(self, ):
        raise NotImplementedError
    def get_alos_18_degrees(self, ):
        raise NotImplementedError
    def get_alos_19_degrees(self, ):
        raise NotImplementedError
    def get_alos_19_point_8_degrees(self, ):
        raise NotImplementedError
    def get_alos_26_degrees(self, ):
        raise NotImplementedError
    def get_alos_60(self, ):
        raise NotImplementedError
    def get_alos_72_zmanis(self, ):
        raise NotImplementedError
    def get_alos_90(self, ):
        raise NotImplementedError
    def get_alos_90_zmanis(self, ):
        raise NotImplementedError
    def get_alos_96(self, ):
        raise NotImplementedError
    def get_alos_96_zmanis(self, ):
        raise NotImplementedError
    def get_alos_baal_hatanya(self, ):
        raise NotImplementedError
    def get_astronomical_calendar(self, ):
        raise NotImplementedError
    def get_ateret_torah_sunset_offset(self, ):
        raise NotImplementedError
    def get_bain_hashmashos_rt_13_point_24_degrees(self, ):
        raise NotImplementedError
    def get_bain_hashmashos_rt_13_point_5_minutes_before_7_point_083_degrees(self, ):
        raise NotImplementedError
    def get_bain_hashmashos_rt_2_stars(self, ):
        raise NotImplementedError
    def get_bain_hashmashos_rt_58_point_5_minutes(self, ):
        raise NotImplementedError
    def get_bain_hashmashos_yereim_13_point_5_minutes(self, ):
        raise NotImplementedError
    def get_bain_hashmashos_yereim_16_point_875_minutes(self, ):
        raise NotImplementedError
    def get_bain_hashmashos_yereim_18_minutes(self, ):
        raise NotImplementedError
    def get_bain_hashmashos_yereim_2_point_1_degrees(self, ):
        raise NotImplementedError
    def get_bain_hashmashos_yereim_2_point_8_degrees(self, ):
        raise NotImplementedError
    def get_bain_hashmashos_yereim_3_point_05_degrees(self, ):
        raise NotImplementedError
    def get_bain_hasmashosrt_13_point_24_degrees(self, ):
        raise NotImplementedError
    def get_bain_hasmashosrt_13_point_5_minutes_before_7_point_083_degrees(self, ):
        raise NotImplementedError
    def get_bain_hasmashosrt_2_stars(self, ):
        raise NotImplementedError
    def get_bain_hasmashosrt_58_point_5_minutes(self, ):
        raise NotImplementedError
    def get_bain_hasmashosyereim_13_point_5_minutes(self, ):
        raise NotImplementedError
    def get_bain_hasmashosyereim_16_point_875_minutes(self, ):
        raise NotImplementedError
    def get_bain_hasmashosyereim_18_minutes(self, ):
        raise NotImplementedError
    def get_bain_hasmashosyereim_2_point_1_degrees(self, ):
        raise NotImplementedError
    def get_bain_hasmashosyereim_2_point_8_degrees(self, ):
        raise NotImplementedError
    def get_bain_hasmashosyereim_3_point_05_degrees(self, ):
        raise NotImplementedError
    def get_candle_lighting_offset(self, ):
        raise NotImplementedError
    def get_fixed_local_chatzos(self, ):
        raise NotImplementedError
    def get_fixed_local_chatzos_based_zmanim(self, start_of_half_day: "int",end_of_half_day: "int",hours: "float"):
        raise NotImplementedError
    def get_mincha_gedola_16_point_1_degrees(self, ):
        raise NotImplementedError
    def get_mincha_gedola_30_minutes(self, ):
        raise NotImplementedError
    def get_mincha_gedola_72_minutes(self, ):
        raise NotImplementedError
    def get_mincha_gedola_ahavat_shalom(self, ):
        raise NotImplementedError
    def get_mincha_gedola_ateret_torah(self, ):
        raise NotImplementedError
    def get_mincha_gedola_baal_hatanya(self, ):
        raise NotImplementedError
    def get_mincha_gedola_baal_hatanya_greater_than_30(self, ):
        raise NotImplementedError
    def get_mincha_gedola_gra_fixed_local_chatzos_30_minutes(self, ):
        raise NotImplementedError
    def get_mincha_gedola_greater_than_30(self, ):
        raise NotImplementedError
    def get_mincha_ketana_16_point_1_degrees(self, ):
        raise NotImplementedError
    def get_mincha_ketana_72_minutes(self, ):
        raise NotImplementedError
    def get_mincha_ketana_ahavat_shalom(self, ):
        raise NotImplementedError
    def get_mincha_ketana_ateret_torah(self, ):
        raise NotImplementedError
    def get_mincha_ketana_baal_hatanya(self, ):
        raise NotImplementedError
    def get_mincha_ketana_gra_fixed_local_chatzos_to_sunset(self, ):
        raise NotImplementedError
    def get_misheyakir_10_point_2_degrees(self, ):
        raise NotImplementedError
    def get_misheyakir_11_degrees(self, ):
        raise NotImplementedError
    def get_misheyakir_11_point_5_degrees(self, ):
        raise NotImplementedError
    def get_misheyakir_7_point_65_degrees(self, ):
        raise NotImplementedError
    def get_misheyakir_9_point_5_degrees(self, ):
        raise NotImplementedError
    def get_plag_ahavat_shalom(self, ):
        raise NotImplementedError
    def get_plag_alos_16_point_1_to_tzais_geonim_7_point_083_degrees(self, ):
        raise NotImplementedError
    def get_plag_alos_to_sunset(self, ):
        raise NotImplementedError
    def get_plag_hamincha_120_minutes(self, ):
        raise NotImplementedError
    def get_plag_hamincha_120_minutes_zmanis(self, ):
        raise NotImplementedError
    def get_plag_hamincha_16_point_1_degrees(self, ):
        raise NotImplementedError
    def get_plag_hamincha_18_degrees(self, ):
        raise NotImplementedError
    def get_plag_hamincha_19_point_8_degrees(self, ):
        raise NotImplementedError
    def get_plag_hamincha_26_degrees(self, ):
        raise NotImplementedError
    def get_plag_hamincha_60_minutes(self, ):
        raise NotImplementedError
    def get_plag_hamincha_72_minutes(self, ):
        raise NotImplementedError
    def get_plag_hamincha_72_minutes_zmanis(self, ):
        raise NotImplementedError
    def get_plag_hamincha_90_minutes(self, ):
        raise NotImplementedError
    def get_plag_hamincha_90_minutes_zmanis(self, ):
        raise NotImplementedError
    def get_plag_hamincha_96_minutes(self, ):
        raise NotImplementedError
    def get_plag_hamincha_96_minutes_zmanis(self, ):
        raise NotImplementedError
    def get_plag_hamincha_ateret_torah(self, ):
        raise NotImplementedError
    def get_plag_hamincha_baal_hatanya(self, ):
        raise NotImplementedError
    def get_plag_hamincha_gra_fixed_local_chatzos_to_sunset(self, ):
        raise NotImplementedError
    def get_samuch_le_mincha_ketana_16_point_1_degrees(self, ):
        raise NotImplementedError
    def get_samuch_le_mincha_ketana_72_minutes(self, ):
        raise NotImplementedError
    def get_samuch_le_mincha_ketana_gra(self, ):
        raise NotImplementedError
    def get_shaah_zmanis_120_minutes(self, ):
        raise NotImplementedError
    def get_shaah_zmanis_120_minutes_zmanis(self, ):
        raise NotImplementedError
    def get_shaah_zmanis_16_point_1_degrees(self, ):
        raise NotImplementedError
    def get_shaah_zmanis_18_degrees(self, ):
        raise NotImplementedError
    def get_shaah_zmanis_19_point_8_degrees(self, ):
        raise NotImplementedError
    def get_shaah_zmanis_26_degrees(self, ):
        raise NotImplementedError
    def get_shaah_zmanis_60_minutes(self, ):
        raise NotImplementedError
    def get_shaah_zmanis_72_minutes(self, ):
        raise NotImplementedError
    def get_shaah_zmanis_72_minutes_zmanis(self, ):
        raise NotImplementedError
    def get_shaah_zmanis_90_minutes(self, ):
        raise NotImplementedError
    def get_shaah_zmanis_90_minutes_zmanis(self, ):
        raise NotImplementedError
    def get_shaah_zmanis_96_minutes(self, ):
        raise NotImplementedError
    def get_shaah_zmanis_96_minutes_zmanis(self, ):
        raise NotImplementedError
    def get_shaah_zmanis_alos_16_point_1_to_tzais_3_point_7(self, ):
        raise NotImplementedError
    def get_shaah_zmanis_alos_16_point_1_to_tzais_3_point_8(self, ):
        raise NotImplementedError
    def get_shaah_zmanis_ateret_torah(self, ):
        raise NotImplementedError
    def get_shaah_zmanis_baal_hatanya(self, ):
        raise NotImplementedError
    def get_sof_zman_achilas_chametz_baal_hatanya(self, ):
        raise NotImplementedError
    def get_sof_zman_achilas_chametz_gra(self, ):
        raise NotImplementedError
    def get_sof_zman_achilas_chametz_mga_16_point_1_degrees(self, ):
        raise NotImplementedError
    def get_sof_zman_achilas_chametz_mga_72_minutes(self, ):
        raise NotImplementedError
    def get_sof_zman_achilas_chametz_mga_72_minutes_zmanis(self, ):
        raise NotImplementedError
    def get_sof_zman_biur_chametz_baal_hatanya(self, ):
        raise NotImplementedError
    def get_sof_zman_biur_chametz_gra(self, ):
        raise NotImplementedError
    def get_sof_zman_biur_chametz_mga_16_point_1_degrees(self, ):
        raise NotImplementedError
    def get_sof_zman_biur_chametz_mga_72_minutes(self, ):
        raise NotImplementedError
    def get_sof_zman_biur_chametz_mga_72_minutes_zmanis(self, ):
        raise NotImplementedError
    def get_sof_zman_kidush_levana_15_days(self, alos: "typing.Optional[int]",tzais: "typing.Optional[int]"):
        raise NotImplementedError
    def get_sof_zman_kidush_levana_15_days_default(self, ):
        raise NotImplementedError
    def get_sof_zman_kidush_levana_between_moldos(self, alos: "typing.Optional[int]",tzais: "typing.Optional[int]"):
        raise NotImplementedError
    def get_sof_zman_kidush_levana_between_moldos_default(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_3_hours_before_chatzos(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_alos_16_point_1_to_sunset(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_alos_16_point_1_to_tzais_geonim_7_point_083_degrees(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_ateret_torah(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_baal_hatanya(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_fixed_local(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_gra_sunrise_to_fixed_local_chatzos(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_kol_eliyahu(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_mga_120_minutes(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_mga_16_point_1_degrees(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_mga_16_point_1_degrees_to_fixed_local_chatzos(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_mga_18_degrees(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_mga_18_degrees_to_fixed_local_chatzos(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_mga_19_point_8_degrees(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_mga_72_minutes(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_mga_72_minutes_to_fixed_local_chatzos(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_mga_72_minutes_zmanis(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_mga_90_minutes(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_mga_90_minutes_to_fixed_local_chatzos(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_mga_90_minutes_zmanis(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_mga_96_minutes(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_mga_96_minutes_zmanis(self, ):
        raise NotImplementedError
    def get_sof_zman_tfila_2_hours_before_chatzos(self, ):
        raise NotImplementedError
    def get_sof_zman_tfila_ateret_torah(self, ):
        raise NotImplementedError
    def get_sof_zman_tfila_baal_hatanya(self, ):
        raise NotImplementedError
    def get_sof_zman_tfila_fixed_local(self, ):
        raise NotImplementedError
    def get_sof_zman_tfila_gra_sunrise_to_fixed_local_chatzos(self, ):
        raise NotImplementedError
    def get_sof_zman_tfila_mga_120_minutes(self, ):
        raise NotImplementedError
    def get_sof_zman_tfila_mga_16_point_1_degrees(self, ):
        raise NotImplementedError
    def get_sof_zman_tfila_mga_18_degrees(self, ):
        raise NotImplementedError
    def get_sof_zman_tfila_mga_19_point_8_degrees(self, ):
        raise NotImplementedError
    def get_sof_zman_tfila_mga_72_minutes(self, ):
        raise NotImplementedError
    def get_sof_zman_tfila_mga_72_minutes_zmanis(self, ):
        raise NotImplementedError
    def get_sof_zman_tfila_mga_90_minutes(self, ):
        raise NotImplementedError
    def get_sof_zman_tfila_mga_90_minutes_zmanis(self, ):
        raise NotImplementedError
    def get_sof_zman_tfila_mga_96_minutes(self, ):
        raise NotImplementedError
    def get_sof_zman_tfila_mga_96_minutes_zmanis(self, ):
        raise NotImplementedError
    def get_sof_zman_tfilah_ateret_torah(self, ):
        raise NotImplementedError
    def get_tchilas_zman_kidush_levana_3_days(self, ):
        raise NotImplementedError
    def get_tchilas_zman_kidush_levana_3_days_with_times(self, alos: "typing.Optional[int]",tzais: "typing.Optional[int]"):
        raise NotImplementedError
    def get_tchilas_zman_kidush_levana_7_days(self, alos: "typing.Optional[int]",tzais: "typing.Optional[int]"):
        raise NotImplementedError
    def get_tchilas_zman_kidush_levana_7_days_default(self, ):
        raise NotImplementedError
    def get_tzais_120(self, ):
        raise NotImplementedError
    def get_tzais_120_zmanis(self, ):
        raise NotImplementedError
    def get_tzais_16_point_1_degrees(self, ):
        raise NotImplementedError
    def get_tzais_18_degrees(self, ):
        raise NotImplementedError
    def get_tzais_19_point_8_degrees(self, ):
        raise NotImplementedError
    def get_tzais_26_degrees(self, ):
        raise NotImplementedError
    def get_tzais_50(self, ):
        raise NotImplementedError
    def get_tzais_60(self, ):
        raise NotImplementedError
    def get_tzais_72_zmanis(self, ):
        raise NotImplementedError
    def get_tzais_90(self, ):
        raise NotImplementedError
    def get_tzais_90_zmanis(self, ):
        raise NotImplementedError
    def get_tzais_96(self, ):
        raise NotImplementedError
    def get_tzais_96_zmanis(self, ):
        raise NotImplementedError
    def get_tzais_ateret_torah(self, ):
        raise NotImplementedError
    def get_tzais_baal_hatanya(self, ):
        raise NotImplementedError
    def get_tzais_geonim_3_point_65_degrees(self, ):
        raise NotImplementedError
    def get_tzais_geonim_3_point_676_degrees(self, ):
        raise NotImplementedError
    def get_tzais_geonim_3_point_7_degrees(self, ):
        raise NotImplementedError
    def get_tzais_geonim_3_point_8_degrees(self, ):
        raise NotImplementedError
    def get_tzais_geonim_4_point_37_degrees(self, ):
        raise NotImplementedError
    def get_tzais_geonim_4_point_61_degrees(self, ):
        raise NotImplementedError
    def get_tzais_geonim_4_point_8_degrees(self, ):
        raise NotImplementedError
    def get_tzais_geonim_5_point_88_degrees(self, ):
        raise NotImplementedError
    def get_tzais_geonim_5_point_95_degrees(self, ):
        raise NotImplementedError
    def get_tzais_geonim_6_point_45_degrees(self, ):
        raise NotImplementedError
    def get_tzais_geonim_7_point_083_degrees(self, ):
        raise NotImplementedError
    def get_tzais_geonim_7_point_67_degrees(self, ):
        raise NotImplementedError
    def get_tzais_geonim_8_point_5_degrees(self, ):
        raise NotImplementedError
    def get_tzais_geonim_9_point_3_degrees(self, ):
        raise NotImplementedError
    def get_tzais_geonim_9_point_75_degrees(self, ):
        raise NotImplementedError
    def get_use_astronomical_chatzos(self, ):
        raise NotImplementedError
    def get_use_astronomical_chatzos_for_other_zmanim(self, ):
        raise NotImplementedError
    def get_zman_molad(self, ):
        raise NotImplementedError


class ComplexZmanimCalendar:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_free_complexzmanimcalendar, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_clone_complexzmanimcalendar, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def get_alos_120(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_120,self._uniffi_clone_pointer(),)
        )





    def get_alos_120_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_120_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_alos_16_point_1_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_16_point_1_degrees,self._uniffi_clone_pointer(),)
        )





    def get_alos_18_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_18_degrees,self._uniffi_clone_pointer(),)
        )





    def get_alos_19_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_19_degrees,self._uniffi_clone_pointer(),)
        )





    def get_alos_19_point_8_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_19_point_8_degrees,self._uniffi_clone_pointer(),)
        )





    def get_alos_26_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_26_degrees,self._uniffi_clone_pointer(),)
        )





    def get_alos_60(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_60,self._uniffi_clone_pointer(),)
        )





    def get_alos_72_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_72_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_alos_90(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_90,self._uniffi_clone_pointer(),)
        )





    def get_alos_90_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_90_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_alos_96(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_96,self._uniffi_clone_pointer(),)
        )





    def get_alos_96_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_96_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_alos_baal_hatanya(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_alos_baal_hatanya,self._uniffi_clone_pointer(),)
        )





    def get_astronomical_calendar(self, ) -> "AstronomicalCalendar":
        return _UniffiConverterTypeAstronomicalCalendar.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_astronomical_calendar,self._uniffi_clone_pointer(),)
        )





    def get_ateret_torah_sunset_offset(self, ) -> "int":
        return _UniffiConverterInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_ateret_torah_sunset_offset,self._uniffi_clone_pointer(),)
        )





    def get_bain_hashmashos_rt_13_point_24_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_rt_13_point_24_degrees,self._uniffi_clone_pointer(),)
        )





    def get_bain_hashmashos_rt_13_point_5_minutes_before_7_point_083_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_rt_13_point_5_minutes_before_7_point_083_degrees,self._uniffi_clone_pointer(),)
        )





    def get_bain_hashmashos_rt_2_stars(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_rt_2_stars,self._uniffi_clone_pointer(),)
        )





    def get_bain_hashmashos_rt_58_point_5_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_rt_58_point_5_minutes,self._uniffi_clone_pointer(),)
        )





    def get_bain_hashmashos_yereim_13_point_5_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_yereim_13_point_5_minutes,self._uniffi_clone_pointer(),)
        )





    def get_bain_hashmashos_yereim_16_point_875_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_yereim_16_point_875_minutes,self._uniffi_clone_pointer(),)
        )





    def get_bain_hashmashos_yereim_18_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_yereim_18_minutes,self._uniffi_clone_pointer(),)
        )





    def get_bain_hashmashos_yereim_2_point_1_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_yereim_2_point_1_degrees,self._uniffi_clone_pointer(),)
        )





    def get_bain_hashmashos_yereim_2_point_8_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_yereim_2_point_8_degrees,self._uniffi_clone_pointer(),)
        )





    def get_bain_hashmashos_yereim_3_point_05_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hashmashos_yereim_3_point_05_degrees,self._uniffi_clone_pointer(),)
        )





    def get_bain_hasmashosrt_13_point_24_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosrt_13_point_24_degrees,self._uniffi_clone_pointer(),)
        )





    def get_bain_hasmashosrt_13_point_5_minutes_before_7_point_083_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosrt_13_point_5_minutes_before_7_point_083_degrees,self._uniffi_clone_pointer(),)
        )





    def get_bain_hasmashosrt_2_stars(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosrt_2_stars,self._uniffi_clone_pointer(),)
        )





    def get_bain_hasmashosrt_58_point_5_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosrt_58_point_5_minutes,self._uniffi_clone_pointer(),)
        )





    def get_bain_hasmashosyereim_13_point_5_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosyereim_13_point_5_minutes,self._uniffi_clone_pointer(),)
        )





    def get_bain_hasmashosyereim_16_point_875_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosyereim_16_point_875_minutes,self._uniffi_clone_pointer(),)
        )





    def get_bain_hasmashosyereim_18_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosyereim_18_minutes,self._uniffi_clone_pointer(),)
        )





    def get_bain_hasmashosyereim_2_point_1_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosyereim_2_point_1_degrees,self._uniffi_clone_pointer(),)
        )





    def get_bain_hasmashosyereim_2_point_8_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosyereim_2_point_8_degrees,self._uniffi_clone_pointer(),)
        )





    def get_bain_hasmashosyereim_3_point_05_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_bain_hasmashosyereim_3_point_05_degrees,self._uniffi_clone_pointer(),)
        )





    def get_candle_lighting_offset(self, ) -> "int":
        return _UniffiConverterInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_candle_lighting_offset,self._uniffi_clone_pointer(),)
        )





    def get_fixed_local_chatzos(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_fixed_local_chatzos,self._uniffi_clone_pointer(),)
        )





    def get_fixed_local_chatzos_based_zmanim(self, start_of_half_day: "int",end_of_half_day: "int",hours: "float") -> "typing.Optional[int]":
        _UniffiConverterInt64.check_lower(start_of_half_day)
        
        _UniffiConverterInt64.check_lower(end_of_half_day)
        
        _UniffiConverterDouble.check_lower(hours)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_fixed_local_chatzos_based_zmanim,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(start_of_half_day),
        _UniffiConverterInt64.lower(end_of_half_day),
        _UniffiConverterDouble.lower(hours))
        )





    def get_mincha_gedola_16_point_1_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_16_point_1_degrees,self._uniffi_clone_pointer(),)
        )





    def get_mincha_gedola_30_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_30_minutes,self._uniffi_clone_pointer(),)
        )





    def get_mincha_gedola_72_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_72_minutes,self._uniffi_clone_pointer(),)
        )





    def get_mincha_gedola_ahavat_shalom(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_ahavat_shalom,self._uniffi_clone_pointer(),)
        )





    def get_mincha_gedola_ateret_torah(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_ateret_torah,self._uniffi_clone_pointer(),)
        )





    def get_mincha_gedola_baal_hatanya(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_baal_hatanya,self._uniffi_clone_pointer(),)
        )





    def get_mincha_gedola_baal_hatanya_greater_than_30(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_baal_hatanya_greater_than_30,self._uniffi_clone_pointer(),)
        )





    def get_mincha_gedola_gra_fixed_local_chatzos_30_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_gra_fixed_local_chatzos_30_minutes,self._uniffi_clone_pointer(),)
        )





    def get_mincha_gedola_greater_than_30(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_gedola_greater_than_30,self._uniffi_clone_pointer(),)
        )





    def get_mincha_ketana_16_point_1_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_ketana_16_point_1_degrees,self._uniffi_clone_pointer(),)
        )





    def get_mincha_ketana_72_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_ketana_72_minutes,self._uniffi_clone_pointer(),)
        )





    def get_mincha_ketana_ahavat_shalom(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_ketana_ahavat_shalom,self._uniffi_clone_pointer(),)
        )





    def get_mincha_ketana_ateret_torah(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_ketana_ateret_torah,self._uniffi_clone_pointer(),)
        )





    def get_mincha_ketana_baal_hatanya(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_ketana_baal_hatanya,self._uniffi_clone_pointer(),)
        )





    def get_mincha_ketana_gra_fixed_local_chatzos_to_sunset(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_mincha_ketana_gra_fixed_local_chatzos_to_sunset,self._uniffi_clone_pointer(),)
        )





    def get_misheyakir_10_point_2_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_misheyakir_10_point_2_degrees,self._uniffi_clone_pointer(),)
        )





    def get_misheyakir_11_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_misheyakir_11_degrees,self._uniffi_clone_pointer(),)
        )





    def get_misheyakir_11_point_5_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_misheyakir_11_point_5_degrees,self._uniffi_clone_pointer(),)
        )





    def get_misheyakir_7_point_65_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_misheyakir_7_point_65_degrees,self._uniffi_clone_pointer(),)
        )





    def get_misheyakir_9_point_5_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_misheyakir_9_point_5_degrees,self._uniffi_clone_pointer(),)
        )





    def get_plag_ahavat_shalom(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_ahavat_shalom,self._uniffi_clone_pointer(),)
        )





    def get_plag_alos_16_point_1_to_tzais_geonim_7_point_083_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_alos_16_point_1_to_tzais_geonim_7_point_083_degrees,self._uniffi_clone_pointer(),)
        )





    def get_plag_alos_to_sunset(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_alos_to_sunset,self._uniffi_clone_pointer(),)
        )





    def get_plag_hamincha_120_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_120_minutes,self._uniffi_clone_pointer(),)
        )





    def get_plag_hamincha_120_minutes_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_120_minutes_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_plag_hamincha_16_point_1_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_16_point_1_degrees,self._uniffi_clone_pointer(),)
        )





    def get_plag_hamincha_18_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_18_degrees,self._uniffi_clone_pointer(),)
        )





    def get_plag_hamincha_19_point_8_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_19_point_8_degrees,self._uniffi_clone_pointer(),)
        )





    def get_plag_hamincha_26_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_26_degrees,self._uniffi_clone_pointer(),)
        )





    def get_plag_hamincha_60_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_60_minutes,self._uniffi_clone_pointer(),)
        )





    def get_plag_hamincha_72_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_72_minutes,self._uniffi_clone_pointer(),)
        )





    def get_plag_hamincha_72_minutes_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_72_minutes_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_plag_hamincha_90_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_90_minutes,self._uniffi_clone_pointer(),)
        )





    def get_plag_hamincha_90_minutes_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_90_minutes_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_plag_hamincha_96_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_96_minutes,self._uniffi_clone_pointer(),)
        )





    def get_plag_hamincha_96_minutes_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_96_minutes_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_plag_hamincha_ateret_torah(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_ateret_torah,self._uniffi_clone_pointer(),)
        )





    def get_plag_hamincha_baal_hatanya(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_baal_hatanya,self._uniffi_clone_pointer(),)
        )





    def get_plag_hamincha_gra_fixed_local_chatzos_to_sunset(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_plag_hamincha_gra_fixed_local_chatzos_to_sunset,self._uniffi_clone_pointer(),)
        )





    def get_samuch_le_mincha_ketana_16_point_1_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_samuch_le_mincha_ketana_16_point_1_degrees,self._uniffi_clone_pointer(),)
        )





    def get_samuch_le_mincha_ketana_72_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_samuch_le_mincha_ketana_72_minutes,self._uniffi_clone_pointer(),)
        )





    def get_samuch_le_mincha_ketana_gra(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_samuch_le_mincha_ketana_gra,self._uniffi_clone_pointer(),)
        )





    def get_shaah_zmanis_120_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_120_minutes,self._uniffi_clone_pointer(),)
        )





    def get_shaah_zmanis_120_minutes_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_120_minutes_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_shaah_zmanis_16_point_1_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_16_point_1_degrees,self._uniffi_clone_pointer(),)
        )





    def get_shaah_zmanis_18_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_18_degrees,self._uniffi_clone_pointer(),)
        )





    def get_shaah_zmanis_19_point_8_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_19_point_8_degrees,self._uniffi_clone_pointer(),)
        )





    def get_shaah_zmanis_26_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_26_degrees,self._uniffi_clone_pointer(),)
        )





    def get_shaah_zmanis_60_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_60_minutes,self._uniffi_clone_pointer(),)
        )





    def get_shaah_zmanis_72_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_72_minutes,self._uniffi_clone_pointer(),)
        )





    def get_shaah_zmanis_72_minutes_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_72_minutes_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_shaah_zmanis_90_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_90_minutes,self._uniffi_clone_pointer(),)
        )





    def get_shaah_zmanis_90_minutes_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_90_minutes_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_shaah_zmanis_96_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_96_minutes,self._uniffi_clone_pointer(),)
        )





    def get_shaah_zmanis_96_minutes_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_96_minutes_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_shaah_zmanis_alos_16_point_1_to_tzais_3_point_7(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_alos_16_point_1_to_tzais_3_point_7,self._uniffi_clone_pointer(),)
        )





    def get_shaah_zmanis_alos_16_point_1_to_tzais_3_point_8(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_alos_16_point_1_to_tzais_3_point_8,self._uniffi_clone_pointer(),)
        )





    def get_shaah_zmanis_ateret_torah(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_ateret_torah,self._uniffi_clone_pointer(),)
        )





    def get_shaah_zmanis_baal_hatanya(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_shaah_zmanis_baal_hatanya,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_achilas_chametz_baal_hatanya(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_baal_hatanya,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_achilas_chametz_gra(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_gra,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_achilas_chametz_mga_16_point_1_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_mga_16_point_1_degrees,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_achilas_chametz_mga_72_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_mga_72_minutes,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_achilas_chametz_mga_72_minutes_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_achilas_chametz_mga_72_minutes_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_biur_chametz_baal_hatanya(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_biur_chametz_baal_hatanya,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_biur_chametz_gra(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_biur_chametz_gra,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_biur_chametz_mga_16_point_1_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_biur_chametz_mga_16_point_1_degrees,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_biur_chametz_mga_72_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_biur_chametz_mga_72_minutes,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_biur_chametz_mga_72_minutes_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_biur_chametz_mga_72_minutes_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_kidush_levana_15_days(self, alos: "typing.Optional[int]",tzais: "typing.Optional[int]") -> "typing.Optional[int]":
        _UniffiConverterOptionalInt64.check_lower(alos)
        
        _UniffiConverterOptionalInt64.check_lower(tzais)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_kidush_levana_15_days,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalInt64.lower(alos),
        _UniffiConverterOptionalInt64.lower(tzais))
        )





    def get_sof_zman_kidush_levana_15_days_default(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_kidush_levana_15_days_default,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_kidush_levana_between_moldos(self, alos: "typing.Optional[int]",tzais: "typing.Optional[int]") -> "typing.Optional[int]":
        _UniffiConverterOptionalInt64.check_lower(alos)
        
        _UniffiConverterOptionalInt64.check_lower(tzais)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_kidush_levana_between_moldos,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalInt64.lower(alos),
        _UniffiConverterOptionalInt64.lower(tzais))
        )





    def get_sof_zman_kidush_levana_between_moldos_default(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_kidush_levana_between_moldos_default,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_3_hours_before_chatzos(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_3_hours_before_chatzos,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_alos_16_point_1_to_sunset(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_alos_16_point_1_to_sunset,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_alos_16_point_1_to_tzais_geonim_7_point_083_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_alos_16_point_1_to_tzais_geonim_7_point_083_degrees,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_ateret_torah(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_ateret_torah,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_baal_hatanya(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_baal_hatanya,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_fixed_local(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_fixed_local,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_gra_sunrise_to_fixed_local_chatzos(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_gra_sunrise_to_fixed_local_chatzos,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_kol_eliyahu(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_kol_eliyahu,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_mga_120_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_120_minutes,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_mga_16_point_1_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_16_point_1_degrees,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_mga_16_point_1_degrees_to_fixed_local_chatzos(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_16_point_1_degrees_to_fixed_local_chatzos,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_mga_18_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_18_degrees,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_mga_18_degrees_to_fixed_local_chatzos(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_18_degrees_to_fixed_local_chatzos,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_mga_19_point_8_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_19_point_8_degrees,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_mga_72_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_72_minutes,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_mga_72_minutes_to_fixed_local_chatzos(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_72_minutes_to_fixed_local_chatzos,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_mga_72_minutes_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_72_minutes_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_mga_90_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_90_minutes,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_mga_90_minutes_to_fixed_local_chatzos(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_90_minutes_to_fixed_local_chatzos,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_mga_90_minutes_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_90_minutes_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_mga_96_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_96_minutes,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_mga_96_minutes_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_shma_mga_96_minutes_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_tfila_2_hours_before_chatzos(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_2_hours_before_chatzos,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_tfila_ateret_torah(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_ateret_torah,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_tfila_baal_hatanya(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_baal_hatanya,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_tfila_fixed_local(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_fixed_local,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_tfila_gra_sunrise_to_fixed_local_chatzos(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_gra_sunrise_to_fixed_local_chatzos,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_tfila_mga_120_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_120_minutes,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_tfila_mga_16_point_1_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_16_point_1_degrees,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_tfila_mga_18_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_18_degrees,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_tfila_mga_19_point_8_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_19_point_8_degrees,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_tfila_mga_72_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_72_minutes,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_tfila_mga_72_minutes_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_72_minutes_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_tfila_mga_90_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_90_minutes,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_tfila_mga_90_minutes_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_90_minutes_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_tfila_mga_96_minutes(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_96_minutes,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_tfila_mga_96_minutes_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfila_mga_96_minutes_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_tfilah_ateret_torah(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_sof_zman_tfilah_ateret_torah,self._uniffi_clone_pointer(),)
        )





    def get_tchilas_zman_kidush_levana_3_days(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_3_days,self._uniffi_clone_pointer(),)
        )





    def get_tchilas_zman_kidush_levana_3_days_with_times(self, alos: "typing.Optional[int]",tzais: "typing.Optional[int]") -> "typing.Optional[int]":
        _UniffiConverterOptionalInt64.check_lower(alos)
        
        _UniffiConverterOptionalInt64.check_lower(tzais)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_3_days_with_times,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalInt64.lower(alos),
        _UniffiConverterOptionalInt64.lower(tzais))
        )





    def get_tchilas_zman_kidush_levana_7_days(self, alos: "typing.Optional[int]",tzais: "typing.Optional[int]") -> "typing.Optional[int]":
        _UniffiConverterOptionalInt64.check_lower(alos)
        
        _UniffiConverterOptionalInt64.check_lower(tzais)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_7_days,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalInt64.lower(alos),
        _UniffiConverterOptionalInt64.lower(tzais))
        )





    def get_tchilas_zman_kidush_levana_7_days_default(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tchilas_zman_kidush_levana_7_days_default,self._uniffi_clone_pointer(),)
        )





    def get_tzais_120(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_120,self._uniffi_clone_pointer(),)
        )





    def get_tzais_120_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_120_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_tzais_16_point_1_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_16_point_1_degrees,self._uniffi_clone_pointer(),)
        )





    def get_tzais_18_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_18_degrees,self._uniffi_clone_pointer(),)
        )





    def get_tzais_19_point_8_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_19_point_8_degrees,self._uniffi_clone_pointer(),)
        )





    def get_tzais_26_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_26_degrees,self._uniffi_clone_pointer(),)
        )





    def get_tzais_50(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_50,self._uniffi_clone_pointer(),)
        )





    def get_tzais_60(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_60,self._uniffi_clone_pointer(),)
        )





    def get_tzais_72_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_72_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_tzais_90(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_90,self._uniffi_clone_pointer(),)
        )





    def get_tzais_90_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_90_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_tzais_96(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_96,self._uniffi_clone_pointer(),)
        )





    def get_tzais_96_zmanis(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_96_zmanis,self._uniffi_clone_pointer(),)
        )





    def get_tzais_ateret_torah(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_ateret_torah,self._uniffi_clone_pointer(),)
        )





    def get_tzais_baal_hatanya(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_baal_hatanya,self._uniffi_clone_pointer(),)
        )





    def get_tzais_geonim_3_point_65_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_3_point_65_degrees,self._uniffi_clone_pointer(),)
        )





    def get_tzais_geonim_3_point_676_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_3_point_676_degrees,self._uniffi_clone_pointer(),)
        )





    def get_tzais_geonim_3_point_7_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_3_point_7_degrees,self._uniffi_clone_pointer(),)
        )





    def get_tzais_geonim_3_point_8_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_3_point_8_degrees,self._uniffi_clone_pointer(),)
        )





    def get_tzais_geonim_4_point_37_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_4_point_37_degrees,self._uniffi_clone_pointer(),)
        )





    def get_tzais_geonim_4_point_61_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_4_point_61_degrees,self._uniffi_clone_pointer(),)
        )





    def get_tzais_geonim_4_point_8_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_4_point_8_degrees,self._uniffi_clone_pointer(),)
        )





    def get_tzais_geonim_5_point_88_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_5_point_88_degrees,self._uniffi_clone_pointer(),)
        )





    def get_tzais_geonim_5_point_95_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_5_point_95_degrees,self._uniffi_clone_pointer(),)
        )





    def get_tzais_geonim_6_point_45_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_6_point_45_degrees,self._uniffi_clone_pointer(),)
        )





    def get_tzais_geonim_7_point_083_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_7_point_083_degrees,self._uniffi_clone_pointer(),)
        )





    def get_tzais_geonim_7_point_67_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_7_point_67_degrees,self._uniffi_clone_pointer(),)
        )





    def get_tzais_geonim_8_point_5_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_8_point_5_degrees,self._uniffi_clone_pointer(),)
        )





    def get_tzais_geonim_9_point_3_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_9_point_3_degrees,self._uniffi_clone_pointer(),)
        )





    def get_tzais_geonim_9_point_75_degrees(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_tzais_geonim_9_point_75_degrees,self._uniffi_clone_pointer(),)
        )





    def get_use_astronomical_chatzos(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_use_astronomical_chatzos,self._uniffi_clone_pointer(),)
        )





    def get_use_astronomical_chatzos_for_other_zmanim(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_use_astronomical_chatzos_for_other_zmanim,self._uniffi_clone_pointer(),)
        )





    def get_zman_molad(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_complexzmanimcalendar_get_zman_molad,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeComplexZmanimCalendar:

    @staticmethod
    def lift(value: int):
        return ComplexZmanimCalendar._make_instance_(value)

    @staticmethod
    def check_lower(value: ComplexZmanimCalendar):
        if not isinstance(value, ComplexZmanimCalendar):
            raise TypeError("Expected ComplexZmanimCalendar instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ComplexZmanimCalendarProtocol):
        if not isinstance(value, ComplexZmanimCalendar):
            raise TypeError("Expected ComplexZmanimCalendar instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ComplexZmanimCalendarProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class GeoLocationProtocol(typing.Protocol):
    def geodesic_distance(self, location: "GeoLocation"):
        raise NotImplementedError
    def geodesic_final_bearing(self, location: "GeoLocation"):
        raise NotImplementedError
    def geodesic_initial_bearing(self, location: "GeoLocation"):
        raise NotImplementedError
    def get_elevation(self, ):
        raise NotImplementedError
    def get_latitude(self, ):
        raise NotImplementedError
    def get_longitude(self, ):
        raise NotImplementedError
    def rhumb_line_bearing(self, location: "GeoLocation"):
        raise NotImplementedError
    def rhumb_line_distance(self, location: "GeoLocation"):
        raise NotImplementedError
    def vincenty_inverse_formula(self, location: "GeoLocation",formula: "Formula"):
        raise NotImplementedError


class GeoLocation:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_free_geolocation, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_clone_geolocation, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def geodesic_distance(self, location: "GeoLocation") -> "typing.Optional[float]":
        _UniffiConverterTypeGeoLocation.check_lower(location)
        
        return _UniffiConverterOptionalDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_geodesic_distance,self._uniffi_clone_pointer(),
        _UniffiConverterTypeGeoLocation.lower(location))
        )





    def geodesic_final_bearing(self, location: "GeoLocation") -> "typing.Optional[float]":
        _UniffiConverterTypeGeoLocation.check_lower(location)
        
        return _UniffiConverterOptionalDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_geodesic_final_bearing,self._uniffi_clone_pointer(),
        _UniffiConverterTypeGeoLocation.lower(location))
        )





    def geodesic_initial_bearing(self, location: "GeoLocation") -> "typing.Optional[float]":
        _UniffiConverterTypeGeoLocation.check_lower(location)
        
        return _UniffiConverterOptionalDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_geodesic_initial_bearing,self._uniffi_clone_pointer(),
        _UniffiConverterTypeGeoLocation.lower(location))
        )





    def get_elevation(self, ) -> "float":
        return _UniffiConverterDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_get_elevation,self._uniffi_clone_pointer(),)
        )





    def get_latitude(self, ) -> "float":
        return _UniffiConverterDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_get_latitude,self._uniffi_clone_pointer(),)
        )





    def get_longitude(self, ) -> "float":
        return _UniffiConverterDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_get_longitude,self._uniffi_clone_pointer(),)
        )





    def rhumb_line_bearing(self, location: "GeoLocation") -> "float":
        _UniffiConverterTypeGeoLocation.check_lower(location)
        
        return _UniffiConverterDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_rhumb_line_bearing,self._uniffi_clone_pointer(),
        _UniffiConverterTypeGeoLocation.lower(location))
        )





    def rhumb_line_distance(self, location: "GeoLocation") -> "float":
        _UniffiConverterTypeGeoLocation.check_lower(location)
        
        return _UniffiConverterDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_rhumb_line_distance,self._uniffi_clone_pointer(),
        _UniffiConverterTypeGeoLocation.lower(location))
        )





    def vincenty_inverse_formula(self, location: "GeoLocation",formula: "Formula") -> "typing.Optional[float]":
        _UniffiConverterTypeGeoLocation.check_lower(location)
        
        _UniffiConverterTypeFormula.check_lower(formula)
        
        return _UniffiConverterOptionalDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_geolocation_vincenty_inverse_formula,self._uniffi_clone_pointer(),
        _UniffiConverterTypeGeoLocation.lower(location),
        _UniffiConverterTypeFormula.lower(formula))
        )






class _UniffiConverterTypeGeoLocation:

    @staticmethod
    def lift(value: int):
        return GeoLocation._make_instance_(value)

    @staticmethod
    def check_lower(value: GeoLocation):
        if not isinstance(value, GeoLocation):
            raise TypeError("Expected GeoLocation instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: GeoLocationProtocol):
        if not isinstance(value, GeoLocation):
            raise TypeError("Expected GeoLocation instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: GeoLocationProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class JewishCalendarProtocol(typing.Protocol):
    def get_bavli_daf_yomi(self, ):
        raise NotImplementedError
    def get_day_of_chanukah(self, ):
        raise NotImplementedError
    def get_day_of_omer(self, ):
        raise NotImplementedError
    def get_in_israel(self, ):
        raise NotImplementedError
    def get_jewish_date(self, ):
        raise NotImplementedError
    def get_parshah(self, ):
        raise NotImplementedError
    def get_use_modern_holidays(self, ):
        raise NotImplementedError
    def get_yom_tov_index(self, ):
        raise NotImplementedError
    def has_candle_lighting(self, ):
        raise NotImplementedError
    def is_aseres_yemei_teshuva(self, ):
        raise NotImplementedError
    def is_assur_bemelacha(self, ):
        raise NotImplementedError
    def is_chanukah(self, ):
        raise NotImplementedError
    def is_chol_hamoed(self, ):
        raise NotImplementedError
    def is_chol_hamoed_pesach(self, ):
        raise NotImplementedError
    def is_chol_hamoed_succos(self, ):
        raise NotImplementedError
    def is_erev_yom_tov(self, ):
        raise NotImplementedError
    def is_erev_yom_tov_sheni(self, ):
        raise NotImplementedError
    def is_hoshana_rabba(self, ):
        raise NotImplementedError
    def is_isru_chag(self, ):
        raise NotImplementedError
    def is_pesach(self, ):
        raise NotImplementedError
    def is_purim(self, ):
        raise NotImplementedError
    def is_rosh_chodesh(self, ):
        raise NotImplementedError
    def is_rosh_hashana(self, ):
        raise NotImplementedError
    def is_shavuos(self, ):
        raise NotImplementedError
    def is_shemini_atzeres(self, ):
        raise NotImplementedError
    def is_simchas_torah(self, ):
        raise NotImplementedError
    def is_succos(self, ):
        raise NotImplementedError
    def is_taanis(self, ):
        raise NotImplementedError
    def is_taanis_bechoros(self, ):
        raise NotImplementedError
    def is_tisha_beav(self, ):
        raise NotImplementedError
    def is_tomorrow_shabbos_or_yom_tov(self, ):
        raise NotImplementedError
    def is_yom_kippur(self, ):
        raise NotImplementedError
    def is_yom_tov(self, ):
        raise NotImplementedError
    def is_yom_tov_assur_bemelacha(self, ):
        raise NotImplementedError


class JewishCalendar:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_free_jewishcalendar, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_clone_jewishcalendar, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def get_bavli_daf_yomi(self, ) -> "typing.Optional[BavliDaf]":
        return _UniffiConverterOptionalTypeBavliDaf.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_bavli_daf_yomi,self._uniffi_clone_pointer(),)
        )





    def get_day_of_chanukah(self, ) -> "int":
        return _UniffiConverterInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_day_of_chanukah,self._uniffi_clone_pointer(),)
        )





    def get_day_of_omer(self, ) -> "int":
        return _UniffiConverterInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_day_of_omer,self._uniffi_clone_pointer(),)
        )





    def get_in_israel(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_in_israel,self._uniffi_clone_pointer(),)
        )





    def get_jewish_date(self, ) -> "JewishDate":
        return _UniffiConverterTypeJewishDate.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_jewish_date,self._uniffi_clone_pointer(),)
        )





    def get_parshah(self, ) -> "Parsha":
        return _UniffiConverterTypeParsha.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_parshah,self._uniffi_clone_pointer(),)
        )





    def get_use_modern_holidays(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_use_modern_holidays,self._uniffi_clone_pointer(),)
        )





    def get_yom_tov_index(self, ) -> "typing.Optional[JewishHoliday]":
        return _UniffiConverterOptionalTypeJewishHoliday.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_get_yom_tov_index,self._uniffi_clone_pointer(),)
        )





    def has_candle_lighting(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_has_candle_lighting,self._uniffi_clone_pointer(),)
        )





    def is_aseres_yemei_teshuva(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_aseres_yemei_teshuva,self._uniffi_clone_pointer(),)
        )





    def is_assur_bemelacha(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_assur_bemelacha,self._uniffi_clone_pointer(),)
        )





    def is_chanukah(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_chanukah,self._uniffi_clone_pointer(),)
        )





    def is_chol_hamoed(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_chol_hamoed,self._uniffi_clone_pointer(),)
        )





    def is_chol_hamoed_pesach(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_chol_hamoed_pesach,self._uniffi_clone_pointer(),)
        )





    def is_chol_hamoed_succos(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_chol_hamoed_succos,self._uniffi_clone_pointer(),)
        )





    def is_erev_yom_tov(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_erev_yom_tov,self._uniffi_clone_pointer(),)
        )





    def is_erev_yom_tov_sheni(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_erev_yom_tov_sheni,self._uniffi_clone_pointer(),)
        )





    def is_hoshana_rabba(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_hoshana_rabba,self._uniffi_clone_pointer(),)
        )





    def is_isru_chag(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_isru_chag,self._uniffi_clone_pointer(),)
        )





    def is_pesach(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_pesach,self._uniffi_clone_pointer(),)
        )





    def is_purim(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_purim,self._uniffi_clone_pointer(),)
        )





    def is_rosh_chodesh(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_rosh_chodesh,self._uniffi_clone_pointer(),)
        )





    def is_rosh_hashana(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_rosh_hashana,self._uniffi_clone_pointer(),)
        )





    def is_shavuos(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_shavuos,self._uniffi_clone_pointer(),)
        )





    def is_shemini_atzeres(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_shemini_atzeres,self._uniffi_clone_pointer(),)
        )





    def is_simchas_torah(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_simchas_torah,self._uniffi_clone_pointer(),)
        )





    def is_succos(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_succos,self._uniffi_clone_pointer(),)
        )





    def is_taanis(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_taanis,self._uniffi_clone_pointer(),)
        )





    def is_taanis_bechoros(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_taanis_bechoros,self._uniffi_clone_pointer(),)
        )





    def is_tisha_beav(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_tisha_beav,self._uniffi_clone_pointer(),)
        )





    def is_tomorrow_shabbos_or_yom_tov(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_tomorrow_shabbos_or_yom_tov,self._uniffi_clone_pointer(),)
        )





    def is_yom_kippur(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_yom_kippur,self._uniffi_clone_pointer(),)
        )





    def is_yom_tov(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_yom_tov,self._uniffi_clone_pointer(),)
        )





    def is_yom_tov_assur_bemelacha(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishcalendar_is_yom_tov_assur_bemelacha,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeJewishCalendar:

    @staticmethod
    def lift(value: int):
        return JewishCalendar._make_instance_(value)

    @staticmethod
    def check_lower(value: JewishCalendar):
        if not isinstance(value, JewishCalendar):
            raise TypeError("Expected JewishCalendar instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: JewishCalendarProtocol):
        if not isinstance(value, JewishCalendar):
            raise TypeError("Expected JewishCalendar instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: JewishCalendarProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class JewishDateProtocol(typing.Protocol):
    def get_chalakim_since_molad_tohu(self, ):
        raise NotImplementedError
    def get_cheshvan_kislev_kviah(self, ):
        raise NotImplementedError
    def get_day_of_week(self, ):
        raise NotImplementedError
    def get_days_in_jewish_month(self, ):
        raise NotImplementedError
    def get_days_in_jewish_year(self, ):
        raise NotImplementedError
    def get_days_since_start_of_jewish_year(self, ):
        raise NotImplementedError
    def get_gregorian_day_of_month(self, ):
        raise NotImplementedError
    def get_gregorian_month(self, ):
        raise NotImplementedError
    def get_gregorian_year(self, ):
        raise NotImplementedError
    def get_jewish_day_of_month(self, ):
        raise NotImplementedError
    def get_jewish_month(self, ):
        raise NotImplementedError
    def get_jewish_year(self, ):
        raise NotImplementedError
    def get_molad_data(self, ):
        raise NotImplementedError
    def get_molad_date(self, ):
        raise NotImplementedError
    def is_cheshvan_long(self, ):
        raise NotImplementedError
    def is_jewish_leap_year(self, ):
        raise NotImplementedError
    def is_kislev_short(self, ):
        raise NotImplementedError


class JewishDate:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_free_jewishdate, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_clone_jewishdate, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def get_chalakim_since_molad_tohu(self, ) -> "int":
        return _UniffiConverterInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_chalakim_since_molad_tohu,self._uniffi_clone_pointer(),)
        )





    def get_cheshvan_kislev_kviah(self, ) -> "YearLengthType":
        return _UniffiConverterTypeYearLengthType.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_cheshvan_kislev_kviah,self._uniffi_clone_pointer(),)
        )





    def get_day_of_week(self, ) -> "DayOfWeek":
        return _UniffiConverterTypeDayOfWeek.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_day_of_week,self._uniffi_clone_pointer(),)
        )





    def get_days_in_jewish_month(self, ) -> "int":
        return _UniffiConverterInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_days_in_jewish_month,self._uniffi_clone_pointer(),)
        )





    def get_days_in_jewish_year(self, ) -> "int":
        return _UniffiConverterInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_days_in_jewish_year,self._uniffi_clone_pointer(),)
        )





    def get_days_since_start_of_jewish_year(self, ) -> "int":
        return _UniffiConverterInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_days_since_start_of_jewish_year,self._uniffi_clone_pointer(),)
        )





    def get_gregorian_day_of_month(self, ) -> "int":
        return _UniffiConverterInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_gregorian_day_of_month,self._uniffi_clone_pointer(),)
        )





    def get_gregorian_month(self, ) -> "int":
        return _UniffiConverterInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_gregorian_month,self._uniffi_clone_pointer(),)
        )





    def get_gregorian_year(self, ) -> "int":
        return _UniffiConverterInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_gregorian_year,self._uniffi_clone_pointer(),)
        )





    def get_jewish_day_of_month(self, ) -> "int":
        return _UniffiConverterInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_jewish_day_of_month,self._uniffi_clone_pointer(),)
        )





    def get_jewish_month(self, ) -> "JewishMonth":
        return _UniffiConverterTypeJewishMonth.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_jewish_month,self._uniffi_clone_pointer(),)
        )





    def get_jewish_year(self, ) -> "int":
        return _UniffiConverterInt32.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_jewish_year,self._uniffi_clone_pointer(),)
        )





    def get_molad_data(self, ) -> "typing.Optional[MoladData]":
        return _UniffiConverterOptionalTypeMoladData.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_molad_data,self._uniffi_clone_pointer(),)
        )





    def get_molad_date(self, ) -> "typing.Optional[JewishDate]":
        return _UniffiConverterOptionalTypeJewishDate.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_get_molad_date,self._uniffi_clone_pointer(),)
        )





    def is_cheshvan_long(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_is_cheshvan_long,self._uniffi_clone_pointer(),)
        )





    def is_jewish_leap_year(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_is_jewish_leap_year,self._uniffi_clone_pointer(),)
        )





    def is_kislev_short(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_jewishdate_is_kislev_short,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeJewishDate:

    @staticmethod
    def lift(value: int):
        return JewishDate._make_instance_(value)

    @staticmethod
    def check_lower(value: JewishDate):
        if not isinstance(value, JewishDate):
            raise TypeError("Expected JewishDate instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: JewishDateProtocol):
        if not isinstance(value, JewishDate):
            raise TypeError("Expected JewishDate instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: JewishDateProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class MoladDataProtocol(typing.Protocol):
    pass


class MoladData:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_free_moladdata, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_clone_moladdata, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst



class _UniffiConverterTypeMoladData:

    @staticmethod
    def lift(value: int):
        return MoladData._make_instance_(value)

    @staticmethod
    def check_lower(value: MoladData):
        if not isinstance(value, MoladData):
            raise TypeError("Expected MoladData instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: MoladDataProtocol):
        if not isinstance(value, MoladData):
            raise TypeError("Expected MoladData instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: MoladDataProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class NoaaCalculatorProtocol(typing.Protocol):
    def get_solar_azimuth(self, timestamp: "int",geo_location: "GeoLocation"):
        raise NotImplementedError
    def get_solar_elevation(self, timestamp: "int",geo_location: "GeoLocation"):
        raise NotImplementedError
    def get_utc_midnight(self, timestamp: "int",geo_location: "GeoLocation"):
        raise NotImplementedError
    def get_utc_noon(self, timestamp: "int",geo_location: "GeoLocation"):
        raise NotImplementedError
    def get_utc_sunrise(self, timestamp: "int",geo_location: "GeoLocation",zenith: "float",adjust_for_elevation: "bool"):
        raise NotImplementedError
    def get_utc_sunset(self, timestamp: "int",geo_location: "GeoLocation",zenith: "float",adjust_for_elevation: "bool"):
        raise NotImplementedError


class NoaaCalculator:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_free_noaacalculator, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_clone_noaacalculator, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def get_solar_azimuth(self, timestamp: "int",geo_location: "GeoLocation") -> "typing.Optional[float]":
        _UniffiConverterInt64.check_lower(timestamp)
        
        _UniffiConverterTypeGeoLocation.check_lower(geo_location)
        
        return _UniffiConverterOptionalDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_noaacalculator_get_solar_azimuth,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(timestamp),
        _UniffiConverterTypeGeoLocation.lower(geo_location))
        )





    def get_solar_elevation(self, timestamp: "int",geo_location: "GeoLocation") -> "typing.Optional[float]":
        _UniffiConverterInt64.check_lower(timestamp)
        
        _UniffiConverterTypeGeoLocation.check_lower(geo_location)
        
        return _UniffiConverterOptionalDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_noaacalculator_get_solar_elevation,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(timestamp),
        _UniffiConverterTypeGeoLocation.lower(geo_location))
        )





    def get_utc_midnight(self, timestamp: "int",geo_location: "GeoLocation") -> "typing.Optional[float]":
        _UniffiConverterInt64.check_lower(timestamp)
        
        _UniffiConverterTypeGeoLocation.check_lower(geo_location)
        
        return _UniffiConverterOptionalDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_noaacalculator_get_utc_midnight,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(timestamp),
        _UniffiConverterTypeGeoLocation.lower(geo_location))
        )





    def get_utc_noon(self, timestamp: "int",geo_location: "GeoLocation") -> "typing.Optional[float]":
        _UniffiConverterInt64.check_lower(timestamp)
        
        _UniffiConverterTypeGeoLocation.check_lower(geo_location)
        
        return _UniffiConverterOptionalDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_noaacalculator_get_utc_noon,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(timestamp),
        _UniffiConverterTypeGeoLocation.lower(geo_location))
        )





    def get_utc_sunrise(self, timestamp: "int",geo_location: "GeoLocation",zenith: "float",adjust_for_elevation: "bool") -> "typing.Optional[float]":
        _UniffiConverterInt64.check_lower(timestamp)
        
        _UniffiConverterTypeGeoLocation.check_lower(geo_location)
        
        _UniffiConverterDouble.check_lower(zenith)
        
        _UniffiConverterBool.check_lower(adjust_for_elevation)
        
        return _UniffiConverterOptionalDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_noaacalculator_get_utc_sunrise,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(timestamp),
        _UniffiConverterTypeGeoLocation.lower(geo_location),
        _UniffiConverterDouble.lower(zenith),
        _UniffiConverterBool.lower(adjust_for_elevation))
        )





    def get_utc_sunset(self, timestamp: "int",geo_location: "GeoLocation",zenith: "float",adjust_for_elevation: "bool") -> "typing.Optional[float]":
        _UniffiConverterInt64.check_lower(timestamp)
        
        _UniffiConverterTypeGeoLocation.check_lower(geo_location)
        
        _UniffiConverterDouble.check_lower(zenith)
        
        _UniffiConverterBool.check_lower(adjust_for_elevation)
        
        return _UniffiConverterOptionalDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_noaacalculator_get_utc_sunset,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(timestamp),
        _UniffiConverterTypeGeoLocation.lower(geo_location),
        _UniffiConverterDouble.lower(zenith),
        _UniffiConverterBool.lower(adjust_for_elevation))
        )






class _UniffiConverterTypeNoaaCalculator:

    @staticmethod
    def lift(value: int):
        return NoaaCalculator._make_instance_(value)

    @staticmethod
    def check_lower(value: NoaaCalculator):
        if not isinstance(value, NoaaCalculator):
            raise TypeError("Expected NoaaCalculator instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: NoaaCalculatorProtocol):
        if not isinstance(value, NoaaCalculator):
            raise TypeError("Expected NoaaCalculator instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: NoaaCalculatorProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))



class ZmanimCalendarProtocol(typing.Protocol):
    def get_mincha_gedola(self, start_of_day: "typing.Optional[int]",end_of_day: "int",synchronous: "bool"):
        raise NotImplementedError
    def get_mincha_ketana(self, start_of_day: "typing.Optional[int]",end_of_day: "int",synchronous: "bool"):
        raise NotImplementedError
    def get_plag_hamincha(self, start_of_day: "typing.Optional[int]",end_of_day: "int",synchronous: "bool"):
        raise NotImplementedError
    def get_samuch_le_mincha_ketana(self, start_of_day: "typing.Optional[int]",end_of_day: "int",synchronous: "bool"):
        raise NotImplementedError
    def get_sof_zman_shma(self, start_of_day: "int",end_of_day: "typing.Optional[int]",synchronous: "bool"):
        raise NotImplementedError
    def get_sof_zman_tfila(self, start_of_day: "int",end_of_day: "typing.Optional[int]",synchronous: "bool"):
        raise NotImplementedError
    def get_alos72(self, ):
        raise NotImplementedError
    def get_alos_hashachar(self, ):
        raise NotImplementedError
    def get_astronomical_calendar(self, ):
        raise NotImplementedError
    def get_candle_lighting(self, ):
        raise NotImplementedError
    def get_candle_lighting_offset(self, ):
        raise NotImplementedError
    def get_chatzos(self, ):
        raise NotImplementedError
    def get_chatzos_as_half_day(self, ):
        raise NotImplementedError
    def get_half_day_based_shaah_zmanis(self, start_of_half_day: "int",end_of_half_day: "int"):
        raise NotImplementedError
    def get_half_day_based_zman(self, start_of_half_day: "int",end_of_half_day: "int",hours: "float"):
        raise NotImplementedError
    def get_mincha_gedola_default(self, ):
        raise NotImplementedError
    def get_mincha_gedola_simple(self, start_of_day: "int",end_of_day: "int"):
        raise NotImplementedError
    def get_mincha_ketana_default(self, ):
        raise NotImplementedError
    def get_mincha_ketana_simple(self, start_of_day: "int",end_of_day: "int"):
        raise NotImplementedError
    def get_percent_of_shaah_zmanis_from_degrees(self, degrees: "float",sunset: "bool"):
        raise NotImplementedError
    def get_plag_hamincha_default(self, ):
        raise NotImplementedError
    def get_plag_hamincha_simple(self, start_of_day: "int",end_of_day: "int"):
        raise NotImplementedError
    def get_samuch_le_mincha_ketana_simple(self, start_of_day: "int",end_of_day: "int"):
        raise NotImplementedError
    def get_shaah_zmanis_based_zman(self, start_of_day: "int",end_of_day: "int",hours: "float"):
        raise NotImplementedError
    def get_shaah_zmanis_gra(self, ):
        raise NotImplementedError
    def get_shaah_zmanis_mga(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_gra(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_mga(self, ):
        raise NotImplementedError
    def get_sof_zman_shma_simple(self, start_of_day: "int",end_of_day: "int"):
        raise NotImplementedError
    def get_sof_zman_tfila_gra(self, ):
        raise NotImplementedError
    def get_sof_zman_tfila_mga(self, ):
        raise NotImplementedError
    def get_sof_zman_tfila_simple(self, start_of_day: "int",end_of_day: "int"):
        raise NotImplementedError
    def get_tzais(self, ):
        raise NotImplementedError
    def get_tzais72(self, ):
        raise NotImplementedError
    def get_use_astronomical_chatzos(self, ):
        raise NotImplementedError
    def get_use_astronomical_chatzos_for_other_zmanim(self, ):
        raise NotImplementedError


class ZmanimCalendar:
    _pointer: ctypes.c_void_p
    
    def __init__(self, *args, **kwargs):
        raise ValueError("This class has no default constructor")

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_free_zmanimcalendar, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_clone_zmanimcalendar, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def get_mincha_gedola(self, start_of_day: "typing.Optional[int]",end_of_day: "int",synchronous: "bool") -> "typing.Optional[int]":
        _UniffiConverterOptionalInt64.check_lower(start_of_day)
        
        _UniffiConverterInt64.check_lower(end_of_day)
        
        _UniffiConverterBool.check_lower(synchronous)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar__get_mincha_gedola,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalInt64.lower(start_of_day),
        _UniffiConverterInt64.lower(end_of_day),
        _UniffiConverterBool.lower(synchronous))
        )





    def get_mincha_ketana(self, start_of_day: "typing.Optional[int]",end_of_day: "int",synchronous: "bool") -> "typing.Optional[int]":
        _UniffiConverterOptionalInt64.check_lower(start_of_day)
        
        _UniffiConverterInt64.check_lower(end_of_day)
        
        _UniffiConverterBool.check_lower(synchronous)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar__get_mincha_ketana,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalInt64.lower(start_of_day),
        _UniffiConverterInt64.lower(end_of_day),
        _UniffiConverterBool.lower(synchronous))
        )





    def get_plag_hamincha(self, start_of_day: "typing.Optional[int]",end_of_day: "int",synchronous: "bool") -> "typing.Optional[int]":
        _UniffiConverterOptionalInt64.check_lower(start_of_day)
        
        _UniffiConverterInt64.check_lower(end_of_day)
        
        _UniffiConverterBool.check_lower(synchronous)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar__get_plag_hamincha,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalInt64.lower(start_of_day),
        _UniffiConverterInt64.lower(end_of_day),
        _UniffiConverterBool.lower(synchronous))
        )





    def get_samuch_le_mincha_ketana(self, start_of_day: "typing.Optional[int]",end_of_day: "int",synchronous: "bool") -> "typing.Optional[int]":
        _UniffiConverterOptionalInt64.check_lower(start_of_day)
        
        _UniffiConverterInt64.check_lower(end_of_day)
        
        _UniffiConverterBool.check_lower(synchronous)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar__get_samuch_le_mincha_ketana,self._uniffi_clone_pointer(),
        _UniffiConverterOptionalInt64.lower(start_of_day),
        _UniffiConverterInt64.lower(end_of_day),
        _UniffiConverterBool.lower(synchronous))
        )





    def get_sof_zman_shma(self, start_of_day: "int",end_of_day: "typing.Optional[int]",synchronous: "bool") -> "typing.Optional[int]":
        _UniffiConverterInt64.check_lower(start_of_day)
        
        _UniffiConverterOptionalInt64.check_lower(end_of_day)
        
        _UniffiConverterBool.check_lower(synchronous)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar__get_sof_zman_shma,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(start_of_day),
        _UniffiConverterOptionalInt64.lower(end_of_day),
        _UniffiConverterBool.lower(synchronous))
        )





    def get_sof_zman_tfila(self, start_of_day: "int",end_of_day: "typing.Optional[int]",synchronous: "bool") -> "typing.Optional[int]":
        _UniffiConverterInt64.check_lower(start_of_day)
        
        _UniffiConverterOptionalInt64.check_lower(end_of_day)
        
        _UniffiConverterBool.check_lower(synchronous)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar__get_sof_zman_tfila,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(start_of_day),
        _UniffiConverterOptionalInt64.lower(end_of_day),
        _UniffiConverterBool.lower(synchronous))
        )





    def get_alos72(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_alos72,self._uniffi_clone_pointer(),)
        )





    def get_alos_hashachar(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_alos_hashachar,self._uniffi_clone_pointer(),)
        )





    def get_astronomical_calendar(self, ) -> "AstronomicalCalendar":
        return _UniffiConverterTypeAstronomicalCalendar.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_astronomical_calendar,self._uniffi_clone_pointer(),)
        )





    def get_candle_lighting(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_candle_lighting,self._uniffi_clone_pointer(),)
        )





    def get_candle_lighting_offset(self, ) -> "int":
        return _UniffiConverterInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_candle_lighting_offset,self._uniffi_clone_pointer(),)
        )





    def get_chatzos(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_chatzos,self._uniffi_clone_pointer(),)
        )





    def get_chatzos_as_half_day(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_chatzos_as_half_day,self._uniffi_clone_pointer(),)
        )





    def get_half_day_based_shaah_zmanis(self, start_of_half_day: "int",end_of_half_day: "int") -> "typing.Optional[int]":
        _UniffiConverterInt64.check_lower(start_of_half_day)
        
        _UniffiConverterInt64.check_lower(end_of_half_day)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_half_day_based_shaah_zmanis,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(start_of_half_day),
        _UniffiConverterInt64.lower(end_of_half_day))
        )





    def get_half_day_based_zman(self, start_of_half_day: "int",end_of_half_day: "int",hours: "float") -> "typing.Optional[int]":
        _UniffiConverterInt64.check_lower(start_of_half_day)
        
        _UniffiConverterInt64.check_lower(end_of_half_day)
        
        _UniffiConverterDouble.check_lower(hours)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_half_day_based_zman,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(start_of_half_day),
        _UniffiConverterInt64.lower(end_of_half_day),
        _UniffiConverterDouble.lower(hours))
        )





    def get_mincha_gedola_default(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_mincha_gedola_default,self._uniffi_clone_pointer(),)
        )





    def get_mincha_gedola_simple(self, start_of_day: "int",end_of_day: "int") -> "typing.Optional[int]":
        _UniffiConverterInt64.check_lower(start_of_day)
        
        _UniffiConverterInt64.check_lower(end_of_day)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_mincha_gedola_simple,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(start_of_day),
        _UniffiConverterInt64.lower(end_of_day))
        )





    def get_mincha_ketana_default(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_mincha_ketana_default,self._uniffi_clone_pointer(),)
        )





    def get_mincha_ketana_simple(self, start_of_day: "int",end_of_day: "int") -> "typing.Optional[int]":
        _UniffiConverterInt64.check_lower(start_of_day)
        
        _UniffiConverterInt64.check_lower(end_of_day)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_mincha_ketana_simple,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(start_of_day),
        _UniffiConverterInt64.lower(end_of_day))
        )





    def get_percent_of_shaah_zmanis_from_degrees(self, degrees: "float",sunset: "bool") -> "typing.Optional[float]":
        _UniffiConverterDouble.check_lower(degrees)
        
        _UniffiConverterBool.check_lower(sunset)
        
        return _UniffiConverterOptionalDouble.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_percent_of_shaah_zmanis_from_degrees,self._uniffi_clone_pointer(),
        _UniffiConverterDouble.lower(degrees),
        _UniffiConverterBool.lower(sunset))
        )





    def get_plag_hamincha_default(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_plag_hamincha_default,self._uniffi_clone_pointer(),)
        )





    def get_plag_hamincha_simple(self, start_of_day: "int",end_of_day: "int") -> "typing.Optional[int]":
        _UniffiConverterInt64.check_lower(start_of_day)
        
        _UniffiConverterInt64.check_lower(end_of_day)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_plag_hamincha_simple,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(start_of_day),
        _UniffiConverterInt64.lower(end_of_day))
        )





    def get_samuch_le_mincha_ketana_simple(self, start_of_day: "int",end_of_day: "int") -> "typing.Optional[int]":
        _UniffiConverterInt64.check_lower(start_of_day)
        
        _UniffiConverterInt64.check_lower(end_of_day)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_samuch_le_mincha_ketana_simple,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(start_of_day),
        _UniffiConverterInt64.lower(end_of_day))
        )





    def get_shaah_zmanis_based_zman(self, start_of_day: "int",end_of_day: "int",hours: "float") -> "typing.Optional[int]":
        _UniffiConverterInt64.check_lower(start_of_day)
        
        _UniffiConverterInt64.check_lower(end_of_day)
        
        _UniffiConverterDouble.check_lower(hours)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_shaah_zmanis_based_zman,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(start_of_day),
        _UniffiConverterInt64.lower(end_of_day),
        _UniffiConverterDouble.lower(hours))
        )





    def get_shaah_zmanis_gra(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_shaah_zmanis_gra,self._uniffi_clone_pointer(),)
        )





    def get_shaah_zmanis_mga(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_shaah_zmanis_mga,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_gra(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_sof_zman_shma_gra,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_mga(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_sof_zman_shma_mga,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_shma_simple(self, start_of_day: "int",end_of_day: "int") -> "typing.Optional[int]":
        _UniffiConverterInt64.check_lower(start_of_day)
        
        _UniffiConverterInt64.check_lower(end_of_day)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_sof_zman_shma_simple,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(start_of_day),
        _UniffiConverterInt64.lower(end_of_day))
        )





    def get_sof_zman_tfila_gra(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_sof_zman_tfila_gra,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_tfila_mga(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_sof_zman_tfila_mga,self._uniffi_clone_pointer(),)
        )





    def get_sof_zman_tfila_simple(self, start_of_day: "int",end_of_day: "int") -> "typing.Optional[int]":
        _UniffiConverterInt64.check_lower(start_of_day)
        
        _UniffiConverterInt64.check_lower(end_of_day)
        
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_sof_zman_tfila_simple,self._uniffi_clone_pointer(),
        _UniffiConverterInt64.lower(start_of_day),
        _UniffiConverterInt64.lower(end_of_day))
        )





    def get_tzais(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_tzais,self._uniffi_clone_pointer(),)
        )





    def get_tzais72(self, ) -> "typing.Optional[int]":
        return _UniffiConverterOptionalInt64.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_tzais72,self._uniffi_clone_pointer(),)
        )





    def get_use_astronomical_chatzos(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_use_astronomical_chatzos,self._uniffi_clone_pointer(),)
        )





    def get_use_astronomical_chatzos_for_other_zmanim(self, ) -> "bool":
        return _UniffiConverterBool.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_method_zmanimcalendar_get_use_astronomical_chatzos_for_other_zmanim,self._uniffi_clone_pointer(),)
        )






class _UniffiConverterTypeZmanimCalendar:

    @staticmethod
    def lift(value: int):
        return ZmanimCalendar._make_instance_(value)

    @staticmethod
    def check_lower(value: ZmanimCalendar):
        if not isinstance(value, ZmanimCalendar):
            raise TypeError("Expected ZmanimCalendar instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: ZmanimCalendarProtocol):
        if not isinstance(value, ZmanimCalendar):
            raise TypeError("Expected ZmanimCalendar instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: ZmanimCalendarProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))





class BavliTractate(enum.Enum):
    BERACHOS = 0
    
    SHABBOS = 1
    
    ERUVIN = 2
    
    PESACHIM = 3
    
    SHEKALIM = 4
    
    YOMA = 5
    
    SUKKAH = 6
    
    BEITZAH = 7
    
    ROSH_HASHANA = 8
    
    TAANIS = 9
    
    MEGILLAH = 10
    
    MOED_KATAN = 11
    
    CHAGIGAH = 12
    
    YEVAMOS = 13
    
    KESUBOS = 14
    
    NEDARIM = 15
    
    NAZIR = 16
    
    SOTAH = 17
    
    GITIN = 18
    
    KIDDUSHIN = 19
    
    BAVA_KAMMA = 20
    
    BAVA_METZIA = 21
    
    BAVA_BASRA = 22
    
    SANHEDRIN = 23
    
    MAKKOS = 24
    
    SHEVUOS = 25
    
    AVODAH_ZARAH = 26
    
    HORIYOS = 27
    
    ZEVACHIM = 28
    
    MENACHOS = 29
    
    CHULLIN = 30
    
    BECHOROS = 31
    
    ARACHIN = 32
    
    TEMURAH = 33
    
    KERISOS = 34
    
    MEILAH = 35
    
    KINNIM = 36
    
    TAMID = 37
    
    MIDOS = 38
    
    NIDDAH = 39
    


class _UniffiConverterTypeBavliTractate(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return BavliTractate.BERACHOS
        if variant == 2:
            return BavliTractate.SHABBOS
        if variant == 3:
            return BavliTractate.ERUVIN
        if variant == 4:
            return BavliTractate.PESACHIM
        if variant == 5:
            return BavliTractate.SHEKALIM
        if variant == 6:
            return BavliTractate.YOMA
        if variant == 7:
            return BavliTractate.SUKKAH
        if variant == 8:
            return BavliTractate.BEITZAH
        if variant == 9:
            return BavliTractate.ROSH_HASHANA
        if variant == 10:
            return BavliTractate.TAANIS
        if variant == 11:
            return BavliTractate.MEGILLAH
        if variant == 12:
            return BavliTractate.MOED_KATAN
        if variant == 13:
            return BavliTractate.CHAGIGAH
        if variant == 14:
            return BavliTractate.YEVAMOS
        if variant == 15:
            return BavliTractate.KESUBOS
        if variant == 16:
            return BavliTractate.NEDARIM
        if variant == 17:
            return BavliTractate.NAZIR
        if variant == 18:
            return BavliTractate.SOTAH
        if variant == 19:
            return BavliTractate.GITIN
        if variant == 20:
            return BavliTractate.KIDDUSHIN
        if variant == 21:
            return BavliTractate.BAVA_KAMMA
        if variant == 22:
            return BavliTractate.BAVA_METZIA
        if variant == 23:
            return BavliTractate.BAVA_BASRA
        if variant == 24:
            return BavliTractate.SANHEDRIN
        if variant == 25:
            return BavliTractate.MAKKOS
        if variant == 26:
            return BavliTractate.SHEVUOS
        if variant == 27:
            return BavliTractate.AVODAH_ZARAH
        if variant == 28:
            return BavliTractate.HORIYOS
        if variant == 29:
            return BavliTractate.ZEVACHIM
        if variant == 30:
            return BavliTractate.MENACHOS
        if variant == 31:
            return BavliTractate.CHULLIN
        if variant == 32:
            return BavliTractate.BECHOROS
        if variant == 33:
            return BavliTractate.ARACHIN
        if variant == 34:
            return BavliTractate.TEMURAH
        if variant == 35:
            return BavliTractate.KERISOS
        if variant == 36:
            return BavliTractate.MEILAH
        if variant == 37:
            return BavliTractate.KINNIM
        if variant == 38:
            return BavliTractate.TAMID
        if variant == 39:
            return BavliTractate.MIDOS
        if variant == 40:
            return BavliTractate.NIDDAH
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == BavliTractate.BERACHOS:
            return
        if value == BavliTractate.SHABBOS:
            return
        if value == BavliTractate.ERUVIN:
            return
        if value == BavliTractate.PESACHIM:
            return
        if value == BavliTractate.SHEKALIM:
            return
        if value == BavliTractate.YOMA:
            return
        if value == BavliTractate.SUKKAH:
            return
        if value == BavliTractate.BEITZAH:
            return
        if value == BavliTractate.ROSH_HASHANA:
            return
        if value == BavliTractate.TAANIS:
            return
        if value == BavliTractate.MEGILLAH:
            return
        if value == BavliTractate.MOED_KATAN:
            return
        if value == BavliTractate.CHAGIGAH:
            return
        if value == BavliTractate.YEVAMOS:
            return
        if value == BavliTractate.KESUBOS:
            return
        if value == BavliTractate.NEDARIM:
            return
        if value == BavliTractate.NAZIR:
            return
        if value == BavliTractate.SOTAH:
            return
        if value == BavliTractate.GITIN:
            return
        if value == BavliTractate.KIDDUSHIN:
            return
        if value == BavliTractate.BAVA_KAMMA:
            return
        if value == BavliTractate.BAVA_METZIA:
            return
        if value == BavliTractate.BAVA_BASRA:
            return
        if value == BavliTractate.SANHEDRIN:
            return
        if value == BavliTractate.MAKKOS:
            return
        if value == BavliTractate.SHEVUOS:
            return
        if value == BavliTractate.AVODAH_ZARAH:
            return
        if value == BavliTractate.HORIYOS:
            return
        if value == BavliTractate.ZEVACHIM:
            return
        if value == BavliTractate.MENACHOS:
            return
        if value == BavliTractate.CHULLIN:
            return
        if value == BavliTractate.BECHOROS:
            return
        if value == BavliTractate.ARACHIN:
            return
        if value == BavliTractate.TEMURAH:
            return
        if value == BavliTractate.KERISOS:
            return
        if value == BavliTractate.MEILAH:
            return
        if value == BavliTractate.KINNIM:
            return
        if value == BavliTractate.TAMID:
            return
        if value == BavliTractate.MIDOS:
            return
        if value == BavliTractate.NIDDAH:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == BavliTractate.BERACHOS:
            buf.write_i32(1)
        if value == BavliTractate.SHABBOS:
            buf.write_i32(2)
        if value == BavliTractate.ERUVIN:
            buf.write_i32(3)
        if value == BavliTractate.PESACHIM:
            buf.write_i32(4)
        if value == BavliTractate.SHEKALIM:
            buf.write_i32(5)
        if value == BavliTractate.YOMA:
            buf.write_i32(6)
        if value == BavliTractate.SUKKAH:
            buf.write_i32(7)
        if value == BavliTractate.BEITZAH:
            buf.write_i32(8)
        if value == BavliTractate.ROSH_HASHANA:
            buf.write_i32(9)
        if value == BavliTractate.TAANIS:
            buf.write_i32(10)
        if value == BavliTractate.MEGILLAH:
            buf.write_i32(11)
        if value == BavliTractate.MOED_KATAN:
            buf.write_i32(12)
        if value == BavliTractate.CHAGIGAH:
            buf.write_i32(13)
        if value == BavliTractate.YEVAMOS:
            buf.write_i32(14)
        if value == BavliTractate.KESUBOS:
            buf.write_i32(15)
        if value == BavliTractate.NEDARIM:
            buf.write_i32(16)
        if value == BavliTractate.NAZIR:
            buf.write_i32(17)
        if value == BavliTractate.SOTAH:
            buf.write_i32(18)
        if value == BavliTractate.GITIN:
            buf.write_i32(19)
        if value == BavliTractate.KIDDUSHIN:
            buf.write_i32(20)
        if value == BavliTractate.BAVA_KAMMA:
            buf.write_i32(21)
        if value == BavliTractate.BAVA_METZIA:
            buf.write_i32(22)
        if value == BavliTractate.BAVA_BASRA:
            buf.write_i32(23)
        if value == BavliTractate.SANHEDRIN:
            buf.write_i32(24)
        if value == BavliTractate.MAKKOS:
            buf.write_i32(25)
        if value == BavliTractate.SHEVUOS:
            buf.write_i32(26)
        if value == BavliTractate.AVODAH_ZARAH:
            buf.write_i32(27)
        if value == BavliTractate.HORIYOS:
            buf.write_i32(28)
        if value == BavliTractate.ZEVACHIM:
            buf.write_i32(29)
        if value == BavliTractate.MENACHOS:
            buf.write_i32(30)
        if value == BavliTractate.CHULLIN:
            buf.write_i32(31)
        if value == BavliTractate.BECHOROS:
            buf.write_i32(32)
        if value == BavliTractate.ARACHIN:
            buf.write_i32(33)
        if value == BavliTractate.TEMURAH:
            buf.write_i32(34)
        if value == BavliTractate.KERISOS:
            buf.write_i32(35)
        if value == BavliTractate.MEILAH:
            buf.write_i32(36)
        if value == BavliTractate.KINNIM:
            buf.write_i32(37)
        if value == BavliTractate.TAMID:
            buf.write_i32(38)
        if value == BavliTractate.MIDOS:
            buf.write_i32(39)
        if value == BavliTractate.NIDDAH:
            buf.write_i32(40)







class DayOfWeek(enum.Enum):
    SUNDAY = 1
    
    MONDAY = 2
    
    TUESDAY = 3
    
    WEDNESDAY = 4
    
    THURSDAY = 5
    
    FRIDAY = 6
    
    SATURDAY = 7
    


class _UniffiConverterTypeDayOfWeek(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return DayOfWeek.SUNDAY
        if variant == 2:
            return DayOfWeek.MONDAY
        if variant == 3:
            return DayOfWeek.TUESDAY
        if variant == 4:
            return DayOfWeek.WEDNESDAY
        if variant == 5:
            return DayOfWeek.THURSDAY
        if variant == 6:
            return DayOfWeek.FRIDAY
        if variant == 7:
            return DayOfWeek.SATURDAY
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == DayOfWeek.SUNDAY:
            return
        if value == DayOfWeek.MONDAY:
            return
        if value == DayOfWeek.TUESDAY:
            return
        if value == DayOfWeek.WEDNESDAY:
            return
        if value == DayOfWeek.THURSDAY:
            return
        if value == DayOfWeek.FRIDAY:
            return
        if value == DayOfWeek.SATURDAY:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == DayOfWeek.SUNDAY:
            buf.write_i32(1)
        if value == DayOfWeek.MONDAY:
            buf.write_i32(2)
        if value == DayOfWeek.TUESDAY:
            buf.write_i32(3)
        if value == DayOfWeek.WEDNESDAY:
            buf.write_i32(4)
        if value == DayOfWeek.THURSDAY:
            buf.write_i32(5)
        if value == DayOfWeek.FRIDAY:
            buf.write_i32(6)
        if value == DayOfWeek.SATURDAY:
            buf.write_i32(7)







class Formula(enum.Enum):
    DISTANCE = 0
    
    INITIAL_BEARING = 1
    
    FINAL_BEARING = 2
    


class _UniffiConverterTypeFormula(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return Formula.DISTANCE
        if variant == 2:
            return Formula.INITIAL_BEARING
        if variant == 3:
            return Formula.FINAL_BEARING
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == Formula.DISTANCE:
            return
        if value == Formula.INITIAL_BEARING:
            return
        if value == Formula.FINAL_BEARING:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == Formula.DISTANCE:
            buf.write_i32(1)
        if value == Formula.INITIAL_BEARING:
            buf.write_i32(2)
        if value == Formula.FINAL_BEARING:
            buf.write_i32(3)







class JewishHoliday(enum.Enum):
    EREV_PESACH = 0
    
    PESACH = 1
    
    CHOL_HAMOED_PESACH = 2
    
    PESACH_SHENI = 3
    
    EREV_SHAVUOS = 4
    
    SHAVUOS = 5
    
    SEVENTEEN_OF_TAMMUZ = 6
    
    TISHA_BEAV = 7
    
    TU_BEAV = 8
    
    EREV_ROSH_HASHANA = 9
    
    ROSH_HASHANA = 10
    
    FAST_OF_GEDALYAH = 11
    
    EREV_YOM_KIPPUR = 12
    
    YOM_KIPPUR = 13
    
    EREV_SUCCOS = 14
    
    SUCCOS = 15
    
    CHOL_HAMOED_SUCCOS = 16
    
    HOSHANA_RABBA = 17
    
    SHEMINI_ATZERES = 18
    
    SIMCHAS_TORAH = 19
    
    CHANUKAH = 21
    
    TENTH_OF_TEVES = 22
    
    TU_BESHVAT = 23
    
    FAST_OF_ESTHER = 24
    
    PURIM = 25
    
    SHUSHAN_PURIM = 26
    
    PURIM_KATAN = 27
    
    ROSH_CHODESH = 28
    
    YOM_HASHOAH = 29
    
    YOM_HAZIKARON = 30
    
    YOM_HAATZMAUT = 31
    
    YOM_YERUSHALAYIM = 32
    
    LAG_BAOMER = 33
    
    SHUSHAN_PURIM_KATAN = 34
    
    ISRU_CHAG = 35
    
    YOM_KIPPUR_KATAN = 36
    
    BEHAB = 37
    


class _UniffiConverterTypeJewishHoliday(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return JewishHoliday.EREV_PESACH
        if variant == 2:
            return JewishHoliday.PESACH
        if variant == 3:
            return JewishHoliday.CHOL_HAMOED_PESACH
        if variant == 4:
            return JewishHoliday.PESACH_SHENI
        if variant == 5:
            return JewishHoliday.EREV_SHAVUOS
        if variant == 6:
            return JewishHoliday.SHAVUOS
        if variant == 7:
            return JewishHoliday.SEVENTEEN_OF_TAMMUZ
        if variant == 8:
            return JewishHoliday.TISHA_BEAV
        if variant == 9:
            return JewishHoliday.TU_BEAV
        if variant == 10:
            return JewishHoliday.EREV_ROSH_HASHANA
        if variant == 11:
            return JewishHoliday.ROSH_HASHANA
        if variant == 12:
            return JewishHoliday.FAST_OF_GEDALYAH
        if variant == 13:
            return JewishHoliday.EREV_YOM_KIPPUR
        if variant == 14:
            return JewishHoliday.YOM_KIPPUR
        if variant == 15:
            return JewishHoliday.EREV_SUCCOS
        if variant == 16:
            return JewishHoliday.SUCCOS
        if variant == 17:
            return JewishHoliday.CHOL_HAMOED_SUCCOS
        if variant == 18:
            return JewishHoliday.HOSHANA_RABBA
        if variant == 19:
            return JewishHoliday.SHEMINI_ATZERES
        if variant == 20:
            return JewishHoliday.SIMCHAS_TORAH
        if variant == 21:
            return JewishHoliday.CHANUKAH
        if variant == 22:
            return JewishHoliday.TENTH_OF_TEVES
        if variant == 23:
            return JewishHoliday.TU_BESHVAT
        if variant == 24:
            return JewishHoliday.FAST_OF_ESTHER
        if variant == 25:
            return JewishHoliday.PURIM
        if variant == 26:
            return JewishHoliday.SHUSHAN_PURIM
        if variant == 27:
            return JewishHoliday.PURIM_KATAN
        if variant == 28:
            return JewishHoliday.ROSH_CHODESH
        if variant == 29:
            return JewishHoliday.YOM_HASHOAH
        if variant == 30:
            return JewishHoliday.YOM_HAZIKARON
        if variant == 31:
            return JewishHoliday.YOM_HAATZMAUT
        if variant == 32:
            return JewishHoliday.YOM_YERUSHALAYIM
        if variant == 33:
            return JewishHoliday.LAG_BAOMER
        if variant == 34:
            return JewishHoliday.SHUSHAN_PURIM_KATAN
        if variant == 35:
            return JewishHoliday.ISRU_CHAG
        if variant == 36:
            return JewishHoliday.YOM_KIPPUR_KATAN
        if variant == 37:
            return JewishHoliday.BEHAB
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == JewishHoliday.EREV_PESACH:
            return
        if value == JewishHoliday.PESACH:
            return
        if value == JewishHoliday.CHOL_HAMOED_PESACH:
            return
        if value == JewishHoliday.PESACH_SHENI:
            return
        if value == JewishHoliday.EREV_SHAVUOS:
            return
        if value == JewishHoliday.SHAVUOS:
            return
        if value == JewishHoliday.SEVENTEEN_OF_TAMMUZ:
            return
        if value == JewishHoliday.TISHA_BEAV:
            return
        if value == JewishHoliday.TU_BEAV:
            return
        if value == JewishHoliday.EREV_ROSH_HASHANA:
            return
        if value == JewishHoliday.ROSH_HASHANA:
            return
        if value == JewishHoliday.FAST_OF_GEDALYAH:
            return
        if value == JewishHoliday.EREV_YOM_KIPPUR:
            return
        if value == JewishHoliday.YOM_KIPPUR:
            return
        if value == JewishHoliday.EREV_SUCCOS:
            return
        if value == JewishHoliday.SUCCOS:
            return
        if value == JewishHoliday.CHOL_HAMOED_SUCCOS:
            return
        if value == JewishHoliday.HOSHANA_RABBA:
            return
        if value == JewishHoliday.SHEMINI_ATZERES:
            return
        if value == JewishHoliday.SIMCHAS_TORAH:
            return
        if value == JewishHoliday.CHANUKAH:
            return
        if value == JewishHoliday.TENTH_OF_TEVES:
            return
        if value == JewishHoliday.TU_BESHVAT:
            return
        if value == JewishHoliday.FAST_OF_ESTHER:
            return
        if value == JewishHoliday.PURIM:
            return
        if value == JewishHoliday.SHUSHAN_PURIM:
            return
        if value == JewishHoliday.PURIM_KATAN:
            return
        if value == JewishHoliday.ROSH_CHODESH:
            return
        if value == JewishHoliday.YOM_HASHOAH:
            return
        if value == JewishHoliday.YOM_HAZIKARON:
            return
        if value == JewishHoliday.YOM_HAATZMAUT:
            return
        if value == JewishHoliday.YOM_YERUSHALAYIM:
            return
        if value == JewishHoliday.LAG_BAOMER:
            return
        if value == JewishHoliday.SHUSHAN_PURIM_KATAN:
            return
        if value == JewishHoliday.ISRU_CHAG:
            return
        if value == JewishHoliday.YOM_KIPPUR_KATAN:
            return
        if value == JewishHoliday.BEHAB:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == JewishHoliday.EREV_PESACH:
            buf.write_i32(1)
        if value == JewishHoliday.PESACH:
            buf.write_i32(2)
        if value == JewishHoliday.CHOL_HAMOED_PESACH:
            buf.write_i32(3)
        if value == JewishHoliday.PESACH_SHENI:
            buf.write_i32(4)
        if value == JewishHoliday.EREV_SHAVUOS:
            buf.write_i32(5)
        if value == JewishHoliday.SHAVUOS:
            buf.write_i32(6)
        if value == JewishHoliday.SEVENTEEN_OF_TAMMUZ:
            buf.write_i32(7)
        if value == JewishHoliday.TISHA_BEAV:
            buf.write_i32(8)
        if value == JewishHoliday.TU_BEAV:
            buf.write_i32(9)
        if value == JewishHoliday.EREV_ROSH_HASHANA:
            buf.write_i32(10)
        if value == JewishHoliday.ROSH_HASHANA:
            buf.write_i32(11)
        if value == JewishHoliday.FAST_OF_GEDALYAH:
            buf.write_i32(12)
        if value == JewishHoliday.EREV_YOM_KIPPUR:
            buf.write_i32(13)
        if value == JewishHoliday.YOM_KIPPUR:
            buf.write_i32(14)
        if value == JewishHoliday.EREV_SUCCOS:
            buf.write_i32(15)
        if value == JewishHoliday.SUCCOS:
            buf.write_i32(16)
        if value == JewishHoliday.CHOL_HAMOED_SUCCOS:
            buf.write_i32(17)
        if value == JewishHoliday.HOSHANA_RABBA:
            buf.write_i32(18)
        if value == JewishHoliday.SHEMINI_ATZERES:
            buf.write_i32(19)
        if value == JewishHoliday.SIMCHAS_TORAH:
            buf.write_i32(20)
        if value == JewishHoliday.CHANUKAH:
            buf.write_i32(21)
        if value == JewishHoliday.TENTH_OF_TEVES:
            buf.write_i32(22)
        if value == JewishHoliday.TU_BESHVAT:
            buf.write_i32(23)
        if value == JewishHoliday.FAST_OF_ESTHER:
            buf.write_i32(24)
        if value == JewishHoliday.PURIM:
            buf.write_i32(25)
        if value == JewishHoliday.SHUSHAN_PURIM:
            buf.write_i32(26)
        if value == JewishHoliday.PURIM_KATAN:
            buf.write_i32(27)
        if value == JewishHoliday.ROSH_CHODESH:
            buf.write_i32(28)
        if value == JewishHoliday.YOM_HASHOAH:
            buf.write_i32(29)
        if value == JewishHoliday.YOM_HAZIKARON:
            buf.write_i32(30)
        if value == JewishHoliday.YOM_HAATZMAUT:
            buf.write_i32(31)
        if value == JewishHoliday.YOM_YERUSHALAYIM:
            buf.write_i32(32)
        if value == JewishHoliday.LAG_BAOMER:
            buf.write_i32(33)
        if value == JewishHoliday.SHUSHAN_PURIM_KATAN:
            buf.write_i32(34)
        if value == JewishHoliday.ISRU_CHAG:
            buf.write_i32(35)
        if value == JewishHoliday.YOM_KIPPUR_KATAN:
            buf.write_i32(36)
        if value == JewishHoliday.BEHAB:
            buf.write_i32(37)







class JewishMonth(enum.Enum):
    NISSAN = 1
    
    IYAR = 2
    
    SIVAN = 3
    
    TAMMUZ = 4
    
    AV = 5
    
    ELUL = 6
    
    TISHREI = 7
    
    CHESHVAN = 8
    
    KISLEV = 9
    
    TEVES = 10
    
    SHEVAT = 11
    
    ADAR = 12
    
    ADARII = 13
    


class _UniffiConverterTypeJewishMonth(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return JewishMonth.NISSAN
        if variant == 2:
            return JewishMonth.IYAR
        if variant == 3:
            return JewishMonth.SIVAN
        if variant == 4:
            return JewishMonth.TAMMUZ
        if variant == 5:
            return JewishMonth.AV
        if variant == 6:
            return JewishMonth.ELUL
        if variant == 7:
            return JewishMonth.TISHREI
        if variant == 8:
            return JewishMonth.CHESHVAN
        if variant == 9:
            return JewishMonth.KISLEV
        if variant == 10:
            return JewishMonth.TEVES
        if variant == 11:
            return JewishMonth.SHEVAT
        if variant == 12:
            return JewishMonth.ADAR
        if variant == 13:
            return JewishMonth.ADARII
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == JewishMonth.NISSAN:
            return
        if value == JewishMonth.IYAR:
            return
        if value == JewishMonth.SIVAN:
            return
        if value == JewishMonth.TAMMUZ:
            return
        if value == JewishMonth.AV:
            return
        if value == JewishMonth.ELUL:
            return
        if value == JewishMonth.TISHREI:
            return
        if value == JewishMonth.CHESHVAN:
            return
        if value == JewishMonth.KISLEV:
            return
        if value == JewishMonth.TEVES:
            return
        if value == JewishMonth.SHEVAT:
            return
        if value == JewishMonth.ADAR:
            return
        if value == JewishMonth.ADARII:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == JewishMonth.NISSAN:
            buf.write_i32(1)
        if value == JewishMonth.IYAR:
            buf.write_i32(2)
        if value == JewishMonth.SIVAN:
            buf.write_i32(3)
        if value == JewishMonth.TAMMUZ:
            buf.write_i32(4)
        if value == JewishMonth.AV:
            buf.write_i32(5)
        if value == JewishMonth.ELUL:
            buf.write_i32(6)
        if value == JewishMonth.TISHREI:
            buf.write_i32(7)
        if value == JewishMonth.CHESHVAN:
            buf.write_i32(8)
        if value == JewishMonth.KISLEV:
            buf.write_i32(9)
        if value == JewishMonth.TEVES:
            buf.write_i32(10)
        if value == JewishMonth.SHEVAT:
            buf.write_i32(11)
        if value == JewishMonth.ADAR:
            buf.write_i32(12)
        if value == JewishMonth.ADARII:
            buf.write_i32(13)







class Parsha(enum.Enum):
    NONE = 0
    
    BERESHIS = 1
    
    NOACH = 2
    
    LECH_LECHA = 3
    
    VAYERA = 4
    
    CHAYEI_SARA = 5
    
    TOLDOS = 6
    
    VAYETZEI = 7
    
    VAYISHLACH = 8
    
    VAYESHEV = 9
    
    MIKETZ = 10
    
    VAYIGASH = 11
    
    VAYECHI = 12
    
    SHEMOS = 13
    
    VAERA = 14
    
    BO = 15
    
    BESHALACH = 16
    
    YISRO = 17
    
    MISHPATIM = 18
    
    TERUMAH = 19
    
    TETZAVEH = 20
    
    KI_SISA = 21
    
    VAYAKHEL = 22
    
    PEKUDEI = 23
    
    VAYIKRA = 24
    
    TZAV = 25
    
    SHMINI = 26
    
    TAZRIA = 27
    
    METZORA = 28
    
    ACHREI_MOS = 29
    
    KEDOSHIM = 30
    
    EMOR = 31
    
    BEHAR = 32
    
    BECHUKOSAI = 33
    
    BAMIDBAR = 34
    
    NASSO = 35
    
    BEHAALOSCHA = 36
    
    SHLACH = 37
    
    KORACH = 38
    
    CHUKAS = 39
    
    BALAK = 40
    
    PINCHAS = 41
    
    MATOS = 42
    
    MASEI = 43
    
    DEVARIM = 44
    
    VAESCHANAN = 45
    
    EIKEV = 46
    
    REEH = 47
    
    SHOFTIM = 48
    
    KI_SEITZEI = 49
    
    KI_SAVO = 50
    
    NITZAVIM = 51
    
    VAYEILECH = 52
    
    HAAZINU = 53
    
    VZOS_HABERACHA = 54
    
    VAYAKHEL_PEKUDEI = 55
    
    TAZRIA_METZORA = 56
    
    ACHREI_MOS_KEDOSHIM = 57
    
    BEHAR_BECHUKOSAI = 58
    
    CHUKAS_BALAK = 59
    
    MATOS_MASEI = 60
    
    NITZAVIM_VAYEILECH = 61
    
    SHKALIM = 62
    
    ZACHOR = 63
    
    PARA = 64
    
    HACHODESH = 65
    
    SHUVA = 66
    
    SHIRA = 67
    
    HAGADOL = 68
    
    CHAZON = 69
    
    NACHAMU = 70
    


class _UniffiConverterTypeParsha(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return Parsha.NONE
        if variant == 2:
            return Parsha.BERESHIS
        if variant == 3:
            return Parsha.NOACH
        if variant == 4:
            return Parsha.LECH_LECHA
        if variant == 5:
            return Parsha.VAYERA
        if variant == 6:
            return Parsha.CHAYEI_SARA
        if variant == 7:
            return Parsha.TOLDOS
        if variant == 8:
            return Parsha.VAYETZEI
        if variant == 9:
            return Parsha.VAYISHLACH
        if variant == 10:
            return Parsha.VAYESHEV
        if variant == 11:
            return Parsha.MIKETZ
        if variant == 12:
            return Parsha.VAYIGASH
        if variant == 13:
            return Parsha.VAYECHI
        if variant == 14:
            return Parsha.SHEMOS
        if variant == 15:
            return Parsha.VAERA
        if variant == 16:
            return Parsha.BO
        if variant == 17:
            return Parsha.BESHALACH
        if variant == 18:
            return Parsha.YISRO
        if variant == 19:
            return Parsha.MISHPATIM
        if variant == 20:
            return Parsha.TERUMAH
        if variant == 21:
            return Parsha.TETZAVEH
        if variant == 22:
            return Parsha.KI_SISA
        if variant == 23:
            return Parsha.VAYAKHEL
        if variant == 24:
            return Parsha.PEKUDEI
        if variant == 25:
            return Parsha.VAYIKRA
        if variant == 26:
            return Parsha.TZAV
        if variant == 27:
            return Parsha.SHMINI
        if variant == 28:
            return Parsha.TAZRIA
        if variant == 29:
            return Parsha.METZORA
        if variant == 30:
            return Parsha.ACHREI_MOS
        if variant == 31:
            return Parsha.KEDOSHIM
        if variant == 32:
            return Parsha.EMOR
        if variant == 33:
            return Parsha.BEHAR
        if variant == 34:
            return Parsha.BECHUKOSAI
        if variant == 35:
            return Parsha.BAMIDBAR
        if variant == 36:
            return Parsha.NASSO
        if variant == 37:
            return Parsha.BEHAALOSCHA
        if variant == 38:
            return Parsha.SHLACH
        if variant == 39:
            return Parsha.KORACH
        if variant == 40:
            return Parsha.CHUKAS
        if variant == 41:
            return Parsha.BALAK
        if variant == 42:
            return Parsha.PINCHAS
        if variant == 43:
            return Parsha.MATOS
        if variant == 44:
            return Parsha.MASEI
        if variant == 45:
            return Parsha.DEVARIM
        if variant == 46:
            return Parsha.VAESCHANAN
        if variant == 47:
            return Parsha.EIKEV
        if variant == 48:
            return Parsha.REEH
        if variant == 49:
            return Parsha.SHOFTIM
        if variant == 50:
            return Parsha.KI_SEITZEI
        if variant == 51:
            return Parsha.KI_SAVO
        if variant == 52:
            return Parsha.NITZAVIM
        if variant == 53:
            return Parsha.VAYEILECH
        if variant == 54:
            return Parsha.HAAZINU
        if variant == 55:
            return Parsha.VZOS_HABERACHA
        if variant == 56:
            return Parsha.VAYAKHEL_PEKUDEI
        if variant == 57:
            return Parsha.TAZRIA_METZORA
        if variant == 58:
            return Parsha.ACHREI_MOS_KEDOSHIM
        if variant == 59:
            return Parsha.BEHAR_BECHUKOSAI
        if variant == 60:
            return Parsha.CHUKAS_BALAK
        if variant == 61:
            return Parsha.MATOS_MASEI
        if variant == 62:
            return Parsha.NITZAVIM_VAYEILECH
        if variant == 63:
            return Parsha.SHKALIM
        if variant == 64:
            return Parsha.ZACHOR
        if variant == 65:
            return Parsha.PARA
        if variant == 66:
            return Parsha.HACHODESH
        if variant == 67:
            return Parsha.SHUVA
        if variant == 68:
            return Parsha.SHIRA
        if variant == 69:
            return Parsha.HAGADOL
        if variant == 70:
            return Parsha.CHAZON
        if variant == 71:
            return Parsha.NACHAMU
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == Parsha.NONE:
            return
        if value == Parsha.BERESHIS:
            return
        if value == Parsha.NOACH:
            return
        if value == Parsha.LECH_LECHA:
            return
        if value == Parsha.VAYERA:
            return
        if value == Parsha.CHAYEI_SARA:
            return
        if value == Parsha.TOLDOS:
            return
        if value == Parsha.VAYETZEI:
            return
        if value == Parsha.VAYISHLACH:
            return
        if value == Parsha.VAYESHEV:
            return
        if value == Parsha.MIKETZ:
            return
        if value == Parsha.VAYIGASH:
            return
        if value == Parsha.VAYECHI:
            return
        if value == Parsha.SHEMOS:
            return
        if value == Parsha.VAERA:
            return
        if value == Parsha.BO:
            return
        if value == Parsha.BESHALACH:
            return
        if value == Parsha.YISRO:
            return
        if value == Parsha.MISHPATIM:
            return
        if value == Parsha.TERUMAH:
            return
        if value == Parsha.TETZAVEH:
            return
        if value == Parsha.KI_SISA:
            return
        if value == Parsha.VAYAKHEL:
            return
        if value == Parsha.PEKUDEI:
            return
        if value == Parsha.VAYIKRA:
            return
        if value == Parsha.TZAV:
            return
        if value == Parsha.SHMINI:
            return
        if value == Parsha.TAZRIA:
            return
        if value == Parsha.METZORA:
            return
        if value == Parsha.ACHREI_MOS:
            return
        if value == Parsha.KEDOSHIM:
            return
        if value == Parsha.EMOR:
            return
        if value == Parsha.BEHAR:
            return
        if value == Parsha.BECHUKOSAI:
            return
        if value == Parsha.BAMIDBAR:
            return
        if value == Parsha.NASSO:
            return
        if value == Parsha.BEHAALOSCHA:
            return
        if value == Parsha.SHLACH:
            return
        if value == Parsha.KORACH:
            return
        if value == Parsha.CHUKAS:
            return
        if value == Parsha.BALAK:
            return
        if value == Parsha.PINCHAS:
            return
        if value == Parsha.MATOS:
            return
        if value == Parsha.MASEI:
            return
        if value == Parsha.DEVARIM:
            return
        if value == Parsha.VAESCHANAN:
            return
        if value == Parsha.EIKEV:
            return
        if value == Parsha.REEH:
            return
        if value == Parsha.SHOFTIM:
            return
        if value == Parsha.KI_SEITZEI:
            return
        if value == Parsha.KI_SAVO:
            return
        if value == Parsha.NITZAVIM:
            return
        if value == Parsha.VAYEILECH:
            return
        if value == Parsha.HAAZINU:
            return
        if value == Parsha.VZOS_HABERACHA:
            return
        if value == Parsha.VAYAKHEL_PEKUDEI:
            return
        if value == Parsha.TAZRIA_METZORA:
            return
        if value == Parsha.ACHREI_MOS_KEDOSHIM:
            return
        if value == Parsha.BEHAR_BECHUKOSAI:
            return
        if value == Parsha.CHUKAS_BALAK:
            return
        if value == Parsha.MATOS_MASEI:
            return
        if value == Parsha.NITZAVIM_VAYEILECH:
            return
        if value == Parsha.SHKALIM:
            return
        if value == Parsha.ZACHOR:
            return
        if value == Parsha.PARA:
            return
        if value == Parsha.HACHODESH:
            return
        if value == Parsha.SHUVA:
            return
        if value == Parsha.SHIRA:
            return
        if value == Parsha.HAGADOL:
            return
        if value == Parsha.CHAZON:
            return
        if value == Parsha.NACHAMU:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == Parsha.NONE:
            buf.write_i32(1)
        if value == Parsha.BERESHIS:
            buf.write_i32(2)
        if value == Parsha.NOACH:
            buf.write_i32(3)
        if value == Parsha.LECH_LECHA:
            buf.write_i32(4)
        if value == Parsha.VAYERA:
            buf.write_i32(5)
        if value == Parsha.CHAYEI_SARA:
            buf.write_i32(6)
        if value == Parsha.TOLDOS:
            buf.write_i32(7)
        if value == Parsha.VAYETZEI:
            buf.write_i32(8)
        if value == Parsha.VAYISHLACH:
            buf.write_i32(9)
        if value == Parsha.VAYESHEV:
            buf.write_i32(10)
        if value == Parsha.MIKETZ:
            buf.write_i32(11)
        if value == Parsha.VAYIGASH:
            buf.write_i32(12)
        if value == Parsha.VAYECHI:
            buf.write_i32(13)
        if value == Parsha.SHEMOS:
            buf.write_i32(14)
        if value == Parsha.VAERA:
            buf.write_i32(15)
        if value == Parsha.BO:
            buf.write_i32(16)
        if value == Parsha.BESHALACH:
            buf.write_i32(17)
        if value == Parsha.YISRO:
            buf.write_i32(18)
        if value == Parsha.MISHPATIM:
            buf.write_i32(19)
        if value == Parsha.TERUMAH:
            buf.write_i32(20)
        if value == Parsha.TETZAVEH:
            buf.write_i32(21)
        if value == Parsha.KI_SISA:
            buf.write_i32(22)
        if value == Parsha.VAYAKHEL:
            buf.write_i32(23)
        if value == Parsha.PEKUDEI:
            buf.write_i32(24)
        if value == Parsha.VAYIKRA:
            buf.write_i32(25)
        if value == Parsha.TZAV:
            buf.write_i32(26)
        if value == Parsha.SHMINI:
            buf.write_i32(27)
        if value == Parsha.TAZRIA:
            buf.write_i32(28)
        if value == Parsha.METZORA:
            buf.write_i32(29)
        if value == Parsha.ACHREI_MOS:
            buf.write_i32(30)
        if value == Parsha.KEDOSHIM:
            buf.write_i32(31)
        if value == Parsha.EMOR:
            buf.write_i32(32)
        if value == Parsha.BEHAR:
            buf.write_i32(33)
        if value == Parsha.BECHUKOSAI:
            buf.write_i32(34)
        if value == Parsha.BAMIDBAR:
            buf.write_i32(35)
        if value == Parsha.NASSO:
            buf.write_i32(36)
        if value == Parsha.BEHAALOSCHA:
            buf.write_i32(37)
        if value == Parsha.SHLACH:
            buf.write_i32(38)
        if value == Parsha.KORACH:
            buf.write_i32(39)
        if value == Parsha.CHUKAS:
            buf.write_i32(40)
        if value == Parsha.BALAK:
            buf.write_i32(41)
        if value == Parsha.PINCHAS:
            buf.write_i32(42)
        if value == Parsha.MATOS:
            buf.write_i32(43)
        if value == Parsha.MASEI:
            buf.write_i32(44)
        if value == Parsha.DEVARIM:
            buf.write_i32(45)
        if value == Parsha.VAESCHANAN:
            buf.write_i32(46)
        if value == Parsha.EIKEV:
            buf.write_i32(47)
        if value == Parsha.REEH:
            buf.write_i32(48)
        if value == Parsha.SHOFTIM:
            buf.write_i32(49)
        if value == Parsha.KI_SEITZEI:
            buf.write_i32(50)
        if value == Parsha.KI_SAVO:
            buf.write_i32(51)
        if value == Parsha.NITZAVIM:
            buf.write_i32(52)
        if value == Parsha.VAYEILECH:
            buf.write_i32(53)
        if value == Parsha.HAAZINU:
            buf.write_i32(54)
        if value == Parsha.VZOS_HABERACHA:
            buf.write_i32(55)
        if value == Parsha.VAYAKHEL_PEKUDEI:
            buf.write_i32(56)
        if value == Parsha.TAZRIA_METZORA:
            buf.write_i32(57)
        if value == Parsha.ACHREI_MOS_KEDOSHIM:
            buf.write_i32(58)
        if value == Parsha.BEHAR_BECHUKOSAI:
            buf.write_i32(59)
        if value == Parsha.CHUKAS_BALAK:
            buf.write_i32(60)
        if value == Parsha.MATOS_MASEI:
            buf.write_i32(61)
        if value == Parsha.NITZAVIM_VAYEILECH:
            buf.write_i32(62)
        if value == Parsha.SHKALIM:
            buf.write_i32(63)
        if value == Parsha.ZACHOR:
            buf.write_i32(64)
        if value == Parsha.PARA:
            buf.write_i32(65)
        if value == Parsha.HACHODESH:
            buf.write_i32(66)
        if value == Parsha.SHUVA:
            buf.write_i32(67)
        if value == Parsha.SHIRA:
            buf.write_i32(68)
        if value == Parsha.HAGADOL:
            buf.write_i32(69)
        if value == Parsha.CHAZON:
            buf.write_i32(70)
        if value == Parsha.NACHAMU:
            buf.write_i32(71)







class SolarEvent(enum.Enum):
    SUNRISE = 1
    
    SUNSET = 2
    
    NOON = 3
    
    MIDNIGHT = 4
    


class _UniffiConverterTypeSolarEvent(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return SolarEvent.SUNRISE
        if variant == 2:
            return SolarEvent.SUNSET
        if variant == 3:
            return SolarEvent.NOON
        if variant == 4:
            return SolarEvent.MIDNIGHT
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == SolarEvent.SUNRISE:
            return
        if value == SolarEvent.SUNSET:
            return
        if value == SolarEvent.NOON:
            return
        if value == SolarEvent.MIDNIGHT:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == SolarEvent.SUNRISE:
            buf.write_i32(1)
        if value == SolarEvent.SUNSET:
            buf.write_i32(2)
        if value == SolarEvent.NOON:
            buf.write_i32(3)
        if value == SolarEvent.MIDNIGHT:
            buf.write_i32(4)







class YearLengthType(enum.Enum):
    CHASERIM = 0
    
    KESIDRAN = 1
    
    SHELAIMIM = 2
    


class _UniffiConverterTypeYearLengthType(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return YearLengthType.CHASERIM
        if variant == 2:
            return YearLengthType.KESIDRAN
        if variant == 3:
            return YearLengthType.SHELAIMIM
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == YearLengthType.CHASERIM:
            return
        if value == YearLengthType.KESIDRAN:
            return
        if value == YearLengthType.SHELAIMIM:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == YearLengthType.CHASERIM:
            buf.write_i32(1)
        if value == YearLengthType.KESIDRAN:
            buf.write_i32(2)
        if value == YearLengthType.SHELAIMIM:
            buf.write_i32(3)





class _UniffiConverterOptionalInt64(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterInt64.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterInt64.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterInt64.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalDouble(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterDouble.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterDouble.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterDouble.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeBavliDaf(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeBavliDaf.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeBavliDaf.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeBavliDaf.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeGeoLocation(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeGeoLocation.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeGeoLocation.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeGeoLocation.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeJewishDate(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeJewishDate.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeJewishDate.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeJewishDate.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeMoladData(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeMoladData.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeMoladData.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeMoladData.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeJewishHoliday(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeJewishHoliday.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeJewishHoliday.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeJewishHoliday.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")

# Async support

def new_astronomical_calendar(timestamp: "int",geo_location: "GeoLocation") -> "AstronomicalCalendar":
    _UniffiConverterInt64.check_lower(timestamp)
    
    _UniffiConverterTypeGeoLocation.check_lower(geo_location)
    
    return _UniffiConverterTypeAstronomicalCalendar.lift(_uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_func_new_astronomical_calendar,
        _UniffiConverterInt64.lower(timestamp),
        _UniffiConverterTypeGeoLocation.lower(geo_location)))


def new_complex_zmanim_calendar(timestamp: "int",geo_location: "GeoLocation",use_astronomical_chatzos: "bool",use_astronomical_chatzos_for_other_zmanim: "bool",candle_lighting_offset: "int",ateret_torah_sunset_offset: "int") -> "ComplexZmanimCalendar":
    _UniffiConverterInt64.check_lower(timestamp)
    
    _UniffiConverterTypeGeoLocation.check_lower(geo_location)
    
    _UniffiConverterBool.check_lower(use_astronomical_chatzos)
    
    _UniffiConverterBool.check_lower(use_astronomical_chatzos_for_other_zmanim)
    
    _UniffiConverterInt64.check_lower(candle_lighting_offset)
    
    _UniffiConverterInt64.check_lower(ateret_torah_sunset_offset)
    
    return _UniffiConverterTypeComplexZmanimCalendar.lift(_uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_func_new_complex_zmanim_calendar,
        _UniffiConverterInt64.lower(timestamp),
        _UniffiConverterTypeGeoLocation.lower(geo_location),
        _UniffiConverterBool.lower(use_astronomical_chatzos),
        _UniffiConverterBool.lower(use_astronomical_chatzos_for_other_zmanim),
        _UniffiConverterInt64.lower(candle_lighting_offset),
        _UniffiConverterInt64.lower(ateret_torah_sunset_offset)))


def new_geolocation(latitude: "float",longitude: "float",elevation: "float") -> "typing.Optional[GeoLocation]":
    _UniffiConverterDouble.check_lower(latitude)
    
    _UniffiConverterDouble.check_lower(longitude)
    
    _UniffiConverterDouble.check_lower(elevation)
    
    return _UniffiConverterOptionalTypeGeoLocation.lift(_uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_func_new_geolocation,
        _UniffiConverterDouble.lower(latitude),
        _UniffiConverterDouble.lower(longitude),
        _UniffiConverterDouble.lower(elevation)))


def new_jewish_date(timestamp: "int",tz_offset: "int") -> "typing.Optional[JewishDate]":
    _UniffiConverterInt64.check_lower(timestamp)
    
    _UniffiConverterInt64.check_lower(tz_offset)
    
    return _UniffiConverterOptionalTypeJewishDate.lift(_uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_func_new_jewish_date,
        _UniffiConverterInt64.lower(timestamp),
        _UniffiConverterInt64.lower(tz_offset)))


def new_noaa_calculator() -> "NoaaCalculator":
    return _UniffiConverterTypeNoaaCalculator.lift(_uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_func_new_noaa_calculator,))


def new_zmanim_calendar(timestamp: "int",geo_location: "GeoLocation",use_astronomical_chatzos: "bool",use_astronomical_chatzos_for_other_zmanim: "bool",candle_lighting_offset: "int") -> "ZmanimCalendar":
    _UniffiConverterInt64.check_lower(timestamp)
    
    _UniffiConverterTypeGeoLocation.check_lower(geo_location)
    
    _UniffiConverterBool.check_lower(use_astronomical_chatzos)
    
    _UniffiConverterBool.check_lower(use_astronomical_chatzos_for_other_zmanim)
    
    _UniffiConverterInt64.check_lower(candle_lighting_offset)
    
    return _UniffiConverterTypeZmanimCalendar.lift(_uniffi_rust_call(_UniffiLib.uniffi_zmanim_core_fn_func_new_zmanim_calendar,
        _UniffiConverterInt64.lower(timestamp),
        _UniffiConverterTypeGeoLocation.lower(geo_location),
        _UniffiConverterBool.lower(use_astronomical_chatzos),
        _UniffiConverterBool.lower(use_astronomical_chatzos_for_other_zmanim),
        _UniffiConverterInt64.lower(candle_lighting_offset)))


__all__ = [
    "InternalError",
    "BavliTractate",
    "DayOfWeek",
    "Formula",
    "JewishHoliday",
    "JewishMonth",
    "Parsha",
    "SolarEvent",
    "YearLengthType",
    "new_astronomical_calendar",
    "new_complex_zmanim_calendar",
    "new_geolocation",
    "new_jewish_date",
    "new_noaa_calculator",
    "new_zmanim_calendar",
    "AstronomicalCalculator",
    "AstronomicalCalendar",
    "BavliDaf",
    "ComplexZmanimCalendar",
    "GeoLocation",
    "JewishCalendar",
    "JewishDate",
    "MoladData",
    "NoaaCalculator",
    "ZmanimCalendar",
]

