
import mock
import os
import ctypes
from infi import unittest
from .. import  File, api
from pkg_resources import parse_version
from contextlib import nested, contextmanager

CMD_EXE_PATH = r"C:\Windows\System32\cmd.exe"

FILE_VERSION_INFO = \
        '\x90\x034\x00\x00\x00V\x00S\x00_\x00V\x00E\x00R\x00S\x00I\x00O\x00N' + \
        '\x00_\x00I\x00N\x00F\x00O\x00\x00\x00\x00\x00\xbd\x04\xef\xfe\x00\x00\x01\x00\x01\x00' + \
        '\x06\x00jD\xb1\x1d\x01\x00\x06\x00jD\xb1\x1d?\x00\x00\x00\x00\x00\x00\x00\x04\x00\x04' + \
        '\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xee\x02\x00\x00\x01\x00S\x00' + \
        't\x00r\x00i\x00n\x00g\x00F\x00i\x00l\x00e\x00I\x00n\x00f\x00o' + \
        '\x00\x00\x00\xca\x02\x00\x00\x01\x000\x004\x000\x009\x000\x004\x00B\x000\x00' + \
        '\x00\x00L\x00\x16\x00\x01\x00C\x00o\x00m\x00p\x00a\x00n\x00y\x00N\x00a' + \
        '\x00m\x00e\x00\x00\x00\x00\x00M\x00i\x00c\x00r\x00o\x00s\x00o\x00f\x00' + \
        't\x00 \x00C\x00o\x00r\x00p\x00o\x00r\x00a\x00t\x00i\x00o\x00n' + \
        '\x00\x00\x00\\\x00\x1a\x00\x01\x00F\x00i\x00l\x00e\x00D\x00e\x00s\x00c\x00' + \
        'r\x00i\x00p\x00t\x00i\x00o\x00n\x00\x00\x00\x00\x00W\x00i\x00n\x00d' + \
        '\x00o\x00w\x00s\x00 \x00C\x00o\x00m\x00m\x00a\x00n\x00d\x00 \x00' + \
        'P\x00r\x00o\x00c\x00e\x00s\x00s\x00o\x00r\x00\x00\x00r\x00)\x00\x01' + \
        '\x00F\x00i\x00l\x00e\x00V\x00e\x00r\x00s\x00i\x00o\x00n\x00\x00\x00' + \
        '\x00\x006\x00.\x001\x00.\x007\x006\x000\x001\x00.\x001\x007\x005' + \
        '\x001\x004\x00 \x00(\x00w\x00i\x00n\x007\x00s\x00p\x001\x00_\x00' + \
        'r\x00t\x00m\x00.\x001\x000\x001\x001\x001\x009\x00-\x001\x008' + \
        '\x005\x000\x00)\x00\x00\x00\x00\x00(\x00\x04\x00\x01\x00I\x00n\x00t\x00e\x00' + \
        'r\x00n\x00a\x00l\x00N\x00a\x00m\x00e\x00\x00\x00c\x00m\x00d\x00\x00' + \
        '\x00\x80\x00.\x00\x01\x00L\x00e\x00g\x00a\x00l\x00C\x00o\x00p\x00y\x00' + \
        'r\x00i\x00g\x00h\x00t\x00\x00\x00\xa9\x00 \x00M\x00i\x00c\x00r\x00o' + \
        '\x00s\x00o\x00f\x00t\x00 \x00C\x00o\x00r\x00p\x00o\x00r\x00a\x00' + \
        't\x00i\x00o\x00n\x00.\x00 \x00A\x00l\x00l\x00 \x00r\x00i\x00g' + \
        '\x00h\x00t\x00s\x00 \x00r\x00e\x00s\x00e\x00r\x00v\x00e\x00d\x00' + \
        '.\x00\x00\x00@\x00\x0c\x00\x01\x00O\x00r\x00i\x00g\x00i\x00n\x00a\x00l' + \
        '\x00F\x00i\x00l\x00e\x00n\x00a\x00m\x00e\x00\x00\x00C\x00m\x00d\x00' + \
        '.\x00E\x00x\x00e\x00.\x00M\x00U\x00I\x00\x00\x00j\x00%\x00\x01\x00P' + \
        '\x00r\x00o\x00d\x00u\x00c\x00t\x00N\x00a\x00m\x00e\x00\x00\x00\x00\x00' + \
        'M\x00i\x00c\x00r\x00o\x00s\x00o\x00f\x00t\x00\xae\x00 \x00W\x00i' + \
        '\x00n\x00d\x00o\x00w\x00s\x00\xae\x00 \x00O\x00p\x00e\x00r\x00a\x00' + \
        't\x00i\x00n\x00g\x00 \x00S\x00y\x00s\x00t\x00e\x00m\x00\x00\x00\x00' + \
        '\x00B\x00\x0f\x00\x01\x00P\x00r\x00o\x00d\x00u\x00c\x00t\x00V\x00e\x00' + \
        'r\x00s\x00i\x00o\x00n\x00\x00\x006\x00.\x001\x00.\x007\x006\x000' + \
        '\x001\x00.\x001\x007\x005\x001\x004\x00\x00\x00\x00\x00D\x00\x00\x00\x01\x00' + \
        'V\x00a\x00r\x00F\x00i\x00l\x00e\x00I\x00n\x00f\x00o\x00\x00\x00\x00' + \
        '\x00$\x00\x04\x00\x00\x00T\x00r\x00a\x00n\x00s\x00l\x00a\x00t\x00i\x00' + \
        'o\x00n\x00\x00\x00\x00\x00\t\x04\xb0\x04FE2X\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00' + \
        '\x00\x00\x00'

MOCK_VS_FIXEDFILEINFO = \
        '\xbd\x04\xef\xfe\x00\x00\x01\x00\x01\x00\x06\x00jD\xb1\x1d\x01\x00\x06\x00jD\xb1\x1d?\x00\x00' + \
        '\x00\x00\x00\x00\x00\x04\x00\x04\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00'

class FileTestCase(unittest.TestCase):
    @classmethod
    def setUpClass(cls):
        super(FileTestCase, cls).setUpClass()
        if os.name != 'nt':
            raise unittest.SkipTest("This test can run only on Windows")

    def test_version_of_cmd_exe(self):
        cmd_exe = File(CMD_EXE_PATH)
        version = cmd_exe.get_version()
        self.assertGreater(parse_version(version), parse_version('1.0'))

class MockFileTestCase(FileTestCase):
    @classmethod
    def setUpClass(cls):
        with mock.patch.object(os, "name", new='nt'):
            super(MockFileTestCase, cls).setUpClass()

    def _patch_exists(self, path):
        self.assertEqual(path, CMD_EXE_PATH)
        return True

    def _patch_GetFileVersionInfoSizeW(self, filepath):
        self.assertEqual(filepath.value, CMD_EXE_PATH)
        return 1828

    def _patch_GetFileVersionInfoW(self, filepath, handle, length, data):
        self.assertEqual(filepath.value, CMD_EXE_PATH)
        self.assertEqual(handle.value, 0)
        self.assertEqual(length.value, 1828)
        data.raw = FILE_VERSION_INFO
        return 1

    def _patch_VerQueryValueW(self, block, sub_block, pointer, length):
        self.assertEqual(block.raw, FILE_VERSION_INFO[:1828])
        self.assertEqual(sub_block.value, u'\\')
        _buffer = ctypes.create_string_buffer(MOCK_VS_FIXEDFILEINFO, api.VS_FIXEDFILEINFO.min_max_sizeof().max)
        pointer.value = ctypes.addressof(_buffer)
        return 1

    def test_version_of_cmd_exe(self):
        with nested(mock.patch.object(os.path, "exists", self._patch_exists),
                    mock.patch.object(api, "GetFileVersionInfoSizeW", self._patch_GetFileVersionInfoSizeW),
                    mock.patch.object(api, "GetFileVersionInfoW", self._patch_GetFileVersionInfoW),
                    mock.patch.object(api, "VerQueryValueW", self._patch_VerQueryValueW),):
            super(MockFileTestCase, self).test_version_of_cmd_exe()

