# coding: utf-8

"""
    public-api

    Public-facing API for external access

    The version of the OpenAPI document: b916381
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from knowledge_stack.models.resp_chunk import RespChunk
from knowledge_stack.models.resp_chunk_lineage_edge import RespChunkLineageEdge
from typing import Optional, Set
from typing_extensions import Self

class RespChunkLineage(BaseModel):
    """
    Chunk lineage response schema.
    """ # noqa: E501
    edges: Optional[List[RespChunkLineageEdge]] = Field(default=None, description="The edges in the lineage")
    chunk_nodes: Optional[List[RespChunk]] = Field(default=None, description="The chunk nodes in the lineage")
    __properties: ClassVar[List[str]] = ["edges", "chunk_nodes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RespChunkLineage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in edges (list)
        _items = []
        if self.edges:
            for _item_edges in self.edges:
                if _item_edges:
                    _items.append(_item_edges.to_dict())
            _dict['edges'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in chunk_nodes (list)
        _items = []
        if self.chunk_nodes:
            for _item_chunk_nodes in self.chunk_nodes:
                if _item_chunk_nodes:
                    _items.append(_item_chunk_nodes.to_dict())
            _dict['chunk_nodes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RespChunkLineage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "edges": [RespChunkLineageEdge.from_dict(_item) for _item in obj["edges"]] if obj.get("edges") is not None else None,
            "chunk_nodes": [RespChunk.from_dict(_item) for _item in obj["chunk_nodes"]] if obj.get("chunk_nodes") is not None else None
        })
        return _obj


