"""test_degenerate_dna

Tests for `degenerate-dna` module.
"""
import unittest

from degenerate_dna import Degenera


class TestApi(unittest.TestCase):
    def setUp(self):
        self.dna = 'AGTTCTTTACTACGTAGA'
        self.res = Degenera(dna=self.dna)

    def test_standard_code_normal(self):
        self.res.table = 1
        self.res.type = 'normal'
        self.res.degenerate()

        result = self.res.degenerated
        expected = 'AGYTCNYTNYTNMGNMGN'
        self.assertEqual(expected, result)

    def test_standard_code_S(self):
        self.res.table = 1
        self.res.type = 'S'
        self.res.degenerate()

        result = self.res.degenerated
        expected = 'AGYAGYYTNYTNMGNMGN'
        self.assertEqual(expected, result)

    def test_standard_code_Z(self):
        self.res.table = 1
        self.res.type = 'Z'
        self.res.degenerate()

        result = self.res.degenerated
        expected = 'TCNTCNYTNYTNMGNMGN'
        self.assertEqual(expected, result)

    def test_standard_code_SZ(self):
        self.res.table = 1
        self.res.type = 'SZ'
        self.res.degenerate()

        result = self.res.degenerated
        expected = 'NNNNNNYTNYTNMGNMGN'
        self.assertEqual(expected, result)

    def test_degenerate_code_nt1(self):
        self.res.dna = 'ANN'
        self.res.table = 1
        self.res.type = 'SZ'
        self.res.degenerate()

        result = self.res.degenerated
        expected = 'NNN'
        self.assertEqual(expected, result)

    def test_long_seq_table_1_normal(self):
        self.res.dna = '??????????aAGACGTGTTGGATGAG?TTGCCGACCTTCCGATCTGTCGGCGACGCCTTGAAAGATGCCTTCGAyGGAGCGTCGCGGGTCATGATGCCC---AACACAGAGTTGGAAGCGCCC---GCT---CAGCGGAACGAT---GCGGCTCCGCACAGAGTCCCGCGAAGAGATCGATACAGATTCCAACTTCGACCGCACAATCCTGACCATAAAACACCCGGGGACAAGGACCTAGTATACTTGGAATCATCGCCGGGTTTCTGCGAAAAGAACCCGAGACTGGGCATTCCCGGTACGCACGGGCGTTCCTGCAACGACACGAGCATCGGCGTCGATGGCTGCGACCTGATGTGCTGTGGCCGGGGGTACCGGACTGAGACGATGTTTGTCGTCGA'
        self.res.table = 1
        self.res.type = 'normal'
        self.res.degenerate()

        result = self.res.degenerated
        expected = 'NNNNNNNNNNNNGAYGTNYTNGAYGARNNNGCNGAYYTNCCNATHTGYMGNMGNMGNYTNGARMGNTGYYTNMGNNNNAGYGTNGCNGGNCAYGAYGCNC---AACAYMGNGTNGGNAGYGCNC---GCT---CAGCNGARMGNT---GCGGNTCNGCNCARAGYCCNGCNAARMGNTCNATHCARATHCCNACNTCNACNGCNCARTCNTGACCNTAAAAYACNMGNGGNCARGGNCCNAGYATHYTNGGNATHATHGCNGGNTTYYTNMGNAARGARCCNGARACNGGNCAYTCNMGNTAYGCNMGNGCNTTYYTNCARMGNCAYGARCAYMGNMGNMGNTGGYTNMGNCCNGAYGTNYTNTGGCCNGGNGTNCCNGAYTGAGAYGAYGTNTGYMGNMGN'
        self.assertEqual(expected, result)

    def test_long_seq_table_1_S(self):
        self.res.dna = '??????????aAGACGTGTTGGATGAG?TTGCCGACCTTCCGATCTGTCGGCGACGCCTTGAAAGATGCCTTCGAyGGAGCGTCGCGGGTCATGATGCCC---AACACAGAGTTGGAAGCGCCC---GCT---CAGCGGAACGAT---GCGGCTCCGCACAGAGTCCCGCGAAGAGATCGATACAGATTCCAACTTCGACCGCACAATCCTGACCATAAAACACCCGGGGACAAGGACCTAGTATACTTGGAATCATCGCCGGGTTTCTGCGAAAAGAACCCGAGACTGGGCATTCCCGGTACGCACGGGCGTTCCTGCAACGACACGAGCATCGGCGTCGATGGCTGCGACCTGATGTGCTGTGGCCGGGGGTACCGGACTGAGACGATGTTTGTCGTCGA'
        self.res.table = 1
        self.res.type = 'S'
        self.res.degenerate()

        result = self.res.degenerated
        expected = 'NNNNNNNNNNNNGAYGTNYTNGAYGARNNNGCNGAYYTNCCNATHTGYMGNMGNMGNYTNGARMGNTGYYTNMGNNNNAGYGTNGCNGGNCAYGAYGCNC---AACAYMGNGTNGGNAGYGCNC---GCT---CAGCNGARMGNT---GCGGNAGYGCNCARAGYCCNGCNAARMGNAGYATHCARATHCCNACNAGYACNGCNCARAGYTGACCNTAAAAYACNMGNGGNCARGGNCCNAGYATHYTNGGNATHATHGCNGGNTTYYTNMGNAARGARCCNGARACNGGNCAYAGYMGNTAYGCNMGNGCNTTYYTNCARMGNCAYGARCAYMGNMGNMGNTGGYTNMGNCCNGAYGTNYTNTGGCCNGGNGTNCCNGAYTGAGAYGAYGTNTGYMGNMGN'

        self.assertEqual(expected, result)

    def test_long_seq_table_1_Z(self):
        self.res.dna = '??????????aAGACGTGTTGGATGAG?TTGCCGACCTTCCGATCTGTCGGCGACGCCTTGAAAGATGCCTTCGAyGGAGCGTCGCGGGTCATGATGCCC---AACACAGAGTTGGAAGCGCCC---GCT---CAGCGGAACGAT---GCGGCTCCGCACAGAGTCCCGCGAAGAGATCGATACAGATTCCAACTTCGACCGCACAATCCTGACCATAAAACACCCGGGGACAAGGACCTAGTATACTTGGAATCATCGCCGGGTTTCTGCGAAAAGAACCCGAGACTGGGCATTCCCGGTACGCACGGGCGTTCCTGCAACGACACGAGCATCGGCGTCGATGGCTGCGACCTGATGTGCTGTGGCCGGGGGTACCGGACTGAGACGATGTTTGTCGTCGA'
        self.res.table = 1
        self.res.type = 'Z'
        self.res.degenerate()

        result = self.res.degenerated
        expected = 'NNNNNNNNNNNNGAYGTNYTNGAYGARNNNGCNGAYYTNCCNATHTGYMGNMGNMGNYTNGARMGNTGYYTNMGNNNNTCNGTNGCNGGNCAYGAYGCNC---AACAYMGNGTNGGNTCNGCNC---GCT---CAGCNGARMGNT---GCGGNTCNGCNCARTCNCCNGCNAARMGNTCNATHCARATHCCNACNTCNACNGCNCARTCNTGACCNTAAAAYACNMGNGGNCARGGNCCNTCNATHYTNGGNATHATHGCNGGNTTYYTNMGNAARGARCCNGARACNGGNCAYTCNMGNTAYGCNMGNGCNTTYYTNCARMGNCAYGARCAYMGNMGNMGNTGGYTNMGNCCNGAYGTNYTNTGGCCNGGNGTNCCNGAYTGAGAYGAYGTNTGYMGNMGN'

        self.assertEqual(expected, result)

    def test_long_seq_table_1_SZ(self):
        self.res.dna = '??????????aAGACGTGTTGGATGAG?TTGCCGACCTTCCGATCTGTCGGCGACGCCTTGAAAGATGCCTTCGAyGGAGCGTCGCGGGTCATGATGCCC---AACACAGAGTTGGAAGCGCCC---GCT---CAGCGGAACGAT---GCGGCTCCGCACAGAGTCCCGCGAAGAGATCGATACAGATTCCAACTTCGACCGCACAATCCTGACCATAAAACACCCGGGGACAAGGACCTAGTATACTTGGAATCATCGCCGGGTTTCTGCGAAAAGAACCCGAGACTGGGCATTCCCGGTACGCACGGGCGTTCCTGCAACGACACGAGCATCGGCGTCGATGGCTGCGACCTGATGTGCTGTGGCCGGGGGTACCGGACTGAGACGATGTTTGTCGTCGA'
        self.res.table = 1
        self.res.type = 'SZ'
        self.res.degenerate()

        result = self.res.degenerated
        expected = 'NNNNNNNNNNNNGAYGTNYTNGAYGARNNNGCNGAYYTNCCNATHTGYMGNMGNMGNYTNGARMGNTGYYTNMGNNNNNNNGTNGCNGGNCAYGAYGCNC---AACAYMGNGTNGGNNNNGCNC---GCT---CAGCNGARMGNT---GCGGNNNNGCNCARNNNCCNGCNAARMGNNNNATHCARATHCCNACNNNNACNGCNCARNNNTGACCNTAAAAYACNMGNGGNCARGGNCCNNNNATHYTNGGNATHATHGCNGGNTTYYTNMGNAARGARCCNGARACNGGNCAYNNNMGNTAYGCNMGNGCNTTYYTNCARMGNCAYGARCAYMGNMGNMGNTGGYTNMGNCCNGAYGTNYTNTGGCCNGGNGTNCCNGAYTGAGAYGAYGTNTGYMGNMGN'

        self.assertEqual(expected, result)

    def test_long_seq_table_5(self):
        self.res.dna = '??????????aAGACGTGTTGGATGAG?TTGCCGACCTTCCGATCTGTCGGCGACGCCTTGAAAGATGCCTTCGAyGGAGCGTCGCGGGTCATGATGCCC---AACACAGAGTTGGAAGCGCCC---GCT---CAGCGGAACGAT---GCGGCTCCGCACAGAGTCCCGCGAAGAGATCGATACAGATTCCAACTTCGACCGCACAATCCTGACCATAAAACACCCGGGGACAAGGACCTAGTATACTTGGAATCATCGCCGGGTTTCTGCGAAAAGAACCCGAGACTGGGCATTCCCGGTACGCACGGGCGTTCCTGCAACGACACGAGCATCGGCGTCGATGGCTGCGACCTGATGTGCTGTGGCCGGGGGTACCGGACTGAGACGATGTTTGTCGTCGA'
        self.res.table = 5
        self.res.degenerate()

        result = self.res.degenerated
        expected = 'NNNNNNNNNNNNGAYGTNYTNGAYGARNNNGCNGAYYTNCCNATYTGYCGNCGNCGNYTNGARAGNTGYYTNCGNNNNAGNGTNGCNGGNCAYGAYGCNC---AACAYAGNGTNGGNAGNGCNC---GCT---CAGCNGARCGNT---GCGGNTCNGCNCARAGNCCNGCNAARAGNTCNATRCARATYCCNACNTCNACNGCNCARTCNTGRCCNTAAAAYACNCGNGGNCARGGNCCNAGNATRYTNGGNATYATYGCNGGNTTYYTNCGNAARGARCCNGARACNGGNCAYTCNCGNTAYGCNCGNGCNTTYYTNCARCGNCAYGARCAYCGNCGNCGNTGRYTNCGNCCNGAYGTNYTNTGRCCNGGNGTNCCNGAYTGRGAYGAYGTNTGYCGNCGN'

        self.assertEqual(expected, result)
