# -*- coding: utf-8 -*-
# Generated by Django 1.9.6 on 2016-07-01 17:27
from __future__ import unicode_literals

from decimal import Decimal
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('offer', '0002_auto_20151210_1053'),
        ('wellsfargo', '0004_auto_20160627_2142'),
    ]

    operations = [
        migrations.CreateModel(
            name='FinancingPlan',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('plan_number', models.PositiveIntegerField(validators=[django.core.validators.MinValueValidator(1001), django.core.validators.MaxValueValidator(9999)], verbose_name='Plan Number')),  # NOQA
                ('description', models.TextField(verbose_name='Description')),
                ('apr', models.DecimalField(decimal_places=2, default='0.00', max_digits=5, validators=[django.core.validators.MinValueValidator(Decimal('0.00')), django.core.validators.MaxValueValidator(Decimal('100.00'))], verbose_name='Annual percentage rate (0.0 – 100.0)')),  # NOQA
                ('term_months', models.PositiveSmallIntegerField(default=12, verbose_name='Term Length (months)')),
            ],
        ),
        migrations.CreateModel(
            name='FinancingPlanBenefit',
            fields=[
                ('benefit_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='offer.Benefit')),  # NOQA
                ('plans', models.ManyToManyField(to='wellsfargo.FinancingPlan')),
            ],
            options={
                'verbose_name': 'Benefit',
                'verbose_name_plural': 'Benefits',
                'abstract': False,
            },
            bases=('offer.benefit',),
        ),
        migrations.AlterField(
            model_name='transfermetadata',
            name='plan_number',
            field=models.PositiveIntegerField(validators=[django.core.validators.MinValueValidator(1001), django.core.validators.MaxValueValidator(9999)], verbose_name='Plan Number'),  # NOQA
        ),
    ]
