# Copyright 2025 PT Espay Debit Indonesia Koe
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Widget API

    API for enabling the user to make payment from merchant's platform with redirecting to DANA's platform.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from dana.base.model import BaseSdkModel

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from dana.widget.v1.models.oauth2_url_data_seamless_data import Oauth2UrlDataSeamlessData
from typing import Optional, Set
from typing_extensions import Self
from pydantic import AliasGenerator
from pydantic.alias_generators import to_camel

class Oauth2UrlData(BaseModel, BaseSdkModel):
    """
    Data needed to construct Oauth2Url
    """ # noqa: E501
    external_id: Annotated[str, Field(strict=True, max_length=64)] = Field(description="Identifier from merchant")
    merchant_id: Annotated[str, Field(strict=True, max_length=64)] = Field(description="Merchant identifier that is unique per each merchant")
    sub_merchant_id: Optional[Annotated[str, Field(strict=True, max_length=64)]] = Field(default=None, description="Information of sub merchant identifier")
    seamless_data: Optional[Oauth2UrlDataSeamlessData] = Field(default=None)
    scopes: Optional[List[StrictStr]] = Field(default=None, description="The scopes of the authorization")
    redirect_url: StrictStr = Field(description="When user authorization is success, the user will be redirected to this URL")
    state: Optional[StrictStr] = Field(default=None, description="Random string for CSRF protection purposes")
    lang: Optional[StrictStr] = Field(default='id', description="Service language code. ISO 639-1")
    allow_registration: Optional[StrictStr] = Field(default='true', description="If value equals true, provider may enable registration process during binding. Default true")
    mode: Optional[StrictStr] = Field(default=None, description="Mode of the authorization. The possible values are API or DEEPLINK")
    __properties: ClassVar[List[str]] = ["externalId", "merchantId", "subMerchantId", "seamlessData", "scopes", "redirectUrl", "state", "lang", "allowRegistration", "mode"]

    @field_validator('mode')
    def mode_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['API', 'DEEPLINK']):
            raise ValueError("must be one of enum values ('API', 'DEEPLINK')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=AliasGenerator(serialization_alias=to_camel, validation_alias=to_camel),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict(), separators=(',', ':'))

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Oauth2UrlData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of seamless_data
        if self.seamless_data:
            _dict['seamlessData'] = self.seamless_data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Oauth2UrlData from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "externalId": obj.get("externalId"),
            "merchantId": obj.get("merchantId"),
            "subMerchantId": obj.get("subMerchantId"),
            "seamlessData": Oauth2UrlDataSeamlessData.from_dict(obj["seamlessData"]) if obj.get("seamlessData") is not None else None,
            "scopes": obj.get("scopes"),
            "redirectUrl": obj.get("redirectUrl"),
            "state": obj.get("state"),
            "lang": obj.get("lang") if obj.get("lang") is not None else 'id',
            "allowRegistration": obj.get("allowRegistration") if obj.get("allowRegistration") is not None else 'true',
            "mode": obj.get("mode")
        })
        return _obj


