"""Change Person.preferred_two_factor_authentication column to ChoiceType

Revision ID: 42ec83db6a01
Revises: f5b113876a49
Create Date: 2022-12-14 01:19:01.159834

"""

from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils


# revision identifiers, used by Alembic.
revision = "42ec83db6a01"
down_revision = "f5b113876a49"
branch_labels = None
depends_on = None

TWO_FACTOR_AUTHENTICATION_TYPES = [
    ("totp", "TOTP"),
    ("email_otp", "Email OTP"),
]


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "person",
        "preferred_two_factor_authentication",
        existing_type=sa.VARCHAR(length=30),
        type_=sqlalchemy_utils.types.choice.ChoiceType(
            TWO_FACTOR_AUTHENTICATION_TYPES
        ),
        existing_nullable=True,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "person",
        "preferred_two_factor_authentication",
        existing_type=sqlalchemy_utils.types.choice.ChoiceType(
            TWO_FACTOR_AUTHENTICATION_TYPES
        ),
        type_=sa.VARCHAR(length=30),
        existing_nullable=True,
    )
    # ### end Alembic commands ###
