"""Allow to set float values for Organisation.hours_by.day, Task.duration, Task.estimation and TimeSpent.duration

Revision ID: 8fbd40afbe5f
Revises: 2baede80b111
Create Date: 2023-02-23 14:47:29.417410

"""

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "8fbd40afbe5f"
down_revision = "2baede80b111"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "organisation",
        "hours_by_day",
        existing_type=sa.INTEGER(),
        type_=sa.Float(),
        existing_nullable=False,
    )
    op.alter_column(
        "task",
        "duration",
        existing_type=sa.INTEGER(),
        type_=sa.Float(),
        existing_nullable=True,
    )
    op.alter_column(
        "task",
        "estimation",
        existing_type=sa.INTEGER(),
        type_=sa.Float(),
        existing_nullable=True,
    )
    op.alter_column(
        "time_spent",
        "duration",
        existing_type=sa.INTEGER(),
        type_=sa.Float(),
        existing_nullable=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "time_spent",
        "duration",
        existing_type=sa.Float(),
        type_=sa.INTEGER(),
        existing_nullable=False,
    )
    op.alter_column(
        "task",
        "estimation",
        existing_type=sa.Float(),
        type_=sa.INTEGER(),
        existing_nullable=True,
    )
    op.alter_column(
        "task",
        "duration",
        existing_type=sa.Float(),
        type_=sa.INTEGER(),
        existing_nullable=True,
    )
    op.alter_column(
        "organisation",
        "hours_by_day",
        existing_type=sa.Float(),
        type_=sa.INTEGER(),
        existing_nullable=False,
    )
    # ### end Alembic commands ###
