# coding: utf-8

"""
    Chatwoot

    This is the API documentation for Chatwoot server.  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: hello@chatwoot.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from chatwoot_client.api_client import ApiClient


class CustomFiltersApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_a_custom_filter(self, body, account_id, **kwargs):  # noqa: E501
        """Create a custom filter  # noqa: E501

        Create a custom filter in the account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_a_custom_filter(body, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomFilterCreateUpdatePayload body: (required)
        :param int account_id: The numeric ID of the account (required)
        :param str filter_type: The type of custom filter
        :return: CustomFilter
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_a_custom_filter_with_http_info(body, account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_a_custom_filter_with_http_info(body, account_id, **kwargs)  # noqa: E501
            return data

    def create_a_custom_filter_with_http_info(self, body, account_id, **kwargs):  # noqa: E501
        """Create a custom filter  # noqa: E501

        Create a custom filter in the account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_a_custom_filter_with_http_info(body, account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomFilterCreateUpdatePayload body: (required)
        :param int account_id: The numeric ID of the account (required)
        :param str filter_type: The type of custom filter
        :return: CustomFilter
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'account_id', 'filter_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_a_custom_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `create_a_custom_filter`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `create_a_custom_filter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []
        if 'filter_type' in params:
            query_params.append(('filter_type', params['filter_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/accounts/{account_id}/custom_filters', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomFilter',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_a_custom_filter(self, account_id, custom_filter_id, **kwargs):  # noqa: E501
        """Delete a custom filter  # noqa: E501

        Delete a custom filter from the account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_a_custom_filter(account_id, custom_filter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param int custom_filter_id: The numeric ID of the custom filter (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_a_custom_filter_with_http_info(account_id, custom_filter_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_a_custom_filter_with_http_info(account_id, custom_filter_id, **kwargs)  # noqa: E501
            return data

    def delete_a_custom_filter_with_http_info(self, account_id, custom_filter_id, **kwargs):  # noqa: E501
        """Delete a custom filter  # noqa: E501

        Delete a custom filter from the account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_a_custom_filter_with_http_info(account_id, custom_filter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param int custom_filter_id: The numeric ID of the custom filter (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'custom_filter_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_a_custom_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `delete_a_custom_filter`")  # noqa: E501
        # verify the required parameter 'custom_filter_id' is set
        if ('custom_filter_id' not in params or
                params['custom_filter_id'] is None):
            raise ValueError("Missing the required parameter `custom_filter_id` when calling `delete_a_custom_filter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501
        if 'custom_filter_id' in params:
            path_params['custom_filter_id'] = params['custom_filter_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['userApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/accounts/{account_id}/custom_filters/{custom_filter_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_details_of_a_single_custom_filter(self, account_id, custom_filter_id, **kwargs):  # noqa: E501
        """Get a custom filter details  # noqa: E501

        Get the details of a custom filter in the account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_details_of_a_single_custom_filter(account_id, custom_filter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param int custom_filter_id: The numeric ID of the custom filter (required)
        :return: CustomFilter
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_details_of_a_single_custom_filter_with_http_info(account_id, custom_filter_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_details_of_a_single_custom_filter_with_http_info(account_id, custom_filter_id, **kwargs)  # noqa: E501
            return data

    def get_details_of_a_single_custom_filter_with_http_info(self, account_id, custom_filter_id, **kwargs):  # noqa: E501
        """Get a custom filter details  # noqa: E501

        Get the details of a custom filter in the account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_details_of_a_single_custom_filter_with_http_info(account_id, custom_filter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param int custom_filter_id: The numeric ID of the custom filter (required)
        :return: CustomFilter
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'custom_filter_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_details_of_a_single_custom_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_details_of_a_single_custom_filter`")  # noqa: E501
        # verify the required parameter 'custom_filter_id' is set
        if ('custom_filter_id' not in params or
                params['custom_filter_id'] is None):
            raise ValueError("Missing the required parameter `custom_filter_id` when calling `get_details_of_a_single_custom_filter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501
        if 'custom_filter_id' in params:
            path_params['custom_filter_id'] = params['custom_filter_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/accounts/{account_id}/custom_filters/{custom_filter_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomFilter',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_all_filters(self, account_id, **kwargs):  # noqa: E501
        """List all custom filters  # noqa: E501

        List all custom filters in a category of a user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_all_filters(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param str filter_type: The type of custom filter
        :return: list[CustomFilter]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_all_filters_with_http_info(account_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_all_filters_with_http_info(account_id, **kwargs)  # noqa: E501
            return data

    def list_all_filters_with_http_info(self, account_id, **kwargs):  # noqa: E501
        """List all custom filters  # noqa: E501

        List all custom filters in a category of a user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_all_filters_with_http_info(account_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param str filter_type: The type of custom filter
        :return: list[CustomFilter]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'filter_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_all_filters" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_all_filters`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []
        if 'filter_type' in params:
            query_params.append(('filter_type', params['filter_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/accounts/{account_id}/custom_filters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CustomFilter]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_a_custom_filter(self, body, account_id, custom_filter_id, **kwargs):  # noqa: E501
        """Update a custom filter  # noqa: E501

        Update a custom filter's attributes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_a_custom_filter(body, account_id, custom_filter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomFilterCreateUpdatePayload body: (required)
        :param int account_id: The numeric ID of the account (required)
        :param int custom_filter_id: The numeric ID of the custom filter (required)
        :return: CustomFilter
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_a_custom_filter_with_http_info(body, account_id, custom_filter_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_a_custom_filter_with_http_info(body, account_id, custom_filter_id, **kwargs)  # noqa: E501
            return data

    def update_a_custom_filter_with_http_info(self, body, account_id, custom_filter_id, **kwargs):  # noqa: E501
        """Update a custom filter  # noqa: E501

        Update a custom filter's attributes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_a_custom_filter_with_http_info(body, account_id, custom_filter_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CustomFilterCreateUpdatePayload body: (required)
        :param int account_id: The numeric ID of the account (required)
        :param int custom_filter_id: The numeric ID of the custom filter (required)
        :return: CustomFilter
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'account_id', 'custom_filter_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_a_custom_filter" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `update_a_custom_filter`")  # noqa: E501
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `update_a_custom_filter`")  # noqa: E501
        # verify the required parameter 'custom_filter_id' is set
        if ('custom_filter_id' not in params or
                params['custom_filter_id'] is None):
            raise ValueError("Missing the required parameter `custom_filter_id` when calling `update_a_custom_filter`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501
        if 'custom_filter_id' in params:
            path_params['custom_filter_id'] = params['custom_filter_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/v1/accounts/{account_id}/custom_filters/{custom_filter_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CustomFilter',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
