# coding: utf-8

"""
    Chatwoot

    This is the API documentation for Chatwoot server.  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: hello@chatwoot.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from chatwoot_client.api_client import ApiClient


class ReportsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_account_conversation_metrics(self, account_id, type, **kwargs):  # noqa: E501
        """Account Conversation Metrics  # noqa: E501

        Get conversation metrics for Account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_conversation_metrics(account_id, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param str type: Type of report (required)
        :return: InlineResponse2007
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_account_conversation_metrics_with_http_info(account_id, type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_account_conversation_metrics_with_http_info(account_id, type, **kwargs)  # noqa: E501
            return data

    def get_account_conversation_metrics_with_http_info(self, account_id, type, **kwargs):  # noqa: E501
        """Account Conversation Metrics  # noqa: E501

        Get conversation metrics for Account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_account_conversation_metrics_with_http_info(account_id, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param str type: Type of report (required)
        :return: InlineResponse2007
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_account_conversation_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_account_conversation_metrics`")  # noqa: E501
        # verify the required parameter 'type' is set
        if ('type' not in params or
                params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `get_account_conversation_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/accounts/{account_id}/reports/conversations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2007',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_agent_conversation_metrics(self, account_id, type, **kwargs):  # noqa: E501
        """Agent Conversation Metrics  # noqa: E501

        Get conversation metrics for Agent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_agent_conversation_metrics(account_id, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param str type: Type of report (required)
        :param str user_id: The numeric ID of the user
        :return: list[AgentConversationMetrics]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_agent_conversation_metrics_with_http_info(account_id, type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_agent_conversation_metrics_with_http_info(account_id, type, **kwargs)  # noqa: E501
            return data

    def get_agent_conversation_metrics_with_http_info(self, account_id, type, **kwargs):  # noqa: E501
        """Agent Conversation Metrics  # noqa: E501

        Get conversation metrics for Agent  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_agent_conversation_metrics_with_http_info(account_id, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param str type: Type of report (required)
        :param str user_id: The numeric ID of the user
        :return: list[AgentConversationMetrics]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'type', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_agent_conversation_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `get_agent_conversation_metrics`")  # noqa: E501
        # verify the required parameter 'type' is set
        if ('type' not in params or
                params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `get_agent_conversation_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'user_id' in params:
            query_params.append(('user_id', params['user_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/accounts/{account_id}/reports/conversations/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AgentConversationMetrics]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_all_conversation_statistics(self, account_id, metric, type, **kwargs):  # noqa: E501
        """Get Account reports  # noqa: E501

        Get Account reports for a specific type, metric and date range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_all_conversation_statistics(account_id, metric, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param str metric: The type of metric (required)
        :param str type: Type of report (required)
        :param str id: The Id of specific object in case of agent/inbox/label
        :param str since: The timestamp from where report should start.
        :param str until: The timestamp from where report should stop.
        :return: list[InlineResponse2006]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_all_conversation_statistics_with_http_info(account_id, metric, type, **kwargs)  # noqa: E501
        else:
            (data) = self.list_all_conversation_statistics_with_http_info(account_id, metric, type, **kwargs)  # noqa: E501
            return data

    def list_all_conversation_statistics_with_http_info(self, account_id, metric, type, **kwargs):  # noqa: E501
        """Get Account reports  # noqa: E501

        Get Account reports for a specific type, metric and date range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_all_conversation_statistics_with_http_info(account_id, metric, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param str metric: The type of metric (required)
        :param str type: Type of report (required)
        :param str id: The Id of specific object in case of agent/inbox/label
        :param str since: The timestamp from where report should start.
        :param str until: The timestamp from where report should stop.
        :return: list[InlineResponse2006]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'metric', 'type', 'id', 'since', 'until']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_all_conversation_statistics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_all_conversation_statistics`")  # noqa: E501
        # verify the required parameter 'metric' is set
        if ('metric' not in params or
                params['metric'] is None):
            raise ValueError("Missing the required parameter `metric` when calling `list_all_conversation_statistics`")  # noqa: E501
        # verify the required parameter 'type' is set
        if ('type' not in params or
                params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `list_all_conversation_statistics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []
        if 'metric' in params:
            query_params.append(('metric', params['metric']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'id' in params:
            query_params.append(('id', params['id']))  # noqa: E501
        if 'since' in params:
            query_params.append(('since', params['since']))  # noqa: E501
        if 'until' in params:
            query_params.append(('until', params['until']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/accounts/{account_id}/reports', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse2006]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_all_conversation_statistics_summary(self, account_id, type, **kwargs):  # noqa: E501
        """Get Account reports summary  # noqa: E501

        Get Account reports summary for a specific type and date range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_all_conversation_statistics_summary(account_id, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param str type: Type of report (required)
        :param str id: The Id of specific object in case of agent/inbox/label
        :param str since: The timestamp from where report should start.
        :param str until: The timestamp from where report should stop.
        :return: AccountSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_all_conversation_statistics_summary_with_http_info(account_id, type, **kwargs)  # noqa: E501
        else:
            (data) = self.list_all_conversation_statistics_summary_with_http_info(account_id, type, **kwargs)  # noqa: E501
            return data

    def list_all_conversation_statistics_summary_with_http_info(self, account_id, type, **kwargs):  # noqa: E501
        """Get Account reports summary  # noqa: E501

        Get Account reports summary for a specific type and date range  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_all_conversation_statistics_summary_with_http_info(account_id, type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int account_id: The numeric ID of the account (required)
        :param str type: Type of report (required)
        :param str id: The Id of specific object in case of agent/inbox/label
        :param str since: The timestamp from where report should start.
        :param str until: The timestamp from where report should stop.
        :return: AccountSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['account_id', 'type', 'id', 'since', 'until']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_all_conversation_statistics_summary" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'account_id' is set
        if ('account_id' not in params or
                params['account_id'] is None):
            raise ValueError("Missing the required parameter `account_id` when calling `list_all_conversation_statistics_summary`")  # noqa: E501
        # verify the required parameter 'type' is set
        if ('type' not in params or
                params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `list_all_conversation_statistics_summary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'account_id' in params:
            path_params['account_id'] = params['account_id']  # noqa: E501

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'id' in params:
            query_params.append(('id', params['id']))  # noqa: E501
        if 'since' in params:
            query_params.append(('since', params['since']))  # noqa: E501
        if 'until' in params:
            query_params.append(('until', params['until']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['userApiKey']  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/accounts/{account_id}/reports/summary', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AccountSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
