# Generated by Django 3.2.10 on 2021-12-23 21:52

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import picklefield.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('django_celery_beat', '0015_edit_solarschedule_events_choices'),
    ]

    operations = [
        migrations.CreateModel(
            name='Application',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=63, unique=True, verbose_name='name')),
            ],
            options={
                'verbose_name': 'application',
                'verbose_name_plural': 'applications',
                'swappable': 'DJANGOFCM_APPLICATION_MODEL',
            },
        ),
        migrations.CreateModel(
            name='PushToken',
            fields=[
                ('push_token', models.CharField(max_length=255, primary_key=True, serialize=False, verbose_name='push token')),
                ('creation_date', models.DateTimeField(auto_now_add=True, verbose_name='creation date')),
                ('update_date', models.DateTimeField(auto_now=True, verbose_name='update date')),
                ('application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='push_tokens', to=settings.DJANGOFCM_APPLICATION_MODEL, verbose_name='application')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='push_tokens', to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'verbose_name': 'push token',
                'verbose_name_plural': 'push tokens',
            },
        ),
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=63, unique=True, verbose_name='name')),
                ('title', models.CharField(blank=True, max_length=63, verbose_name='title')),
                ('body', models.CharField(blank=True, max_length=255, verbose_name='body')),
                ('recipients_composer_conditions', picklefield.fields.PickledObjectField(editable=False, null=True, verbose_name='recipients composer conditions')),
                ('send_on', models.DateTimeField(blank=True, verbose_name='send on date')),
                ('sent', models.BooleanField(default=False, verbose_name='is sent')),
                ('creation_date', models.DateTimeField(auto_now_add=True, verbose_name='creation date')),
                ('recipients', models.ManyToManyField(blank=True, related_name='notifications', to='djangoFCM.PushToken', verbose_name='recipients')),
                ('task', models.OneToOneField(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='notification', to='django_celery_beat.periodictask', verbose_name='task')),
            ],
            options={
                'verbose_name': 'notification',
                'verbose_name_plural': 'notifications',
            },
        ),
    ]
