# Generated by Django 5.0.7 on 2024-07-25 20:16

import artd_alliance.models
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('artd_location', '0002_alter_city_created_at_alter_city_status_and_more'),
        ('artd_partner', '0005_alter_coworker_created_at_alter_coworker_updated_at_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='Alliance',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, help_text='Created at', verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, help_text='Updated at', verbose_name='Updated at')),
                ('status', models.BooleanField(default=True, help_text='Status', verbose_name='Status')),
                ('service', models.CharField(help_text='Service', max_length=150, verbose_name='Service')),
                ('benefit', models.CharField(help_text='Benefit', max_length=150, verbose_name='Benefit')),
                ('benefit_type', models.CharField(choices=[('discount', 'Discount'), ('fixed', 'Fixed')], default='fixed', help_text='Benefit Type', max_length=255, verbose_name='Benefit Type')),
                ('alliance_status', models.CharField(choices=[('active', 'Active'), ('requested', 'Requested'), ('under_review', 'Under review'), ('denied', 'Denied'), ('inactive', 'Inactive'), ('created', 'Created')], default='inactive', help_text='Benefit Status', max_length=255, verbose_name='Benefit Status')),
                ('code_alliance', models.SlugField(help_text='Code Alliance', max_length=150, verbose_name='Code')),
                ('partner', models.ForeignKey(help_text='Partner of headquarter', on_delete=django.db.models.deletion.CASCADE, to='artd_partner.partner', verbose_name='Partner')),
            ],
            options={
                'verbose_name': 'Alliance',
                'verbose_name_plural': 'Alliances',
            },
        ),
        migrations.CreateModel(
            name='AllianceStatusChange',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, help_text='Created at', verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, help_text='Updated at', verbose_name='Updated at')),
                ('status', models.BooleanField(default=True, help_text='Status', verbose_name='Status')),
                ('new_status', models.CharField(choices=[('active', 'Active'), ('requested', 'Requested'), ('under_review', 'Under review'), ('denied', 'Denied'), ('inactive', 'Inactive'), ('created', 'Created')], default='inactive', help_text='Status', max_length=255, verbose_name='Status')),
                ('old_status', models.CharField(blank=True, choices=[('active', 'Active'), ('requested', 'Requested'), ('under_review', 'Under review'), ('denied', 'Denied'), ('inactive', 'Inactive'), ('created', 'Created')], help_text='Status', max_length=255, null=True, verbose_name='Status')),
                ('change_date', models.DateTimeField(auto_now_add=True, verbose_name='Change Date')),
                ('alliance', models.ForeignKey(help_text='The alliance whose status has changed', on_delete=django.db.models.deletion.CASCADE, to='artd_alliance.alliance', verbose_name='Alliance')),
                ('changed_by', models.ForeignKey(blank=True, help_text='User who made the change', null=True, on_delete=django.db.models.deletion.SET_NULL, to='artd_partner.partner', verbose_name='Changed By')),
            ],
            options={
                'verbose_name': 'Alliance Status Change',
                'verbose_name_plural': 'Alliance Status Changes',
            },
        ),
        migrations.CreateModel(
            name='Ally',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, help_text='Created at', verbose_name='Created at')),
                ('updated_at', models.DateTimeField(auto_now=True, help_text='Updated at', verbose_name='Updated at')),
                ('status', models.BooleanField(default=True, help_text='Status', verbose_name='Status')),
                ('name', models.CharField(help_text='Name of partner', max_length=150, verbose_name='Name')),
                ('dni', models.CharField(help_text='DNI of partner', max_length=20, verbose_name='Dni')),
                ('phone', models.CharField(blank=True, max_length=12, null=True)),
                ('email', models.EmailField(help_text='Email of partner', max_length=254, verbose_name='Email')),
                ('address', models.CharField(help_text='Address of partner', max_length=250, verbose_name='Address')),
                ('logo', models.ImageField(help_text='Logo ally', upload_to=artd_alliance.models.ally_image_path, verbose_name='Logo')),
                ('city_new', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='artd_location.city')),
            ],
            options={
                'verbose_name': 'Ally',
                'verbose_name_plural': 'Allies',
            },
        ),
        migrations.AddField(
            model_name='alliance',
            name='ally',
            field=models.ForeignKey(help_text='Ally', on_delete=django.db.models.deletion.CASCADE, to='artd_alliance.ally', verbose_name='Ally'),
        ),
    ]
