"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InterfaceVpcEndpointTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
/**
 * Set an InterfaceVpcEndpoint as a target for an ARecord.
 *
 * @stability stable
 */
class InterfaceVpcEndpointTarget {
    /**
     * @stability stable
     */
    constructor(vpcEndpoint) {
        this.vpcEndpoint = vpcEndpoint;
        this.cfnVpcEndpoint = this.vpcEndpoint.node.findChild('Resource');
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record) {
        return {
            dnsName: cdk.Fn.select(1, cdk.Fn.split(':', cdk.Fn.select(0, this.cfnVpcEndpoint.attrDnsEntries))),
            hostedZoneId: cdk.Fn.select(0, cdk.Fn.split(':', cdk.Fn.select(0, this.cfnVpcEndpoint.attrDnsEntries))),
        };
    }
}
exports.InterfaceVpcEndpointTarget = InterfaceVpcEndpointTarget;
_a = JSII_RTTI_SYMBOL_1;
InterfaceVpcEndpointTarget[_a] = { fqn: "@aws-cdk/aws-route53-targets.InterfaceVpcEndpointTarget", version: "1.93.0" };
//# sourceMappingURL=data:application/json;base64,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