/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.metric;

import io.qameta.allure.entity.Statistic;
import io.qameta.allure.entity.Status;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.metric.Metric;
import io.qameta.allure.metric.MetricLine;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StatusMetric
implements Metric {
    private final Statistic statistic = new Statistic();
    private final BiFunction<Status, Long, MetricLine> lineFactory;

    public StatusMetric(BiFunction<Status, Long, MetricLine> lineFactory) {
        this.lineFactory = lineFactory;
    }

    @Override
    public void update(TestResult testResult) {
        if (testResult.isRetry()) {
            return;
        }
        this.statistic.update(testResult);
    }

    @Override
    public List<MetricLine> getLines() {
        return Stream.of(Status.values()).map(status -> this.lineFactory.apply((Status)status, this.statistic.get((Status)status))).collect(Collectors.toList());
    }
}

