/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.suites;

import io.qameta.allure.Aggregator;
import io.qameta.allure.CommonCsvExportAggregator;
import io.qameta.allure.CommonJsonAggregator;
import io.qameta.allure.CompositeAggregator;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.csv.CsvExportSuite;
import io.qameta.allure.entity.LabelName;
import io.qameta.allure.entity.Statistic;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.tree.TestResultTree;
import io.qameta.allure.tree.TestResultTreeGroup;
import io.qameta.allure.tree.Tree;
import io.qameta.allure.tree.TreeUtils;
import io.qameta.allure.tree.TreeWidgetData;
import io.qameta.allure.tree.TreeWidgetItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class SuitesPlugin
extends CompositeAggregator {
    private static final String SUITES = "suites";
    protected static final String JSON_FILE_NAME = "suites.json";
    protected static final String CSV_FILE_NAME = "suites.csv";

    public SuitesPlugin() {
        super(Arrays.asList(new Aggregator[]{new JsonAggregator(), new CsvExportAggregator(), new WidgetAggregator()}));
    }

    static Tree<TestResult> getData(List<LaunchResults> launchResults) {
        TestResultTree xunit = new TestResultTree(SUITES, testResult -> TreeUtils.groupByLabels((TestResult)testResult, (LabelName[])new LabelName[]{LabelName.PARENT_SUITE, LabelName.SUITE, LabelName.SUB_SUITE}));
        launchResults.stream().map(LaunchResults::getResults).flatMap(Collection::stream).sorted(TestResult.comparingByTimeAsc()).forEach(arg_0 -> ((Tree)xunit).add(arg_0));
        return xunit;
    }

    private static class WidgetAggregator
    extends CommonJsonAggregator {
        WidgetAggregator() {
            super("widgets", SuitesPlugin.JSON_FILE_NAME);
        }

        protected Object getData(List<LaunchResults> launches) {
            Tree<TestResult> data = SuitesPlugin.getData(launches);
            List items = data.getChildren().stream().filter(TestResultTreeGroup.class::isInstance).map(TestResultTreeGroup.class::cast).map(WidgetAggregator::toWidgetItem).sorted(Comparator.comparing(TreeWidgetItem::getStatistic, Statistic.comparator()).reversed()).limit(10L).collect(Collectors.toList());
            return new TreeWidgetData().setItems(items).setTotal((long)data.getChildren().size());
        }

        private static TreeWidgetItem toWidgetItem(TestResultTreeGroup group) {
            return new TreeWidgetItem().setUid(group.getUid()).setName(group.getName()).setStatistic(TreeUtils.calculateStatisticByLeafs((TestResultTreeGroup)group));
        }
    }

    private static class CsvExportAggregator
    extends CommonCsvExportAggregator<CsvExportSuite> {
        CsvExportAggregator() {
            super(SuitesPlugin.CSV_FILE_NAME, CsvExportSuite.class);
        }

        protected List<CsvExportSuite> getData(List<LaunchResults> launchesResults) {
            return launchesResults.stream().flatMap(launch -> launch.getResults().stream()).map(CsvExportSuite::new).collect(Collectors.toList());
        }
    }

    private static class JsonAggregator
    extends CommonJsonAggregator {
        JsonAggregator() {
            super(SuitesPlugin.JSON_FILE_NAME);
        }

        protected Tree<TestResult> getData(List<LaunchResults> launches) {
            return SuitesPlugin.getData(launches);
        }
    }
}

