import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleworkspaceUsersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/d/users#id DataGoogleworkspaceUsers#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataGoogleworkspaceUsersUsersAddresses {
}
export declare function dataGoogleworkspaceUsersUsersAddressesToTerraform(struct?: DataGoogleworkspaceUsersUsersAddresses): any;
export declare class DataGoogleworkspaceUsersUsersAddressesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUsersUsersAddresses | undefined;
    set internalValue(value: DataGoogleworkspaceUsersUsersAddresses | undefined);
    get country(): string;
    get countryCode(): string;
    get customType(): string;
    get extendedAddress(): string;
    get formatted(): string;
    get locality(): string;
    get poBox(): string;
    get postalCode(): string;
    get primary(): cdktf.IResolvable;
    get region(): string;
    get sourceIsStructured(): cdktf.IResolvable;
    get streetAddress(): string;
    get type(): string;
}
export declare class DataGoogleworkspaceUsersUsersAddressesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUsersUsersAddressesOutputReference;
}
export interface DataGoogleworkspaceUsersUsersCustomSchemas {
}
export declare function dataGoogleworkspaceUsersUsersCustomSchemasToTerraform(struct?: DataGoogleworkspaceUsersUsersCustomSchemas): any;
export declare class DataGoogleworkspaceUsersUsersCustomSchemasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUsersUsersCustomSchemas | undefined;
    set internalValue(value: DataGoogleworkspaceUsersUsersCustomSchemas | undefined);
    get schemaName(): string;
    private _schemaValues;
    get schemaValues(): cdktf.StringMap;
}
export declare class DataGoogleworkspaceUsersUsersCustomSchemasList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUsersUsersCustomSchemasOutputReference;
}
export interface DataGoogleworkspaceUsersUsersEmails {
}
export declare function dataGoogleworkspaceUsersUsersEmailsToTerraform(struct?: DataGoogleworkspaceUsersUsersEmails): any;
export declare class DataGoogleworkspaceUsersUsersEmailsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUsersUsersEmails | undefined;
    set internalValue(value: DataGoogleworkspaceUsersUsersEmails | undefined);
    get address(): string;
    get customType(): string;
    get primary(): cdktf.IResolvable;
    get type(): string;
}
export declare class DataGoogleworkspaceUsersUsersEmailsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUsersUsersEmailsOutputReference;
}
export interface DataGoogleworkspaceUsersUsersExternalIds {
}
export declare function dataGoogleworkspaceUsersUsersExternalIdsToTerraform(struct?: DataGoogleworkspaceUsersUsersExternalIds): any;
export declare class DataGoogleworkspaceUsersUsersExternalIdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUsersUsersExternalIds | undefined;
    set internalValue(value: DataGoogleworkspaceUsersUsersExternalIds | undefined);
    get customType(): string;
    get type(): string;
    get value(): string;
}
export declare class DataGoogleworkspaceUsersUsersExternalIdsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUsersUsersExternalIdsOutputReference;
}
export interface DataGoogleworkspaceUsersUsersIms {
}
export declare function dataGoogleworkspaceUsersUsersImsToTerraform(struct?: DataGoogleworkspaceUsersUsersIms): any;
export declare class DataGoogleworkspaceUsersUsersImsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUsersUsersIms | undefined;
    set internalValue(value: DataGoogleworkspaceUsersUsersIms | undefined);
    get customProtocol(): string;
    get customType(): string;
    get im(): string;
    get primary(): cdktf.IResolvable;
    get protocol(): string;
    get type(): string;
}
export declare class DataGoogleworkspaceUsersUsersImsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUsersUsersImsOutputReference;
}
export interface DataGoogleworkspaceUsersUsersKeywords {
}
export declare function dataGoogleworkspaceUsersUsersKeywordsToTerraform(struct?: DataGoogleworkspaceUsersUsersKeywords): any;
export declare class DataGoogleworkspaceUsersUsersKeywordsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUsersUsersKeywords | undefined;
    set internalValue(value: DataGoogleworkspaceUsersUsersKeywords | undefined);
    get customType(): string;
    get type(): string;
    get value(): string;
}
export declare class DataGoogleworkspaceUsersUsersKeywordsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUsersUsersKeywordsOutputReference;
}
export interface DataGoogleworkspaceUsersUsersLanguages {
}
export declare function dataGoogleworkspaceUsersUsersLanguagesToTerraform(struct?: DataGoogleworkspaceUsersUsersLanguages): any;
export declare class DataGoogleworkspaceUsersUsersLanguagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUsersUsersLanguages | undefined;
    set internalValue(value: DataGoogleworkspaceUsersUsersLanguages | undefined);
    get customLanguage(): string;
    get languageCode(): string;
    get preference(): string;
}
export declare class DataGoogleworkspaceUsersUsersLanguagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUsersUsersLanguagesOutputReference;
}
export interface DataGoogleworkspaceUsersUsersLocations {
}
export declare function dataGoogleworkspaceUsersUsersLocationsToTerraform(struct?: DataGoogleworkspaceUsersUsersLocations): any;
export declare class DataGoogleworkspaceUsersUsersLocationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUsersUsersLocations | undefined;
    set internalValue(value: DataGoogleworkspaceUsersUsersLocations | undefined);
    get area(): string;
    get buildingId(): string;
    get customType(): string;
    get deskCode(): string;
    get floorName(): string;
    get floorSection(): string;
    get type(): string;
}
export declare class DataGoogleworkspaceUsersUsersLocationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUsersUsersLocationsOutputReference;
}
export interface DataGoogleworkspaceUsersUsersName {
}
export declare function dataGoogleworkspaceUsersUsersNameToTerraform(struct?: DataGoogleworkspaceUsersUsersName): any;
export declare class DataGoogleworkspaceUsersUsersNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUsersUsersName | undefined;
    set internalValue(value: DataGoogleworkspaceUsersUsersName | undefined);
    get familyName(): string;
    get fullName(): string;
    get givenName(): string;
}
export declare class DataGoogleworkspaceUsersUsersNameList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUsersUsersNameOutputReference;
}
export interface DataGoogleworkspaceUsersUsersOrganizations {
}
export declare function dataGoogleworkspaceUsersUsersOrganizationsToTerraform(struct?: DataGoogleworkspaceUsersUsersOrganizations): any;
export declare class DataGoogleworkspaceUsersUsersOrganizationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUsersUsersOrganizations | undefined;
    set internalValue(value: DataGoogleworkspaceUsersUsersOrganizations | undefined);
    get costCenter(): string;
    get customType(): string;
    get department(): string;
    get description(): string;
    get domain(): string;
    get fullTimeEquivalent(): number;
    get location(): string;
    get name(): string;
    get primary(): cdktf.IResolvable;
    get symbol(): string;
    get title(): string;
    get type(): string;
}
export declare class DataGoogleworkspaceUsersUsersOrganizationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUsersUsersOrganizationsOutputReference;
}
export interface DataGoogleworkspaceUsersUsersPhones {
}
export declare function dataGoogleworkspaceUsersUsersPhonesToTerraform(struct?: DataGoogleworkspaceUsersUsersPhones): any;
export declare class DataGoogleworkspaceUsersUsersPhonesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUsersUsersPhones | undefined;
    set internalValue(value: DataGoogleworkspaceUsersUsersPhones | undefined);
    get customType(): string;
    get primary(): cdktf.IResolvable;
    get type(): string;
    get value(): string;
}
export declare class DataGoogleworkspaceUsersUsersPhonesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUsersUsersPhonesOutputReference;
}
export interface DataGoogleworkspaceUsersUsersPosixAccounts {
}
export declare function dataGoogleworkspaceUsersUsersPosixAccountsToTerraform(struct?: DataGoogleworkspaceUsersUsersPosixAccounts): any;
export declare class DataGoogleworkspaceUsersUsersPosixAccountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUsersUsersPosixAccounts | undefined;
    set internalValue(value: DataGoogleworkspaceUsersUsersPosixAccounts | undefined);
    get accountId(): string;
    get gecos(): string;
    get gid(): string;
    get homeDirectory(): string;
    get operatingSystemType(): string;
    get primary(): cdktf.IResolvable;
    get shell(): string;
    get systemId(): string;
    get uid(): string;
    get username(): string;
}
export declare class DataGoogleworkspaceUsersUsersPosixAccountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUsersUsersPosixAccountsOutputReference;
}
export interface DataGoogleworkspaceUsersUsersRelations {
}
export declare function dataGoogleworkspaceUsersUsersRelationsToTerraform(struct?: DataGoogleworkspaceUsersUsersRelations): any;
export declare class DataGoogleworkspaceUsersUsersRelationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUsersUsersRelations | undefined;
    set internalValue(value: DataGoogleworkspaceUsersUsersRelations | undefined);
    get customType(): string;
    get type(): string;
    get value(): string;
}
export declare class DataGoogleworkspaceUsersUsersRelationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUsersUsersRelationsOutputReference;
}
export interface DataGoogleworkspaceUsersUsersSshPublicKeys {
}
export declare function dataGoogleworkspaceUsersUsersSshPublicKeysToTerraform(struct?: DataGoogleworkspaceUsersUsersSshPublicKeys): any;
export declare class DataGoogleworkspaceUsersUsersSshPublicKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUsersUsersSshPublicKeys | undefined;
    set internalValue(value: DataGoogleworkspaceUsersUsersSshPublicKeys | undefined);
    get expirationTimeUsec(): string;
    get fingerprint(): string;
    get key(): string;
}
export declare class DataGoogleworkspaceUsersUsersSshPublicKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUsersUsersSshPublicKeysOutputReference;
}
export interface DataGoogleworkspaceUsersUsersWebsites {
}
export declare function dataGoogleworkspaceUsersUsersWebsitesToTerraform(struct?: DataGoogleworkspaceUsersUsersWebsites): any;
export declare class DataGoogleworkspaceUsersUsersWebsitesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUsersUsersWebsites | undefined;
    set internalValue(value: DataGoogleworkspaceUsersUsersWebsites | undefined);
    get customType(): string;
    get primary(): cdktf.IResolvable;
    get type(): string;
    get value(): string;
}
export declare class DataGoogleworkspaceUsersUsersWebsitesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUsersUsersWebsitesOutputReference;
}
export interface DataGoogleworkspaceUsersUsers {
}
export declare function dataGoogleworkspaceUsersUsersToTerraform(struct?: DataGoogleworkspaceUsersUsers): any;
export declare class DataGoogleworkspaceUsersUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleworkspaceUsersUsers | undefined;
    set internalValue(value: DataGoogleworkspaceUsersUsers | undefined);
    private _addresses;
    get addresses(): DataGoogleworkspaceUsersUsersAddressesList;
    get agreedToTerms(): cdktf.IResolvable;
    get aliases(): string[];
    get archived(): cdktf.IResolvable;
    get changePasswordAtNextLogin(): cdktf.IResolvable;
    get creationTime(): string;
    private _customSchemas;
    get customSchemas(): DataGoogleworkspaceUsersUsersCustomSchemasList;
    get customerId(): string;
    get deletionTime(): string;
    private _emails;
    get emails(): DataGoogleworkspaceUsersUsersEmailsList;
    get etag(): string;
    private _externalIds;
    get externalIds(): DataGoogleworkspaceUsersUsersExternalIdsList;
    get hashFunction(): string;
    get id(): string;
    private _ims;
    get ims(): DataGoogleworkspaceUsersUsersImsList;
    get includeInGlobalAddressList(): cdktf.IResolvable;
    get ipAllowlist(): cdktf.IResolvable;
    get isAdmin(): cdktf.IResolvable;
    get isDelegatedAdmin(): cdktf.IResolvable;
    get isEnforcedIn2StepVerification(): cdktf.IResolvable;
    get isEnrolledIn2StepVerification(): cdktf.IResolvable;
    get isMailboxSetup(): cdktf.IResolvable;
    private _keywords;
    get keywords(): DataGoogleworkspaceUsersUsersKeywordsList;
    private _languages;
    get languages(): DataGoogleworkspaceUsersUsersLanguagesList;
    get lastLoginTime(): string;
    private _locations;
    get locations(): DataGoogleworkspaceUsersUsersLocationsList;
    private _name;
    get name(): DataGoogleworkspaceUsersUsersNameList;
    get nonEditableAliases(): string[];
    get orgUnitPath(): string;
    private _organizations;
    get organizations(): DataGoogleworkspaceUsersUsersOrganizationsList;
    get password(): string;
    private _phones;
    get phones(): DataGoogleworkspaceUsersUsersPhonesList;
    private _posixAccounts;
    get posixAccounts(): DataGoogleworkspaceUsersUsersPosixAccountsList;
    get primaryEmail(): string;
    get recoveryEmail(): string;
    get recoveryPhone(): string;
    private _relations;
    get relations(): DataGoogleworkspaceUsersUsersRelationsList;
    private _sshPublicKeys;
    get sshPublicKeys(): DataGoogleworkspaceUsersUsersSshPublicKeysList;
    get suspended(): cdktf.IResolvable;
    get suspensionReason(): string;
    get thumbnailPhotoEtag(): string;
    get thumbnailPhotoUrl(): string;
    private _websites;
    get websites(): DataGoogleworkspaceUsersUsersWebsitesList;
}
export declare class DataGoogleworkspaceUsersUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleworkspaceUsersUsersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/googleworkspace/d/users googleworkspace_users}
*/
export declare class DataGoogleworkspaceUsers extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "googleworkspace_users";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/googleworkspace/d/users googleworkspace_users} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleworkspaceUsersConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleworkspaceUsersConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _users;
    get users(): DataGoogleworkspaceUsersUsersList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
