#
# Autogenerated by Thrift Compiler (0.9.0)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py:new_style
#

from thrift.Thrift import TType, TMessageType, TException, TApplicationException
from ttypes import *
from thrift.Thrift import TProcessor
from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol, TProtocol
try:
  from thrift.protocol import fastbinary
except:
  fastbinary = None


class Iface(object):
  def enableTable(self, tableName):
    """
    Brings a table on-line (enables it)

    Parameters:
     - tableName: name of the table
    """
    pass

  def disableTable(self, tableName):
    """
    Disables a table (takes it off-line) If it is being served, the master
    will tell the servers to stop serving it.

    Parameters:
     - tableName: name of the table
    """
    pass

  def isTableEnabled(self, tableName):
    """
    @return true if table is on-line

    Parameters:
     - tableName: name of the table to check
    """
    pass

  def compact(self, tableNameOrRegionName):
    """
    Parameters:
     - tableNameOrRegionName
    """
    pass

  def majorCompact(self, tableNameOrRegionName):
    """
    Parameters:
     - tableNameOrRegionName
    """
    pass

  def getTableNames(self, ):
    """
    List all the userspace tables.

    @return returns a list of names
    """
    pass

  def getColumnDescriptors(self, tableName):
    """
    List all the column families assoicated with a table.

    @return list of column family descriptors

    Parameters:
     - tableName: table name
    """
    pass

  def getTableRegions(self, tableName):
    """
    List the regions associated with a table.

    @return list of region descriptors

    Parameters:
     - tableName: table name
    """
    pass

  def createTable(self, tableName, columnFamilies):
    """
    Create a table with the specified column families.  The name
    field for each ColumnDescriptor must be set and must end in a
    colon (:). All other fields are optional and will get default
    values if not explicitly specified.

    @throws IllegalArgument if an input parameter is invalid

    @throws AlreadyExists if the table name already exists

    Parameters:
     - tableName: name of table to create
     - columnFamilies: list of column family descriptors
    """
    pass

  def deleteTable(self, tableName):
    """
    Deletes a table

    @throws IOError if table doesn't exist on server or there was some other
    problem

    Parameters:
     - tableName: name of table to delete
    """
    pass

  def get(self, tableName, row, column, attributes):
    """
    Get a single TCell for the specified table, row, and column at the
    latest timestamp. Returns an empty list if no such value exists.

    @return value for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
     - attributes: Get attributes
    """
    pass

  def getVer(self, tableName, row, column, numVersions, attributes):
    """
    Get the specified number of versions for the specified table,
    row, and column.

    @return list of cells for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
     - numVersions: number of versions to retrieve
     - attributes: Get attributes
    """
    pass

  def getVerTs(self, tableName, row, column, timestamp, numVersions, attributes):
    """
    Get the specified number of versions for the specified table,
    row, and column.  Only versions less than or equal to the specified
    timestamp will be returned.

    @return list of cells for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
     - timestamp: timestamp
     - numVersions: number of versions to retrieve
     - attributes: Get attributes
    """
    pass

  def getRow(self, tableName, row, attributes):
    """
    Get all the data for the specified table and row at the latest
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of table
     - row: row key
     - attributes: Get attributes
    """
    pass

  def getRowWithColumns(self, tableName, row, columns, attributes):
    """
    Get the specified columns for the specified table and row at the latest
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of table
     - row: row key
     - columns: List of columns to return, null for all columns
     - attributes: Get attributes
    """
    pass

  def getRowTs(self, tableName, row, timestamp, attributes):
    """
    Get all the data for the specified table and row at the specified
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of the table
     - row: row key
     - timestamp: timestamp
     - attributes: Get attributes
    """
    pass

  def getRowWithColumnsTs(self, tableName, row, columns, timestamp, attributes):
    """
    Get the specified columns for the specified table and row at the specified
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of table
     - row: row key
     - columns: List of columns to return, null for all columns
     - timestamp
     - attributes: Get attributes
    """
    pass

  def getRows(self, tableName, rows, attributes):
    """
    Get all the data for the specified table and rows at the latest
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of table
     - rows: row keys
     - attributes: Get attributes
    """
    pass

  def getRowsWithColumns(self, tableName, rows, columns, attributes):
    """
    Get the specified columns for the specified table and rows at the latest
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of table
     - rows: row keys
     - columns: List of columns to return, null for all columns
     - attributes: Get attributes
    """
    pass

  def getRowsTs(self, tableName, rows, timestamp, attributes):
    """
    Get all the data for the specified table and rows at the specified
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of the table
     - rows: row keys
     - timestamp: timestamp
     - attributes: Get attributes
    """
    pass

  def getRowsWithColumnsTs(self, tableName, rows, columns, timestamp, attributes):
    """
    Get the specified columns for the specified table and rows at the specified
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of table
     - rows: row keys
     - columns: List of columns to return, null for all columns
     - timestamp
     - attributes: Get attributes
    """
    pass

  def mutateRow(self, tableName, row, mutations, attributes):
    """
    Apply a series of mutations (updates/deletes) to a row in a
    single transaction.  If an exception is thrown, then the
    transaction is aborted.  Default current timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - row: row key
     - mutations: list of mutation commands
     - attributes: Mutation attributes
    """
    pass

  def mutateRowTs(self, tableName, row, mutations, timestamp, attributes):
    """
    Apply a series of mutations (updates/deletes) to a row in a
    single transaction.  If an exception is thrown, then the
    transaction is aborted.  The specified timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - row: row key
     - mutations: list of mutation commands
     - timestamp: timestamp
     - attributes: Mutation attributes
    """
    pass

  def mutateRows(self, tableName, rowBatches, attributes):
    """
    Apply a series of batches (each a series of mutations on a single row)
    in a single transaction.  If an exception is thrown, then the
    transaction is aborted.  Default current timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - rowBatches: list of row batches
     - attributes: Mutation attributes
    """
    pass

  def mutateRowsTs(self, tableName, rowBatches, timestamp, attributes):
    """
    Apply a series of batches (each a series of mutations on a single row)
    in a single transaction.  If an exception is thrown, then the
    transaction is aborted.  The specified timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - rowBatches: list of row batches
     - timestamp: timestamp
     - attributes: Mutation attributes
    """
    pass

  def atomicIncrement(self, tableName, row, column, value):
    """
    Atomically increment the column value specified.  Returns the next value post increment.

    Parameters:
     - tableName: name of table
     - row: row to increment
     - column: name of column
     - value: amount to increment by
    """
    pass

  def deleteAll(self, tableName, row, column, attributes):
    """
    Delete all cells that match the passed row and column.

    Parameters:
     - tableName: name of table
     - row: Row to update
     - column: name of column whose value is to be deleted
     - attributes: Delete attributes
    """
    pass

  def deleteAllTs(self, tableName, row, column, timestamp, attributes):
    """
    Delete all cells that match the passed row and column and whose
    timestamp is equal-to or older than the passed timestamp.

    Parameters:
     - tableName: name of table
     - row: Row to update
     - column: name of column whose value is to be deleted
     - timestamp: timestamp
     - attributes: Delete attributes
    """
    pass

  def deleteAllRow(self, tableName, row, attributes):
    """
    Completely delete the row's cells.

    Parameters:
     - tableName: name of table
     - row: key of the row to be completely deleted.
     - attributes: Delete attributes
    """
    pass

  def increment(self, increment):
    """
    Increment a cell by the ammount.
    Increments can be applied async if hbase.regionserver.thrift.coalesceIncrement is set to true.
    False is the default.  Turn to true if you need the extra performance and can accept some
    data loss if a thrift server dies with increments still in the queue.

    Parameters:
     - increment: The single increment to apply
    """
    pass

  def incrementRows(self, increments):
    """
    Parameters:
     - increments: The list of increments
    """
    pass

  def deleteAllRowTs(self, tableName, row, timestamp, attributes):
    """
    Completely delete the row's cells marked with a timestamp
    equal-to or older than the passed timestamp.

    Parameters:
     - tableName: name of table
     - row: key of the row to be completely deleted.
     - timestamp: timestamp
     - attributes: Delete attributes
    """
    pass

  def scannerOpenWithScan(self, tableName, scan, attributes):
    """
    Get a scanner on the current table, using the Scan instance
    for the scan parameters.

    Parameters:
     - tableName: name of table
     - scan: Scan instance
     - attributes: Scan attributes
    """
    pass

  def scannerOpen(self, tableName, startRow, columns, attributes):
    """
    Get a scanner on the current table starting at the specified row and
    ending at the last row in the table.  Return the specified columns.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - attributes: Scan attributes
    """
    pass

  def scannerOpenWithStop(self, tableName, startRow, stopRow, columns, attributes):
    """
    Get a scanner on the current table starting and stopping at the
    specified rows.  ending at the last row in the table.  Return the
    specified columns.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - stopRow: row to stop scanning on. This row is *not* included in the
    scanner's results
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - attributes: Scan attributes
    """
    pass

  def scannerOpenWithPrefix(self, tableName, startAndPrefix, columns, attributes):
    """
    Open a scanner for a given prefix.  That is all rows will have the specified
    prefix. No other rows will be returned.

    @return scanner id to use with other scanner calls

    Parameters:
     - tableName: name of table
     - startAndPrefix: the prefix (and thus start row) of the keys you want
     - columns: the columns you want returned
     - attributes: Scan attributes
    """
    pass

  def scannerOpenTs(self, tableName, startRow, columns, timestamp, attributes):
    """
    Get a scanner on the current table starting at the specified row and
    ending at the last row in the table.  Return the specified columns.
    Only values with the specified timestamp are returned.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - timestamp: timestamp
     - attributes: Scan attributes
    """
    pass

  def scannerOpenWithStopTs(self, tableName, startRow, stopRow, columns, timestamp, attributes):
    """
    Get a scanner on the current table starting and stopping at the
    specified rows.  ending at the last row in the table.  Return the
    specified columns.  Only values with the specified timestamp are
    returned.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - stopRow: row to stop scanning on. This row is *not* included in the
    scanner's results
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - timestamp: timestamp
     - attributes: Scan attributes
    """
    pass

  def scannerGet(self, id):
    """
    Returns the scanner's current row value and advances to the next
    row in the table.  When there are no more rows in the table, or a key
    greater-than-or-equal-to the scanner's specified stopRow is reached,
    an empty list is returned.

    @return a TRowResult containing the current row and a map of the columns to TCells.

    @throws IllegalArgument if ScannerID is invalid

    @throws NotFound when the scanner reaches the end

    Parameters:
     - id: id of a scanner returned by scannerOpen
    """
    pass

  def scannerGetList(self, id, nbRows):
    """
    Returns, starting at the scanner's current row value nbRows worth of
    rows and advances to the next row in the table.  When there are no more
    rows in the table, or a key greater-than-or-equal-to the scanner's
    specified stopRow is reached,  an empty list is returned.

    @return a TRowResult containing the current row and a map of the columns to TCells.

    @throws IllegalArgument if ScannerID is invalid

    @throws NotFound when the scanner reaches the end

    Parameters:
     - id: id of a scanner returned by scannerOpen
     - nbRows: number of results to return
    """
    pass

  def scannerClose(self, id):
    """
    Closes the server-state associated with an open scanner.

    @throws IllegalArgument if ScannerID is invalid

    Parameters:
     - id: id of a scanner returned by scannerOpen
    """
    pass

  def getRowOrBefore(self, tableName, row, family):
    """
    Get the row just before the specified one.

    @return value for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - family: column name
    """
    pass

  def getRegionInfo(self, row):
    """
    Get the regininfo for the specified row. It scans
    the metatable to find region's start and end keys.

    @return value for specified row/column

    Parameters:
     - row: row key
    """
    pass

  def append(self, append):
    """
    Appends values to one or more columns within a single row.

    @return values of columns after the append operation.

    Parameters:
     - append: The single append operation to apply
    """
    pass

  def checkAndPut(self, tableName, row, column, value, mput, attributes):
    """
    Atomically checks if a row/family/qualifier value matches the expected
    value. If it does, it adds the corresponding mutation operation for put.

    @return true if the new put was executed, false otherwise

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
     - value: the expected value for the column parameter, if not
    provided the check is for the non-existence of the
    column in question
     - mput: mutation for the put
     - attributes: Mutation attributes
    """
    pass


class Client(Iface):
  def __init__(self, iprot, oprot=None):
    self._iprot = self._oprot = iprot
    if oprot is not None:
      self._oprot = oprot
    self._seqid = 0

  def enableTable(self, tableName):
    """
    Brings a table on-line (enables it)

    Parameters:
     - tableName: name of the table
    """
    self.send_enableTable(tableName)
    self.recv_enableTable()

  def send_enableTable(self, tableName):
    self._oprot.writeMessageBegin('enableTable', TMessageType.CALL, self._seqid)
    args = enableTable_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_enableTable(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = enableTable_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def disableTable(self, tableName):
    """
    Disables a table (takes it off-line) If it is being served, the master
    will tell the servers to stop serving it.

    Parameters:
     - tableName: name of the table
    """
    self.send_disableTable(tableName)
    self.recv_disableTable()

  def send_disableTable(self, tableName):
    self._oprot.writeMessageBegin('disableTable', TMessageType.CALL, self._seqid)
    args = disableTable_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_disableTable(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = disableTable_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def isTableEnabled(self, tableName):
    """
    @return true if table is on-line

    Parameters:
     - tableName: name of the table to check
    """
    self.send_isTableEnabled(tableName)
    return self.recv_isTableEnabled()

  def send_isTableEnabled(self, tableName):
    self._oprot.writeMessageBegin('isTableEnabled', TMessageType.CALL, self._seqid)
    args = isTableEnabled_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_isTableEnabled(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = isTableEnabled_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "isTableEnabled failed: unknown result");

  def compact(self, tableNameOrRegionName):
    """
    Parameters:
     - tableNameOrRegionName
    """
    self.send_compact(tableNameOrRegionName)
    self.recv_compact()

  def send_compact(self, tableNameOrRegionName):
    self._oprot.writeMessageBegin('compact', TMessageType.CALL, self._seqid)
    args = compact_args()
    args.tableNameOrRegionName = tableNameOrRegionName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_compact(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = compact_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def majorCompact(self, tableNameOrRegionName):
    """
    Parameters:
     - tableNameOrRegionName
    """
    self.send_majorCompact(tableNameOrRegionName)
    self.recv_majorCompact()

  def send_majorCompact(self, tableNameOrRegionName):
    self._oprot.writeMessageBegin('majorCompact', TMessageType.CALL, self._seqid)
    args = majorCompact_args()
    args.tableNameOrRegionName = tableNameOrRegionName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_majorCompact(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = majorCompact_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def getTableNames(self, ):
    """
    List all the userspace tables.

    @return returns a list of names
    """
    self.send_getTableNames()
    return self.recv_getTableNames()

  def send_getTableNames(self, ):
    self._oprot.writeMessageBegin('getTableNames', TMessageType.CALL, self._seqid)
    args = getTableNames_args()
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTableNames(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTableNames_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTableNames failed: unknown result");

  def getColumnDescriptors(self, tableName):
    """
    List all the column families assoicated with a table.

    @return list of column family descriptors

    Parameters:
     - tableName: table name
    """
    self.send_getColumnDescriptors(tableName)
    return self.recv_getColumnDescriptors()

  def send_getColumnDescriptors(self, tableName):
    self._oprot.writeMessageBegin('getColumnDescriptors', TMessageType.CALL, self._seqid)
    args = getColumnDescriptors_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getColumnDescriptors(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getColumnDescriptors_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getColumnDescriptors failed: unknown result");

  def getTableRegions(self, tableName):
    """
    List the regions associated with a table.

    @return list of region descriptors

    Parameters:
     - tableName: table name
    """
    self.send_getTableRegions(tableName)
    return self.recv_getTableRegions()

  def send_getTableRegions(self, tableName):
    self._oprot.writeMessageBegin('getTableRegions', TMessageType.CALL, self._seqid)
    args = getTableRegions_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTableRegions(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTableRegions_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTableRegions failed: unknown result");

  def createTable(self, tableName, columnFamilies):
    """
    Create a table with the specified column families.  The name
    field for each ColumnDescriptor must be set and must end in a
    colon (:). All other fields are optional and will get default
    values if not explicitly specified.

    @throws IllegalArgument if an input parameter is invalid

    @throws AlreadyExists if the table name already exists

    Parameters:
     - tableName: name of table to create
     - columnFamilies: list of column family descriptors
    """
    self.send_createTable(tableName, columnFamilies)
    self.recv_createTable()

  def send_createTable(self, tableName, columnFamilies):
    self._oprot.writeMessageBegin('createTable', TMessageType.CALL, self._seqid)
    args = createTable_args()
    args.tableName = tableName
    args.columnFamilies = columnFamilies
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_createTable(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = createTable_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    if result.exist is not None:
      raise result.exist
    return

  def deleteTable(self, tableName):
    """
    Deletes a table

    @throws IOError if table doesn't exist on server or there was some other
    problem

    Parameters:
     - tableName: name of table to delete
    """
    self.send_deleteTable(tableName)
    self.recv_deleteTable()

  def send_deleteTable(self, tableName):
    self._oprot.writeMessageBegin('deleteTable', TMessageType.CALL, self._seqid)
    args = deleteTable_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteTable(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = deleteTable_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def get(self, tableName, row, column, attributes):
    """
    Get a single TCell for the specified table, row, and column at the
    latest timestamp. Returns an empty list if no such value exists.

    @return value for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
     - attributes: Get attributes
    """
    self.send_get(tableName, row, column, attributes)
    return self.recv_get()

  def send_get(self, tableName, row, column, attributes):
    self._oprot.writeMessageBegin('get', TMessageType.CALL, self._seqid)
    args = get_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_get(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = get_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "get failed: unknown result");

  def getVer(self, tableName, row, column, numVersions, attributes):
    """
    Get the specified number of versions for the specified table,
    row, and column.

    @return list of cells for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
     - numVersions: number of versions to retrieve
     - attributes: Get attributes
    """
    self.send_getVer(tableName, row, column, numVersions, attributes)
    return self.recv_getVer()

  def send_getVer(self, tableName, row, column, numVersions, attributes):
    self._oprot.writeMessageBegin('getVer', TMessageType.CALL, self._seqid)
    args = getVer_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.numVersions = numVersions
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getVer(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getVer_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getVer failed: unknown result");

  def getVerTs(self, tableName, row, column, timestamp, numVersions, attributes):
    """
    Get the specified number of versions for the specified table,
    row, and column.  Only versions less than or equal to the specified
    timestamp will be returned.

    @return list of cells for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
     - timestamp: timestamp
     - numVersions: number of versions to retrieve
     - attributes: Get attributes
    """
    self.send_getVerTs(tableName, row, column, timestamp, numVersions, attributes)
    return self.recv_getVerTs()

  def send_getVerTs(self, tableName, row, column, timestamp, numVersions, attributes):
    self._oprot.writeMessageBegin('getVerTs', TMessageType.CALL, self._seqid)
    args = getVerTs_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.timestamp = timestamp
    args.numVersions = numVersions
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getVerTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getVerTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getVerTs failed: unknown result");

  def getRow(self, tableName, row, attributes):
    """
    Get all the data for the specified table and row at the latest
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of table
     - row: row key
     - attributes: Get attributes
    """
    self.send_getRow(tableName, row, attributes)
    return self.recv_getRow()

  def send_getRow(self, tableName, row, attributes):
    self._oprot.writeMessageBegin('getRow', TMessageType.CALL, self._seqid)
    args = getRow_args()
    args.tableName = tableName
    args.row = row
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRow(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRow_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRow failed: unknown result");

  def getRowWithColumns(self, tableName, row, columns, attributes):
    """
    Get the specified columns for the specified table and row at the latest
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of table
     - row: row key
     - columns: List of columns to return, null for all columns
     - attributes: Get attributes
    """
    self.send_getRowWithColumns(tableName, row, columns, attributes)
    return self.recv_getRowWithColumns()

  def send_getRowWithColumns(self, tableName, row, columns, attributes):
    self._oprot.writeMessageBegin('getRowWithColumns', TMessageType.CALL, self._seqid)
    args = getRowWithColumns_args()
    args.tableName = tableName
    args.row = row
    args.columns = columns
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowWithColumns(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowWithColumns_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowWithColumns failed: unknown result");

  def getRowTs(self, tableName, row, timestamp, attributes):
    """
    Get all the data for the specified table and row at the specified
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of the table
     - row: row key
     - timestamp: timestamp
     - attributes: Get attributes
    """
    self.send_getRowTs(tableName, row, timestamp, attributes)
    return self.recv_getRowTs()

  def send_getRowTs(self, tableName, row, timestamp, attributes):
    self._oprot.writeMessageBegin('getRowTs', TMessageType.CALL, self._seqid)
    args = getRowTs_args()
    args.tableName = tableName
    args.row = row
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowTs failed: unknown result");

  def getRowWithColumnsTs(self, tableName, row, columns, timestamp, attributes):
    """
    Get the specified columns for the specified table and row at the specified
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of table
     - row: row key
     - columns: List of columns to return, null for all columns
     - timestamp
     - attributes: Get attributes
    """
    self.send_getRowWithColumnsTs(tableName, row, columns, timestamp, attributes)
    return self.recv_getRowWithColumnsTs()

  def send_getRowWithColumnsTs(self, tableName, row, columns, timestamp, attributes):
    self._oprot.writeMessageBegin('getRowWithColumnsTs', TMessageType.CALL, self._seqid)
    args = getRowWithColumnsTs_args()
    args.tableName = tableName
    args.row = row
    args.columns = columns
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowWithColumnsTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowWithColumnsTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowWithColumnsTs failed: unknown result");

  def getRows(self, tableName, rows, attributes):
    """
    Get all the data for the specified table and rows at the latest
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of table
     - rows: row keys
     - attributes: Get attributes
    """
    self.send_getRows(tableName, rows, attributes)
    return self.recv_getRows()

  def send_getRows(self, tableName, rows, attributes):
    self._oprot.writeMessageBegin('getRows', TMessageType.CALL, self._seqid)
    args = getRows_args()
    args.tableName = tableName
    args.rows = rows
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRows(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRows_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRows failed: unknown result");

  def getRowsWithColumns(self, tableName, rows, columns, attributes):
    """
    Get the specified columns for the specified table and rows at the latest
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of table
     - rows: row keys
     - columns: List of columns to return, null for all columns
     - attributes: Get attributes
    """
    self.send_getRowsWithColumns(tableName, rows, columns, attributes)
    return self.recv_getRowsWithColumns()

  def send_getRowsWithColumns(self, tableName, rows, columns, attributes):
    self._oprot.writeMessageBegin('getRowsWithColumns', TMessageType.CALL, self._seqid)
    args = getRowsWithColumns_args()
    args.tableName = tableName
    args.rows = rows
    args.columns = columns
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowsWithColumns(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowsWithColumns_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowsWithColumns failed: unknown result");

  def getRowsTs(self, tableName, rows, timestamp, attributes):
    """
    Get all the data for the specified table and rows at the specified
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of the table
     - rows: row keys
     - timestamp: timestamp
     - attributes: Get attributes
    """
    self.send_getRowsTs(tableName, rows, timestamp, attributes)
    return self.recv_getRowsTs()

  def send_getRowsTs(self, tableName, rows, timestamp, attributes):
    self._oprot.writeMessageBegin('getRowsTs', TMessageType.CALL, self._seqid)
    args = getRowsTs_args()
    args.tableName = tableName
    args.rows = rows
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowsTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowsTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowsTs failed: unknown result");

  def getRowsWithColumnsTs(self, tableName, rows, columns, timestamp, attributes):
    """
    Get the specified columns for the specified table and rows at the specified
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of table
     - rows: row keys
     - columns: List of columns to return, null for all columns
     - timestamp
     - attributes: Get attributes
    """
    self.send_getRowsWithColumnsTs(tableName, rows, columns, timestamp, attributes)
    return self.recv_getRowsWithColumnsTs()

  def send_getRowsWithColumnsTs(self, tableName, rows, columns, timestamp, attributes):
    self._oprot.writeMessageBegin('getRowsWithColumnsTs', TMessageType.CALL, self._seqid)
    args = getRowsWithColumnsTs_args()
    args.tableName = tableName
    args.rows = rows
    args.columns = columns
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowsWithColumnsTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowsWithColumnsTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowsWithColumnsTs failed: unknown result");

  def mutateRow(self, tableName, row, mutations, attributes):
    """
    Apply a series of mutations (updates/deletes) to a row in a
    single transaction.  If an exception is thrown, then the
    transaction is aborted.  Default current timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - row: row key
     - mutations: list of mutation commands
     - attributes: Mutation attributes
    """
    self.send_mutateRow(tableName, row, mutations, attributes)
    self.recv_mutateRow()

  def send_mutateRow(self, tableName, row, mutations, attributes):
    self._oprot.writeMessageBegin('mutateRow', TMessageType.CALL, self._seqid)
    args = mutateRow_args()
    args.tableName = tableName
    args.row = row
    args.mutations = mutations
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_mutateRow(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = mutateRow_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    return

  def mutateRowTs(self, tableName, row, mutations, timestamp, attributes):
    """
    Apply a series of mutations (updates/deletes) to a row in a
    single transaction.  If an exception is thrown, then the
    transaction is aborted.  The specified timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - row: row key
     - mutations: list of mutation commands
     - timestamp: timestamp
     - attributes: Mutation attributes
    """
    self.send_mutateRowTs(tableName, row, mutations, timestamp, attributes)
    self.recv_mutateRowTs()

  def send_mutateRowTs(self, tableName, row, mutations, timestamp, attributes):
    self._oprot.writeMessageBegin('mutateRowTs', TMessageType.CALL, self._seqid)
    args = mutateRowTs_args()
    args.tableName = tableName
    args.row = row
    args.mutations = mutations
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_mutateRowTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = mutateRowTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    return

  def mutateRows(self, tableName, rowBatches, attributes):
    """
    Apply a series of batches (each a series of mutations on a single row)
    in a single transaction.  If an exception is thrown, then the
    transaction is aborted.  Default current timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - rowBatches: list of row batches
     - attributes: Mutation attributes
    """
    self.send_mutateRows(tableName, rowBatches, attributes)
    self.recv_mutateRows()

  def send_mutateRows(self, tableName, rowBatches, attributes):
    self._oprot.writeMessageBegin('mutateRows', TMessageType.CALL, self._seqid)
    args = mutateRows_args()
    args.tableName = tableName
    args.rowBatches = rowBatches
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_mutateRows(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = mutateRows_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    return

  def mutateRowsTs(self, tableName, rowBatches, timestamp, attributes):
    """
    Apply a series of batches (each a series of mutations on a single row)
    in a single transaction.  If an exception is thrown, then the
    transaction is aborted.  The specified timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - rowBatches: list of row batches
     - timestamp: timestamp
     - attributes: Mutation attributes
    """
    self.send_mutateRowsTs(tableName, rowBatches, timestamp, attributes)
    self.recv_mutateRowsTs()

  def send_mutateRowsTs(self, tableName, rowBatches, timestamp, attributes):
    self._oprot.writeMessageBegin('mutateRowsTs', TMessageType.CALL, self._seqid)
    args = mutateRowsTs_args()
    args.tableName = tableName
    args.rowBatches = rowBatches
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_mutateRowsTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = mutateRowsTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    return

  def atomicIncrement(self, tableName, row, column, value):
    """
    Atomically increment the column value specified.  Returns the next value post increment.

    Parameters:
     - tableName: name of table
     - row: row to increment
     - column: name of column
     - value: amount to increment by
    """
    self.send_atomicIncrement(tableName, row, column, value)
    return self.recv_atomicIncrement()

  def send_atomicIncrement(self, tableName, row, column, value):
    self._oprot.writeMessageBegin('atomicIncrement', TMessageType.CALL, self._seqid)
    args = atomicIncrement_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.value = value
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_atomicIncrement(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = atomicIncrement_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    raise TApplicationException(TApplicationException.MISSING_RESULT, "atomicIncrement failed: unknown result");

  def deleteAll(self, tableName, row, column, attributes):
    """
    Delete all cells that match the passed row and column.

    Parameters:
     - tableName: name of table
     - row: Row to update
     - column: name of column whose value is to be deleted
     - attributes: Delete attributes
    """
    self.send_deleteAll(tableName, row, column, attributes)
    self.recv_deleteAll()

  def send_deleteAll(self, tableName, row, column, attributes):
    self._oprot.writeMessageBegin('deleteAll', TMessageType.CALL, self._seqid)
    args = deleteAll_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteAll(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = deleteAll_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def deleteAllTs(self, tableName, row, column, timestamp, attributes):
    """
    Delete all cells that match the passed row and column and whose
    timestamp is equal-to or older than the passed timestamp.

    Parameters:
     - tableName: name of table
     - row: Row to update
     - column: name of column whose value is to be deleted
     - timestamp: timestamp
     - attributes: Delete attributes
    """
    self.send_deleteAllTs(tableName, row, column, timestamp, attributes)
    self.recv_deleteAllTs()

  def send_deleteAllTs(self, tableName, row, column, timestamp, attributes):
    self._oprot.writeMessageBegin('deleteAllTs', TMessageType.CALL, self._seqid)
    args = deleteAllTs_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteAllTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = deleteAllTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def deleteAllRow(self, tableName, row, attributes):
    """
    Completely delete the row's cells.

    Parameters:
     - tableName: name of table
     - row: key of the row to be completely deleted.
     - attributes: Delete attributes
    """
    self.send_deleteAllRow(tableName, row, attributes)
    self.recv_deleteAllRow()

  def send_deleteAllRow(self, tableName, row, attributes):
    self._oprot.writeMessageBegin('deleteAllRow', TMessageType.CALL, self._seqid)
    args = deleteAllRow_args()
    args.tableName = tableName
    args.row = row
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteAllRow(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = deleteAllRow_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def increment(self, increment):
    """
    Increment a cell by the ammount.
    Increments can be applied async if hbase.regionserver.thrift.coalesceIncrement is set to true.
    False is the default.  Turn to true if you need the extra performance and can accept some
    data loss if a thrift server dies with increments still in the queue.

    Parameters:
     - increment: The single increment to apply
    """
    self.send_increment(increment)
    self.recv_increment()

  def send_increment(self, increment):
    self._oprot.writeMessageBegin('increment', TMessageType.CALL, self._seqid)
    args = increment_args()
    args.increment = increment
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_increment(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = increment_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def incrementRows(self, increments):
    """
    Parameters:
     - increments: The list of increments
    """
    self.send_incrementRows(increments)
    self.recv_incrementRows()

  def send_incrementRows(self, increments):
    self._oprot.writeMessageBegin('incrementRows', TMessageType.CALL, self._seqid)
    args = incrementRows_args()
    args.increments = increments
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_incrementRows(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = incrementRows_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def deleteAllRowTs(self, tableName, row, timestamp, attributes):
    """
    Completely delete the row's cells marked with a timestamp
    equal-to or older than the passed timestamp.

    Parameters:
     - tableName: name of table
     - row: key of the row to be completely deleted.
     - timestamp: timestamp
     - attributes: Delete attributes
    """
    self.send_deleteAllRowTs(tableName, row, timestamp, attributes)
    self.recv_deleteAllRowTs()

  def send_deleteAllRowTs(self, tableName, row, timestamp, attributes):
    self._oprot.writeMessageBegin('deleteAllRowTs', TMessageType.CALL, self._seqid)
    args = deleteAllRowTs_args()
    args.tableName = tableName
    args.row = row
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteAllRowTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = deleteAllRowTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def scannerOpenWithScan(self, tableName, scan, attributes):
    """
    Get a scanner on the current table, using the Scan instance
    for the scan parameters.

    Parameters:
     - tableName: name of table
     - scan: Scan instance
     - attributes: Scan attributes
    """
    self.send_scannerOpenWithScan(tableName, scan, attributes)
    return self.recv_scannerOpenWithScan()

  def send_scannerOpenWithScan(self, tableName, scan, attributes):
    self._oprot.writeMessageBegin('scannerOpenWithScan', TMessageType.CALL, self._seqid)
    args = scannerOpenWithScan_args()
    args.tableName = tableName
    args.scan = scan
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerOpenWithScan(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerOpenWithScan_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenWithScan failed: unknown result");

  def scannerOpen(self, tableName, startRow, columns, attributes):
    """
    Get a scanner on the current table starting at the specified row and
    ending at the last row in the table.  Return the specified columns.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - attributes: Scan attributes
    """
    self.send_scannerOpen(tableName, startRow, columns, attributes)
    return self.recv_scannerOpen()

  def send_scannerOpen(self, tableName, startRow, columns, attributes):
    self._oprot.writeMessageBegin('scannerOpen', TMessageType.CALL, self._seqid)
    args = scannerOpen_args()
    args.tableName = tableName
    args.startRow = startRow
    args.columns = columns
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerOpen(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerOpen_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpen failed: unknown result");

  def scannerOpenWithStop(self, tableName, startRow, stopRow, columns, attributes):
    """
    Get a scanner on the current table starting and stopping at the
    specified rows.  ending at the last row in the table.  Return the
    specified columns.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - stopRow: row to stop scanning on. This row is *not* included in the
    scanner's results
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - attributes: Scan attributes
    """
    self.send_scannerOpenWithStop(tableName, startRow, stopRow, columns, attributes)
    return self.recv_scannerOpenWithStop()

  def send_scannerOpenWithStop(self, tableName, startRow, stopRow, columns, attributes):
    self._oprot.writeMessageBegin('scannerOpenWithStop', TMessageType.CALL, self._seqid)
    args = scannerOpenWithStop_args()
    args.tableName = tableName
    args.startRow = startRow
    args.stopRow = stopRow
    args.columns = columns
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerOpenWithStop(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerOpenWithStop_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenWithStop failed: unknown result");

  def scannerOpenWithPrefix(self, tableName, startAndPrefix, columns, attributes):
    """
    Open a scanner for a given prefix.  That is all rows will have the specified
    prefix. No other rows will be returned.

    @return scanner id to use with other scanner calls

    Parameters:
     - tableName: name of table
     - startAndPrefix: the prefix (and thus start row) of the keys you want
     - columns: the columns you want returned
     - attributes: Scan attributes
    """
    self.send_scannerOpenWithPrefix(tableName, startAndPrefix, columns, attributes)
    return self.recv_scannerOpenWithPrefix()

  def send_scannerOpenWithPrefix(self, tableName, startAndPrefix, columns, attributes):
    self._oprot.writeMessageBegin('scannerOpenWithPrefix', TMessageType.CALL, self._seqid)
    args = scannerOpenWithPrefix_args()
    args.tableName = tableName
    args.startAndPrefix = startAndPrefix
    args.columns = columns
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerOpenWithPrefix(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerOpenWithPrefix_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenWithPrefix failed: unknown result");

  def scannerOpenTs(self, tableName, startRow, columns, timestamp, attributes):
    """
    Get a scanner on the current table starting at the specified row and
    ending at the last row in the table.  Return the specified columns.
    Only values with the specified timestamp are returned.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - timestamp: timestamp
     - attributes: Scan attributes
    """
    self.send_scannerOpenTs(tableName, startRow, columns, timestamp, attributes)
    return self.recv_scannerOpenTs()

  def send_scannerOpenTs(self, tableName, startRow, columns, timestamp, attributes):
    self._oprot.writeMessageBegin('scannerOpenTs', TMessageType.CALL, self._seqid)
    args = scannerOpenTs_args()
    args.tableName = tableName
    args.startRow = startRow
    args.columns = columns
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerOpenTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerOpenTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenTs failed: unknown result");

  def scannerOpenWithStopTs(self, tableName, startRow, stopRow, columns, timestamp, attributes):
    """
    Get a scanner on the current table starting and stopping at the
    specified rows.  ending at the last row in the table.  Return the
    specified columns.  Only values with the specified timestamp are
    returned.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - stopRow: row to stop scanning on. This row is *not* included in the
    scanner's results
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - timestamp: timestamp
     - attributes: Scan attributes
    """
    self.send_scannerOpenWithStopTs(tableName, startRow, stopRow, columns, timestamp, attributes)
    return self.recv_scannerOpenWithStopTs()

  def send_scannerOpenWithStopTs(self, tableName, startRow, stopRow, columns, timestamp, attributes):
    self._oprot.writeMessageBegin('scannerOpenWithStopTs', TMessageType.CALL, self._seqid)
    args = scannerOpenWithStopTs_args()
    args.tableName = tableName
    args.startRow = startRow
    args.stopRow = stopRow
    args.columns = columns
    args.timestamp = timestamp
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerOpenWithStopTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerOpenWithStopTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenWithStopTs failed: unknown result");

  def scannerGet(self, id):
    """
    Returns the scanner's current row value and advances to the next
    row in the table.  When there are no more rows in the table, or a key
    greater-than-or-equal-to the scanner's specified stopRow is reached,
    an empty list is returned.

    @return a TRowResult containing the current row and a map of the columns to TCells.

    @throws IllegalArgument if ScannerID is invalid

    @throws NotFound when the scanner reaches the end

    Parameters:
     - id: id of a scanner returned by scannerOpen
    """
    self.send_scannerGet(id)
    return self.recv_scannerGet()

  def send_scannerGet(self, id):
    self._oprot.writeMessageBegin('scannerGet', TMessageType.CALL, self._seqid)
    args = scannerGet_args()
    args.id = id
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerGet(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerGet_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerGet failed: unknown result");

  def scannerGetList(self, id, nbRows):
    """
    Returns, starting at the scanner's current row value nbRows worth of
    rows and advances to the next row in the table.  When there are no more
    rows in the table, or a key greater-than-or-equal-to the scanner's
    specified stopRow is reached,  an empty list is returned.

    @return a TRowResult containing the current row and a map of the columns to TCells.

    @throws IllegalArgument if ScannerID is invalid

    @throws NotFound when the scanner reaches the end

    Parameters:
     - id: id of a scanner returned by scannerOpen
     - nbRows: number of results to return
    """
    self.send_scannerGetList(id, nbRows)
    return self.recv_scannerGetList()

  def send_scannerGetList(self, id, nbRows):
    self._oprot.writeMessageBegin('scannerGetList', TMessageType.CALL, self._seqid)
    args = scannerGetList_args()
    args.id = id
    args.nbRows = nbRows
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerGetList(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerGetList_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerGetList failed: unknown result");

  def scannerClose(self, id):
    """
    Closes the server-state associated with an open scanner.

    @throws IllegalArgument if ScannerID is invalid

    Parameters:
     - id: id of a scanner returned by scannerOpen
    """
    self.send_scannerClose(id)
    self.recv_scannerClose()

  def send_scannerClose(self, id):
    self._oprot.writeMessageBegin('scannerClose', TMessageType.CALL, self._seqid)
    args = scannerClose_args()
    args.id = id
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerClose(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerClose_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    return

  def getRowOrBefore(self, tableName, row, family):
    """
    Get the row just before the specified one.

    @return value for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - family: column name
    """
    self.send_getRowOrBefore(tableName, row, family)
    return self.recv_getRowOrBefore()

  def send_getRowOrBefore(self, tableName, row, family):
    self._oprot.writeMessageBegin('getRowOrBefore', TMessageType.CALL, self._seqid)
    args = getRowOrBefore_args()
    args.tableName = tableName
    args.row = row
    args.family = family
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowOrBefore(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowOrBefore_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowOrBefore failed: unknown result");

  def getRegionInfo(self, row):
    """
    Get the regininfo for the specified row. It scans
    the metatable to find region's start and end keys.

    @return value for specified row/column

    Parameters:
     - row: row key
    """
    self.send_getRegionInfo(row)
    return self.recv_getRegionInfo()

  def send_getRegionInfo(self, row):
    self._oprot.writeMessageBegin('getRegionInfo', TMessageType.CALL, self._seqid)
    args = getRegionInfo_args()
    args.row = row
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRegionInfo(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRegionInfo_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRegionInfo failed: unknown result");

  def append(self, append):
    """
    Appends values to one or more columns within a single row.

    @return values of columns after the append operation.

    Parameters:
     - append: The single append operation to apply
    """
    self.send_append(append)
    return self.recv_append()

  def send_append(self, append):
    self._oprot.writeMessageBegin('append', TMessageType.CALL, self._seqid)
    args = append_args()
    args.append = append
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_append(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = append_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "append failed: unknown result");

  def checkAndPut(self, tableName, row, column, value, mput, attributes):
    """
    Atomically checks if a row/family/qualifier value matches the expected
    value. If it does, it adds the corresponding mutation operation for put.

    @return true if the new put was executed, false otherwise

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
     - value: the expected value for the column parameter, if not
    provided the check is for the non-existence of the
    column in question
     - mput: mutation for the put
     - attributes: Mutation attributes
    """
    self.send_checkAndPut(tableName, row, column, value, mput, attributes)
    return self.recv_checkAndPut()

  def send_checkAndPut(self, tableName, row, column, value, mput, attributes):
    self._oprot.writeMessageBegin('checkAndPut', TMessageType.CALL, self._seqid)
    args = checkAndPut_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.value = value
    args.mput = mput
    args.attributes = attributes
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_checkAndPut(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = checkAndPut_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    raise TApplicationException(TApplicationException.MISSING_RESULT, "checkAndPut failed: unknown result");


class Processor(Iface, TProcessor):
  def __init__(self, handler):
    self._handler = handler
    self._processMap = {}
    self._processMap["enableTable"] = Processor.process_enableTable
    self._processMap["disableTable"] = Processor.process_disableTable
    self._processMap["isTableEnabled"] = Processor.process_isTableEnabled
    self._processMap["compact"] = Processor.process_compact
    self._processMap["majorCompact"] = Processor.process_majorCompact
    self._processMap["getTableNames"] = Processor.process_getTableNames
    self._processMap["getColumnDescriptors"] = Processor.process_getColumnDescriptors
    self._processMap["getTableRegions"] = Processor.process_getTableRegions
    self._processMap["createTable"] = Processor.process_createTable
    self._processMap["deleteTable"] = Processor.process_deleteTable
    self._processMap["get"] = Processor.process_get
    self._processMap["getVer"] = Processor.process_getVer
    self._processMap["getVerTs"] = Processor.process_getVerTs
    self._processMap["getRow"] = Processor.process_getRow
    self._processMap["getRowWithColumns"] = Processor.process_getRowWithColumns
    self._processMap["getRowTs"] = Processor.process_getRowTs
    self._processMap["getRowWithColumnsTs"] = Processor.process_getRowWithColumnsTs
    self._processMap["getRows"] = Processor.process_getRows
    self._processMap["getRowsWithColumns"] = Processor.process_getRowsWithColumns
    self._processMap["getRowsTs"] = Processor.process_getRowsTs
    self._processMap["getRowsWithColumnsTs"] = Processor.process_getRowsWithColumnsTs
    self._processMap["mutateRow"] = Processor.process_mutateRow
    self._processMap["mutateRowTs"] = Processor.process_mutateRowTs
    self._processMap["mutateRows"] = Processor.process_mutateRows
    self._processMap["mutateRowsTs"] = Processor.process_mutateRowsTs
    self._processMap["atomicIncrement"] = Processor.process_atomicIncrement
    self._processMap["deleteAll"] = Processor.process_deleteAll
    self._processMap["deleteAllTs"] = Processor.process_deleteAllTs
    self._processMap["deleteAllRow"] = Processor.process_deleteAllRow
    self._processMap["increment"] = Processor.process_increment
    self._processMap["incrementRows"] = Processor.process_incrementRows
    self._processMap["deleteAllRowTs"] = Processor.process_deleteAllRowTs
    self._processMap["scannerOpenWithScan"] = Processor.process_scannerOpenWithScan
    self._processMap["scannerOpen"] = Processor.process_scannerOpen
    self._processMap["scannerOpenWithStop"] = Processor.process_scannerOpenWithStop
    self._processMap["scannerOpenWithPrefix"] = Processor.process_scannerOpenWithPrefix
    self._processMap["scannerOpenTs"] = Processor.process_scannerOpenTs
    self._processMap["scannerOpenWithStopTs"] = Processor.process_scannerOpenWithStopTs
    self._processMap["scannerGet"] = Processor.process_scannerGet
    self._processMap["scannerGetList"] = Processor.process_scannerGetList
    self._processMap["scannerClose"] = Processor.process_scannerClose
    self._processMap["getRowOrBefore"] = Processor.process_getRowOrBefore
    self._processMap["getRegionInfo"] = Processor.process_getRegionInfo
    self._processMap["append"] = Processor.process_append
    self._processMap["checkAndPut"] = Processor.process_checkAndPut

  def process(self, iprot, oprot):
    (name, type, seqid) = iprot.readMessageBegin()
    if name not in self._processMap:
      iprot.skip(TType.STRUCT)
      iprot.readMessageEnd()
      x = TApplicationException(TApplicationException.UNKNOWN_METHOD, 'Unknown function %s' % (name))
      oprot.writeMessageBegin(name, TMessageType.EXCEPTION, seqid)
      x.write(oprot)
      oprot.writeMessageEnd()
      oprot.trans.flush()
      return
    else:
      self._processMap[name](self, seqid, iprot, oprot)
    return True

  def process_enableTable(self, seqid, iprot, oprot):
    args = enableTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = enableTable_result()
    try:
      self._handler.enableTable(args.tableName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("enableTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_disableTable(self, seqid, iprot, oprot):
    args = disableTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = disableTable_result()
    try:
      self._handler.disableTable(args.tableName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("disableTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_isTableEnabled(self, seqid, iprot, oprot):
    args = isTableEnabled_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = isTableEnabled_result()
    try:
      result.success = self._handler.isTableEnabled(args.tableName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("isTableEnabled", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_compact(self, seqid, iprot, oprot):
    args = compact_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = compact_result()
    try:
      self._handler.compact(args.tableNameOrRegionName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("compact", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_majorCompact(self, seqid, iprot, oprot):
    args = majorCompact_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = majorCompact_result()
    try:
      self._handler.majorCompact(args.tableNameOrRegionName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("majorCompact", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTableNames(self, seqid, iprot, oprot):
    args = getTableNames_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTableNames_result()
    try:
      result.success = self._handler.getTableNames()
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getTableNames", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getColumnDescriptors(self, seqid, iprot, oprot):
    args = getColumnDescriptors_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getColumnDescriptors_result()
    try:
      result.success = self._handler.getColumnDescriptors(args.tableName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getColumnDescriptors", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTableRegions(self, seqid, iprot, oprot):
    args = getTableRegions_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTableRegions_result()
    try:
      result.success = self._handler.getTableRegions(args.tableName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getTableRegions", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_createTable(self, seqid, iprot, oprot):
    args = createTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = createTable_result()
    try:
      self._handler.createTable(args.tableName, args.columnFamilies)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    except AlreadyExists as exist:
      result.exist = exist
    oprot.writeMessageBegin("createTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteTable(self, seqid, iprot, oprot):
    args = deleteTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteTable_result()
    try:
      self._handler.deleteTable(args.tableName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("deleteTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_get(self, seqid, iprot, oprot):
    args = get_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = get_result()
    try:
      result.success = self._handler.get(args.tableName, args.row, args.column, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("get", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getVer(self, seqid, iprot, oprot):
    args = getVer_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getVer_result()
    try:
      result.success = self._handler.getVer(args.tableName, args.row, args.column, args.numVersions, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getVer", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getVerTs(self, seqid, iprot, oprot):
    args = getVerTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getVerTs_result()
    try:
      result.success = self._handler.getVerTs(args.tableName, args.row, args.column, args.timestamp, args.numVersions, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getVerTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRow(self, seqid, iprot, oprot):
    args = getRow_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRow_result()
    try:
      result.success = self._handler.getRow(args.tableName, args.row, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRow", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowWithColumns(self, seqid, iprot, oprot):
    args = getRowWithColumns_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowWithColumns_result()
    try:
      result.success = self._handler.getRowWithColumns(args.tableName, args.row, args.columns, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowWithColumns", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowTs(self, seqid, iprot, oprot):
    args = getRowTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowTs_result()
    try:
      result.success = self._handler.getRowTs(args.tableName, args.row, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowWithColumnsTs(self, seqid, iprot, oprot):
    args = getRowWithColumnsTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowWithColumnsTs_result()
    try:
      result.success = self._handler.getRowWithColumnsTs(args.tableName, args.row, args.columns, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowWithColumnsTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRows(self, seqid, iprot, oprot):
    args = getRows_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRows_result()
    try:
      result.success = self._handler.getRows(args.tableName, args.rows, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRows", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowsWithColumns(self, seqid, iprot, oprot):
    args = getRowsWithColumns_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowsWithColumns_result()
    try:
      result.success = self._handler.getRowsWithColumns(args.tableName, args.rows, args.columns, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowsWithColumns", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowsTs(self, seqid, iprot, oprot):
    args = getRowsTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowsTs_result()
    try:
      result.success = self._handler.getRowsTs(args.tableName, args.rows, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowsTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowsWithColumnsTs(self, seqid, iprot, oprot):
    args = getRowsWithColumnsTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowsWithColumnsTs_result()
    try:
      result.success = self._handler.getRowsWithColumnsTs(args.tableName, args.rows, args.columns, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowsWithColumnsTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_mutateRow(self, seqid, iprot, oprot):
    args = mutateRow_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = mutateRow_result()
    try:
      self._handler.mutateRow(args.tableName, args.row, args.mutations, args.attributes)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("mutateRow", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_mutateRowTs(self, seqid, iprot, oprot):
    args = mutateRowTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = mutateRowTs_result()
    try:
      self._handler.mutateRowTs(args.tableName, args.row, args.mutations, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("mutateRowTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_mutateRows(self, seqid, iprot, oprot):
    args = mutateRows_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = mutateRows_result()
    try:
      self._handler.mutateRows(args.tableName, args.rowBatches, args.attributes)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("mutateRows", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_mutateRowsTs(self, seqid, iprot, oprot):
    args = mutateRowsTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = mutateRowsTs_result()
    try:
      self._handler.mutateRowsTs(args.tableName, args.rowBatches, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("mutateRowsTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_atomicIncrement(self, seqid, iprot, oprot):
    args = atomicIncrement_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = atomicIncrement_result()
    try:
      result.success = self._handler.atomicIncrement(args.tableName, args.row, args.column, args.value)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("atomicIncrement", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteAll(self, seqid, iprot, oprot):
    args = deleteAll_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteAll_result()
    try:
      self._handler.deleteAll(args.tableName, args.row, args.column, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("deleteAll", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteAllTs(self, seqid, iprot, oprot):
    args = deleteAllTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteAllTs_result()
    try:
      self._handler.deleteAllTs(args.tableName, args.row, args.column, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("deleteAllTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteAllRow(self, seqid, iprot, oprot):
    args = deleteAllRow_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteAllRow_result()
    try:
      self._handler.deleteAllRow(args.tableName, args.row, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("deleteAllRow", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_increment(self, seqid, iprot, oprot):
    args = increment_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = increment_result()
    try:
      self._handler.increment(args.increment)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("increment", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_incrementRows(self, seqid, iprot, oprot):
    args = incrementRows_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = incrementRows_result()
    try:
      self._handler.incrementRows(args.increments)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("incrementRows", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteAllRowTs(self, seqid, iprot, oprot):
    args = deleteAllRowTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteAllRowTs_result()
    try:
      self._handler.deleteAllRowTs(args.tableName, args.row, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("deleteAllRowTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerOpenWithScan(self, seqid, iprot, oprot):
    args = scannerOpenWithScan_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerOpenWithScan_result()
    try:
      result.success = self._handler.scannerOpenWithScan(args.tableName, args.scan, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("scannerOpenWithScan", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerOpen(self, seqid, iprot, oprot):
    args = scannerOpen_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerOpen_result()
    try:
      result.success = self._handler.scannerOpen(args.tableName, args.startRow, args.columns, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("scannerOpen", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerOpenWithStop(self, seqid, iprot, oprot):
    args = scannerOpenWithStop_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerOpenWithStop_result()
    try:
      result.success = self._handler.scannerOpenWithStop(args.tableName, args.startRow, args.stopRow, args.columns, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("scannerOpenWithStop", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerOpenWithPrefix(self, seqid, iprot, oprot):
    args = scannerOpenWithPrefix_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerOpenWithPrefix_result()
    try:
      result.success = self._handler.scannerOpenWithPrefix(args.tableName, args.startAndPrefix, args.columns, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("scannerOpenWithPrefix", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerOpenTs(self, seqid, iprot, oprot):
    args = scannerOpenTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerOpenTs_result()
    try:
      result.success = self._handler.scannerOpenTs(args.tableName, args.startRow, args.columns, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("scannerOpenTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerOpenWithStopTs(self, seqid, iprot, oprot):
    args = scannerOpenWithStopTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerOpenWithStopTs_result()
    try:
      result.success = self._handler.scannerOpenWithStopTs(args.tableName, args.startRow, args.stopRow, args.columns, args.timestamp, args.attributes)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("scannerOpenWithStopTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerGet(self, seqid, iprot, oprot):
    args = scannerGet_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerGet_result()
    try:
      result.success = self._handler.scannerGet(args.id)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("scannerGet", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerGetList(self, seqid, iprot, oprot):
    args = scannerGetList_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerGetList_result()
    try:
      result.success = self._handler.scannerGetList(args.id, args.nbRows)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("scannerGetList", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerClose(self, seqid, iprot, oprot):
    args = scannerClose_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerClose_result()
    try:
      self._handler.scannerClose(args.id)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("scannerClose", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowOrBefore(self, seqid, iprot, oprot):
    args = getRowOrBefore_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowOrBefore_result()
    try:
      result.success = self._handler.getRowOrBefore(args.tableName, args.row, args.family)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowOrBefore", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRegionInfo(self, seqid, iprot, oprot):
    args = getRegionInfo_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRegionInfo_result()
    try:
      result.success = self._handler.getRegionInfo(args.row)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRegionInfo", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_append(self, seqid, iprot, oprot):
    args = append_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = append_result()
    try:
      result.success = self._handler.append(args.append)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("append", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_checkAndPut(self, seqid, iprot, oprot):
    args = checkAndPut_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = checkAndPut_result()
    try:
      result.success = self._handler.checkAndPut(args.tableName, args.row, args.column, args.value, args.mput, args.attributes)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("checkAndPut", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()


# HELPER FUNCTIONS AND STRUCTURES

class enableTable_args(object):
  """
  Attributes:
   - tableName: name of the table
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('enableTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class enableTable_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('enableTable_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class disableTable_args(object):
  """
  Attributes:
   - tableName: name of the table
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('disableTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class disableTable_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('disableTable_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class isTableEnabled_args(object):
  """
  Attributes:
   - tableName: name of the table to check
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('isTableEnabled_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class isTableEnabled_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.BOOL, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.BOOL:
          self.success = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('isTableEnabled_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.BOOL, 0)
      oprot.writeBool(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class compact_args(object):
  """
  Attributes:
   - tableNameOrRegionName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableNameOrRegionName', None, None, ), # 1
  )

  def __init__(self, tableNameOrRegionName=None,):
    self.tableNameOrRegionName = tableNameOrRegionName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableNameOrRegionName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('compact_args')
    if self.tableNameOrRegionName is not None:
      oprot.writeFieldBegin('tableNameOrRegionName', TType.STRING, 1)
      oprot.writeString(self.tableNameOrRegionName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class compact_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('compact_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class majorCompact_args(object):
  """
  Attributes:
   - tableNameOrRegionName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableNameOrRegionName', None, None, ), # 1
  )

  def __init__(self, tableNameOrRegionName=None,):
    self.tableNameOrRegionName = tableNameOrRegionName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableNameOrRegionName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('majorCompact_args')
    if self.tableNameOrRegionName is not None:
      oprot.writeFieldBegin('tableNameOrRegionName', TType.STRING, 1)
      oprot.writeString(self.tableNameOrRegionName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class majorCompact_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('majorCompact_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableNames_args(object):

  thrift_spec = (
  )

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableNames_args')
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableNames_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRING,None), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype47, _size44) = iprot.readListBegin()
          for _i48 in xrange(_size44):
            _elem49 = iprot.readString();
            self.success.append(_elem49)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableNames_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRING, len(self.success))
      for iter50 in self.success:
        oprot.writeString(iter50)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getColumnDescriptors_args(object):
  """
  Attributes:
   - tableName: table name
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getColumnDescriptors_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getColumnDescriptors_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.MAP, 'success', (TType.STRING,None,TType.STRUCT,(ColumnDescriptor, ColumnDescriptor.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.MAP:
          self.success = {}
          (_ktype52, _vtype53, _size51 ) = iprot.readMapBegin() 
          for _i55 in xrange(_size51):
            _key56 = iprot.readString();
            _val57 = ColumnDescriptor()
            _val57.read(iprot)
            self.success[_key56] = _val57
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getColumnDescriptors_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.MAP, 0)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.success))
      for kiter58,viter59 in self.success.items():
        oprot.writeString(kiter58)
        viter59.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableRegions_args(object):
  """
  Attributes:
   - tableName: table name
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableRegions_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableRegions_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRegionInfo, TRegionInfo.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype63, _size60) = iprot.readListBegin()
          for _i64 in xrange(_size60):
            _elem65 = TRegionInfo()
            _elem65.read(iprot)
            self.success.append(_elem65)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableRegions_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter66 in self.success:
        iter66.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createTable_args(object):
  """
  Attributes:
   - tableName: name of table to create
   - columnFamilies: list of column family descriptors
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'columnFamilies', (TType.STRUCT,(ColumnDescriptor, ColumnDescriptor.thrift_spec)), None, ), # 2
  )

  def __init__(self, tableName=None, columnFamilies=None,):
    self.tableName = tableName
    self.columnFamilies = columnFamilies

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.columnFamilies = []
          (_etype70, _size67) = iprot.readListBegin()
          for _i71 in xrange(_size67):
            _elem72 = ColumnDescriptor()
            _elem72.read(iprot)
            self.columnFamilies.append(_elem72)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.columnFamilies is not None:
      oprot.writeFieldBegin('columnFamilies', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.columnFamilies))
      for iter73 in self.columnFamilies:
        iter73.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createTable_result(object):
  """
  Attributes:
   - io
   - ia
   - exist
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'exist', (AlreadyExists, AlreadyExists.thrift_spec), None, ), # 3
  )

  def __init__(self, io=None, ia=None, exist=None,):
    self.io = io
    self.ia = ia
    self.exist = exist

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.exist = AlreadyExists()
          self.exist.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createTable_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    if self.exist is not None:
      oprot.writeFieldBegin('exist', TType.STRUCT, 3)
      self.exist.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteTable_args(object):
  """
  Attributes:
   - tableName: name of table to delete
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteTable_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteTable_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - column: column name
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, row=None, column=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.column = column
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype75, _vtype76, _size74 ) = iprot.readMapBegin() 
          for _i78 in xrange(_size74):
            _key79 = iprot.readString();
            _val80 = iprot.readString();
            self.attributes[_key79] = _val80
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter81,viter82 in self.attributes.items():
        oprot.writeString(kiter81)
        oprot.writeString(viter82)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TCell, TCell.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype86, _size83) = iprot.readListBegin()
          for _i87 in xrange(_size83):
            _elem88 = TCell()
            _elem88.read(iprot)
            self.success.append(_elem88)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter89 in self.success:
        iter89.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getVer_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - column: column name
   - numVersions: number of versions to retrieve
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
    (4, TType.I32, 'numVersions', None, None, ), # 4
    (5, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 5
  )

  def __init__(self, tableName=None, row=None, column=None, numVersions=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.column = column
    self.numVersions = numVersions
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.numVersions = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype91, _vtype92, _size90 ) = iprot.readMapBegin() 
          for _i94 in xrange(_size90):
            _key95 = iprot.readString();
            _val96 = iprot.readString();
            self.attributes[_key95] = _val96
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getVer_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    if self.numVersions is not None:
      oprot.writeFieldBegin('numVersions', TType.I32, 4)
      oprot.writeI32(self.numVersions)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 5)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter97,viter98 in self.attributes.items():
        oprot.writeString(kiter97)
        oprot.writeString(viter98)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getVer_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TCell, TCell.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype102, _size99) = iprot.readListBegin()
          for _i103 in xrange(_size99):
            _elem104 = TCell()
            _elem104.read(iprot)
            self.success.append(_elem104)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getVer_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter105 in self.success:
        iter105.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getVerTs_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - column: column name
   - timestamp: timestamp
   - numVersions: number of versions to retrieve
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
    (5, TType.I32, 'numVersions', None, None, ), # 5
    (6, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 6
  )

  def __init__(self, tableName=None, row=None, column=None, timestamp=None, numVersions=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.column = column
    self.timestamp = timestamp
    self.numVersions = numVersions
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.numVersions = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype107, _vtype108, _size106 ) = iprot.readMapBegin() 
          for _i110 in xrange(_size106):
            _key111 = iprot.readString();
            _val112 = iprot.readString();
            self.attributes[_key111] = _val112
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getVerTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.numVersions is not None:
      oprot.writeFieldBegin('numVersions', TType.I32, 5)
      oprot.writeI32(self.numVersions)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 6)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter113,viter114 in self.attributes.items():
        oprot.writeString(kiter113)
        oprot.writeString(viter114)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getVerTs_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TCell, TCell.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype118, _size115) = iprot.readListBegin()
          for _i119 in xrange(_size115):
            _elem120 = TCell()
            _elem120.read(iprot)
            self.success.append(_elem120)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getVerTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter121 in self.success:
        iter121.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRow_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 3
  )

  def __init__(self, tableName=None, row=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype123, _vtype124, _size122 ) = iprot.readMapBegin() 
          for _i126 in xrange(_size122):
            _key127 = iprot.readString();
            _val128 = iprot.readString();
            self.attributes[_key127] = _val128
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRow_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 3)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter129,viter130 in self.attributes.items():
        oprot.writeString(kiter129)
        oprot.writeString(viter130)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRow_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype134, _size131) = iprot.readListBegin()
          for _i135 in xrange(_size131):
            _elem136 = TRowResult()
            _elem136.read(iprot)
            self.success.append(_elem136)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRow_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter137 in self.success:
        iter137.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowWithColumns_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - columns: List of columns to return, null for all columns
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, row=None, columns=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.columns = columns
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype141, _size138) = iprot.readListBegin()
          for _i142 in xrange(_size138):
            _elem143 = iprot.readString();
            self.columns.append(_elem143)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype145, _vtype146, _size144 ) = iprot.readMapBegin() 
          for _i148 in xrange(_size144):
            _key149 = iprot.readString();
            _val150 = iprot.readString();
            self.attributes[_key149] = _val150
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowWithColumns_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter151 in self.columns:
        oprot.writeString(iter151)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter152,viter153 in self.attributes.items():
        oprot.writeString(kiter152)
        oprot.writeString(viter153)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowWithColumns_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype157, _size154) = iprot.readListBegin()
          for _i158 in xrange(_size154):
            _elem159 = TRowResult()
            _elem159.read(iprot)
            self.success.append(_elem159)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowWithColumns_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter160 in self.success:
        iter160.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowTs_args(object):
  """
  Attributes:
   - tableName: name of the table
   - row: row key
   - timestamp: timestamp
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.I64, 'timestamp', None, None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, row=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype162, _vtype163, _size161 ) = iprot.readMapBegin() 
          for _i165 in xrange(_size161):
            _key166 = iprot.readString();
            _val167 = iprot.readString();
            self.attributes[_key166] = _val167
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 3)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter168,viter169 in self.attributes.items():
        oprot.writeString(kiter168)
        oprot.writeString(viter169)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowTs_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype173, _size170) = iprot.readListBegin()
          for _i174 in xrange(_size170):
            _elem175 = TRowResult()
            _elem175.read(iprot)
            self.success.append(_elem175)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter176 in self.success:
        iter176.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowWithColumnsTs_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - columns: List of columns to return, null for all columns
   - timestamp
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
    (5, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 5
  )

  def __init__(self, tableName=None, row=None, columns=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.columns = columns
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype180, _size177) = iprot.readListBegin()
          for _i181 in xrange(_size177):
            _elem182 = iprot.readString();
            self.columns.append(_elem182)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype184, _vtype185, _size183 ) = iprot.readMapBegin() 
          for _i187 in xrange(_size183):
            _key188 = iprot.readString();
            _val189 = iprot.readString();
            self.attributes[_key188] = _val189
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowWithColumnsTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter190 in self.columns:
        oprot.writeString(iter190)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 5)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter191,viter192 in self.attributes.items():
        oprot.writeString(kiter191)
        oprot.writeString(viter192)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowWithColumnsTs_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype196, _size193) = iprot.readListBegin()
          for _i197 in xrange(_size193):
            _elem198 = TRowResult()
            _elem198.read(iprot)
            self.success.append(_elem198)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowWithColumnsTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter199 in self.success:
        iter199.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRows_args(object):
  """
  Attributes:
   - tableName: name of table
   - rows: row keys
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'rows', (TType.STRING,None), None, ), # 2
    (3, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 3
  )

  def __init__(self, tableName=None, rows=None, attributes=None,):
    self.tableName = tableName
    self.rows = rows
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.rows = []
          (_etype203, _size200) = iprot.readListBegin()
          for _i204 in xrange(_size200):
            _elem205 = iprot.readString();
            self.rows.append(_elem205)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype207, _vtype208, _size206 ) = iprot.readMapBegin() 
          for _i210 in xrange(_size206):
            _key211 = iprot.readString();
            _val212 = iprot.readString();
            self.attributes[_key211] = _val212
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRows_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.rows is not None:
      oprot.writeFieldBegin('rows', TType.LIST, 2)
      oprot.writeListBegin(TType.STRING, len(self.rows))
      for iter213 in self.rows:
        oprot.writeString(iter213)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 3)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter214,viter215 in self.attributes.items():
        oprot.writeString(kiter214)
        oprot.writeString(viter215)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRows_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype219, _size216) = iprot.readListBegin()
          for _i220 in xrange(_size216):
            _elem221 = TRowResult()
            _elem221.read(iprot)
            self.success.append(_elem221)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRows_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter222 in self.success:
        iter222.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowsWithColumns_args(object):
  """
  Attributes:
   - tableName: name of table
   - rows: row keys
   - columns: List of columns to return, null for all columns
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'rows', (TType.STRING,None), None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, rows=None, columns=None, attributes=None,):
    self.tableName = tableName
    self.rows = rows
    self.columns = columns
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.rows = []
          (_etype226, _size223) = iprot.readListBegin()
          for _i227 in xrange(_size223):
            _elem228 = iprot.readString();
            self.rows.append(_elem228)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype232, _size229) = iprot.readListBegin()
          for _i233 in xrange(_size229):
            _elem234 = iprot.readString();
            self.columns.append(_elem234)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype236, _vtype237, _size235 ) = iprot.readMapBegin() 
          for _i239 in xrange(_size235):
            _key240 = iprot.readString();
            _val241 = iprot.readString();
            self.attributes[_key240] = _val241
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowsWithColumns_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.rows is not None:
      oprot.writeFieldBegin('rows', TType.LIST, 2)
      oprot.writeListBegin(TType.STRING, len(self.rows))
      for iter242 in self.rows:
        oprot.writeString(iter242)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter243 in self.columns:
        oprot.writeString(iter243)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter244,viter245 in self.attributes.items():
        oprot.writeString(kiter244)
        oprot.writeString(viter245)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowsWithColumns_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype249, _size246) = iprot.readListBegin()
          for _i250 in xrange(_size246):
            _elem251 = TRowResult()
            _elem251.read(iprot)
            self.success.append(_elem251)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowsWithColumns_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter252 in self.success:
        iter252.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowsTs_args(object):
  """
  Attributes:
   - tableName: name of the table
   - rows: row keys
   - timestamp: timestamp
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'rows', (TType.STRING,None), None, ), # 2
    (3, TType.I64, 'timestamp', None, None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, rows=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.rows = rows
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.rows = []
          (_etype256, _size253) = iprot.readListBegin()
          for _i257 in xrange(_size253):
            _elem258 = iprot.readString();
            self.rows.append(_elem258)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype260, _vtype261, _size259 ) = iprot.readMapBegin() 
          for _i263 in xrange(_size259):
            _key264 = iprot.readString();
            _val265 = iprot.readString();
            self.attributes[_key264] = _val265
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowsTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.rows is not None:
      oprot.writeFieldBegin('rows', TType.LIST, 2)
      oprot.writeListBegin(TType.STRING, len(self.rows))
      for iter266 in self.rows:
        oprot.writeString(iter266)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 3)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter267,viter268 in self.attributes.items():
        oprot.writeString(kiter267)
        oprot.writeString(viter268)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowsTs_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype272, _size269) = iprot.readListBegin()
          for _i273 in xrange(_size269):
            _elem274 = TRowResult()
            _elem274.read(iprot)
            self.success.append(_elem274)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowsTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter275 in self.success:
        iter275.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowsWithColumnsTs_args(object):
  """
  Attributes:
   - tableName: name of table
   - rows: row keys
   - columns: List of columns to return, null for all columns
   - timestamp
   - attributes: Get attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'rows', (TType.STRING,None), None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
    (5, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 5
  )

  def __init__(self, tableName=None, rows=None, columns=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.rows = rows
    self.columns = columns
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.rows = []
          (_etype279, _size276) = iprot.readListBegin()
          for _i280 in xrange(_size276):
            _elem281 = iprot.readString();
            self.rows.append(_elem281)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype285, _size282) = iprot.readListBegin()
          for _i286 in xrange(_size282):
            _elem287 = iprot.readString();
            self.columns.append(_elem287)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype289, _vtype290, _size288 ) = iprot.readMapBegin() 
          for _i292 in xrange(_size288):
            _key293 = iprot.readString();
            _val294 = iprot.readString();
            self.attributes[_key293] = _val294
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowsWithColumnsTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.rows is not None:
      oprot.writeFieldBegin('rows', TType.LIST, 2)
      oprot.writeListBegin(TType.STRING, len(self.rows))
      for iter295 in self.rows:
        oprot.writeString(iter295)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter296 in self.columns:
        oprot.writeString(iter296)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 5)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter297,viter298 in self.attributes.items():
        oprot.writeString(kiter297)
        oprot.writeString(viter298)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowsWithColumnsTs_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype302, _size299) = iprot.readListBegin()
          for _i303 in xrange(_size299):
            _elem304 = TRowResult()
            _elem304.read(iprot)
            self.success.append(_elem304)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowsWithColumnsTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter305 in self.success:
        iter305.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRow_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - mutations: list of mutation commands
   - attributes: Mutation attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.LIST, 'mutations', (TType.STRUCT,(Mutation, Mutation.thrift_spec)), None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, row=None, mutations=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.mutations = mutations
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.mutations = []
          (_etype309, _size306) = iprot.readListBegin()
          for _i310 in xrange(_size306):
            _elem311 = Mutation()
            _elem311.read(iprot)
            self.mutations.append(_elem311)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype313, _vtype314, _size312 ) = iprot.readMapBegin() 
          for _i316 in xrange(_size312):
            _key317 = iprot.readString();
            _val318 = iprot.readString();
            self.attributes[_key317] = _val318
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRow_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.mutations is not None:
      oprot.writeFieldBegin('mutations', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.mutations))
      for iter319 in self.mutations:
        iter319.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter320,viter321 in self.attributes.items():
        oprot.writeString(kiter320)
        oprot.writeString(viter321)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRow_result(object):
  """
  Attributes:
   - io
   - ia
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, io=None, ia=None,):
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRow_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRowTs_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - mutations: list of mutation commands
   - timestamp: timestamp
   - attributes: Mutation attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.LIST, 'mutations', (TType.STRUCT,(Mutation, Mutation.thrift_spec)), None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
    (5, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 5
  )

  def __init__(self, tableName=None, row=None, mutations=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.mutations = mutations
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.mutations = []
          (_etype325, _size322) = iprot.readListBegin()
          for _i326 in xrange(_size322):
            _elem327 = Mutation()
            _elem327.read(iprot)
            self.mutations.append(_elem327)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype329, _vtype330, _size328 ) = iprot.readMapBegin() 
          for _i332 in xrange(_size328):
            _key333 = iprot.readString();
            _val334 = iprot.readString();
            self.attributes[_key333] = _val334
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRowTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.mutations is not None:
      oprot.writeFieldBegin('mutations', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.mutations))
      for iter335 in self.mutations:
        iter335.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 5)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter336,viter337 in self.attributes.items():
        oprot.writeString(kiter336)
        oprot.writeString(viter337)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRowTs_result(object):
  """
  Attributes:
   - io
   - ia
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, io=None, ia=None,):
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRowTs_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRows_args(object):
  """
  Attributes:
   - tableName: name of table
   - rowBatches: list of row batches
   - attributes: Mutation attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'rowBatches', (TType.STRUCT,(BatchMutation, BatchMutation.thrift_spec)), None, ), # 2
    (3, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 3
  )

  def __init__(self, tableName=None, rowBatches=None, attributes=None,):
    self.tableName = tableName
    self.rowBatches = rowBatches
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.rowBatches = []
          (_etype341, _size338) = iprot.readListBegin()
          for _i342 in xrange(_size338):
            _elem343 = BatchMutation()
            _elem343.read(iprot)
            self.rowBatches.append(_elem343)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype345, _vtype346, _size344 ) = iprot.readMapBegin() 
          for _i348 in xrange(_size344):
            _key349 = iprot.readString();
            _val350 = iprot.readString();
            self.attributes[_key349] = _val350
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRows_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.rowBatches is not None:
      oprot.writeFieldBegin('rowBatches', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.rowBatches))
      for iter351 in self.rowBatches:
        iter351.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 3)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter352,viter353 in self.attributes.items():
        oprot.writeString(kiter352)
        oprot.writeString(viter353)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRows_result(object):
  """
  Attributes:
   - io
   - ia
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, io=None, ia=None,):
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRows_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRowsTs_args(object):
  """
  Attributes:
   - tableName: name of table
   - rowBatches: list of row batches
   - timestamp: timestamp
   - attributes: Mutation attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'rowBatches', (TType.STRUCT,(BatchMutation, BatchMutation.thrift_spec)), None, ), # 2
    (3, TType.I64, 'timestamp', None, None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, rowBatches=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.rowBatches = rowBatches
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.rowBatches = []
          (_etype357, _size354) = iprot.readListBegin()
          for _i358 in xrange(_size354):
            _elem359 = BatchMutation()
            _elem359.read(iprot)
            self.rowBatches.append(_elem359)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype361, _vtype362, _size360 ) = iprot.readMapBegin() 
          for _i364 in xrange(_size360):
            _key365 = iprot.readString();
            _val366 = iprot.readString();
            self.attributes[_key365] = _val366
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRowsTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.rowBatches is not None:
      oprot.writeFieldBegin('rowBatches', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.rowBatches))
      for iter367 in self.rowBatches:
        iter367.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 3)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter368,viter369 in self.attributes.items():
        oprot.writeString(kiter368)
        oprot.writeString(viter369)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRowsTs_result(object):
  """
  Attributes:
   - io
   - ia
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, io=None, ia=None,):
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRowsTs_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class atomicIncrement_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row to increment
   - column: name of column
   - value: amount to increment by
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
    (4, TType.I64, 'value', None, None, ), # 4
  )

  def __init__(self, tableName=None, row=None, column=None, value=None,):
    self.tableName = tableName
    self.row = row
    self.column = column
    self.value = value

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.value = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('atomicIncrement_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    if self.value is not None:
      oprot.writeFieldBegin('value', TType.I64, 4)
      oprot.writeI64(self.value)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class atomicIncrement_result(object):
  """
  Attributes:
   - success
   - io
   - ia
  """

  thrift_spec = (
    (0, TType.I64, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, io=None, ia=None,):
    self.success = success
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I64:
          self.success = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('atomicIncrement_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I64, 0)
      oprot.writeI64(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAll_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: Row to update
   - column: name of column whose value is to be deleted
   - attributes: Delete attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, row=None, column=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.column = column
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype371, _vtype372, _size370 ) = iprot.readMapBegin() 
          for _i374 in xrange(_size370):
            _key375 = iprot.readString();
            _val376 = iprot.readString();
            self.attributes[_key375] = _val376
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAll_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter377,viter378 in self.attributes.items():
        oprot.writeString(kiter377)
        oprot.writeString(viter378)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAll_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAll_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAllTs_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: Row to update
   - column: name of column whose value is to be deleted
   - timestamp: timestamp
   - attributes: Delete attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
    (5, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 5
  )

  def __init__(self, tableName=None, row=None, column=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.column = column
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype380, _vtype381, _size379 ) = iprot.readMapBegin() 
          for _i383 in xrange(_size379):
            _key384 = iprot.readString();
            _val385 = iprot.readString();
            self.attributes[_key384] = _val385
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAllTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 5)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter386,viter387 in self.attributes.items():
        oprot.writeString(kiter386)
        oprot.writeString(viter387)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAllTs_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAllTs_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAllRow_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: key of the row to be completely deleted.
   - attributes: Delete attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 3
  )

  def __init__(self, tableName=None, row=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype389, _vtype390, _size388 ) = iprot.readMapBegin() 
          for _i392 in xrange(_size388):
            _key393 = iprot.readString();
            _val394 = iprot.readString();
            self.attributes[_key393] = _val394
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAllRow_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 3)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter395,viter396 in self.attributes.items():
        oprot.writeString(kiter395)
        oprot.writeString(viter396)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAllRow_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAllRow_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class increment_args(object):
  """
  Attributes:
   - increment: The single increment to apply
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'increment', (TIncrement, TIncrement.thrift_spec), None, ), # 1
  )

  def __init__(self, increment=None,):
    self.increment = increment

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.increment = TIncrement()
          self.increment.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('increment_args')
    if self.increment is not None:
      oprot.writeFieldBegin('increment', TType.STRUCT, 1)
      self.increment.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class increment_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('increment_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class incrementRows_args(object):
  """
  Attributes:
   - increments: The list of increments
  """

  thrift_spec = (
    None, # 0
    (1, TType.LIST, 'increments', (TType.STRUCT,(TIncrement, TIncrement.thrift_spec)), None, ), # 1
  )

  def __init__(self, increments=None,):
    self.increments = increments

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.LIST:
          self.increments = []
          (_etype400, _size397) = iprot.readListBegin()
          for _i401 in xrange(_size397):
            _elem402 = TIncrement()
            _elem402.read(iprot)
            self.increments.append(_elem402)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('incrementRows_args')
    if self.increments is not None:
      oprot.writeFieldBegin('increments', TType.LIST, 1)
      oprot.writeListBegin(TType.STRUCT, len(self.increments))
      for iter403 in self.increments:
        iter403.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class incrementRows_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('incrementRows_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAllRowTs_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: key of the row to be completely deleted.
   - timestamp: timestamp
   - attributes: Delete attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.I64, 'timestamp', None, None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, row=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype405, _vtype406, _size404 ) = iprot.readMapBegin() 
          for _i408 in xrange(_size404):
            _key409 = iprot.readString();
            _val410 = iprot.readString();
            self.attributes[_key409] = _val410
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAllRowTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 3)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter411,viter412 in self.attributes.items():
        oprot.writeString(kiter411)
        oprot.writeString(viter412)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAllRowTs_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAllRowTs_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithScan_args(object):
  """
  Attributes:
   - tableName: name of table
   - scan: Scan instance
   - attributes: Scan attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRUCT, 'scan', (TScan, TScan.thrift_spec), None, ), # 2
    (3, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 3
  )

  def __init__(self, tableName=None, scan=None, attributes=None,):
    self.tableName = tableName
    self.scan = scan
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.scan = TScan()
          self.scan.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype414, _vtype415, _size413 ) = iprot.readMapBegin() 
          for _i417 in xrange(_size413):
            _key418 = iprot.readString();
            _val419 = iprot.readString();
            self.attributes[_key418] = _val419
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithScan_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.scan is not None:
      oprot.writeFieldBegin('scan', TType.STRUCT, 2)
      self.scan.write(oprot)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 3)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter420,viter421 in self.attributes.items():
        oprot.writeString(kiter420)
        oprot.writeString(viter421)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithScan_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithScan_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpen_args(object):
  """
  Attributes:
   - tableName: name of table
   - startRow: Starting row in table to scan.
  Send "" (empty string) to start at the first row.
   - columns: columns to scan. If column name is a column family, all
  columns of the specified column family are returned. It's also possible
  to pass a regex in the column qualifier.
   - attributes: Scan attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'startRow', None, None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, startRow=None, columns=None, attributes=None,):
    self.tableName = tableName
    self.startRow = startRow
    self.columns = columns
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.startRow = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype425, _size422) = iprot.readListBegin()
          for _i426 in xrange(_size422):
            _elem427 = iprot.readString();
            self.columns.append(_elem427)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype429, _vtype430, _size428 ) = iprot.readMapBegin() 
          for _i432 in xrange(_size428):
            _key433 = iprot.readString();
            _val434 = iprot.readString();
            self.attributes[_key433] = _val434
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpen_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.startRow is not None:
      oprot.writeFieldBegin('startRow', TType.STRING, 2)
      oprot.writeString(self.startRow)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter435 in self.columns:
        oprot.writeString(iter435)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter436,viter437 in self.attributes.items():
        oprot.writeString(kiter436)
        oprot.writeString(viter437)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpen_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpen_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithStop_args(object):
  """
  Attributes:
   - tableName: name of table
   - startRow: Starting row in table to scan.
  Send "" (empty string) to start at the first row.
   - stopRow: row to stop scanning on. This row is *not* included in the
  scanner's results
   - columns: columns to scan. If column name is a column family, all
  columns of the specified column family are returned. It's also possible
  to pass a regex in the column qualifier.
   - attributes: Scan attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'startRow', None, None, ), # 2
    (3, TType.STRING, 'stopRow', None, None, ), # 3
    (4, TType.LIST, 'columns', (TType.STRING,None), None, ), # 4
    (5, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 5
  )

  def __init__(self, tableName=None, startRow=None, stopRow=None, columns=None, attributes=None,):
    self.tableName = tableName
    self.startRow = startRow
    self.stopRow = stopRow
    self.columns = columns
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.startRow = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.stopRow = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.columns = []
          (_etype441, _size438) = iprot.readListBegin()
          for _i442 in xrange(_size438):
            _elem443 = iprot.readString();
            self.columns.append(_elem443)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype445, _vtype446, _size444 ) = iprot.readMapBegin() 
          for _i448 in xrange(_size444):
            _key449 = iprot.readString();
            _val450 = iprot.readString();
            self.attributes[_key449] = _val450
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithStop_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.startRow is not None:
      oprot.writeFieldBegin('startRow', TType.STRING, 2)
      oprot.writeString(self.startRow)
      oprot.writeFieldEnd()
    if self.stopRow is not None:
      oprot.writeFieldBegin('stopRow', TType.STRING, 3)
      oprot.writeString(self.stopRow)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 4)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter451 in self.columns:
        oprot.writeString(iter451)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 5)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter452,viter453 in self.attributes.items():
        oprot.writeString(kiter452)
        oprot.writeString(viter453)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithStop_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithStop_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithPrefix_args(object):
  """
  Attributes:
   - tableName: name of table
   - startAndPrefix: the prefix (and thus start row) of the keys you want
   - columns: the columns you want returned
   - attributes: Scan attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'startAndPrefix', None, None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
    (4, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, startAndPrefix=None, columns=None, attributes=None,):
    self.tableName = tableName
    self.startAndPrefix = startAndPrefix
    self.columns = columns
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.startAndPrefix = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype457, _size454) = iprot.readListBegin()
          for _i458 in xrange(_size454):
            _elem459 = iprot.readString();
            self.columns.append(_elem459)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype461, _vtype462, _size460 ) = iprot.readMapBegin() 
          for _i464 in xrange(_size460):
            _key465 = iprot.readString();
            _val466 = iprot.readString();
            self.attributes[_key465] = _val466
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithPrefix_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.startAndPrefix is not None:
      oprot.writeFieldBegin('startAndPrefix', TType.STRING, 2)
      oprot.writeString(self.startAndPrefix)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter467 in self.columns:
        oprot.writeString(iter467)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 4)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter468,viter469 in self.attributes.items():
        oprot.writeString(kiter468)
        oprot.writeString(viter469)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithPrefix_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithPrefix_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenTs_args(object):
  """
  Attributes:
   - tableName: name of table
   - startRow: Starting row in table to scan.
  Send "" (empty string) to start at the first row.
   - columns: columns to scan. If column name is a column family, all
  columns of the specified column family are returned. It's also possible
  to pass a regex in the column qualifier.
   - timestamp: timestamp
   - attributes: Scan attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'startRow', None, None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
    (5, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 5
  )

  def __init__(self, tableName=None, startRow=None, columns=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.startRow = startRow
    self.columns = columns
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.startRow = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype473, _size470) = iprot.readListBegin()
          for _i474 in xrange(_size470):
            _elem475 = iprot.readString();
            self.columns.append(_elem475)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype477, _vtype478, _size476 ) = iprot.readMapBegin() 
          for _i480 in xrange(_size476):
            _key481 = iprot.readString();
            _val482 = iprot.readString();
            self.attributes[_key481] = _val482
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.startRow is not None:
      oprot.writeFieldBegin('startRow', TType.STRING, 2)
      oprot.writeString(self.startRow)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter483 in self.columns:
        oprot.writeString(iter483)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 5)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter484,viter485 in self.attributes.items():
        oprot.writeString(kiter484)
        oprot.writeString(viter485)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenTs_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithStopTs_args(object):
  """
  Attributes:
   - tableName: name of table
   - startRow: Starting row in table to scan.
  Send "" (empty string) to start at the first row.
   - stopRow: row to stop scanning on. This row is *not* included in the
  scanner's results
   - columns: columns to scan. If column name is a column family, all
  columns of the specified column family are returned. It's also possible
  to pass a regex in the column qualifier.
   - timestamp: timestamp
   - attributes: Scan attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'startRow', None, None, ), # 2
    (3, TType.STRING, 'stopRow', None, None, ), # 3
    (4, TType.LIST, 'columns', (TType.STRING,None), None, ), # 4
    (5, TType.I64, 'timestamp', None, None, ), # 5
    (6, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 6
  )

  def __init__(self, tableName=None, startRow=None, stopRow=None, columns=None, timestamp=None, attributes=None,):
    self.tableName = tableName
    self.startRow = startRow
    self.stopRow = stopRow
    self.columns = columns
    self.timestamp = timestamp
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.startRow = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.stopRow = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.columns = []
          (_etype489, _size486) = iprot.readListBegin()
          for _i490 in xrange(_size486):
            _elem491 = iprot.readString();
            self.columns.append(_elem491)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype493, _vtype494, _size492 ) = iprot.readMapBegin() 
          for _i496 in xrange(_size492):
            _key497 = iprot.readString();
            _val498 = iprot.readString();
            self.attributes[_key497] = _val498
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithStopTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.startRow is not None:
      oprot.writeFieldBegin('startRow', TType.STRING, 2)
      oprot.writeString(self.startRow)
      oprot.writeFieldEnd()
    if self.stopRow is not None:
      oprot.writeFieldBegin('stopRow', TType.STRING, 3)
      oprot.writeString(self.stopRow)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 4)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter499 in self.columns:
        oprot.writeString(iter499)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 5)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 6)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter500,viter501 in self.attributes.items():
        oprot.writeString(kiter500)
        oprot.writeString(viter501)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithStopTs_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithStopTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerGet_args(object):
  """
  Attributes:
   - id: id of a scanner returned by scannerOpen
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'id', None, None, ), # 1
  )

  def __init__(self, id=None,):
    self.id = id

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.id = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerGet_args')
    if self.id is not None:
      oprot.writeFieldBegin('id', TType.I32, 1)
      oprot.writeI32(self.id)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerGet_result(object):
  """
  Attributes:
   - success
   - io
   - ia
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, io=None, ia=None,):
    self.success = success
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype505, _size502) = iprot.readListBegin()
          for _i506 in xrange(_size502):
            _elem507 = TRowResult()
            _elem507.read(iprot)
            self.success.append(_elem507)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerGet_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter508 in self.success:
        iter508.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerGetList_args(object):
  """
  Attributes:
   - id: id of a scanner returned by scannerOpen
   - nbRows: number of results to return
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'id', None, None, ), # 1
    (2, TType.I32, 'nbRows', None, None, ), # 2
  )

  def __init__(self, id=None, nbRows=None,):
    self.id = id
    self.nbRows = nbRows

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.id = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.nbRows = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerGetList_args')
    if self.id is not None:
      oprot.writeFieldBegin('id', TType.I32, 1)
      oprot.writeI32(self.id)
      oprot.writeFieldEnd()
    if self.nbRows is not None:
      oprot.writeFieldBegin('nbRows', TType.I32, 2)
      oprot.writeI32(self.nbRows)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerGetList_result(object):
  """
  Attributes:
   - success
   - io
   - ia
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, io=None, ia=None,):
    self.success = success
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype512, _size509) = iprot.readListBegin()
          for _i513 in xrange(_size509):
            _elem514 = TRowResult()
            _elem514.read(iprot)
            self.success.append(_elem514)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerGetList_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter515 in self.success:
        iter515.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerClose_args(object):
  """
  Attributes:
   - id: id of a scanner returned by scannerOpen
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'id', None, None, ), # 1
  )

  def __init__(self, id=None,):
    self.id = id

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.id = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerClose_args')
    if self.id is not None:
      oprot.writeFieldBegin('id', TType.I32, 1)
      oprot.writeI32(self.id)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerClose_result(object):
  """
  Attributes:
   - io
   - ia
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, io=None, ia=None,):
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerClose_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowOrBefore_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - family: column name
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'family', None, None, ), # 3
  )

  def __init__(self, tableName=None, row=None, family=None,):
    self.tableName = tableName
    self.row = row
    self.family = family

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.family = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowOrBefore_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.family is not None:
      oprot.writeFieldBegin('family', TType.STRING, 3)
      oprot.writeString(self.family)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowOrBefore_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TCell, TCell.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype519, _size516) = iprot.readListBegin()
          for _i520 in xrange(_size516):
            _elem521 = TCell()
            _elem521.read(iprot)
            self.success.append(_elem521)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowOrBefore_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter522 in self.success:
        iter522.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRegionInfo_args(object):
  """
  Attributes:
   - row: row key
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'row', None, None, ), # 1
  )

  def __init__(self, row=None,):
    self.row = row

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRegionInfo_args')
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 1)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRegionInfo_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.STRUCT, 'success', (TRegionInfo, TRegionInfo.thrift_spec), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.STRUCT:
          self.success = TRegionInfo()
          self.success.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRegionInfo_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.STRUCT, 0)
      self.success.write(oprot)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class append_args(object):
  """
  Attributes:
   - append: The single append operation to apply
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'append', (TAppend, TAppend.thrift_spec), None, ), # 1
  )

  def __init__(self, append=None,):
    self.append = append

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.append = TAppend()
          self.append.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('append_args')
    if self.append is not None:
      oprot.writeFieldBegin('append', TType.STRUCT, 1)
      self.append.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class append_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TCell, TCell.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype526, _size523) = iprot.readListBegin()
          for _i527 in xrange(_size523):
            _elem528 = TCell()
            _elem528.read(iprot)
            self.success.append(_elem528)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('append_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter529 in self.success:
        iter529.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class checkAndPut_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - column: column name
   - value: the expected value for the column parameter, if not
  provided the check is for the non-existence of the
  column in question
   - mput: mutation for the put
   - attributes: Mutation attributes
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
    None, # 4
    (5, TType.STRING, 'value', None, None, ), # 5
    (6, TType.STRUCT, 'mput', (Mutation, Mutation.thrift_spec), None, ), # 6
    (7, TType.MAP, 'attributes', (TType.STRING,None,TType.STRING,None), None, ), # 7
  )

  def __init__(self, tableName=None, row=None, column=None, value=None, mput=None, attributes=None,):
    self.tableName = tableName
    self.row = row
    self.column = column
    self.value = value
    self.mput = mput
    self.attributes = attributes

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.STRING:
          self.value = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 6:
        if ftype == TType.STRUCT:
          self.mput = Mutation()
          self.mput.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 7:
        if ftype == TType.MAP:
          self.attributes = {}
          (_ktype531, _vtype532, _size530 ) = iprot.readMapBegin() 
          for _i534 in xrange(_size530):
            _key535 = iprot.readString();
            _val536 = iprot.readString();
            self.attributes[_key535] = _val536
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('checkAndPut_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    if self.value is not None:
      oprot.writeFieldBegin('value', TType.STRING, 5)
      oprot.writeString(self.value)
      oprot.writeFieldEnd()
    if self.mput is not None:
      oprot.writeFieldBegin('mput', TType.STRUCT, 6)
      self.mput.write(oprot)
      oprot.writeFieldEnd()
    if self.attributes is not None:
      oprot.writeFieldBegin('attributes', TType.MAP, 7)
      oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
      for kiter537,viter538 in self.attributes.items():
        oprot.writeString(kiter537)
        oprot.writeString(viter538)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class checkAndPut_result(object):
  """
  Attributes:
   - success
   - io
   - ia
  """

  thrift_spec = (
    (0, TType.BOOL, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, io=None, ia=None,):
    self.success = success
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.BOOL:
          self.success = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('checkAndPut_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.BOOL, 0)
      oprot.writeBool(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)
